/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _UACE_
#define _UACE_

// attention please: must be xorg-server.h in fornt of extnsionst.h
// beause of XaceResourceAccessRec-XID in xorg is 4 bytes.
// in uace is 8 byte.
#include "xorg-server.h"
#include "extnsionst.h"

/*! \file Message.hpp */

/*! \class Message
 *  \brief Forwards string to screen
 *  \author Roberto Di Remigio
 *  \date 2018
 */

#define UACE_EXTENSION_NAME "UACE-EXTENSION"
#define UACE_NUMBER_EVENTS 3
#define UACE_NUMBER_ERRORS 0
  /*! \brief Constructor from a string
   *  \param[in] m a message
   */
void uaceExtensionInit(void);
void UACEResetProc(ExtensionEntry* extEntry);
void uaceClientStateChange(CallbackListPtr * l, void * d, void * p);
void uaceResourcecallback(CallbackListPtr * l, void * d, void * p);

#endif
