/*
* Copyright (c) 1997 - 2016
* Actelion Pharmaceuticals Ltd.
* Gewerbestrasse 16
* CH-4123 Allschwil, Switzerland
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* 1. Redistributions of source code must retain the above copyright notice, this
*    list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the documentation
*    and/or other materials provided with the distribution.
* 3. Neither the name of the the copyright holder nor the
*    names of its contributors may be used to endorse or promote products
*    derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

package com.actelion.research.chem.reaction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Scanner;

public class ClassificationData {
	private static final String CLASSDATA = 
			  "53\n"
			+ "RC+2R     XF+2X      C000000    01\n"
			+ "RC+R+re   XF+X+xa    B000000    01\n"
			+ "RC+R+E    XF+X+A     AF00000    01\n"
			+ "RC+E+re   XF+A+xa    9F00000    01\n"
			+ "RC+R      XF+X       8000000    11\n"
			+ "RC+RE     XF+XA      7300000    02\n"
			+ "RC+re     XF+xa      7000000    01\n"
			+ "RC+S'     XF+S'      6FD0000    13\n"
			+ "RC+E      XF+A       6F00000    01\n"
			+ "XAC+2E    REF+2A     6B00000    12\n"
			+ "RAC+R     XEF+X      5100000    01\n"
			+ "RAC+re    XEF+xa     4100000    01\n"
			+ "RC'+re    XF'+xa     4030000    01\n"
			+ "RC        XF         4000000    01\n"
			+ "XAC+re    REF+xa     3D00000    12\n"
			+ "RC+E      XF+A       3300000    01\n"
			+ "XC+re     RF+xa      3000000    01\n"
			+ "XC+S'     RF+S'      2FD0000    01\n"
			+ "XC+E      RF+A       2F00000    01\n"
			+ "RAC+RA*   XEF+XE*    2200000    11\n"
			+ "XAC+A     REF+E      1A00000    12\n"
			+ "RAC+R     XEF+X      1500000    02\n"
			+ "RAC+H'    XEF+H'     1200000    12\n"
			+ "RAC       XEF        1100000    12\n"
			+ "RC'       XF'        1030000    03\n"
			+ "RAC'      XEF'       1001000    14\n"
			+ "RC''      XF''       1000300    05\n"
			+ "RAC''     XEF''      1000010    16\n"
			+ "RC'''     XF'''      1000003    07\n"
			+ "RC        XF         1000000    01\n"
			+ "XC'''     RF'''       FFFFFF    07\n"
			+ "XAC''     REF''       FFFFD0    16\n"
			+ "XC''      RF''        FFFF00    05\n"
			+ "XAC'      REF'        FFD000    14\n"
			+ "XC'       RF'         FF0000    03\n"
			+ "XAC       REF         D00000    12\n"
			+ "XAC+A     REF+E       A10000    12\n"
			+ "XAC+A+xe  REF+E+ra    A00000    12\n"
			+ "XAC+X     REF+R       900000    12\n"
			+ "RAC+xe    XEF+ra      100000    01\n"
			+ "RC'+xe    XF'+ra       30000    03\n"
			+ "XC        RF               0    01\n"
			+ "XAC'+xe   REF'+ra      -3000    14\n"
			+ "XC'+xe    RF'+ra      -10000    03\n"
			+ "XAC+xe    REF+ra     -300000    02\n"
			+ "XA+X+xe   RF+R+ra    -700000    12\n"
			+ "XC+E      RF+A       -D00000    01\n"
			+ "XC+H'     RF+H'      -FF0000    03\n"
			+ "XC+xe     RF+ra     -1000000    01\n"
			+ "XC+XE     RF+RA     -1100000    01\n"
			+ "XC+A      RF+E      -2F00000    11\n"
			+ "XC+X      RF+R      -4000000    11\n"
			+ "XC+2X     RF+2R     -8000000    11\n"

			+ "27\n"
			+ "ACC''     EFF''       100001\n"
			+ "2RC+E'    2XF+A'        7003\n"
			+ "ACC'+R+xe EFF'+X+ra     5000\n"
			+ "ACC'+2E'  EFF'+2A'      3003\n"
			+ "ACC'      EFF'          1001\n"
			+ "RC+RC'+re XF+XF'+xa      704\n"
			+ "RC+RC'    XF+XF'         701\n"
			+ "RC+XC+E   XF+RF+A         6F\n"
			+ "ACC+R     EFF+X           51\n"
			+ "ACC+R+xe  EFF+X+ra        50\n"
			+ "ACC+2re   EFF+2xa         44\n"
			+ "ACC+re    EFF+xa          41\n"
			+ "ACC+re+xe EFF+xa+ra       40\n"
			+ "2XC+E     2RF+A           2F\n"
			+ "2RAC      2XEF            22\n"
			+ "ACC       EFF             11\n"
			+ "ACC+xe    EFF+ra          10\n"
			+ "XC+XAC    RF+REF           D\n"
			+ "2RC+re    2XF+xa           B\n"
			+ "2RC       2XF              8\n"
			+ "2RC+xe    2XF+ra           7\n"
			+ "RC+XC     XF+RF            4\n"
			+ "2XC+re    2RF+xa           3\n"
			+ "ACC''+re  EFF''+xa         1\n"
			+ "2XC*      2RF*             0\n"
			+ "2XC+xe    2RF+ra          -1\n"
			+ "2XC+XE    2RF+RA         -11\n"

			+ "13\n"
			+ "RC+REF     6F00000\n"
			+ "FC+R       4000000\n"
			+ "RC+RF+E    3300000\n"
			+ "FC+re      3000000\n"
			+ "XC+REF     2F00000\n"
			+ "RAC+RF     1100000\n"
			+ "FC''        FFFF00\n"
			+ "FC'         FF0000\n"
			+ "XAC+XF      900000\n"
			+ "FC               0\n"
			+ "FC+xe*    -1000000\n"
			+ "FC+xa     -3000000\n"
			+ "FC+X      -4000000\n"

			+ "14\n"
			+ "XAC+XAC   REF+REF     A10000\n"
			+ "RAC+XAC   XEF+REF     E10000\n"
			+ "XC+XC'    RF+RF'      FF0000\n"
			+ "XAC+XAC'  REF+REF'    FFA100\n"
			+ "RAC+XAC'  XEF+REF'    FFE100\n"
			+ "XC+XC''   RF+RF''     FFFF00\n"
			+ "AC''      EF''       1000010\n"
			+ "AC'       EF'        1001000\n"
			+ "RAC+RAC'  XEF+XEF'   1200100\n"
			+ "RAC+RAC   XEF+XEF    1210000\n"
			+ "RC+XC''   XF+RF''    3000100\n"
			+ "RC+XC'    XF+RF'     3010000\n"
			+ "RC+RC''   XF+XF''    7000100\n"
			+ "RC+RC'    XF+XF'     7010000\n"

			+ "221\n"
			+ "RE''      300003  2  2  1  00000106  00000601\n"
			+ "E''       2FFFFF  1  2  0  00000106\n"
			+ "RA''      100001  2  2  1  00004146  00004641\n"
			+ "A''        FFFFD  1  2  0  00004641\n"
			+ "2R'        30401  1  4  0  01034345\n"
			+ "S'+R'      303FD  1  4  0  01034543\n"
			+ "2R'        30203  4  4  1  01054353  01055343  05014353  05015343\n"
			+ "R'+H'      301FF  2  4  0  01054353  01055343\n"
			+ "R''        30001  1  2  0  00000145\n"
			+ "S''        2FFFD  1  2  0  00000145\n"
			+ "R'+S'      2FE03  4  4  1  01054353  01055343  05014353  05015343\n"
			+ "H'+S'      2FDFF  2  4  0  01435305  01534305\n"
			+ "H'+S'      2FC01  1  4  0  01430345\n"
			+ "S'+X'      2FBFD  1  4  0  01434503\n"
			+ "2S'        2FA03  4  4  1  01054353  01055343  05014353  05015343\n"
			+ "X'+S'      2F9FF  2  4  0  01435305  01534305\n"
			+ "2R'        10601  4  4  1  03134145  13034145  03134541  13034541\n"
			+ "R'+S'      105FD  2  4  0  03134541  13034541\n"
			+ "H'+R'      103FF  1  4  0  03054143\n"
			+ "R'+H'      10201  4  4  1  03134145  13034145  03134541  13034541\n"
			+ "S'+H'      101FD  2  4  0  45031341  45130341\n"
			+ "H''         FFFF  1  2  0  00000541\n"
			+ "2H'         FE01  4  4  1  03134145  13034145  03134541  13034541\n"
			+ "X'+H'       FDFD  2  4  0  45031341  45130341\n"
			+ "H'+X'       FBFF  1  4  0  43030541\n"
			+ "RE'2R       7007  8  4  1  01110414  01111404  11010414  11011404  04140111  04141101  14040111  14041101\n"
			+ "RE'+R       7003  2  4  0  01110441  11010441\n"
			+ "E'+R        6FFF  2  4  0  01110441  11010441\n"
			+ "RA'+R       5001  2  4  0  01415144  01514144\n"
			+ "A'+R        4FFD  2  4  0  01444151  01445141\n"
			+ "R'+RE       3601  2  4  0  01021244  01120244\n"
			+ "S'+RE       35FD  2  4  0  01021244  01120244\n"
			+ "R'+RE       3403  1  4  0  01020442\n"
			+ "H'+RE       33FF  1  4  0  01020442\n"
			+ "H'+RE       3201  2  4  0  01021244  01120244\n"
			+ "S'+E        31FD  2  4  0  01440212  01441202\n"
			+ "2R'         3113  2  4  1  01044243  04014342\n"
			+ "R'+H'       310F  1  4  0  01044243\n"
			+ "R'+S'       30D3  1  4  0  01044342\n"
			+ "S'+H'       30CF  1  4  0  01430442\n"
			+ "R'+E        303F  1  4  0  01030443\n"
			+ "R'+RA       3021  2  4  0  01435344  01534344\n"
			+ "R'+A        301D  2  4  0  01444353  01445343\n"
			+ "RE'         3003  2  2  1  00000104  00000401\n"
			+ "E'          2FFF  1  2  0  00000104\n"
			+ "E'+X        2FFB  2  4  0  01440414  01441404\n"
			+ "S'+RA       2FE1  2  4  0  01435344  01534344\n"
			+ "S'+A        2FDD  2  4  0  01444353  01445343\n"
			+ "S'+E        2FC3  1  4  0  01044303\n"
			+ "S'+XE       2FBF  1  4  0  01430304\n"
			+ "S'+A        2FA1  2  4  0  01435344  01534344\n"
			+ "S'+XA       2F9D  2  4  0  01435344  01534344\n"
			+ "H'+E        2E01  2  4  0  01021244  01120244\n"
			+ "X'+E        2DFD  2  4  0  01440212  01441202\n"
			+ "X'+R'       2D0F  1  4  0  01420443\n"
			+ "2S'         2CD3  2  4  1  01044243  04014342\n"
			+ "X'+S'       2CCF  1  4  0  01424304\n"
			+ "X'+E        2BFF  1  4  0  01420204\n"
			+ "R'+RA       1401  1  4  0  02414244\n"
			+ "S'+RA       13FD  1  4  0  02444142\n"
			+ "2R'         1331  2  4  1  02034144  03024441\n"
			+ "R'+S'       132D  1  4  0  02034441\n"
			+ "R'+H'       12F1  1  4  0  02034144\n"
			+ "H'+S'       12ED  1  4  0  02440341\n"
			+ "H'+RA       11FF  2  4  0  04414252  04415242\n"
			+ "R'+E        105F  2  4  0  03130441  13030441\n"
			+ "R'+A        103D  1  4  0  03444143\n"
			+ "H'+E        101F  2  4  0  03130441  13030441\n"
			+ "RA'         1001  2  2  1  00004144  00004441\n"
			+ "A'           FFD  1  2  0  00004441\n"
			+ "A'+X         FF9  2  4  0  44540441  54440441\n"
			+ "H'+XE        FDF  2  4  0  03130441  13030441\n"
			+ "H'+A         FC1  1  4  0  43034144\n"
			+ "H'+XA        FBD  1  4  0  43440341\n"
			+ "R'+X'        F2D  1  4  0  03440241\n"
			+ "2H'          EF1  2  4  1  02034144  03024441\n"
			+ "X'+H'        EED  1  4  0  44020341\n"
			+ "H'+A         DFF  2  4  0  42520441  52420441\n"
			+ "X'+A         BFD  1  4  0  42440241\n"
			+ "X'+A         9FF  2  4  0  42520441  52420441\n"
			+ "R'+R         701  2  4  0  01114143  11014143\n"
			+ "S'+R         6FD  2  4  0  01114341  11014341\n"
			+ "S'+R+X       6F9  4  4  0  01114353  01115343  11014353  11015343\n"
			+ "R'+RE        631  2  4  0  01110243  11010243\n"
			+ "S'+RE        62D  2  4  0  01110243  11010243\n"
			+ "2R'          602  4  4  0  01114353  01115343  11014353  11015343\n"
			+ "R'+S'        5FE  4  4  0  01114353  01115343  11014353  11015343\n"
			+ "2S'          5FA  4  4  0  01114353  01115343  11014353  11015343\n"
			+ "R'+E         5F1  2  4  0  01110243  11010243\n"
			+ "S'+E         5ED  2  4  0  01114302  11014302\n"
			+ "R'+R         503  2  4  0  01034151  01035141\n"
			+ "H'+R         4FF  2  4  0  01034151  01035141\n"
			+ "2RE          363  4  4  1  01021203  01120203  03021201  03120201\n"
			+ "E+RE         35F  2  4  0  01021203  01120203\n"
			+ "RA+RE        341  1  4  0  01024243\n"
			+ "A+RE         33D  1  4  0  01024342\n"
			+ "E+RE         323  4  4  1  01030212  01031202  03010212  03011202\n"
			+ "2E           31F  2  4  0  01021203  01120203\n"
			+ "R'+RA        312  2  4  0  01424353  01425343\n"
			+ "R'+A         30E  2  4  0  01435342  01534342\n"
			+ "S'+A         30A  2  4  0  01435342  01534342\n"
			+ "R'           301  1  2  0  00000143\n"
			+ "S'           2FD  1  2  0  00000143\n"
			+ "S'+X         2F9  2  4  0  01435303  01534303\n"
			+ "2E           2E3  4  4  1  01030212  01031202  03010212  03011202\n"
			+ "XE+E         2DF  2  4  0  01021203  01120203\n"
			+ "R'+A         2D2  2  4  0  01424353  01425343\n"
			+ "S'+A         2CE  2  4  0  01424353  01425343\n"
			+ "S'+XA        2CA  2  4  0  01424353  01425343\n"
			+ "A+E          2C1  1  4  0  01420243\n"
			+ "XA+E         2BD  1  4  0  01424302\n"
			+ "R'+E         231  2  4  0  02011143  02110143\n"
			+ "S'+E         22D  2  4  0  02430111  02431101\n"
			+ "H'+RA        20F  2  4  0  03415142  03514142\n"
			+ "R'+H'        202  1  0  0  00000000\n"
			+ "2H'          1FE  4  4  0  03134151  03135141  13034151  13035141\n"
			+ "X'+S'        1FA  4  4  0  43530111  43531101  53430111  53431101\n"
			+ "H'+E         1F1  2  4  0  01110243  11010243\n"
			+ "X'+E         1ED  2  4  0  43011102  43110102  \n"
			+ "H'+A         1CF  2  4  0  42034151  42035141\n"
			+ "RA+E         13F  1  4  0  02034142\n"
			+ "H'+E         12E  2  4  0  02031341  02130341\n"
			+ "2RA          121  4  4  1  41425243  41524243  43425241  43524241\n"
			+ "RA+A         11D  2  4  0  43414252  43415242\n"
			+ "H'            FF  1  2  0  00000341\n"
			+ "H'+X          FB  2  4  0  43031341  43130341\n"
			+ "H'+XE         EE  2  4  0  02031341  02130341\n"
			+ "RA+A          E1  4  4  1  42524143  52424143  42524341  52424341\n"
			+ "2A            DD  2  4  0  43425241  43524241\n"
			+ "A+XE          BF  1  4  0  42020341\n"
			+ "RE+2R         B3  6  4  0  01112102  01211102  11012102  11210102  21011102  21110102\n"
			+ "E+2R          AF  6  4  0  01112102  01211102  11012102  11210102  21011102  21110102\n"
			+ "2A            A1  4  4  1  42524143  52424143  42524341  52424341\n"
			+ "2E+R          9E  6  4  0  01112141  01211141  11012141  11210141  21011141  21110141\n"
			+ "A+XA          9D  2  4  0  42524341  52424341\n"
			+ "RE+2R         77  8  4  1  01110212  01111202  11010212  11011202  02120111  02121101  12020111  12021101\n"
			+ "RE+R          73  2  4  0  01110241  11010241\n"
			+ "E+R           6F  2  4  0  01110241  11010241\n"
			+ "2RE           66  8  4  1  01110212  01111202  11010212  11011202  02120111  02121101  12020111  12021101\n"
			+ "RE+E          62  4  4  0  01110212  01111202  11010212  11011202\n"
			+ "2E            5E  4  4  0  01110212  01111202  11010212  11011202\n"
			+ "RA+R          51  2  4  0  01415142  01514142\n"
			+ "A+R           4D  2  4  0  01424151  01425141\n"
			+ "RE            33  2  2  1  00000102  00000201\n"
			+ "E             2F  1  2  0  00000102\n"
			+ "E+X           2B  2  4  0  01420212  01421202\n"
			+ "2RA*          22  1  0  0  00000000\n"
			+ "A+RA*         1E  1  0  0  00000000\n"
			+ "2A            1A  4  4  0  42524151  42525141  52424151  52425141\n"
			+ "2A+X          16  6  4  0  42526202  42625202  52426202  52624202  62425202  62524202\n"
			+ "RA            11  2  2  1  00004142  00004241\n"
			+ "A              D  1  2  0  00004241\n"
			+ "3R             C  6  4  0  01112141  01211141  11012141  11210141  21011141  21110141\n"
			+ "A+X            9  2  4  0  42520241  52420241\n"
			+ "2R             8  4  4  0  01114151  01115141  11014151  11015141\n"
			+ "A+2X           5  6  4  0  42526241  42625241  52426241  52624241  62425241  62524241\n"
			+ "R              4  1  2  0  00000141\n"
			+ "S              0  4  4  0  01114151  01115141  11014151  11015141\n"
			+ "X             -4  1  2  0  00004101\n"
			+ "2X            -8  4  4  0  41510111  41511101  51410111  51411101\n"
			+ "3X            -C  6  4  0  41516101  41615101  51416101  51614101  61415101  61514101\n"
			+ "XE           -11  2  2  1  00000102  00000201\n"
			+ "XE+X         -15  2  4  0  42010212  42011202\n"
			+ "2A*          -22  1  0  0  00000000\n"
			+ "XA+A         -26  4  4  0  42524151  42525141  52424151  52425141\n"
			+ "XA           -33  2  2  1  00004142  00004241\n"
			+ "XA+X         -37  2  4  0  41425202  41524202\n"
			+ "XA+2X        -3B  6  4  0  41425262  41426252  41524262  41526242  41624252  41625242\n"
			+ "2XA          -66  8  4  1  41514252  41515242  51414252  51415242  42524151  42525141  52424151  52425141\n"
			+ "XA+2X        -77  8  4  1  41514252  41515242  51414252  51415242  42524151  42525141  52424151  52425141\n"
			+ "2E           -A1  4  4  1  02120103  12020103  02120301  12020301\n"
			+ "A+E          -C3  1  4  0  02430142\n"
			+ "XE+E         -E1  4  4  1  02120103  12020103  02120301  12020301\n"
			+ "H'+A         -F2  2  4  0  43530142  53430142\n"
			+ "X'+A         -F6  2  4  0  43530142  53430142\n"
			+ "X'          -103  1  2  0  00004301\n"
			+ "X'+X        -107  2  4  0  43530103  53430103\n"
			+ "2XE         -121  4  4  1  01021203  01120203  03021201  03120201\n"
			+ "X'+A        -132  2  4  0  42435301  42534301\n"
			+ "X'+XA       -136  2  4  0  42435301  42534301\n"
			+ "XA+XE       -143  1  4  0  42430102\n"
			+ "X'+E        -1D3  2  4  0  02430111  02431101\n"
			+ "X'+H'       -202  1  0  0  00000000\n"
			+ "2X'         -206  4  4  0  43530111  43531101  53430111  53431101\n"
			+ "X'+XE       -213  2  4  0  43011102  43110102\n"
			+ "2A          -2E3  4  4  1  41434252  41435242  43414252  43415242\n"
			+ "X'+X        -305  2  4  0  41430313  41431303\n"
			+ "A+XA        -323  4  4  1  41434252  41435242  43414252  43415242\n"
			+ "2XA         -363  4  4  1  41425243  41524243  43425241  43524241\n"
			+ "S'+E        -A03  2  4  0  02124401  12024401\n"
			+ "H'+E        -C01  1  4  0  02010442\n"
			+ "S'+XE       -E03  2  4  0  44021201  44120201\n"
			+ "2H'         -EF1  2  4  1  01044243  04014342\n"
			+ "X'+H'       -F31  1  4  0  43010442\n"
			+ "H'+A        -FE3  2  4  0  44014353  44015343\n"
			+ "XE'        -1001  2  2  1  00000104  00000401\n"
			+ "XE'+X      -1005  2  4  0  44010414  44011404\n"
			+ "H'+XA      -1023  2  4  0  44014353  44015343\n"
			+ "X'+XE      -1041  1  4  0  43010304\n"
			+ "X'+XA      -1063  2  4  0  43534401  53434401\n"
			+ "X'+XE      -1203  2  4  0  44010212  44011202\n"
			+ "2X'        -1331  2  4  1  42430104  43420401\n"
			+ "S'+A       -2C03  1  4  0  02414442\n"
			+ "2S'        -2CD3  2  4  1  02034144  03024441\n"
			+ "X'+S'      -2D13  1  4  0  02414403\n"
			+ "XA'        -3003  2  2  1  00004144  00004441\n"
			+ "XA'+X      -3007  2  4  0  41445404  41544404\n"
			+ "X'+XA      -3043  1  4  0  41434403\n"
			+ "2X'        -3113  2  4  1  41440203  44410302\n"
			+ "XA'+2X     -7007  8  4  1  41514454  41515444  51414454  51415444  44544151  44545141  54444151  54445141\n"
			+ "S'+H'      -FC03  1  4  0  03450143\n"
			+ "2H'        -FE01  4  4  1  01054353  01055343  05014353  05015343\n"
			+ "X''       -10003  1  2  0  00004501\n"
			+ "X'+H'     -10201  4  4  1  43530105  53430105  43530501  53430501\n"
			+ "2X'       -10403  1  4  0  43450103\n"
			+ "2X'       -10601  4  4  1  43530105  53430105  43530501  53430501\n"
			+ "2S'       -2FA03  4  4  1  03134145  13034145  03134541  13034541\n"
			+ "X'+S'     -2FE03  4  4  1  41450313  41451303  45410313  45411303\n"
			+ "2X'       -30203  4  4  1  41450313  41451303  45410313  45411303\n"
			+ "XE''     -100000  2  2  1  00000106  00000601\n"
			+ "XA''     -300003  2  2  1  00004146  00004641";

	private String GRPNAMES = 
			  "8 02 Hydrogen\n"
			+ "8 04 Deuterium\n"
			+ "8 06 Tritium\n"
			+ "8 24 Sodium\n"
			+ "8 25 Potassium\n"
			+ "8 26 Rubidium\n"
			+ "8 27 Cesium\n"
			+ "8 28 Lithium\n"
			+ "8 2A Magnesium\n"
			+ "8 2C Calcium\n"
			+ "8 2D Strontium\n"
			+ "8 2E Barium\n"
			+ "8 2F Radium\n"
			+ "8 30 Beryllium\n"
			+ "8 32 Aluminium\n"
			+ "8 34 Gallium\n"
			+ "8 36 Indium\n"
			+ "8 37 Thallium\n"
			+ "8 38 Boron\n"
			+ "8 3A Silicon\n"
			+ "8 3B Germanium\n"
			+ "8 3C Tin\n"
			+ "8 3D Lead\n"
			+ "8 3E Antimony\n"
			+ "8 3F Bismuth\n"
			+ "8 40 Scandium\n"
			+ "8 41 Yttrium\n"
			+ "8 42 Lanthanum\n"
			+ "8 43 Actinium\n"
			+ "8 44 Titanium\n"
			+ "8 45 Zirconium/Hafnium\n"
			+ "8 46 Vanadium\n"
			+ "8 47 Niobium/Tantalum\n"
			+ "8 48 Copper\n"
			+ "8 49 Silver\n"
			+ "8 4A Gold\n"
			+ "8 4C Zinc\n"
			+ "8 4D Cadmium\n"
			+ "8 4E Mercury\n"
			+ "8 50 Chromium\n"
			+ "8 52 Molybdenum\n"
			+ "8 53 Tungsten\n"
			+ "8 54 Manganese\n"
			+ "8 55 Iron\n"
			+ "8 56 Cobalt\n"
			+ "8 57 Nickel\n"
			+ "8 59 Ruthenium\n"
			+ "8 5A Rhodium\n"
			+ "8 5B Palladium\n"
			+ "8 5C Rhenium\n"
			+ "8 5D Osmium\n"
			+ "8 5E Iridium\n"
			+ "8 5F Platinum\n"
			+ "8 62 Cerium\n"
			+ "8 63 Praseodymium\n"
			+ "8 64 Neodymium\n"
			+ "8 65 Promethium\n"
			+ "8 66 Samarium\n"
			+ "8 67 Europium\n"
			+ "8 68 Gadolinium\n"
			+ "8 69 Terbium\n"
			+ "8 6A Dysprosium\n"
			+ "8 6B Holmium\n"
			+ "8 6C Erbium\n"
			+ "8 6D Thulium\n"
			+ "8 6E Ytterbium\n"
			+ "8 6F Lutetium\n"
			+ "8 72 Thorium\n"
			+ "8 73 Protactinium\n"
			+ "8 74 Uranium\n"
			+ "8 75 Neptunium\n"
			+ "8 76 Plutonium\n"
			+ "8 77 Americium\n"
			+ "8 78 Curium\n"
			+ "8 79 Berkelium\n"
			+ "8 7A Californium\n"
			+ "8 7B Einsteinium\n"
			+ "8 7C Fermium\n"
			+ "8 7D Mendelevium\n"
			+ "8 7E Nobelium\n"
			+ "8 7F Lawrencium\n"
			+ "8 80 methoxy\n"
			+ "8 81 saturated primary alkoxy (except methoxy)\n"
			+ "8 82 saturated secondary alkoxy\n"
			+ "8 83 saturated tertiary alkoxy\n"
			+ "8 84 allyloxy or benzyloxy\n"
			+ "8 86 phenoxy\n"
			+ "8 87 alkenoxy\n"
			+ "8 88 hetero substituted methoxy\n"
			+ "8 89 primary alpha hetero substituted alkoxy (except methoxy)\n"
			+ "8 8A secondary alpha hetero substituted alkoxy\n"
			+ "8 8C di hetero substituted methoxy\n"
			+ "8 8D di hetero substituted alkoxy (except methoxy)\n"
			+ "8 8E tri hetero substituted methoxy\n"
			+ "8 90 peroxo\n"
			+ "8 91 -O-N group\n"
			+ "8 92 sulfonate, sulfinate, sulfenate, sulfate, sulfite\n"
			+ "8 93 phosphate, phosphite, phosphonate, phosphinate\n"
			+ "8 94 -O-? (except -OH, -O-O, -O-N, -O-S, -O-P, -O-Si, -O-C)\n"
			+ "8 98 hydroxy\n"
			+ "8 9A silyloxy\n"
			+ "8 9C oxo\n"
			+ "8 A0 primary amino\n"
			+ "8 A1 monoalkyl amino\n"
			+ "8 A2 dialkyl amino\n"
			+ "8 A3 imine -N=C\n"
			+ "8 A4 monohetero substituted amino\n"
			+ "8 A6 dihetero substituted amino\n"
			+ "8 A8 ammonium, alkylammonium\n"
			+ "8 AA immonium -N(+)=C\n"
			+ "8 AB isonitril\n"
			+ "8 AC monohetero substituted ammonium\n"
			+ "8 AE nitro, di- or trihetero substituted ammonium\n"
			+ "8 B0 immonium =N(+)R2\n"
			+ "8 B2 mono hetero substituted immonium =N(+)ZR\n"
			+ "8 B3 dihetero substituted immonium =N(+)Z2\n"
			+ "8 B4 imine, alkylimine =NH, =NR\n"
			+ "8 B6 hetero substituted imine =N-Z\n"
			+ "8 B8 nitrile\n"
			+ "8 D0 carbenium\n"
			+ "8 D8 fluoride\n"
			+ "8 DC chloride\n"
			+ "8 DE bromide\n"
			+ "8 DF iodide\n"
			+ "8 E0 phosphide\n"
			+ "8 E2 phosphonium\n"
			+ "8 E4 mono- or dihetero substituted phosphide\n"
			+ "8 E6 tri- or higher hetero substituted phosphide\n"
			+ "8 E8 any arsenium group\n"
			+ "8 F0 sulfonic or sulfinic acid derivative\n"
			+ "8 F1 selenonic or seleninic acid derivative\n"
			+ "8 F2 sulfenic acid derivative\n"
			+ "8 F3 selenenic acid derivative\n"
			+ "8 F4 sulfoxide, dihetero substituted sulfide\n"
			+ "8 F5 selenoxide, dihetero substituted selenide\n"
			+ "8 F6 sulfone, tetrahetero substituted sulfide\n"
			+ "8 F7 selenone, tetrahetero substituted selenide\n"
			+ "8 F8 sulfide\n"
			+ "8 F9 thiocarbonyl\n"
			+ "8 FA selenide\n"
			+ "8 FC telluride\n"
			+ "8 FE hetero subsituted telluride\n"
			+ "7 24 Sodium,Potassium\n"
			+ "7 26 Rubidium,Cesium\n"
			+ "7 2C Calcium,Strontium\n"
			+ "7 2E Barium,Radium\n"
			+ "7 36 Indium,Thallium\n"
			+ "7 3A Silicon,Germanium\n"
			+ "7 3C Tin,Lead\n"
			+ "7 3E Antimony,Bismuth\n"
			+ "7 40 Scandium,Yttrium\n"
			+ "7 42 Lanthanum,Actinium\n"
			+ "7 44 Titanium,Zirconium,Hafnium\n"
			+ "7 46 Vanadium,Niobium,Tantalum\n"
			+ "7 48 Copper,Silver\n"
			+ "7 4C Zinc,Cadmium\n"
			+ "7 52 Molybdenum,Tungsten\n"
			+ "7 54 Manganese,Iron\n"
			+ "7 56 Cobalt,Nickel\n"
			+ "7 5A Rhodium,Palladium\n"
			+ "7 5C Rhenium,Osmium\n"
			+ "7 5E Iridium,Platinum\n"
			+ "7 62 Cerium, Praseodymium\n"
			+ "7 64 Neodymium, Promethium\n"
			+ "7 66 Samarium, Europium\n"
			+ "7 68 Gadolinium, Terbium\n"
			+ "7 6A Dysprosium, Holmium\n"
			+ "7 6C Erbium, Thulium\n"
			+ "7 6E Ytterbium, Lutetium\n"
			+ "7 72 Thorium, Protactinium\n"
			+ "7 74 Uranium, Neptunium\n"
			+ "7 76 Plutonium, Americium\n"
			+ "7 78 Curium, Berkelium\n"
			+ "7 7A Californium, Einsteinium\n"
			+ "7 7C Fermium, Mendelevium\n"
			+ "7 7E Nobelium, Lawrencium\n"
			+ "7 80 saturated primary alkoxy\n"
			+ "7 82 saturated secondary or tertiary alkoxy\n"
			+ "7 86 phenoxy or alkenoxy\n"
			+ "7 88 primary alpha hetero substituted alkoxy\n"
			+ "7 8C di hetero substituted alkoxy\n"
			+ "7 90 -O-O or -O-N group\n"
			+ "7 92 -O-P or -O-S group\n"
			+ "7 A0 -NH2, -NHR\n"
			+ "7 A2 dialkyl amino, -N=C\n"
			+ "7 AA immonium -N(+)=C, isonitril\n"
			+ "7 B2 hetero substituted immonium =N(+)ZR, =N(+)Z2\n"
			+ "7 DE bromide,iodide\n"
			+ "7 F0 sulfonic, sulfinic, selenonic or seleninic acid derivative\n"
			+ "7 F2 sulfenic or selenenic acid derivative\n"
			+ "7 F4 sulfoxide, selenoxide or S/Se group in same oxidation state\n"
			+ "7 F6 sulfone, selenone or S/Se group in same oxidation state\n"
			+ "7 F8 sulfide, thiocarbonyl\n"
			+ "6 04 Deuterium,Tritium\n"
			+ "6 24 Sodium,Potassium,Rubidium,Cesium\n"
			+ "6 28 Lithium,Magnesium\n"
			+ "6 2C Calcium,Strontium,Barium,Radium\n"
			+ "6 30 Beryllium,Aluminium\n"
			+ "6 34 Gallium,Indium,Thallium\n"
			+ "6 38 Boron,Silicon,Germanium\n"
			+ "6 3C Tin,Lead,Antimony,Bismuth\n"
			+ "6 40 Scandium,Yttrium,Lanthanum,Actinium\n"
			+ "6 44 Ti,Zr,Hf,V,Nb,Ta\n"
			+ "6 48 Copper,Silver,Gold\n"
			+ "6 4C Zinc,Cadmium,Mercury\n"
			+ "6 50 Chromium,Molybdenum,Tungsten\n"
			+ "6 54 Manganese,Iron,Cobalt,Nickel\n"
			+ "6 58 Ruthenium,Rhodium,Palladium\n"
			+ "6 5C Rhenium,Osmium,Iridium,Platinum\n"
			+ "6 64 Nd,Pm,Sm,Eu\n"
			+ "6 68 Gd,Tb,Dy,Ho\n"
			+ "6 6C Er,Tm,Yb,Lu\n"
			+ "6 74 U,Np,Pu,Am\n"
			+ "6 78 Cm,Bk,Cf,Es\n"
			+ "6 7C Fm,Md,No,Lr\n"
			+ "6 80 saturated alkoxy\n"
			+ "6 84 allyloxy, benzyloxy, phenoxy or alkenoxy\n"
			+ "6 88 alpha monohetero substituted alkoxy\n"
			+ "6 8C di- or trihetero substituted alkoxy\n"
			+ "6 90 -O-O, -O-N, -O-P or -O-S group\n"
			+ "6 98 hydroxy,silyloxy\n"
			+ "6 A0 -NH2, -NHR, -NR2, -N=C\n"
			+ "6 A4 -NHZ, -NRZ, -NZ2\n"
			+ "6 A8 ammonium, immonium -N(+)=C, isonitril\n"
			+ "6 AC nitro, hetero substituted ammonium\n"
			+ "6 B0 =N(+)R2, =N(+)ZR, =N(+)Z2\n"
			+ "6 B4 =NH, =NR, =NZ\n"
			+ "6 DC chloride,bromide,iodide\n"
			+ "6 E0 phosphide, phosphonium\n"
			+ "6 F0 -SZ, -SZ3, -SZ5, -SeZ, -SeZ3, -SeZ5\n"
			+ "6 F4 -SZ2, -SZ4, -SeZ2, -SeZ4\n"
			+ "6 F8 sulfide, selenide, thiocarbonyl\n"
			+ "6 FC any tellurium group\n"
			+ "5 00 Hydrogen,Deuterium,Tritium\n"
			+ "5 28 Li,Mg,Ca,Sr,Ba,Ra\n"
			+ "5 30 Be,Al,Ga,In,Tl\n"
			+ "5 38 B,Si,Ge,Sn,Pb,Sb,Bi\n"
			+ "5 40 Sc,Y,La,Ac,Ti,Zr,Hf,V,Nb,Ta\n"
			+ "5 48 Cu,Ag,Au,Zn,Cd,Hg\n"
			+ "5 50 Cr,Mo,W,Mn,Fe,Co,Ni\n"
			+ "5 58 Ru,Rh,Pd,Re,Os,Ir,Pt\n"
			+ "5 60 Ce,Pr,Nd,Pm,Sm,Eu\n"
			+ "5 68 Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu\n"
			+ "5 70 Th,Pa,U,Np,Pu,Am\n"
			+ "5 78 Cm,Bk,Cf,Es,Fm,Md,No,Lr\n"
			+ "5 80 alkoxy, alkenoxy, phenoxy\n"
			+ "5 88 alpha hetero substituted alkoxy\n"
			+ "5 90 -O-? (? <> H,Si,C)\n"
			+ "5 98 oxo,hydroxy,silyloxy\n"
			+ "5 A0 -NH2, -NHR, -NR2, -NHZ, -NRZ, -NZ2, -N=C\n"
			+ "5 A8 -N(+), isonitril\n"
			+ "5 B0 =NH, =NR, =NZ, =N(+)R2, =N(+)ZR, =N(+)Z2\n"
			+ "5 D8 halogenide\n"
			+ "5 E0 any phoshorous group\n"
			+ "5 F0 any oxidized sulfur or selenium group\n"
			+ "5 F8 sulfide, selenide, thiocarbonyl or any tellurium group\n"
			+ "4 20 metal of group I A or II A except Be\n"
			+ "4 30 electropositive element of group III A, IV A, V A or Be\n"
			+ "4 40 element of group I B, II B, III B, IV B or V B\n"
			+ "4 50 element of group VI B, VII B or VIII B\n"
			+ "4 60 lanthanide\n"
			+ "4 70 actinide\n"
			+ "4 80 -O-C\n"
			+ "4 90 -O-? (except -O-C), oxo\n"
			+ "4 A0 any single bond nitrogen group\n"
			+ "4 B0 any double bond nitrogen group or nitrile\n"
			+ "4 D0 halogenide or carbenium\n"
			+ "4 E0 any phoshorous or arsenium group\n"
			+ "4 F0 any sulfur, selenium or tellurium group\n"
			+ "3 20 electropositive element of group I-V A except Hydrogen\n"
			+ "3 40 transition element\n"
			+ "3 60 rare earth element\n"
			+ "3 80 any oxygen group\n"
			+ "3 A0 any nitrogen group\n"
			+ "3 E0 any P,As,S,Se or Te group\n"
			+ "2 00 electropositive element of group I-V A\n"
			+ "2 40 transition element, rare earth\n"
			+ "2 80 any oxygen or nitrogen group\n"
			+ "2 C0 any P,As,S,Se,Te,F,Cl,Br or I group\n"
			+ "1 00 any electropositive element\n"
			+ "1 80 any electronegative element\n"
			+ "0 00 anything\n";

		private String EFGNAMES =
			  "8 0000 non allylic R3C-Li\n"
			+ "8 0001 C=C-CR2-Li\n"
			+ "8 0002 non allylic X-C-Li\n"
			+ "8 0003 C=C-C(-X)-Li\n"
			+ "8 0004 non allylic R3C-Na,K,Rb,Cs\n"
			+ "8 0005 C=C-CR2-Na,K,Rb,Cs\n"
			+ "8 0006 non allylic X-C-Na,K,Rb,Cs\n"
			+ "8 0007 C=C-C(-X)-Na,K,Rb,Cs\n"
			+ "8 0008 non allylic R3C-Mg,Be\n"
			+ "8 0009 C=C-CR2-Mg,Be\n"
			+ "8 000A non allylic X-C-Mg,Be\n"
			+ "8 000B C=C-C(-X)-Mg,Be\n"
			+ "8 000C non allylic R3C-Ca,Sr,Ba\n"
			+ "8 000D C=C-CR2-Ca,Sr,Ba\n"
			+ "8 000E non allylic X-C-Ca,Sr,Ba\n"
			+ "8 000F C=C-C(-X)-Ca,Sr,Ba\n"
			+ "8 0010 non allylic R3C-Al\n"
			+ "8 0011 C=C-CR2-Al\n"
			+ "8 0012 non allylic X-C-Al\n"
			+ "8 0013 C=C-C(-X)-Al\n"
			+ "8 0014 non allylic R3C-Ga,In,Tl\n"
			+ "8 0015 C=C-CR2-Ga,In,Tl\n"
			+ "8 0016 non allylic X-C-Ga,In,Tl\n"
			+ "8 0017 C=C-C(-X)-Ga,In,Tl\n"
			+ "8 0018 non allylic R3C-Ge,Sn,Pb\n"
			+ "8 0019 C=C-CR2-Ge,Sn,Pb\n"
			+ "8 001A non allylic X-C-Ge,Sn,Pb\n"
			+ "8 001B C=C-C(-X)-Ge,Sn,Pb\n"
			+ "8 001C non allylic R3C-Sb,Bi\n"
			+ "8 001D C=C-CR2-Sb,Bi\n"
			+ "8 001E non allylic X-C-Sb,Bi\n"
			+ "8 001F C=C-C(-X)-Sb,Bi\n"
			+ "8 0020 non allylic R3C-Cu,Ag,Au\n"
			+ "8 0021 C=C-CR2-Cu,Ag,Au\n"
			+ "8 0022 non allylic X-C-Cu,Ag,Au\n"
			+ "8 0023 C=C-C(-X)-Cu,Ag,Au\n"
			+ "8 0024 non allylic R3C-Zn,Cd,Hg\n"
			+ "8 0025 C=C-CR2-Zn,Cd,Hg\n"
			+ "8 0026 non allylic X-C-Zn,Cd,Hg\n"
			+ "8 0027 C=C-C(-X)-Zn,Cd,Hg\n"
			+ "8 0028 non allylic R3C-Sc,Y,La,Ac\n"
			+ "8 0029 C=C-CR2-Sc,Y,La,Ac\n"
			+ "8 002A non allylic X-C-Sc,Y,La,Ac\n"
			+ "8 002B C=C-C(-X)-Sc,Y,La,Ac\n"
			+ "8 002C non allylic R3C-rare Earth\n"
			+ "8 002D C=C-CR2-rare Earth\n"
			+ "8 002E non allylic X-C-rare Earth\n"
			+ "8 002F C=C-C(-X)-rare Earth\n"
			+ "8 0030 non allylic R3C-Ti,Zr,Hf\n"
			+ "8 0031 C=C-CR2-Ti,Zr,Hf\n"
			+ "8 0032 non allylic X-C-Ti,Zr,Hf\n"
			+ "8 0033 C=C-C(-X)-Ti,Zr,Hf\n"
			+ "8 0034 non allylic R3C-V,Cr type\n"
			+ "8 0035 C=C-CR2-V,Cr type\n"
			+ "8 0036 non allylic X-C-V,Cr type\n"
			+ "8 0037 C=C-C(-X)-V,Cr type\n"
			+ "8 0038 non allylic R3C-Mn,Fe,Co,Ni\n"
			+ "8 0039 C=C-CR2-Mn,Fe,Co,Ni\n"
			+ "8 003A non allylic X-C-Mn,Fe,Co,Ni\n"
			+ "8 003B C=C-C(-X)-Mn,Fe,Co,Ni\n"
			+ "8 003C non allylic R3C-Pd type\n"
			+ "8 003D C=C-CR2-Pd type\n"
			+ "8 003E non allylic X-C-Pd type\n"
			+ "8 003F C=C-C(-X)-Pd type\n"
			+ "8 0040 BH(-)X3,R-BH(-)X2\n"
			+ "8 0041 R2-BH(-)X\n"
			+ "8 0042 R3BH(-)\n"
			+ "8 0043 (C-)4B(-)\n"
			+ "8 0044 (C-)3B(-)X\n"
			+ "8 0045 (C-)2B(-)X2\n"
			+ "8 0046 C-B(-)X3\n"
			+ "8 0047 B(-)X4\n"
			+ "8 0048 (C-)2BH\n"
			+ "8 0049 C-BH2\n"
			+ "8 004A C-BHX\n"
			+ "8 004B BH2X\n"
			+ "8 004C BH(NR2)2\n"
			+ "8 004D BH(OR)2\n"
			+ "8 004E BHX2  X<>N,O\n"
			+ "8 004F Met at B\n"
			+ "8 0050 (C-)2B-N\n"
			+ "8 0051 (C-)2B-O\n"
			+ "8 0052 (C-)2B-S\n"
			+ "8 0053 (C-)2B-X  X<>N,O,S\n"
			+ "8 0054 B(NR2)3\n"
			+ "8 0055 B(OR)3\n"
			+ "8 0056 BX3  X<>N,O\n"
			+ "8 0057 B=X\n"
			+ "8 0058 Ar-B(OR)2\n"
			+ "8 0059 C(pi<>0)-B(OR)2\n"
			+ "8 005A C=C-C-B(OR)2\n"
			+ "8 005B C(aliph)-B(OR)2\n"
			+ "8 005C C-B(NR2)2\n"
			+ "8 005D C-BX2  X<>N,O\n"
			+ "8 005E (C-)3B\n"
			+ "8 0060 R4P(+)\n"
			+ "8 0061 RnP(+)X(4-n)  n<>4\n"
			+ "8 0062 (C-)2PH\n"
			+ "8 0063 C-PH2 type\n"
			+ "8 0064 (C-)3P=C\n"
			+ "8 0065 C-P=C\n"
			+ "8 0066 C=PH\n"
			+ "8 0067 rare P=C\n"
			+ "8 0068 Ar3P\n"
			+ "8 0069 (C-)3P except Ar3P\n"
			+ "8 006A P(-O-?)3\n"
			+ "8 006B PX3 except P(-O-?)3\n"
			+ "8 006C R3P=O type\n"
			+ "8 006D R3P=X  X<>O; RP=X\n"
			+ "8 006E R2PX type\n"
			+ "8 006F R3PX2,RPX2\n"
			+ "8 0070 R2P(=O)-X\n"
			+ "8 0071 R2P(=X)-Y  X<>O\n"
			+ "8 0072 RP(=O)(OR)2\n"
			+ "8 0073 RP(=O)X2  X<>O\n"
			+ "8 0074 RP(=X)Y2  X<>O\n"
			+ "8 0075 X=PY3  X<>O\n"
			+ "8 0076 O=P(OR)3\n"
			+ "8 0077 O=PX3  X<>O\n"
			+ "8 0078 As(z=3)\n"
			+ "8 0079 As(z=5)\n"
			+ "8 007A rare AsXn\n"
			+ "8 007B C-As-C\n"
			+ "8 007C C-AsH2 type\n"
			+ "8 007D C-AsX2\n"
			+ "8 007E C-As(z=4)\n"
			+ "8 007F rare C-AsXn\n"
			+ "8 0080 N-TMS\n"
			+ "8 0081 N-SiEtMe2\n"
			+ "8 0082 N-Si(iPr)Me2\n"
			+ "8 0083 N-Si(tBu)Me2\n"
			+ "8 0084 N-SiMe(iPr)2\n"
			+ "8 0085 N-SiEt(iPr)2\n"
			+ "8 0086 N-SiMe(tBu)2\n"
			+ "8 0087 N-Si(tBu)Ph2\n"
			+ "8 0088 O-TMS\n"
			+ "8 0089 O-SiEtMe2\n"
			+ "8 008A O-Si(iPr)Me2\n"
			+ "8 008B O-Si(tBu)Me2\n"
			+ "8 008C O-SiMe(iPr)2\n"
			+ "8 008D O-SiEt(iPr)2\n"
			+ "8 008E O-SiMe(tBu)2\n"
			+ "8 008F O-Si(tBu)Ph2\n"
			+ "8 0090 (C-)2Si(-O)2\n"
			+ "8 0091 (C-)2Si(-N)2\n"
			+ "8 0092 (C-)2Si(-S)2\n"
			+ "8 0093 (C-)2SiX2  X<>N,O,S\n"
			+ "8 0094 C-Si(-O)3\n"
			+ "8 0095 C-SiX3  X<>O\n"
			+ "8 0096 Si(-O)4\n"
			+ "8 0097 SiX4  X<>O\n"
			+ "8 0098 (C-)3Si-P\n"
			+ "8 0099 (C-)3Si-S\n"
			+ "8 009A (C-)3Si-X  X<>N,O,P,S\n"
			+ "8 009C Si-NH-?=X type\n"
			+ "8 009D Si-N(-C,X)-?=X\n"
			+ "8 009E Si-NH-?  non stabilized N\n"
			+ "8 009F Si-N(-C,X)2  non stabilized N\n"
			+ "8 00A0 (C-)3SiH\n"
			+ "8 00A1 (C-)2SiH2\n"
			+ "8 00A2 C-SiH3\n"
			+ "8 00A4 (C-)2SiH-O\n"
			+ "8 00A5 (C-)2SiH-X  X<>O\n"
			+ "8 00A6 C-SiH2-O\n"
			+ "8 00A7 C-SiH2-X  X<>O\n"
			+ "8 00A8 RSiH(-O)2\n"
			+ "8 00A9 RSiH(-N)2\n"
			+ "8 00AA RSiH(-S)2\n"
			+ "8 00AB RSiHX2  X<>N,O,S\n"
			+ "8 00AC SiH(-O)3\n"
			+ "8 00AD SiHX3  X<>O\n"
			+ "8 00B0 alkinylsilane\n"
			+ "8 00B1 alkenylsilane\n"
			+ "8 00B2 arylsilane\n"
			+ "8 00B3 allylsilane\n"
			+ "8 00B4 acylsilane\n"
			+ "8 00B5 tetraalkylsilane\n"
			+ "8 00B8 aromatic -C=N- or -N=N-\n"
			+ "8 00B9 aromatic -NH-\n"
			+ "8 00BA O(arom)\n"
			+ "8 00BB S(arom)\n"
			+ "8 00BC quinone\n"
			+ "8 00BD dihetero 3-ring\n"
			+ "8 00BE B at N\n"
			+ "8 00BF N-Met  Met<>B,Si\n"
			+ "8 00C0 X=?-C#CH\n"
			+ "8 00C1 C=C-C#CH\n"
			+ "8 00C2 X-C#CH\n"
			+ "8 00C3 C(sat)-C#CH\n"
			+ "8 00C4 X-C#C-X\n"
			+ "8 00C5 C=C-C#C-X\n"
			+ "8 00C6 C(sat)-C#C-X\n"
			+ "8 00C7 C(sat)-C#C-C(sat)\n"
			+ "8 00C8 X=?-C#C-?=X\n"
			+ "8 00C9 C=C-C#C-?=X\n"
			+ "8 00CA X=?-C#C-X\n"
			+ "8 00CB C(sat)-C#C-?=X\n"
			+ "8 00CC C=C-C#C-C=C\n"
			+ "8 00CD C(sat)-C#C-C=C\n"
			+ "8 00CE ?-C#C-B\n"
			+ "8 00CF ?-C#C-Met  Met,?<>B\n"
			+ "8 00D0 C(sat)-CH=CH2\n"
			+ "8 00D1 C=C-CH=CH2\n"
			+ "8 00D2 C(sat)-CH=CH-C(sat) type\n"
			+ "8 00D3 C=C-CH=CH-C type\n"
			+ "8 00D4 C-CH=C(-C)2\n"
			+ "8 00D5 C=C-CH=C(-C)2 type\n"
			+ "8 00D6 (C-)2C=C(-C)2\n"
			+ "8 00D7 C=C-C(-C)=C(-C)2\n"
			+ "8 00D8 (X=?-)2C=C-?=X type\n"
			+ "8 00D9 X=?-RC=CR-?=X type\n"
			+ "8 00DA C-C=C(-C)-?=X type\n"
			+ "8 00DB R-HC=CH-?=X type\n"
			+ "8 00DC X=?-XC=C-?=X type\n"
			+ "8 00DD X=?-C=CX type\n"
			+ "8 00DE X=?-XC=CX-? type\n"
			+ "8 00DF X=?-XC=CX2\n"
			+ "8 00E0 X2C=CX-?\n"
			+ "8 00E1 ?-XC=CX-? type\n"
			+ "8 00E2 R-HC=CH-X type\n"
			+ "8 00E3 C-C=CX-C type\n"
			+ "8 00E4 C3-ring with double bond\n"
			+ "8 00E5 featureless C3-ring\n"
			+ "8 00E6 stabilized C3-ring\n"
			+ "8 00E7 allylic C3-ring\n"
			+ "8 00E8 X-C=C=C-C=X type\n"
			+ "8 00E9 X-C=C=CR2 type\n"
			+ "8 00EA C=C=C-C=X type\n"
			+ "8 00EB dull C=C=C\n"
			+ "8 00EC X=?-Ar\n"
			+ "8 00ED X-Ar\n"
			+ "8 00EE featureless Ar\n"
			+ "8 00F0 XnC*(-C)4-n\n"
			+ "8 00F1 X=?-C*H\n"
			+ "8 00F2 C=C-C*H\n"
			+ "8 00F3 featureless C*H\n"
			+ "8 00F4 C-Te-X\n"
			+ "8 00F5 C-Te(z=3)\n"
			+ "8 00F6 C-Te(z=5)\n"
			+ "8 00F7 rare C-TeXn\n"
			+ "8 00F8 TeX2\n"
			+ "8 00F9 Te(z=4)\n"
			+ "8 00FA Te(z=6)\n"
			+ "8 00FB rare TeXn\n"
			+ "8 00FC C-Te-C\n"
			+ "8 00FD C-Te(z=2)-C\n"
			+ "8 00FE C-Te(z=4)-C\n"
			+ "8 00FF rare C-TeXn-C\n"
			+ "8 0100 Ar-F\n"
			+ "8 0101 C#C-F\n"
			+ "8 0102 C=C(-C)-F\n"
			+ "8 0103 C=CH-F\n"
			+ "8 0104 C=C-CR2-F\n"
			+ "8 0105 non allylic R-CH2-F\n"
			+ "8 0106 non allylic (C-)2CH-F\n"
			+ "8 0107 non allylic (C-)3C-F\n"
			+ "8 0108 C=CX-F\n"
			+ "8 0109 C=C-CX-F\n"
			+ "8 010A non allylic R2CX-F\n"
			+ "8 010C F3C-?=X\n"
			+ "8 010D F3C-R(non stabilized)\n"
			+ "8 010E stabilized F-CX2-R\n"
			+ "8 010F non stabilized F-CX2-R\n"
			+ "8 0110 R-CO-F\n"
			+ "8 0111 R-C(=X)-F  X<>N,O\n"
			+ "8 0112 R-C(=N)-F\n"
			+ "8 0113 F-CN\n"
			+ "8 0114 F-C(=O)-X\n"
			+ "8 0115 F-C(=N)-X\n"
			+ "8 0116 F-C(=X)-Y  X<>N,O\n"
			+ "8 0117 F-CX3\n"
			+ "8 0118 F-O-C\n"
			+ "8 0119 F-O-X\n"
			+ "8 011A F at P\n"
			+ "8 011B F at S\n"
			+ "8 011C F at amide N\n"
			+ "8 011D F at amine N\n"
			+ "8 011E F at B\n"
			+ "8 011F F at Si\n"
			+ "8 0120 Ar-Cl\n"
			+ "8 0121 C#C-Cl\n"
			+ "8 0122 C=C(-C)-Cl\n"
			+ "8 0123 C=CH-Cl\n"
			+ "8 0124 C=C-CR2-Cl\n"
			+ "8 0125 non allylic R-CH2-Cl\n"
			+ "8 0126 non allylic (C-)2CH-Cl\n"
			+ "8 0127 non allylic (C-)3C-Cl\n"
			+ "8 0128 C=CX-Cl\n"
			+ "8 0129 C=C-CX-Cl\n"
			+ "8 012A non allylic R2CX-Cl\n"
			+ "8 012C Cl3C-X=Y\n"
			+ "8 012D Cl3C-R(non stabilized)\n"
			+ "8 012E stabilized Cl-CX2-R\n"
			+ "8 012F non stabilized Cl-CX2-R\n"
			+ "8 0130 R-CO-Cl\n"
			+ "8 0131 R-C(=X)-Cl  X<>N,O\n"
			+ "8 0132 R-C(=N)-Cl\n"
			+ "8 0133 Cl-CN\n"
			+ "8 0134 Cl-C(=O)-X\n"
			+ "8 0135 Cl-C(=N)-X\n"
			+ "8 0136 Cl-C(=X)-Y  X<>N,O\n"
			+ "8 0137 Cl-CX3\n"
			+ "8 0138 Cl-O-C\n"
			+ "8 0139 Cl-O-X\n"
			+ "8 013A Cl at P\n"
			+ "8 013B Cl at S\n"
			+ "8 013C Cl at amide N\n"
			+ "8 013D Cl at amine N\n"
			+ "8 013E Cl at B\n"
			+ "8 013F Cl at Si\n"
			+ "8 0140 Ar-Br\n"
			+ "8 0141 C#C-Br\n"
			+ "8 0142 C=C(-C)-Br\n"
			+ "8 0143 C=CH-Br\n"
			+ "8 0144 C=C-CR2-Br\n"
			+ "8 0145 non allylic R-CH2-Br\n"
			+ "8 0146 non allylic (C-)2CH-Br\n"
			+ "8 0147 non allylic (C-)3C-Br\n"
			+ "8 0148 C=CX-Br\n"
			+ "8 0149 C=C-CX-Br\n"
			+ "8 014A non allylic R2CX-Br\n"
			+ "8 014C Br3C-X=Y\n"
			+ "8 014D Br3C-R(non stabilized)\n"
			+ "8 014E stabilized Br-CX2-R\n"
			+ "8 014F non stabilized Br-CX2-R\n"
			+ "8 0150 R-CO-Br\n"
			+ "8 0151 R-C(=X)-Br  X<>N,O\n"
			+ "8 0152 R-C(=N)-Br\n"
			+ "8 0153 Br-CN\n"
			+ "8 0154 Br-C(=O)-X\n"
			+ "8 0155 Br-C(=N)-X\n"
			+ "8 0156 Br-C(=X)-Y  X<>N,O\n"
			+ "8 0157 Br-CX3\n"
			+ "8 0158 Br-O-C\n"
			+ "8 0159 Br-O-X\n"
			+ "8 015A Br at P\n"
			+ "8 015B Br at S\n"
			+ "8 015C Br at amide N\n"
			+ "8 015D Br at amine N\n"
			+ "8 015E Br at B\n"
			+ "8 015F Br at Si\n"
			+ "8 0160 Ar-I\n"
			+ "8 0161 C#C-I\n"
			+ "8 0162 C=C(-C)-I\n"
			+ "8 0163 C=CH-I\n"
			+ "8 0164 C=C-CR2-I\n"
			+ "8 0165 non allylic R-CH2-I\n"
			+ "8 0166 non allylic (C-)2CH-I\n"
			+ "8 0167 non allylic (C-)3C-I\n"
			+ "8 0168 C=CX-I\n"
			+ "8 0169 C=C-CX-I\n"
			+ "8 016A non allylic R2CX-I\n"
			+ "8 016B R-IX4 type\n"
			+ "8 016C I3C-X=Y\n"
			+ "8 016D I3C-R(non stabilized)\n"
			+ "8 016E stabilized I-CX2-R\n"
			+ "8 016F non stabilized I-CX2-R\n"
			+ "8 0170 R-CO-I\n"
			+ "8 0171 R-C(=X)-I  X<>N,O\n"
			+ "8 0172 R-C(=N)-I\n"
			+ "8 0173 I-CN\n"
			+ "8 0174 I-C(=O)-X\n"
			+ "8 0175 I-C(=N)-X\n"
			+ "8 0176 I-C(=X)-Y  X<>N,O\n"
			+ "8 0177 I-CX3\n"
			+ "8 0178 I-O-C\n"
			+ "8 0179 I-O-X\n"
			+ "8 017A I at P\n"
			+ "8 017B I at S\n"
			+ "8 017C I at amide N\n"
			+ "8 017D I at amine N\n"
			+ "8 017E I at B\n"
			+ "8 017F I at Si\n"
			+ "8 0180 C-SeOH\n"
			+ "8 0181 C-Se-O-?  ?<>H\n"
			+ "8 0182 C-Se-Cl\n"
			+ "8 0183 C-SeX  X<>O,Cl,Se\n"
			+ "8 0184 C-SeSeH\n"
			+ "8 0185 C-SeSe-C\n"
			+ "8 0186 C-SeSe(z>1)\n"
			+ "8 0187 X-SeH\n"
			+ "8 0188 C-Se(=O)-C\n"
			+ "8 0189 rare Se(z=2)\n"
			+ "8 018A O-SeO2-O\n"
			+ "8 018B rare Se(z=6)\n"
			+ "8 018C C-SeO2-C\n"
			+ "8 018D O-Se(=O)-O\n"
			+ "8 018E X-Se(=O)-X  X<>O\n"
			+ "8 018F rare Se(z=4)\n"
			+ "8 0190 C-Se(=O)-OH\n"
			+ "8 0191 C-Se(=O)-O-?  ?<>H\n"
			+ "8 0192 C-Se(=O)-X  X<>O\n"
			+ "8 0193 rare Se(z=3)\n"
			+ "8 0194 C-SeO2-OH\n"
			+ "8 0195 C-SeO2-O-?  ?<>H\n"
			+ "8 0196 C-SeO2-X  X<>O\n"
			+ "8 0197 rare Se(z=5)\n"
			+ "8 0198 C-C(=Se)-C\n"
			+ "8 0199 R-CH(=Se)\n"
			+ "8 019A C-C(=Se)-X\n"
			+ "8 019B HC(=Se)-X\n"
			+ "8 019C X-C(=Se)-X\n"
			+ "8 019E C-Se-C\n"
			+ "8 019F C-SeH\n"
			+ "8 01A0 Ar-Se\n"
			+ "8 01A1 C=C(-X)-Se\n"
			+ "8 01A2 C#C-Se; C=CH-Se\n"
			+ "8 01A3 C=C(-C)-Se\n"
			+ "8 01A4 (C-)3C-Se\n"
			+ "8 01A5 (C-)2CH-Se\n"
			+ "8 01A6 R-CH2-Se\n"
			+ "8 01A7 C=C-CR2-Se\n"
			+ "8 01A8 X=C-Se\n"
			+ "8 01A9 (C-)2C(-X)-Se\n"
			+ "8 01AA C-CH(-X)-Se\n"
			+ "8 01AB X-CH2-Se\n"
			+ "8 01AC C-CX2-Se\n"
			+ "8 01AD H-CX2-Se\n"
			+ "8 01AE CX3-Se\n"
			+ "8 01B0 Ar-CH=O\n"
			+ "8 01B2 C=C-CH=O\n"
			+ "8 01B3 C#C-CH=O\n"
			+ "8 01B4 (C-)3C-CH=O\n"
			+ "8 01B6 (C-)2CH-CH=O\n"
			+ "8 01B7 RCH2-CH=O\n"
			+ "8 01B8 X3C-CH=O\n"
			+ "8 01BA C-CX2-CH=O\n"
			+ "8 01BB X2CH-CH=O\n"
			+ "8 01BC X-CH2-CH=O\n"
			+ "8 01BD XCH(-C)-CH=O\n"
			+ "8 01BE XC(-C)2-CH=O\n"
			+ "8 01C0 Ar-S\n"
			+ "8 01C1 C#C-S\n"
			+ "8 01C2 C=C(-C)-S\n"
			+ "8 01C3 C=CH-S\n"
			+ "8 01C4 R-CH2-S\n"
			+ "8 01C5 (C-)2CH-S\n"
			+ "8 01C6 (C-)3C-S\n"
			+ "8 01C7 C=C-CR2-S\n"
			+ "8 01C8 C=C(S)-S\n"
			+ "8 01C9 C=CX-S  X<>S\n"
			+ "8 01CA S-C(-C)2-S\n"
			+ "8 01CB X-C(-C)2-S  X<>S\n"
			+ "8 01CC S-CH(-C)-S\n"
			+ "8 01CD X-CH(-C)-S  X<>S\n"
			+ "8 01CE S-CH2-S\n"
			+ "8 01CF X-CH2-S  X<>S\n"
			+ "8 01D0 -SCN\n"
			+ "8 01D1 X=C-S\n"
			+ "8 01D2 R-CX2-S\n"
			+ "8 01D3 S-CX3\n"
			+ "8 01D4 H2C=N-?\n"
			+ "8 01D5 H2C=O\n"
			+ "8 01D6 H2C=S\n"
			+ "8 01D8 C=C-CN\n"
			+ "8 01D9 R3C-CN\n"
			+ "8 01DA R2CX-CN\n"
			+ "8 01DB R-CX2-CN; CX3-CN\n"
			+ "8 01DC H-CN\n"
			+ "8 01DD X-CN\n"
			+ "8 01DE B-CN; Si-CN\n"
			+ "8 01DF Met-CN, Met<>B,Si\n"
			+ "8 01E0 (C-)3C-O-CX(-C)2\n"
			+ "8 01E1 (C-)2CH-O-CX(-C)2\n"
			+ "8 01E2 C-CH2-O-CX(-C)2\n"
			+ "8 01E3 CH3-O-CX(-C)2\n"
			+ "8 01E4 Ar-O-CX(-C)2\n"
			+ "8 01E6 Ar-O-CHX-C\n"
			+ "8 01E7 Ar-O-CH2-X\n"
			+ "8 01E8 (C-)3C-O-CHX-C\n"
			+ "8 01E9 (C-)2CH-O-CHX-C\n"
			+ "8 01EA C-CH2-O-CHX-C\n"
			+ "8 01EB CH3-O-CHX-C\n"
			+ "8 01EC (C-)3C-O-CH2-X\n"
			+ "8 01ED (C-)2CH-O-CH2-X\n"
			+ "8 01EE C-CH2-O-CH2-X\n"
			+ "8 01EF CH3-O-CH2-X\n"
			+ "8 01F0 (C-)2CX-O-CX(-C)2\n"
			+ "8 01F2 (C-)2CX-O-CHX-C\n"
			+ "8 01F3 C-CHX-O-CHX-C\n"
			+ "8 01F4 (C-)2CX-O-CH2-X\n"
			+ "8 01F6 C-CHX-O-CH2-X\n"
			+ "8 01F7 X-CH2-O-CH2-X\n"
			+ "8 01F8 (C-)3C-O-CX2-C\n"
			+ "8 01F9 (C-)2CH-O-CX2-C\n"
			+ "8 01FA C-CH2-O-CX2-C\n"
			+ "8 01FB CH3-O-CX2-C\n"
			+ "8 01FC (C-)3C-O-CHX2\n"
			+ "8 01FD (C-)2CH-O-CHX2\n"
			+ "8 01FE C-CH2-O-CHX2\n"
			+ "8 01FF CH3-O-CHX2\n"
			+ "8 0200 X=?-N3 type\n"
			+ "8 0201 X-N3\n"
			+ "8 0202 C=C-N3 type\n"
			+ "8 0203 aliph C-N3 type\n"
			+ "8 0204 C=N(+)=N(-) type\n"
			+ "8 0205 O-NO2\n"
			+ "8 0206 C-N(+)#C type\n"
			+ "8 0207 R-N(+)#N\n"
			+ "8 0209 R-NO2\n"
			+ "8 020A N=NR(+)-O\n"
			+ "8 020B rare X=NR(+)-Y\n"
			+ "8 020C C=N(+)(-C)-O type\n"
			+ "8 020D rare C=N(+)(-R)-X\n"
			+ "8 020E R3N(+)-O\n"
			+ "8 020F -C#N(+)-O\n"
			+ "8 0210 R4N(+) type\n"
			+ "8 0211 R3N(+)-X  X<>O\n"
			+ "8 0212 R2N(+)X2\n"
			+ "8 0213 R-N(+)X3\n"
			+ "8 0214 C=NH2(+)\n"
			+ "8 0215 C=N(+)R-C\n"
			+ "8 0216 C=N(+)(-O)2 type\n"
			+ "8 0217 C=N(+)X2  X<>O\n"
			+ "8 0218 C=C=NR type\n"
			+ "8 0219 C=C=O\n"
			+ "8 021A C=C=S\n"
			+ "8 021B C=C=X  X<>N,O,S\n"
			+ "8 021C -N=C=O type\n"
			+ "8 021D -N=C=S type\n"
			+ "8 021E ?-N=C=N-?\n"
			+ "8 021F ?-N=C=X  X<>N,O,S\n"
			+ "8 0220 C-C(=N-?)-N-?=X\n"
			+ "8 0221 C-C(=N-?)-O-?=X\n"
			+ "8 0222 C-C(=N-?)-S-?=X\n"
			+ "8 0223 C-C(=N-?)-Y-?=X  Y<>N,O,S\n"
			+ "8 0224 C-C(=N-?)-N(without -?=X)\n"
			+ "8 0225 C-C(=N-?)-O(without -?=X)\n"
			+ "8 0226 C-C(=N-?)-S(without -?=X)\n"
			+ "8 0227 C-C(=N-?)-X  X<>N,O,S non AT\n"
			+ "8 0228 ?-N=CH-N-?=X\n"
			+ "8 0229 ?-N=CH-O-?=X\n"
			+ "8 022A ?-N=CH-S-?=X\n"
			+ "8 022B ?-N=CH-X-?=Y  X<>N,O,S\n"
			+ "8 022C ?-N=CH-N(without -?=X)\n"
			+ "8 022D ?-N=CH-O(without -?=X)\n"
			+ "8 022E ?-N=CH-S(without -?=X)\n"
			+ "8 022F ?-N=CH-X(X<>N,O,S)(without -?=X)\n"
			+ "8 0230 N-C(=N-?)-N\n"
			+ "8 0231 N-C(=N-?)-O\n"
			+ "8 0232 N-C(=N-?)-S\n"
			+ "8 0233 N-C(=N-?)-X  X<>N,O,S\n"
			+ "8 0234 O-C(=N-?)-O\n"
			+ "8 0235 O-C(=N-?)-S\n"
			+ "8 0236 O-C(=N-?)-X  X<>N,O,S\n"
			+ "8 0238 S-C(=N-?)-S\n"
			+ "8 0239 S-C(=N-?)-X  X<>N,O,S\n"
			+ "8 023A Y-C(=N-?)-X  X,Y<>N,O,S\n"
			+ "8 023C C=C-C(=N-?)-C\n"
			+ "8 023D C(sat)-C(=N-?)-C(sat)\n"
			+ "8 023E C=C-CH=N-?\n"
			+ "8 023F C(sat)-CH=N-?\n"
			+ "8 0240 Ar-N\n"
			+ "8 0241 C=C(-X)-N\n"
			+ "8 0242 C#C-N; C=CH-N\n"
			+ "8 0243 C=C(-C)-N\n"
			+ "8 0244 (C-)3C-N\n"
			+ "8 0245 (C-)2CH-N\n"
			+ "8 0246 R-CH2-N\n"
			+ "8 0247 C=C-CR2-N\n"
			+ "8 0248 X=C-N\n"
			+ "8 0249 (C-)2C(-X)-N\n"
			+ "8 024A C-CH(-X)-N\n"
			+ "8 024B X-CH2-N\n"
			+ "8 024C C-CX2-N\n"
			+ "8 024D H-CX2-N\n"
			+ "8 024E CX3-N\n"
			+ "8 0250 C=NH\n"
			+ "8 0252 C=N-C(-C)2-R\n"
			+ "8 0253 C=N-CH2-R\n"
			+ "8 0254 C=N-C(-C)=C\n"
			+ "8 0255 C=N-CH=C type\n"
			+ "8 0256 C=N-CXR2 type\n"
			+ "8 0257 C=N-Ar\n"
			+ "8 0258 C=N-C=X\n"
			+ "8 0259 C=N-SO2-? type\n"
			+ "8 025A rare C=N-X\n"
			+ "8 025C C=N-N=C type\n"
			+ "8 025D C=N-NR2 type\n"
			+ "8 025E C=N-OH\n"
			+ "8 025F C=N-O-?  ?<>H\n"
			+ "8 0260 N-N=O\n"
			+ "8 0261 -O-N=O\n"
			+ "8 0262 X-N=O  X<>N,O\n"
			+ "8 0263 Y-N=X  X<>N,O\n"
			+ "8 0264 NX3\n"
			+ "8 0265 X-N=N-  X<>N,O\n"
			+ "8 0266 -O-N=N-\n"
			+ "8 0267 N-N=N-\n"
			+ "8 0268 R-N=N-\n"
			+ "8 0269 R-N=O\n"
			+ "8 026A R-N=X  X<>N,O\n"
			+ "8 026B R-NX2\n"
			+ "8 026C (C-)2N-N\n"
			+ "8 026D (C-)2N-X  X<>N,O\n"
			+ "8 026E (C-)2N-OH\n"
			+ "8 026F (C-)2N-O-?  ?<>H\n"
			+ "8 0270 NH2-N\n"
			+ "8 0271 -O-NH2\n"
			+ "8 0272 NH2-X  X<>N,O\n"
			+ "8 0274 C-NH-N\n"
			+ "8 0275 C-NH-X  X<>N,O\n"
			+ "8 0276 C-NH-OH\n"
			+ "8 0277 C-NH-O-?  ?<>H\n"
			+ "8 0278 amine type (C-)3N\n"
			+ "8 0279 amine type (C-)2NH\n"
			+ "8 027A amine type C-NH2\n"
			+ "8 027B amide type C-NH2\n"
			+ "8 027C amide type (C-)2NH\n"
			+ "8 027D amide type (C-)3N\n"
			+ "8 027E imide type (C-)2NH\n"
			+ "8 027F imide type (C-)3N\n"
			+ "8 0280 N-C(=O)-N\n"
			+ "8 0281 N-C(=O)-O\n"
			+ "8 0282 N-C(=O)-S\n"
			+ "8 0283 N-C(=O)-X  X<>N,O,S\n"
			+ "8 0284 O-C(=O)-O\n"
			+ "8 0285 O-C(=O)-S\n"
			+ "8 0286 O-C(=O)-X  X<>N,O,S\n"
			+ "8 0288 S-C(=O)-S\n"
			+ "8 0289 S-C(=O)-X  X<>N,O,S\n"
			+ "8 028A Y-C(=O)-X  X,Y<>N,O,S\n"
			+ "8 0290 C-C(=O)-N-?=X\n"
			+ "8 0291 C-C(=O)-O-?=X\n"
			+ "8 0292 C-C(=O)-S-?=X\n"
			+ "8 0293 C-C(=O)-Y-?=X  Y<>N,O,S\n"
			+ "8 0294 C-C(=O)-N(without -?=X)\n"
			+ "8 0295 C-C(=O)-O(without -?=X)\n"
			+ "8 0296 C-C(=O)-S(without -?=X)\n"
			+ "8 0297 C-C(=O)-X(X<>N,O,S)(without -?=X)\n"
			+ "8 0298 O=CH-N-?=X\n"
			+ "8 0299 O=CH-O-?=X\n"
			+ "8 029A O=CH-S-?=X\n"
			+ "8 029B O=CH-X-?=Y  X<>N,O,S\n"
			+ "8 029C O=CH-N(without -?=X)\n"
			+ "8 029D O=CH-O(without -?=X)\n"
			+ "8 029E O=CH-S(without -?=X)\n"
			+ "8 029F O=CH-X(X<>N,O,S)(without -?=X)\n"
			+ "8 02A0 Ar-C(=O)-C=C\n"
			+ "8 02A1 C=C-C(=O)-C=C\n"
			+ "8 02A2 (C-)3C-C(=O)-C=C\n"
			+ "8 02A3 R2CH-C(=O)-C=C\n"
			+ "8 02A4 X3C-C(=O)-C=C\n"
			+ "8 02A5 R-CX2-C(=O)-C=C\n"
			+ "8 02A6 (C-)2CX-C(=O)-C=C\n"
			+ "8 02A7 R-CH(-X)-C(=O)-C=C\n"
			+ "8 02A8 ?-CX2-C(=O)-CX3\n"
			+ "8 02A9 R-CX2-C(=O)-CX2-R type\n"
			+ "8 02AA C-CHX-C(=O)-CX(-C)2 type\n"
			+ "8 02AB R-CHX-C(=O)-CH2-R type\n"
			+ "8 02AC X3C-C(=O)-Ar\n"
			+ "8 02AD R-CX2-C(=O)-Ar\n"
			+ "8 02AE (C-)2CX-C(=O)-Ar\n"
			+ "8 02AF R-CH(-X)-C(=O)-Ar\n"
			+ "8 02B0 Ar-C(=O)-Ar\n"
			+ "8 02B2 (C-)3C-C(=O)-Ar\n"
			+ "8 02B3 R2CH-C(=O)-Ar\n"
			+ "8 02B4 (C-)3C-C(=O)-CH(-C)2 type\n"
			+ "8 02B5 R-CH2-C(=O)-CH2-R type\n"
			+ "8 02B8 allene oxide\n"
			+ "8 02B9 alkenyl oxirane\n"
			+ "8 02BA hetero subst. oxirane\n"
			+ "8 02BB alkyl oxirane\n"
			+ "8 02BC alkylidene aziridine\n"
			+ "8 02BD alkenyl aziridine\n"
			+ "8 02BE hetero subst. aziridine\n"
			+ "8 02BF alkyl aziridine\n"
			+ "8 02C0 N-C(=S)-N\n"
			+ "8 02C1 N-C(=S)-O\n"
			+ "8 02C2 N-C(=S)-S\n"
			+ "8 02C3 N-C(=S)-X  X<>N,O,S\n"
			+ "8 02C4 O-C(=S)-O\n"
			+ "8 02C5 O-C(=S)-S\n"
			+ "8 02C6 O-C(=S)-X  X<>N,O,S\n"
			+ "8 02C8 S-C(=S)-S\n"
			+ "8 02C9 S-C(=S)-X  X<>N,O,S\n"
			+ "8 02CA Y-C(=S)-X  X,Y<>N,O,S\n"
			+ "8 02CC C=C-C(=S)-C\n"
			+ "8 02CD C(pi=0)-C(=S)-C(pi=0)\n"
			+ "8 02CE C=C-CH=S\n"
			+ "8 02CF C(pi=0)-CH=S\n"
			+ "8 02D0 C-C(=S)-N\n"
			+ "8 02D1 C-C(=S)-O\n"
			+ "8 02D2 C-C(=S)-S\n"
			+ "8 02D3 C-C(=S)-X  X<>N,O,S\n"
			+ "8 02D4 S=CH-N\n"
			+ "8 02D5 S=CH-O\n"
			+ "8 02D6 S=CH-S\n"
			+ "8 02D7 S=CH-X  X<>N,O,S\n"
			+ "8 02D8 C-S-SH\n"
			+ "8 02D9 C-S-S-C\n"
			+ "8 02DA C-S-S(z>1)\n"
			+ "8 02DB C-S-X  X<>S\n"
			+ "8 02DC C-S-C\n"
			+ "8 02DD C-SH; C-S-Met\n"
			+ "8 02DE X-SH\n"
			+ "8 02DF S(+)\n"
			+ "8 02E0 C-S(=O)-C\n"
			+ "8 02E1 rare S(z=2)\n"
			+ "8 02E2 X-SO2-X\n"
			+ "8 02E3 rare S(z=6)\n"
			+ "8 02E4 C-SO2-C\n"
			+ "8 02E5 O-S(=O)-O\n"
			+ "8 02E6 X-S(=O)-X  X<>O\n"
			+ "8 02E7 rare S(z=4)\n"
			+ "8 02E8 C-S(=O)-O\n"
			+ "8 02E9 C-S(=O)-X  X<>O\n"
			+ "8 02EA rare S(z=3)\n"
			+ "8 02EC C-SO2-O\n"
			+ "8 02ED C-SO2-X  X<>O\n"
			+ "8 02EE rare S(z=5)\n"
			+ "8 02F0 Ar-O-CX2-C\n"
			+ "8 02F1 Ar-O-CHX2\n"
			+ "8 02F4 C-CX2-O-CX2-C\n"
			+ "8 02F6 CHX2-O-CX2-C\n"
			+ "8 02F7 CHX2-O-CHX2\n"
			+ "8 02F8 (C-)2CX-O-CX2-C\n"
			+ "8 02FA C-CHX-O-CX2-C\n"
			+ "8 02FB X-CH2-O-CX2-C\n"
			+ "8 02FC (C-)2CX-O-CHX2\n"
			+ "8 02FE C-CHX-O-CHX2\n"
			+ "8 02FF X-CH2-O-CHX2\n"
			+ "8 0300 Ar-O-C=X\n"
			+ "8 0301 X=C-O-C=X\n"
			+ "8 0304 (C-)3C-O-C=X\n"
			+ "8 0305 (C-)2CH-O-C=X\n"
			+ "8 0306 C-CH2-O-C=X\n"
			+ "8 0307 CH3-O-C=X\n"
			+ "8 0308 (C-)2CX-O-C=X\n"
			+ "8 030A C-CHX-O-C=X\n"
			+ "8 030B X-CH2-O-C=X\n"
			+ "8 030C C-CX2-O-C=X\n"
			+ "8 030D CHX2-O-C=X\n"
			+ "8 0310 C=CX-O-C(-C)3\n"
			+ "8 0311 C=CX-O-CH(-C)2\n"
			+ "8 0312 C=CX-O-CH2-C\n"
			+ "8 0313 C=CX-O-CH3\n"
			+ "8 0314 C=CX-O-Ar\n"
			+ "8 0315 C=CX-O-CX=C\n"
			+ "8 0316 C=CX-O-CH=C\n"
			+ "8 0317 C=CX-O-C(-C)=C\n"
			+ "8 0318 C=CX-O-C=X\n"
			+ "8 031A C=CX-O-CX2-C\n"
			+ "8 031B C=CX-O-CHX2\n"
			+ "8 031C C=CX-O-CH2-X\n"
			+ "8 031D C=CX-O-CHX-C\n"
			+ "8 031E C=CX-O-CX(-C)2\n"
			+ "8 0320 C=C(-C)-O-CX2-C\n"
			+ "8 0321 C=CH-O-CX2-C\n"
			+ "8 0322 C=C(-C)-O-CHX2\n"
			+ "8 0323 C=CH-O-CHX2\n"
			+ "8 0324 C=C(-C)-O-C=X\n"
			+ "8 0325 C=CH-O-C=X\n"
			+ "8 0326 C=C(-C)-O-CX3\n"
			+ "8 0327 C=CH-O-CX3\n"
			+ "8 0328 C=C(-C)-O-CX(-C)2\n"
			+ "8 0329 C=CH-O-CX(-C)2\n"
			+ "8 032C C=C(-C)-O-CHX-C\n"
			+ "8 032D C=CH-O-CHX-C\n"
			+ "8 032E C=C(-C)-O-CH2-X\n"
			+ "8 032F C=CH-O-CH2-X\n"
			+ "8 0330 C=CH-O-CH=C\n"
			+ "8 0331 C=C(-C)-O-CH=C\n"
			+ "8 0332 C=C(-C)-O-C(-C)=C\n"
			+ "8 0334 C=CH-O-Ar\n"
			+ "8 0335 C=C(-C)-O-Ar\n"
			+ "8 0338 C=CH-O-C(-C)3\n"
			+ "8 0339 C=CH-O-CH(-C)2\n"
			+ "8 033A C=CH-O-CH2-C\n"
			+ "8 033B C=CH-O-CH3\n"
			+ "8 033C C=C(-C)-O-C(-C)3\n"
			+ "8 033D C=C(-C)-O-CH(-C)2\n"
			+ "8 033E C=C(-C)-O-CH2-C\n"
			+ "8 033F C=C(-C)-O-CH3\n"
			+ "8 0340 Ar-O-C(-C)3\n"
			+ "8 0341 Ar-O-CH(-C)2\n"
			+ "8 0342 Ar-O-CH2-C\n"
			+ "8 0343 Ar-O-CH3\n"
			+ "8 0344 Ar-O-Ar\n"
			+ "8 0345 (C-)3C-O-C(-C)3\n"
			+ "8 0346 (C-)3C-O-CH(-C)2\n"
			+ "8 0347 (C-)2CH-O-CH(-C)2\n"
			+ "8 0348 (C-)3C-O-CH2-C\n"
			+ "8 0349 (C-)3C-O-CH3\n"
			+ "8 034A (C-)2CH-O-CH2-C\n"
			+ "8 034C (C-)2CH-O-CH3\n"
			+ "8 034D C-CH2-O-CH2-C\n"
			+ "8 034E C-CH2-O-CH3\n"
			+ "8 034F CH3-O-CH3\n"
			+ "8 0350 Ar-OH\n"
			+ "8 0352 C#C-OH; C=CH-OH\n"
			+ "8 0353 C=C(-C)-OH\n"
			+ "8 0354 (C-)3C-OH\n"
			+ "8 0355 (C-)2CH-OH\n"
			+ "8 0356 C-CH2-OH\n"
			+ "8 0357 CH3-OH\n"
			+ "8 0358 C=C(-X)-OH\n"
			+ "8 0359 (C-)2C(-X)-OH\n"
			+ "8 035A C-CH(-X)-OH\n"
			+ "8 035B X-CH2-OH\n"
			+ "8 035C C-CX2-OH\n"
			+ "8 035D H-CX2-OH\n"
			+ "8 035E CX3-OH\n"
			+ "8 035F X=C-OH\n"
			+ "8 0360 P-O-B\n"
			+ "8 0361 P-O-Si\n"
			+ "8 0362 P-O-X  X<>N,O,P,S\n"
			+ "8 0364 P-O-O\n"
			+ "8 0365 P-O-N\n"
			+ "8 0366 P-O-P\n"
			+ "8 0367 P-O-S\n"
			+ "8 0368 S-O-B\n"
			+ "8 0369 S-O-Si\n"
			+ "8 036A B-O-B\n"
			+ "8 036C S-O-O\n"
			+ "8 036D S-O-N\n"
			+ "8 036E S-O-S\n"
			+ "8 036F S-O-X  X<>N,O,P,S\n"
			+ "8 0370 N-O-B\n"
			+ "8 0371 N-O-Si\n"
			+ "8 0372 Si-O-Si\n"
			+ "8 0373 Si-O-B\n"
			+ "8 0374 N-O-O\n"
			+ "8 0375 N-O-N\n"
			+ "8 0376 N-O-X  X<>N,O,P,S\n"
			+ "8 0378 B-O-O\n"
			+ "8 0379 Si-O-O\n"
			+ "8 037A O-O-O\n"
			+ "8 037B X-O-O  X<>N,O,P,S\n"
			+ "8 037C B-O-X  X<>N,O,P,S\n"
			+ "8 037D Si-O-X  X<>N,O,P,S\n"
			+ "8 037E X-O-X  X<>N,O,P,S\n"
			+ "8 0380 B-O-Ar\n"
			+ "8 0381 B-O-C=X\n"
			+ "8 0382 B-O-CH=C\n"
			+ "8 0383 B-O-C(-C)=C\n"
			+ "8 0384 B-O-C(-C)3\n"
			+ "8 0385 B-O-CH(-C)2\n"
			+ "8 0386 B-O-CH2-C\n"
			+ "8 0387 B-O-CH3\n"
			+ "8 0388 B-O-CX=C\n"
			+ "8 0389 B-O-CX(-C)2\n"
			+ "8 038A B-O-CHX-C\n"
			+ "8 038B B-O-CH2-X\n"
			+ "8 038C B-O-CX2-C\n"
			+ "8 038D B-O-CHX2\n"
			+ "8 038E B-O-CX3\n"
			+ "8 038F B-OH\n"
			+ "8 0390 Si-O-Ar\n"
			+ "8 0391 Si-O-C=X\n"
			+ "8 0392 Si-O-CH=C\n"
			+ "8 0393 Si-O-C(-C)=C\n"
			+ "8 0394 Si-O-C(-C)3\n"
			+ "8 0395 Si-O-CH(-C)2\n"
			+ "8 0396 Si-O-CH2-C\n"
			+ "8 0397 Si-O-CH3\n"
			+ "8 0398 Si-O-CX=C\n"
			+ "8 0399 Si-O-CX(-C)2\n"
			+ "8 039A Si-O-CHX-C\n"
			+ "8 039B Si-O-CH2-X\n"
			+ "8 039C Si-O-CX2-C\n"
			+ "8 039D Si-O-CHX2\n"
			+ "8 039E Si-O-CX3\n"
			+ "8 039F Si-OH\n"
			+ "8 03A0 X-O-Ar  X<>N,O,P,S\n"
			+ "8 03A1 X-O-C=Y  X<>N,O,P,S\n"
			+ "8 03A2 X-O-CH=C  X<>N,O,P,S\n"
			+ "8 03A3 X-O-C(-C)=C  X<>N,O,P,S\n"
			+ "8 03A4 X-O-C(-C)3  X<>N,O,P,S\n"
			+ "8 03A5 X-O-CH(-C)2  X<>N,O,P,S\n"
			+ "8 03A6 X-O-CH2-C  X<>N,O,P,S\n"
			+ "8 03A7 X-O-CH3  X<>N,O,P,S\n"
			+ "8 03A8 X-O-CY=C  X<>N,O,P,S\n"
			+ "8 03A9 X-O-CY(-C)2  X<>N,O,P,S\n"
			+ "8 03AA X-O-CHY-C  X<>N,O,P,S\n"
			+ "8 03AB X-O-CH2-Y  X<>N,O,P,S\n"
			+ "8 03AC X-O-CY2-C  X<>N,O,P,S\n"
			+ "8 03AD X-O-CHY2  X<>N,O,P,S\n"
			+ "8 03AE X-O-CY3  X<>N,O,P,S\n"
			+ "8 03AF X-OH  X<>N,O,P,S\n"
			+ "8 03B0 X3C-O-Ar\n"
			+ "8 03B1 X3C-O-C=X\n"
			+ "8 03B4 X3C-O-C(-C)3\n"
			+ "8 03B5 X3C-O-CH(-C)2\n"
			+ "8 03B6 X3C-O-CH2-C\n"
			+ "8 03B7 X3C-O-CH3\n"
			+ "8 03B8 X3C-O-CX=C\n"
			+ "8 03B9 X3C-O-CX(-C)2\n"
			+ "8 03BA X3C-O-CHX-C\n"
			+ "8 03BB X3C-O-CH2-X\n"
			+ "8 03BC X3C-O-CX2-C\n"
			+ "8 03BD X3C-O-CHX2\n"
			+ "8 03BE X3C-O-CX3\n"
			+ "8 03C0 O-O-Ar\n"
			+ "8 03C1 O-O-C=X\n"
			+ "8 03C2 O-O-CH=C\n"
			+ "8 03C3 O-O-C(-C)=C\n"
			+ "8 03C4 O-O-C(-C)3\n"
			+ "8 03C5 O-O-CH(-C)2\n"
			+ "8 03C6 O-O-CH2-C\n"
			+ "8 03C7 O-O-CH3\n"
			+ "8 03C8 O-O-CX=C\n"
			+ "8 03C9 O-O-CX(-C)2\n"
			+ "8 03CA O-O-CHX-C\n"
			+ "8 03CB O-O-CH2-X\n"
			+ "8 03CC O-O-CX2-C\n"
			+ "8 03CD O-O-CHX2\n"
			+ "8 03CE O-O-CX3\n"
			+ "8 03CF O-OH\n"
			+ "8 03D0 N-O-Ar\n"
			+ "8 03D1 N-O-C=X\n"
			+ "8 03D2 N-O-CH=C\n"
			+ "8 03D3 N-O-C(-C)=C\n"
			+ "8 03D4 N-O-C(-C)3\n"
			+ "8 03D5 N-O-CH(-C)2\n"
			+ "8 03D6 N-O-CH2-C\n"
			+ "8 03D7 N-O-CH3\n"
			+ "8 03D8 N-O-CX=C\n"
			+ "8 03D9 N-O-CX(-C)2\n"
			+ "8 03DA N-O-CHX-C\n"
			+ "8 03DB N-O-CH2-X\n"
			+ "8 03DC N-O-CX2-C\n"
			+ "8 03DD N-O-CHX2\n"
			+ "8 03DE N-O-CX3\n"
			+ "8 03DF N-OH\n"
			+ "8 03E0 P-O-Ar\n"
			+ "8 03E1 P-O-C=X\n"
			+ "8 03E2 P-O-CH=C\n"
			+ "8 03E3 P-O-C(-C)=C\n"
			+ "8 03E4 P-O-C(-C)3\n"
			+ "8 03E5 P-O-CH(-C)2\n"
			+ "8 03E6 P-O-CH2-C\n"
			+ "8 03E7 P-O-CH3\n"
			+ "8 03E8 P-O-CX=C\n"
			+ "8 03E9 P-O-CX(-C)2\n"
			+ "8 03EA P-O-CHX-C\n"
			+ "8 03EB P-O-CH2-X\n"
			+ "8 03EC P-O-CX2-C\n"
			+ "8 03ED P-O-CHX2\n"
			+ "8 03EE P-O-CX3\n"
			+ "8 03EF P-OH\n"
			+ "8 03F0 S-O-Ar\n"
			+ "8 03F1 S-O-C=X\n"
			+ "8 03F2 S-O-CH=C\n"
			+ "8 03F3 S-O-C(-C)=C\n"
			+ "8 03F4 S-O-C(-C)3\n"
			+ "8 03F5 S-O-CH(-C)2\n"
			+ "8 03F6 S-O-CH2-C\n"
			+ "8 03F7 S-O-CH3\n"
			+ "8 03F8 S-O-CX=C\n"
			+ "8 03F9 S-O-CX(-C)2\n"
			+ "8 03FA S-O-CHX-C\n"
			+ "8 03FB S-O-CH2-X\n"
			+ "8 03FC S-O-CX2-C\n"
			+ "8 03FD S-O-CHX2\n"
			+ "8 03FE S-O-CX3\n"
			+ "8 03FF S-OH\n"
			+ "7 0000 R3C-Li\n"
			+ "7 0002 X-C-Li\n"
			+ "7 0004 R3C-Na,K,Rb,Cs\n"
			+ "7 0006 X-C-Na,K,Rb,Cs\n"
			+ "7 0008 R3C-Mg,Be\n"
			+ "7 000A X-C-Mg,Be\n"
			+ "7 000C R3C-Ca,Sr,Ba\n"
			+ "7 000E X-C-Ca,Sr,Ba\n"
			+ "7 0010 R3C-Al\n"
			+ "7 0012 X-C-Al\n"
			+ "7 0014 R3C-Ga,In,Tl\n"
			+ "7 0016 X-C-Ga,In,Tl\n"
			+ "7 0018 R3C-Ge,Sn,Pb\n"
			+ "7 001A X-C-Ge,Sn,Pb\n"
			+ "7 001C R3C-Sb,Bi\n"
			+ "7 001E X-C-Sb,Bi\n"
			+ "7 0020 R3C-Cu,Ag,Au\n"
			+ "7 0022 X-C-Cu,Ag,Au\n"
			+ "7 0024 R3C-Zn,Cd,Hg\n"
			+ "7 0026 X-C-Zn,Cd,Hg\n"
			+ "7 0028 R3C-Sc,Y,La,Ac\n"
			+ "7 002A X-C-Sc,Y,La,Ac\n"
			+ "7 002C R3C-rare Earth\n"
			+ "7 002E X-C-rare Earth\n"
			+ "7 0030 R3C-Ti,Zr,Hf\n"
			+ "7 0032 X-C-Ti,Zr,Hf\n"
			+ "7 0034 R3C-V,Cr type\n"
			+ "7 0036 X-C-V,Cr type\n"
			+ "7 0038 R3C-Mn,Fe,Co,Ni\n"
			+ "7 003A X-C-Mn,Fe,Co,Ni\n"
			+ "7 003C R3C-Pd type\n"
			+ "7 003E X-C-Pd type\n"
			+ "7 0040 BH(-)X3; R-BH(-)X2; R2-BH(-)X\n"
			+ "7 0042 R4B(-)\n"
			+ "7 0044 (C-)3B(-)X; (C-)2B(-)X2\n"
			+ "7 0046 C-B(-)X3; B(-)X4\n"
			+ "7 0048 (C-)2BH; C-BH2\n"
			+ "7 004A C-BHX; BH2X\n"
			+ "7 004C BH(NR2)2; BH(OR)2\n"
			+ "7 0050 (C-)2B-N; (C-)2B-O\n"
			+ "7 0052 (C-)2B-X  X<>N,O\n"
			+ "7 0054 B(NR2)3; B(OR)3\n"
			+ "7 0058 C=C-B(OR)2\n"
			+ "7 005A R3C-B(OR)2\n"
			+ "7 005C C-BX2  X<>O\n"
			+ "7 0060 RnP(+)X(4-n)\n"
			+ "7 0062 R2PH\n"
			+ "7 0064 (C-)3P=C; C-P=C\n"
			+ "7 0068 (C-)3P\n"
			+ "7 006A PX3\n"
			+ "7 006C R3P=X; RP=X\n"
			+ "7 006E R2PX type; R3PX2; RPX2\n"
			+ "7 0070 R2P(=X)-Y\n"
			+ "7 0072 RP(=O)X2\n"
			+ "7 0074 RP(=X)Y2  X<>O; X=PY3  X<>O\n"
			+ "7 0076 O=PX3\n"
			+ "7 0078 As(z=3,5)\n"
			+ "7 007C C-AsH2 type; C-AsX2\n"
			+ "7 007E C-AsXn  n<>2\n"
			+ "7 0080 N-TMS; N-SiEtMe2\n"
			+ "7 0082 N-Si(iPr)Me2; N-Si(tBu)Me2\n"
			+ "7 0084 N-SiMe(iPr)2; N-SiEt(iPr)2\n"
			+ "7 0086 N-SiMe(tBu)2; N-Si(tBu)Ph2\n"
			+ "7 0088 O-TMS; O-SiEtMe2\n"
			+ "7 008A O-Si(iPr)Me2; O-Si(tBu)Me2\n"
			+ "7 008C O-SiMe(iPr)2; O-SiEt(iPr)2\n"
			+ "7 008E O-SiMe(tBu)2; O-Si(tBu)Ph2\n"
			+ "7 0090 (C-)2Si(-O)2; (C-)2Si(-N)2\n"
			+ "7 0092 (C-)2SiX2  X<>N,O\n"
			+ "7 0094 C-SiX3\n"
			+ "7 0096 SiX4\n"
			+ "7 0098 (C-)3Si-P; (C-)3Si-S\n"
			+ "7 009C Si-N-?=X\n"
			+ "7 009E Si-N  non stabilized N\n"
			+ "7 00A0 (C-)2SiH-R\n"
			+ "7 00A4 (C-)2SiH-X\n"
			+ "7 00A6 C-SiH2-X\n"
			+ "7 00A8 RSiH(-O)2; RSiH(-N)2\n"
			+ "7 00AA RSiHX2  X<>N,O\n"
			+ "7 00AC SiHX3\n"
			+ "7 00B0 alkinyl-, alkenylsilane\n"
			+ "7 00B8 aromatic ring with N\n"
			+ "7 00BA aromatic ring with O,S\n"
			+ "8 00BE N-Met  Met<>Si\n"
			+ "7 00C0 X=?-C#CH; C=C-C#CH\n"
			+ "7 00C2 X-C#CH; C(sat)-C#CH\n"
			+ "7 00C4 X-C#C-X; C=C-C#C-X\n"
			+ "7 00C6 C(sat)-C#C-X; C(sat)-C#C-C(sat)\n"
			+ "7 00C8 X=?-C#C-?=X; C=C-C#C-?=X\n"
			+ "7 00CA X=?-C#C-X; C(sat)-C#C-?=X\n"
			+ "7 00CC C=C-C#C-C=C; C(sat)-C#C-C=C\n"
			+ "7 00CE ?-C#C-Met\n"
			+ "7 00D0 C-CH=CH2\n"
			+ "7 00D2 C-CH=CH-C\n"
			+ "7 00D4 C-CH=C(-C)2 type\n"
			+ "7 00D6 (C-)2C=C(-C)2 type\n"
			+ "7 00D8 (X=?-)2C=C-?=X type; X=?-RC=CR-?=X type\n"
			+ "7 00DA C-C=C(-C)-?=X type; R-HC=CH-?=X type\n"
			+ "7 00DC X=?-XC=C-?=X type; X=?-C=CX type\n"
			+ "7 00DE X=?-XC=CX-? type; X=?-XC=CX2\n"
			+ "7 00E0 X2C=CX-?; ?-XC=CX-? type\n"
			+ "7 00E2 R-HC=CH-X type; C-C=CX-C type\n"
			+ "7 00E4 saturated or unsaturated cyclopropane\n"
			+ "7 00E6 stabilized or allylic cyclopropane\n"
			+ "7 00E8 donor substituted allene\n"
			+ "7 00EA non donor substituted allene\n"
			+ "7 00EC X=?-Ar; X-Ar\n"
			+ "7 00F0 XnC*(-C)4-n; X=?-C*H\n"
			+ "7 00F2 C=C-C*H; featureless C*H\n"
			+ "7 00F4 C-Te-X; C-Te(z=3)\n"
			+ "7 00F6 C-TeXn  n<>1,3\n"
			+ "7 00F8 Te(z=2,4)\n"
			+ "7 00FA TeXn  n<>2,4\n"
			+ "7 00FC C-Te-C; C-TeX2-C\n"
			+ "7 00FE C-TeXn-C  n<>0,2\n"
			+ "7 0100 Ar-F; C#C-F\n"
			+ "7 0102 C=CR-F\n"
			+ "7 0104 C=C-CR2-F; C(sat)-CH2-F\n"
			+ "7 0106 non allylic (C-)2CR-F\n"
			+ "7 0108 C=CX-F; C=C-CX-F\n"
			+ "7 010C F3C-C\n"
			+ "7 010E F-CX2-R\n"
			+ "7 0110 R-C(=X)-F  X<>N\n"
			+ "7 0112 R-C(=N)-F; F-CN\n"
			+ "7 0114 F-C(=X)-Y  X=N,O\n"
			+ "7 0116 F-C(=X)-Y  X<>N,O; F-CX3\n"
			+ "7 0118 F at O\n"
			+ "7 011A F at P,S\n"
			+ "7 011C F at N\n"
			+ "7 011E F at B,Si\n"
			+ "7 0120 Ar-Cl; C#C-Cl\n"
			+ "7 0122 C=CR-Cl\n"
			+ "7 0124 C=C-CR2-Cl; C(sat)-CH2-Cl\n"
			+ "7 0126 non allylic (C-)2CR-Cl\n"
			+ "7 0128 C=CX-Cl; C=C-CX-Cl\n"
			+ "7 012C Cl3C-C\n"
			+ "7 012E Cl-CX2-R\n"
			+ "7 0130 R-C(=X)-Cl  X<>N\n"
			+ "7 0132 R-C(=N)-Cl; Cl-CN\n"
			+ "7 0134 Cl-C(=X)-Y  X=N,O\n"
			+ "7 0136 Cl-C(=X)-Y  X<>N,O; Cl-CX3\n"
			+ "7 0138 Cl at O\n"
			+ "7 013A Cl at P,S\n"
			+ "7 013C Cl at N\n"
			+ "7 013E Cl at B,Si\n"
			+ "7 0140 Ar-Br; C#C-Br\n"
			+ "7 0142 C=CR-Br\n"
			+ "7 0144 C=C-CR2-Br; C(sat)-CH2-Br\n"
			+ "7 0146 non allylic (C-)2CR-Br\n"
			+ "7 0148 C=CX-Br; C=C-CX-Br\n"
			+ "7 014C Br3C-C\n"
			+ "7 014E Br-CX2-R\n"
			+ "7 0150 R-C(=X)-Br  X<>N\n"
			+ "7 0152 R-C(=N)-Br; Br-CN\n"
			+ "7 0154 Br-C(=X)-Y  X=N,O\n"
			+ "7 0156 Br-C(=X)-Y  X<>N,O; Br-CX3\n"
			+ "7 0158 Br at O\n"
			+ "7 015A Br at P,S\n"
			+ "7 015C Br at N\n"
			+ "7 015E Br at B,Si\n"
			+ "7 0160 Ar-I; C#C-I\n"
			+ "7 0162 C=CR-I\n"
			+ "7 0164 C=C-CR2-I; C(sat)-CH2-I\n"
			+ "7 0166 non allylic (C-)2CR-I\n"
			+ "7 0168 C=CX-I; C=C-CX-I\n"
			+ "7 016A non allylic R2CX-I\n"
			+ "7 016C I3C-C\n"
			+ "7 016E I-CX2-R\n"
			+ "7 0170 R-C(=X)-I  X<>N\n"
			+ "7 0172 R-C(=N)-I; I-CN\n"
			+ "7 0174 I-C(=X)-Y  X=N,O\n"
			+ "7 0176 I-C(=X)-Y  X<>N,O; I-CX3\n"
			+ "7 0178 I at O\n"
			+ "7 017A I at P,S\n"
			+ "7 017C I at N\n"
			+ "7 017E I at B,Si\n"
			+ "7 0180 C-Se-O-?\n"
			+ "7 0182 C-SeX  X<>O,Se\n"
			+ "7 0184 C-SeSe-R\n"
			+ "7 0188 Se(z=2)\n"
			+ "7 018A Se(z=6)\n"
			+ "7 018C C-SeO2-C; O-Se(=O)-O\n"
			+ "7 018E X-Se(=O)-X  X<>O; rare Se(z=4)\n"
			+ "7 0190 C-Se(=O)-O-?\n"
			+ "7 0192 C-Se(=O)-X  X<>O; rare Se(z=3)\n"
			+ "7 0194 C-SeO2-O-?\n"
			+ "7 0196 C-SeO2-X  X<>O; rare Se(z=5)\n"
			+ "7 0198 R-C(=Se)-R\n"
			+ "7 019A R-C(=Se)-X\n"
			+ "7 019E C-Se-R\n"
			+ "7 01A0 Ar-Se; C=C(-X)-Se\n"
			+ "7 01A2 C#C-Se; C=CR-Se\n"
			+ "7 01A4 (C-)2CR-Se\n"
			+ "7 01AA X-CHR-Se\n"
			+ "7 01AC R-CX2-Se\n"
			+ "7 01B2 C=C-CH=O; C#C-CH=O\n"
			+ "7 01B6 R2CH-CH=O\n"
			+ "7 01BA R-CX2-CH=O\n"
			+ "7 01BC X-CHR-CH=O\n"
			+ "7 01C0 Ar-S; C#C-S\n"
			+ "7 01C2 C=CR-S\n"
			+ "7 01C4 R2CH-S\n"
			+ "7 01C8 C=CX-S\n"
			+ "7 01CA X-C(-C)2-S\n"
			+ "7 01CC X-CH(-C)-S\n"
			+ "7 01CE X-CH2-S\n"
			+ "7 01D0 -SCN; X=C-S\n"
			+ "7 01D2 R-CX2-S; S-CX3\n"
			+ "7 01D4 H2C=X  X=N,O\n"
			+ "7 01D8 C=C-CN; R3C-CN\n"
			+ "7 01DA R2CX-CN; R-CX2-CN; CX3-CN; \n"
			+ "7 01DC H-CN; X-CN\n"
			+ "7 01DE Met-CN\n"
			+ "7 01E0 (C-)2CR-O-CX(-C)2\n"
			+ "7 01E2 R-CH2-O-CX(-C)2\n"
			+ "7 01E6 Ar-O-CHR-X\n"
			+ "7 01E8 (C-)2CR-O-CHX-C\n"
			+ "7 01EA R-CH2-O-CHX-C\n"
			+ "7 01EC (C-)2CR-O-CH2-X\n"
			+ "7 01EE R-CH2-O-CH2-X\n"
			+ "7 01F2 C-CRX-O-CHX-C\n"
			+ "7 01F6 R-CHX-O-CH2-X\n"
			+ "7 01F8 (C-)2CR-O-CX2-C\n"
			+ "7 01FA R-CH2-O-CX2-C\n"
			+ "7 01FC (C-)2CR-O-CHX2\n"
			+ "7 01FE R-CH2-O-CHX2\n"
			+ "7 0200 X=?-N3 type; X-N3\n"
			+ "7 0202 C=C-N3 type; aliph C-N3 type\n"
			+ "7 0206 C-N(+)#C type; R-N(+)#N\n"
			+ "7 020A X=NR(+)-Y\n"
			+ "7 020C C=N(+)(-R)-X\n"
			+ "7 020E R3N(+)-O; -C#N(+)-O\n"
			+ "7 0210 R4N(+) type; R3N(+)-X  X<>O\n"
			+ "7 0212 R2N(+)X2; R-N(+)X3\n"
			+ "7 0214 C=NR2(+)\n"
			+ "7 0216 C=N(+)X2\n"
			+ "7 0218 C=C=NR type; C=C=O\n"
			+ "7 021A C=C=X  X<>N,O\n"
			+ "7 021C -N=C=O type; -N=C=S type\n"
			+ "7 021E -N=C=X  X<>O,S\n"
			+ "7 0220 C-C(=N-?)-Y-?=X  Y=N,O\n"
			+ "7 0222 C-C(=N-?)-Y-?=X  Y<>N,O\n"
			+ "7 0224 C-C(=N-?)-X  X=N,O non AT\n"
			+ "7 0226 C-C(=N-?)-X  X<>N,O non AT\n"
			+ "7 0228 ?-N=CH-X-?=Y  X=N,O\n"
			+ "7 022A ?-N=CH-X-?=Y  X<>N,O\n"
			+ "7 022C ?-N=CH-X  X=N,O non AT\n"
			+ "7 022E ?-N=CH-X  X<>N,O non AT\n"
			+ "7 0230 N-C(=N-?)-X  X=N,O\n"
			+ "7 0232 N-C(=N-?)-X  X<>N,O\n"
			+ "7 0234 O-C(=N-?)-X  X=O,S\n"
			+ "7 0238 S-C(=N-?)-X  X<>N,O\n"
			+ "7 023C C-C(=N-?)-C\n"
			+ "7 023E C-CH=N-?\n"
			+ "7 0240 Ar-N; C=C(-X)-N\n"
			+ "7 0242 C#C-N; C=CR-N\n"
			+ "7 0244 (C-)2CR-N\n"
			+ "7 0248 X=C-N; (C-)2C(-X)-N\n"
			+ "7 024A X-CHR-N\n"
			+ "7 024C R-CX2-N\n"
			+ "7 0252 C=N-CR3\n"
			+ "7 0254 C=N-CR=C type\n"
			+ "7 0258 C=N-?=X\n"
			+ "7 025C C=N-N=C; C=N-NR2 type\n"
			+ "7 025E C=N-O-?\n"
			+ "7 0260 X-N=O  X=N,O\n"
			+ "7 0262 X-N=O  X<>N,O; Y-N=X  X<>N,O\n"
			+ "7 0266 X-N=N-  X=N,O\n"
			+ "7 0268 R-N=X  X=N,O\n"
			+ "7 026C (C-)2N-X  X<>O\n"
			+ "7 026E (C-)2N-O-?\n"
			+ "7 0270 X-NH2  X=N,O\n"
			+ "7 0274 C-NH-X  X<>O\n"
			+ "7 0276 C-NH-O-?\n"
			+ "7 0278 amine type (C-)2NR\n"
			+ "7 027A C-NH2\n"
			+ "7 027C amide type (C-)2NR\n"
			+ "7 027E imide type (C-)2NR\n"
			+ "7 0280 N-C(=O)-X  X=N,O\n"
			+ "7 0282 N-C(=O)-X  X<>N,O\n"
			+ "7 0284 O-C(=O)-X  X=O,S\n"
			+ "7 0288 S-C(=O)-X  X<>N,O\n"
			+ "7 0290 C-C(=O)-X-?=Y  X=N,O\n"
			+ "7 0293 C-C(=O)-X-?=Y  X<>N,O\n"
			+ "7 0294 C-C(=O)-X  X=N,O non AT\n"
			+ "7 0296 C-C(=O)-X  X<>N,O non AT\n"
			+ "7 0298 O=CH-X-?=Y  X=N,O\n"
			+ "7 029A O=CH-X-?=Y  X<>N,O\n"
			+ "7 029C O=CH-X  X=N,O non AT\n"
			+ "7 029E O=CH-X  X<>N,O non AT\n"
			+ "7 02A0 Ar-C(=O)-C=C; C=C-C(=O)-C=C\n"
			+ "7 02A2 R3C-C(=O)-C=C\n"
			+ "7 02A4 X3C-C(=O)-C=C; R-CX2-C(=O)-C=C\n"
			+ "7 02A6 R2C(-X)-C(=O)-C=C\n"
			+ "7 02A8 CX2-C(=O)-CX2 type\n"
			+ "7 02AA R-CHX-C(=O)-CXR2 type\n"
			+ "7 02AC ?-CX2-C(=O)-Ar\n"
			+ "7 02AE R2C(-X)-C(=O)-Ar\n"
			+ "7 02B2 R3C-C(=O)-Ar\n"
			+ "7 02B4 R3C-C(=O)-CR3\n"
			+ "7 02C0 N-C(=S)-X  X=N,O\n"
			+ "7 02C2 N-C(=S)-X  X<>N,O\n"
			+ "7 02C4 O-C(=S)-X  X=O,S\n"
			+ "7 02C8 S-C(=S)-X  X<>N,O\n"
			+ "7 02CC C-C(=S)-C\n"
			+ "7 02CE C-CH=S\n"
			+ "7 02D0 C-C(=S)-X  X=N,O\n"
			+ "7 02D2 C-C(=S)-X  X<>N,O\n"
			+ "7 02D4 S=CH-X  X=N,O\n"
			+ "7 02D6 S=CH-X  X<>N,O\n"
			+ "7 02D8 C-S-S-R\n"
			+ "7 02DA C-S-S(z>1); C-S-X  X<>S\n"
			+ "7 02DC C-S-R; C-S-Met\n"
			+ "7 02E0 S(z=2)\n"
			+ "7 02E2 S(z=6)\n"
			+ "7 02E4 C-SO2-C; O-S(=O)-O\n"
			+ "7 02E6 X-S(=O)-X  X<>O; rare S(z=4)\n"
			+ "7 02E8 C-S(=O)-X\n"
			+ "7 02EC C-SO2-X\n"
			+ "7 02F0 Ar-O-CX2-R\n"
			+ "7 02F6 CHX2-O-CX2-R\n"
			+ "7 02FA R-CHX-O-CX2-C\n"
			+ "7 02FE R-CHX-O-CHX2\n"
			+ "7 0300 Ar-O-C=X; X=C-O-C=X\n"
			+ "7 0304 (C-)2CR-O-C=X\n"
			+ "7 0306 R-CH2-O-C=X\n"
			+ "7 030A R-CHX-O-C=X\n"
			+ "7 030C R-CX2-O-C=X\n"
			+ "7 0310 C=CX-O-CR(-C)2\n"
			+ "7 0312 C=CX-O-CH2-R\n"
			+ "7 0314 C=CX-O-Ar; C=CX-O-CX=C\n"
			+ "7 0316 C=CX-O-CR=C\n"
			+ "7 031A C=CX-O-CX2-R\n"
			+ "7 031C C=CX-O-CHX-R\n"
			+ "7 0320 C=CR-O-CX2-C\n"
			+ "7 0322 C=CR-O-CHX2\n"
			+ "7 0324 C=CR-O-C=X\n"
			+ "7 0326 C=CR-O-CX3\n"
			+ "7 0328 C=CR-O-CX(-C)2\n"
			+ "7 032C C=CR-O-CHX-C\n"
			+ "7 032E C=CR-O-CH2-X\n"
			+ "7 0330 C=CR-O-CH=C\n"
			+ "7 0334 C=CR-O-Ar\n"
			+ "7 0338 C=CH-O-CR(-C)2\n"
			+ "7 033A C=CH-O-CH2-R\n"
			+ "7 033C C=C(-C)-O-CR(-C)2\n"
			+ "7 033E C=C(-C)-O-CH3\n"
			+ "7 0340 Ar-O-CR(-C)2\n"
			+ "7 0342 Ar-O-CH2-R\n"
			+ "7 0344 Ar-O-Ar; (C-)3C-O-C(-C)3\n"
			+ "7 0346 (C-)2CR-O-CH(-C)2\n"
			+ "7 0348 (C-)3C-O-CH2-R\n"
			+ "7 034C (C-)2CH-O-CH3; C-CH2-O-CH2-C\n"
			+ "7 034E R-CH2-O-CH3\n"
			+ "7 0352 C#C-OH; C=CR-OH\n"
			+ "7 0354 (C-)2CR-OH\n"
			+ "7 0356 R-CH2-OH\n"
			+ "7 0358 C=C(-X)-OH; (C-)2C(-X)-OH\n"
			+ "7 035A R-CH(-X)-OH\n"
			+ "7 035C R-CX2-OH\n"
			+ "7 035E CX3-OH; X=C-OH\n"
			+ "7 0360 P-O-B; P-O-Si\n"
			+ "7 0364 P-O-O; P-O-N\n"
			+ "7 0366 P-O-P; P-O-S\n"
			+ "7 0368 S-O-B; S-O-Si\n"
			+ "7 036C S-O-O; S-O-N\n"
			+ "7 036E S-O-X  X<>N,O,P\n"
			+ "7 0370 N-O-B; N-O-Si\n"
			+ "7 0372 Si-O-Si; Si-O-B\n"
			+ "7 0374 N-O-O; N-O-N\n"
			+ "7 0378 B-O-O; Si-O-O\n"
			+ "7 037A X-O-O  X<>N,P,S\n"
			+ "7 037C B-O-X, Si-O-X  X<>N,O,P,S\n"
			+ "7 0380 B-O-Ar; B-O-C=X\n"
			+ "7 0382 B-O-CR=C\n"
			+ "7 0384 B-O-CR(-C)2\n"
			+ "7 0386 B-O-CH2-R\n"
			+ "7 0388 B-O-CX=C; B-O-CX(-C)2\n"
			+ "7 038A B-O-CHX-R\n"
			+ "7 038C B-O-CX2-R\n"
			+ "7 0390 Si-O-Ar; Si-O-C=X\n"
			+ "7 0392 Si-O-CR=C\n"
			+ "7 0394 Si-O-CR(-C)2\n"
			+ "7 0396 Si-O-CH2-R\n"
			+ "7 0398 Si-O-CX=C; Si-O-CX(-C)2\n"
			+ "7 039A Si-O-CHX-R\n"
			+ "7 039C Si-O-CX2-R\n"
			+ "7 03A0 X-O-Ar, X-O-C=Y  X<>N,O,P,S\n"
			+ "7 03A2 X-O-CR=C  X<>N,O,P,S\n"
			+ "7 03A4 X-O-CR(-C)2  X<>N,O,P,S\n"
			+ "7 03A6 X-O-CH2-R  X<>N,O,P,S\n"
			+ "7 03A8 X-O-CY=C, X-O-CY(-C)2  X<>N,O,P,S\n"
			+ "7 03AA X-O-CHY-R  X<>N,O,P,S\n"
			+ "7 03AC X-O-CY2-R  X<>N,O,P,S\n"
			+ "7 03B0 X3C-O-Ar; X3C-O-C=X\n"
			+ "7 03B4 X3C-O-CR(-C)2\n"
			+ "7 03B6 X3C-O-CH2-R\n"
			+ "7 03B8 X3C-O-CX=C; X3C-O-CX(-C)2\n"
			+ "7 03BA X3C-O-CHX-R\n"
			+ "7 03BC X3C-O-CX2-R\n"
			+ "7 03C0 O-O-Ar; O-O-C=X\n"
			+ "7 03C2 O-O-CR=C\n"
			+ "7 03C4 O-O-CR(-C)2\n"
			+ "7 03C6 O-O-CH2-R\n"
			+ "7 03C8 O-O-CX=C; O-O-CX(-C)2\n"
			+ "7 03CA O-O-CHX-R\n"
			+ "7 03CC O-O-CX2-R\n"
			+ "7 03D0 N-O-Ar; N-O-C=X\n"
			+ "7 03D2 N-O-CR=C\n"
			+ "7 03D4 N-O-CR(-C)2\n"
			+ "7 03D6 N-O-CH2-R\n"
			+ "7 03D8 N-O-CX=C; N-O-CX(-C)2\n"
			+ "7 03DA N-O-CHX-R\n"
			+ "7 03DC N-O-CX2-R\n"
			+ "7 03E0 P-O-Ar; P-O-C=X\n"
			+ "7 03E2 P-O-CR=C\n"
			+ "7 03E4 P-O-CR(-C)2\n"
			+ "7 03E6 P-O-CH2-R\n"
			+ "7 03E8 P-O-CX=C; P-O-CX(-C)2\n"
			+ "7 03EA P-O-CHX-R\n"
			+ "7 03EC P-O-CX2-R\n"
			+ "7 03F0 S-O-Ar; S-O-C=X\n"
			+ "7 03F2 S-O-CR=C\n"
			+ "7 03F4 S-O-CR(-C)2\n"
			+ "7 03F6 S-O-CH2-R\n"
			+ "7 03F8 S-O-CX=C; S-O-CX(-C)2\n"
			+ "7 03FA S-O-CHX-R\n"
			+ "7 03FC S-O-CX2-R\n"
			+ "6 0000 C-Li\n"
			+ "6 0004 C-Na,K,Rb,Cs\n"
			+ "6 0008 C-Mg,Be\n"
			+ "6 000C C-Ca,Sr,Ba\n"
			+ "6 0010 C-Al\n"
			+ "6 0014 C-Ga,In,Tl\n"
			+ "6 0018 C-Ge,Sn,Pb\n"
			+ "6 001C C-Sb,Bi\n"
			+ "6 0020 C-Cu,Ag,Au\n"
			+ "6 0024 C-Zn,Cd,Hg\n"
			+ "6 0028 C-Sc,Y,La,Ac\n"
			+ "6 002C C-rare Earth\n"
			+ "6 0030 C-Ti,Zr,Hf\n"
			+ "6 0034 C-V,Nb,Ta,Cr,Mo,W\n"
			+ "6 0038 C-Mn,Fe,Co,Ni\n"
			+ "6 003C C-Pd type\n"
			+ "6 0040 RnBH(-)X(3-n); (C-)4B(-)\n"
			+ "6 0044 (C-)nB(-)X(4-n)  n<>4\n"
			+ "6 0048 R-BH-C; R-BH-X\n"
			+ "6 004C BHX2; Met at B\n"
			+ "6 0050 (C-)2B-X\n"
			+ "6 0054 BX3; B=X\n"
			+ "6 0058 C-B(OR)2\n"
			+ "6 005C C-BX2  X<>O; (C-)3B\n"
			+ "6 0060 (?-)4P(+); C-PH-R\n"
			+ "6 0064 P=C\n"
			+ "6 0068 (C-)3P; PX3\n"
			+ "6 006C R3P=X; R3PX2; RPX2; R2PX\n"
			+ "6 0080 little bulky N-Si(-C)3\n"
			+ "6 0084 bulky N-Si(-C)3\n"
			+ "6 0088 little bulky O-Si(-C)3\n"
			+ "6 008C bulky O-Si(-C)3\n"
			+ "6 0090 (C-)2SiX2\n"
			+ "6 0094 C-SiX3; SiX4\n"
			+ "6 0098 (C-)3Si-X  X<>N,O\n"
			+ "6 009C Si-N\n"
			+ "6 00A0 C-SiHR2\n"
			+ "6 00A4 C-SiHR-X\n"
			+ "6 00A8 RSiHX2\n"
			+ "6 00B0 (C-)3Si-C(pi>0); allylsilane\n"
			+ "6 00B8 aromatic N,O or S\n"
			+ "6 00C0 ?-C#CH\n"
			+ "6 00C8 (X,C)-C#C-?=X\n"
			+ "6 00D0 C-CH=CH-R; (C-)2-C=CH2\n"
			+ "6 00D4 C-CR=C(-C)2\n"
			+ "6 00D8 activated R2C=CR2\n"
			+ "6 00DC activated C=C-X\n"
			+ "6 00E0 not activated C=C-X\n"
			+ "6 00E4 C3-ring\n"
			+ "6 00E8 C=C=C\n"
			+ "6 00EC aromatic ring\n"
			+ "6 00F0 assymetric carbon\n"
			+ "6 00F4 C-TeXn\n"
			+ "6 00F8 TeXn\n"
			+ "6 00FC C-TeXn-C\n"
			+ "6 0100 C(z=1,pi>0)-F\n"
			+ "6 0104 R3C-F\n"
			+ "6 0108 C=CX-F; R2CX-F\n"
			+ "6 010C R-CX2-F\n"
			+ "6 0110 R-C(=X)-F; F-CN\n"
			+ "6 0114 F-C(=X)-Y; F-CX3\n"
			+ "6 0120 C(z=1,pi>0)-Cl\n"
			+ "6 0124 R3C-Cl\n"
			+ "6 0128 C=CX-Cl; R2CX-Cl\n"
			+ "6 012C R-CX2-Cl\n"
			+ "6 0130 R-C(=X)-Cl; Cl-CN\n"
			+ "6 0134 Cl-C(=X)-Y; Cl-CX3\n"
			+ "6 0140 C(z=1,pi>0)-Br\n"
			+ "6 0144 R3C-Br\n"
			+ "6 0148 C=CX-Br; R2CX-Br\n"
			+ "6 014C R-CX2-Br\n"
			+ "6 0150 R-C(=X)-Br; Br-CN\n"
			+ "6 0154 Br-C(=X)-Y; Br-CX3\n"
			+ "6 0160 C(z=1,pi>0)-I\n"
			+ "6 0164 R3C-I\n"
			+ "6 0168 C=CX-I; R2CX-I; R-IX4 type\n"
			+ "6 016C R-CX2-I\n"
			+ "6 0170 R-C(=X)-I; I-CN\n"
			+ "6 0174 I-C(=X)-Y; I-CX3\n"
			+ "6 0180 C-SeX  X<>Se\n"
			+ "6 0184 C-Se-Se; X-SeH\n"
			+ "6 0188 Se(z=2,6)\n"
			+ "6 018C Se(z=4)\n"
			+ "6 0190 Se(z=3)\n"
			+ "6 0194 Se(z=5)\n"
			+ "6 0198 R-C(=Se)-?\n"
			+ "6 01A0 C(pi>0)-Se\n"
			+ "6 01A4 R3C-Se\n"
			+ "6 01A8 X=C-Se; R2C(-X)-Se\n"
			+ "6 01AC ?-CX2-Se\n"
			+ "6 01B0 C(pi>0)-CH=O\n"
			+ "6 01B4 R3C-CH=O\n"
			+ "6 01B8 ?-CX2-CH=O\n"
			+ "6 01BC X-CR2-CH=O\n"
			+ "6 01C0 C(z=1,pi>0)-S\n"
			+ "6 01C4 R3C-S\n"
			+ "6 01C8 C=CX-S; X-C(-C)2-S\n"
			+ "6 01CC X-CHR-S\n"
			+ "6 01D4 H2C=X  X=N,O,S\n"
			+ "6 01D8 C-CN\n"
			+ "6 01DC ?-CN  ?<>C\n"
			+ "6 01E0 R3C-O-CX(-C)2\n"
			+ "6 01E4 Ar-O-CXR2\n"
			+ "6 01E8 R3C-O-CHX-C\n"
			+ "6 01EC R3C-O-CH2-X\n"
			+ "6 01F0 C-CR(-X)-O-CR(-X)-C\n"
			+ "6 01F4 R2CX-O-CH2-X\n"
			+ "6 01F8 R3C-O-CX2-C\n"
			+ "6 01FC R3C-O-CHX2\n"
			+ "6 0200 azide\n"
			+ "6 0208 X=NR(+)-Y\n"
			+ "6 0210 RnN(+)X(4-n) except R3N(+)-O\n"
			+ "6 0214 C=N(+)\n"
			+ "6 0218 C=C=X\n"
			+ "6 021C ?-N=C=X\n"
			+ "6 0220 C-C(=N-?)-Y-?=X\n"
			+ "6 0224 C-C(=N-?)-X(without -?=X)\n"
			+ "6 0228 ?-N=CH-X-?=Y\n"
			+ "6 022C ?-N=CH-X(without -?=X)\n"
			+ "6 0230 N-C(=N-?)-X\n"
			+ "6 0234 O-C(=N-?)-X  X<>N\n"
			+ "6 0238 Y-C(=N-?)-X  X,Y<>N,O\n"
			+ "6 023C C-C(=N-?)-R\n"
			+ "6 0240 C(pi>0)-N\n"
			+ "6 0244 R3C-N\n"
			+ "6 0248 X=C-N; R2C(-X)-N\n"
			+ "6 024C (R,X)-CX2-N\n"
			+ "6 0250 C=NH; C=N-CR3\n"
			+ "6 0254 C=N-C(pi>0); C=N-CXR2 type\n"
			+ "6 0258 C=N-?=X; C=N-X  X<>N,O\n"
			+ "6 025C C=N-X  X=N,O\n"
			+ "6 0260 Y-N=X  X<>N\n"
			+ "6 0264 NX3; X-N=N-\n"
			+ "6 0268 R-N=X; R-NX2\n"
			+ "6 026C (C-)2N-X\n"
			+ "6 0270 NH2-X\n"
			+ "6 0274 C-NH-X\n"
			+ "6 0278 amine type R3N; amide type C-NH2\n"
			+ "6 027C amide or imide type (C-)2NR\n"
			+ "6 0280 N-C(=O)-X\n"
			+ "6 0284 O-C(=O)-X  X<>N\n"
			+ "6 0288 Y-C(=O)-X  X,Y<>N,O\n"
			+ "6 0290 C-C(=O)-Y-?=X\n"
			+ "6 0294 C-C(=O)-X(without -?=X)\n"
			+ "6 0298 O=CH-X-?=Y\n"
			+ "6 029C O=CH-X(without -?=X)\n"
			+ "6 02A0 C(pi>0)-C(=O)-C=C; R3C-C(=O)-C=C\n"
			+ "6 02A4 X-C(pi=0,z>0)-C(=O)-C=C\n"
			+ "6 02A8 X-C(pi=0)-C(=O)-C(pi=0)\n"
			+ "6 02AC X-C-C(=O)-Ar\n"
			+ "6 02B0 Ar-C(=O)-Ar; R3C-C(=O)-Ar\n"
			+ "6 02B4 R3C-C(=O)-CR3\n"
			+ "6 02B8 oxirane\n"
			+ "6 02BC aziridine\n"
			+ "6 02C0 N-C(=S)-X\n"
			+ "6 02C4 O-C(=S)-X  X<>N\n"
			+ "6 02C8 Y-C(=S)-X  X,Y<>N,O\n"
			+ "6 02CC C-C(=S)-R\n"
			+ "6 02D0 C-C(=S)-X\n"
			+ "6 02D4 S=CH-X\n"
			+ "6 02D8 C-S-X\n"
			+ "6 02E0 S(z=2,6)\n"
			+ "6 02E4 S(z=4)\n"
			+ "6 02E8 S(z=3)\n"
			+ "6 02EC S(z=5)\n"
			+ "6 02F4 R-CX2-O-CX2-R\n"
			+ "6 02F8 R2CX-O-CX2-C\n"
			+ "6 02FC R2CX-O-CHX2\n"
			+ "6 0304 R3C-O-C=X\n"
			+ "6 0308 R2CX-O-C=X\n"
			+ "6 0310 C=CX-O-CR3\n"
			+ "6 0314 C=CX-O-C(pi>0)\n"
			+ "6 0318 C=CX-O-C=X; C=CX-O-CX2-R\n"
			+ "6 031C C=CX-O-CR2-X\n"
			+ "6 0320 C=CR-O-CX2-R\n"
			+ "6 0324 C=CR-O-C=X; C=CR-O-CX3\n"
			+ "6 032C C=CR-O-CHX-R\n"
			+ "6 0330 C=CR-O-CR=C\n"
			+ "6 0338 C=CH-O-CR3\n"
			+ "6 033C C=C(-C)-O-CR3\n"
			+ "6 0340 Ar-O-CR3\n"
			+ "6 0344 Ar-O-Ar; (C-)2CR-O-CR(-C)2\n"
			+ "6 0348 (C-)3C-O-CH2-R; (C-)2CH-O-CH2-C\n"
			+ "6 034C (C-)2CH-O-CH3; R-CH2-O-CH2-R\n"
			+ "6 0350 C(z=1,pi>0)-OH\n"
			+ "6 0354 R3C-OH\n"
			+ "6 0358 C=C(-X)-OH; X-CR2-OH\n"
			+ "6 035C R-CX2-OH; CX3-OH; X=C-OH\n"
			+ "6 0360 P-O-B,Si,X  X<>N,O,P,S\n"
			+ "6 0364 P-O-X  X=N,O,P,S\n"
			+ "6 0368 S-O-B; S-O-Si; B-O-B\n"
			+ "6 036C S-O-X  X<>P\n"
			+ "6 0370 N-O-B; N-O-Si; Si-O-Si; Si-O-B\n"
			+ "6 0374 N-O-X  X<>P,S\n"
			+ "6 0378 B-O-O; Si-O-O; X-O-O  X<>N,P,S\n"
			+ "6 037C B-O-X, Si-O-X, X-O-X  X<>N,O,P,S\n"
			+ "6 0380 B-O-C=X; B-O-C(pi>0,z=1)\n"
			+ "6 0384 B-O-CR3\n"
			+ "6 0388 B-O-CX=C; B-O-CR2-X\n"
			+ "6 038C B-O-CX2-?; B-OH\n"
			+ "6 0390 Si-O-C=X; Si-O-C(pi>0,z=1)\n"
			+ "6 0394 Si-O-CR3\n"
			+ "6 0398 Si-O-CX=C; Si-O-CR2-X\n"
			+ "6 039C Si-O-CX2-?; Si-OH\n"
			+ "6 03A0 X-O-C=Y, X-O-C(pi>0,z=1)  X<>N,O,P,S\n"
			+ "6 03A4 X-O-CR3  X<>N,O,P,S\n"
			+ "6 03A8 X-O-CY=C, X-O-CR2-Y  X<>N,O,P,S\n"
			+ "6 03AC X-O-CY2-?, X-OH  X<>N,O,P,S\n"
			+ "6 03B0 X3C-O-C=X, X3C-O-C(pi>0,z=1)\n"
			+ "6 03B4 X3C-O-CR3\n"
			+ "6 03B8 X3C-O-CX=C; X3C-O-CR2-X\n"
			+ "6 03BC X3C-O-CX2-?\n"
			+ "6 03C0 O-O-C=X; O-O-C(pi>0,z=1)\n"
			+ "6 03C4 O-O-CR3\n"
			+ "6 03C8 O-O-CX=C; O-O-CR2-X\n"
			+ "6 03CC O-O-CX2-?; O-OH\n"
			+ "6 03D0 N-O-C=X; N-O-C(pi>0,z=1)\n"
			+ "6 03D4 N-O-CR3\n"
			+ "6 03D8 N-O-CX=C; N-O-CR2-X\n"
			+ "6 03DC N-O-CX2-?; N-OH\n"
			+ "6 03E0 P-O-C=X; P-O-C(pi>0,z=1)\n"
			+ "6 03E4 P-O-CR3\n"
			+ "6 03E8 P-O-CX=C; P-O-CR2-X\n"
			+ "6 03EC P-O-CX2-?; P-OH\n"
			+ "6 03F0 S-O-C=X; S-O-C(pi>0,z=1)\n"
			+ "6 03F4 S-O-CR3\n"
			+ "6 03F8 S-O-CX=C; S-O-CR2-X\n"
			+ "6 03FC S-O-CX2-?; S-OH\n"
			+ "5 0000 C-Li,Na,K,Rb,Cs\n"
			+ "5 0008 C-Mg,Be,Ca,Sr,Ba\n"
			+ "5 0010 C-Al,Ga,In,Tl\n"
			+ "5 0018 C-Ge,Sn,Pb,Sb,Bi\n"
			+ "5 0020 C-Cu,Ag,Au,Zn,Cd,Hg\n"
			+ "5 0028 C-Sc,Y,La,Ac,rare Earth\n"
			+ "5 0030 C-Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W\n"
			+ "5 0038 C-Mn,Fe,Co,Ni; C-Pd type\n"
			+ "5 0040 (?-)4B(-)\n"
			+ "5 0048 ?-BH-?; Met at B\n"
			+ "5 0058 C-BX2; (C-)3B\n"
			+ "5 0070 P(=X)-Y; RP(=X)Y2; X=PY3\n"
			+ "5 0078 any As\n"
			+ "5 0080 N-Si(-C)3\n"
			+ "5 0088 O-Si(-C)3\n"
			+ "5 0090 (C-)2SiX2; C-SiX3; SiX4\n"
			+ "5 00A0 C-SiHR-?\n"
			+ "5 00A8 ?-SiHX2\n"
			+ "5 00B0 (C-)4Si\n"
			+ "5 00D0 non activated R2C=CR2\n"
			+ "5 00D8 activated C=C\n"
			+ "5 00F8 TeXn; C-TeXn-C\n"
			+ "5 0100 C(z=1)-F\n"
			+ "5 0108 C=CX-F; R2CX-F; R-CX2-F\n"
			+ "5 0110 ?-C(=X)-F; F-CN; F-CX3\n"
			+ "5 0120 C(z=1)-Cl\n"
			+ "5 0128 C=CX-Cl; R2CX-Cl; R-CX2-Cl\n"
			+ "5 0130 ?-C(=X)-Cl; Cl-CN; Cl-CX3\n"
			+ "5 0140 C(z=1)-Br\n"
			+ "5 0148 C=CX-Br; R2CX-Br; R-CX2-Br\n"
			+ "5 0150 ?-C(=X)-Br; Br-CN; Br-CX3\n"
			+ "5 0160 C(z=1)-I\n"
			+ "5 0168 C=CX-I; R2CX-I; R-CX2-I\n"
			+ "5 0170 ?-C(=X)-I; I-CN; I-CX3\n"
			+ "5 0180 C-SeX; X-SeH\n"
			+ "5 0188 Se(z=2,4,6)\n"
			+ "5 0190 Se(z=3,5)\n"
			+ "5 0198 C=Se; C-Se-C; C-SeH\n"
			+ "5 01A0 C(z=1)-Se\n"
			+ "5 01A8 C(z>1)-Se\n"
			+ "5 01B0 C(pi>0)-CH=O; R3C-CH=O\n"
			+ "5 01B8 C(pi=0,z>0)-CH=O\n"
			+ "5 01C0 C(z=1)-S\n"
			+ "5 01C8 C=CX-S; X-CR2-S\n"
			+ "5 01D8 ?-CN\n"
			+ "5 01E8 R3C-O-CHX-R\n"
			+ "5 01F0 X-CR2-O-CR2-X\n"
			+ "5 01F8 R3C-O-CX2-R\n"
			+ "5 0220 C-C(=N-?)-X\n"
			+ "5 0228 ?-N=CH-X\n"
			+ "5 0230 X-C(=N-?)-Y  X=N,O\n"
			+ "5 0258 C=N-?=X; C=N-X\n"
			+ "5 0260 Y-N=X; NX3\n"
			+ "5 0270 R-NH-X\n"
			+ "5 0278 R3N\n"
			+ "5 0280 X-C(=O)-Y  X=N,O\n"
			+ "5 0290 C-C(=O)-X\n"
			+ "5 0298 O=CH-X\n"
			+ "5 02A0 C-C(=O)-C=C\n"
			+ "5 02A8 X-C(pi=0)-C(=O)-C(pi=0); X-C-C(=O)-Ar\n"
			+ "5 02B0 Ar-C(=O)-Ar; R3C-C(=O)-Ar; R3C-C(=O)-CR3\n"
			+ "5 02B8 oxirane; aziridine\n"
			+ "5 02C0 X-C(=S)-Y  X=N,O\n"
			+ "5 02D0 R-C(=S)-X\n"
			+ "5 02D8 C-S-?; X-SH; S(+)\n"
			+ "5 02E0 S(z=2,4,6)\n"
			+ "5 02E8 S(z=3,5)\n"
			+ "5 02F8 R2CX-O-CX2-R\n"
			+ "5 0308 R2CX-O-C=X; R-CX2-O-C=X\n"
			+ "5 0310 C=CX-O-CR3; C=CX-O-C(pi>0)\n"
			+ "5 0318 C=CX-O-C=X; C=CX-O-CX2-R; C=CX-O-CR2-X\n"
			+ "5 0320 C=CR-O-C=X; C=CR-O-CX2-R; C=CR-O-CX3\n"
			+ "5 0328 C=CR-O-CR2-X\n"
			+ "5 0330 C=CR-O-C(pi>0,z=1)\n"
			+ "5 0338 C=CR-O-CR3\n"
			+ "5 0340 Ar-O-CR3; Ar-O-Ar; (C-)2CR-O-CR(-C)2\n"
			+ "5 0348 R-CH2-O-CR3\n"
			+ "5 0350 C(z=1)-OH\n"
			+ "5 0358 C(z>1)-OH\n"
			+ "5 0360 P-O-B,Si,X\n"
			+ "5 0380 B-O-C=X; B-O-C(z=1)\n"
			+ "5 0388 B-O-C(z>1); B-OH\n"
			+ "5 0390 Si-O-C=X; Si-O-C(z=1)\n"
			+ "5 0398 Si-O-C(z>1); Si-OH\n"
			+ "5 03A0 X-O-C=Y, X-O-C(z=1)  X<>N,O,P,S\n"
			+ "5 03A8 X-O-C(z>1), X-OH  X<>N,O,P,S\n"
			+ "5 03B0 X3C-O-C=X, X3C-O-C(z=1)\n"
			+ "5 03B8 X3C-O-C(z>1)\n"
			+ "5 03C0 O-O-C=X; O-O-C(z=1)\n"
			+ "5 03C8 O-O-C(z>1); O-OH\n"
			+ "5 03D0 N-O-C=X; N-O-C(z=1)\n"
			+ "5 03D8 N-O-C(z>1); N-OH\n"
			+ "5 03E0 P-O-C=X; P-O-C(z=1)\n"
			+ "5 03E8 P-O-C(z>1); P-OH\n"
			+ "5 03F0 S-O-C=X; S-O-C(z=1)\n"
			+ "5 03F8 S-O-C(z>1); S-OH\n"
			+ "4 0000 C-Met (group I A,II A)\n"
			+ "4 0010 C-Met (group III A,IV A, V A except B,Si)\n"
			+ "4 0020 C-Met (group I B,II B, III B, rare earth)\n"
			+ "4 0030 C-Met (group IV B,V B, VI B, VII B, VIII B)\n"
			+ "4 0080 X-Si(-C)3  X=N,O\n"
			+ "4 00C0 C#C\n"
			+ "4 00D0 non activated R2C=CR2; activated C=C\n"
			+ "4 0180 Se(z=1,2,4,6)\n"
			+ "4 0190 Se(z=0,3,5)\n"
			+ "4 01A0 C-Se\n"
			+ "4 01B0 C-CH=O\n"
			+ "4 01C0 C(z=1,2)-S\n"
			+ "4 01F0 X-CR2-O-CR2-X; R3C-O-CX2-R\n"
			+ "4 0220 R-C(=N-?)-X\n"
			+ "4 0230 X-C(=N-?)-Y; C-C(=N-?)-R\n"
			+ "4 0240 C-N\n"
			+ "4 0250 C=N\n"
			+ "4 0260 ?-N=X; NX3; R-NX2; (C-)2N-X\n"
			+ "4 0270 R-NH-X; R3N\n"
			+ "4 0280 X-C(=O)-Y\n"
			+ "4 0290 R-C(=O)-X\n"
			+ "4 02A0 C-C(=O)-C=C; X-C-C(=O)-C\n"
			+ "4 02C0 X-C(=S)-Y; C-C(=S)-R\n"
			+ "4 02E0 S(z=2,3,4,5,6)\n"
			+ "4 02F0 Ar-O-CX2-R; R-CX2-O-CX2-R; R2CX-O-CX2-R\n"
			+ "4 0300 Ar-O-C=X; R3C(pi=0,z<>4)-O-C=X\n"
			+ "4 0310 C=CX-O-C(z<>4)\n"
			+ "4 0320 C=CR-O-C(pi=0)-X\n"
			+ "4 0330 C=CR-O-C(z=1)\n"
			+ "4 0340 Ar-O-Ar; Ar-O-CR3; R3C-O-CR3\n"
			+ "4 0350 C-OH\n"
			+ "4 0380 B-O-R\n"
			+ "4 0390 Si-O-R\n"
			+ "4 03A0 X-O-R  X<>N,O,P,S\n"
			+ "4 03B0 X3C-O-C\n"
			+ "4 03C0 O-O-R\n"
			+ "4 03D0 N-O-R\n"
			+ "4 03E0 P-O-R\n"
			+ "4 03F0 S-O-R\n"
			+ "3 0000 C-Met (group I to V A except B,Si)\n"
			+ "3 0020 C-Met (group I to VIII B, rare earth)\n"
			+ "3 0040 any B\n"
			+ "3 0060 any P or As\n"
			+ "3 0080 (C-)nSiX(4-n)  n<>4; Si-N\n"
			+ "3 0100 any F\n"
			+ "3 0120 any Cl\n"
			+ "3 0140 any Br\n"
			+ "3 0160 any I\n"
			+ "3 0180 any Se\n"
			+ "3 01C0 C-S; H2C=X  X=N,O,S; ?-CN\n"
			+ "3 01E0 R3C-O-CR2-X; Ar-O-CR2-X; X-CR2-O-CR2-X; R3C-O-CX2-R\n"
			+ "3 0200 any N(+); C=C=X; ?-N=C=X\n"
			+ "3 0220 ?-C(=N-?)-?  except H2C=N-?\n"
			+ "3 0240 C-N; C=N\n"
			+ "3 0260 ?-N=X; RnNX(3-n)\n"
			+ "3 0280 ?-C(=O)-X\n"
			+ "3 02A0 any ketone; oxirane; aziridine\n"
			+ "3 02C0 any C=S; C-S-?; X-SH; S(+)\n"
			+ "3 0320 C=CR-O-C(pi=0); C=CR-O-C(z=1)\n"
			+ "3 0380 B-O-R; Si-O-R\n"
			+ "3 03C0 O-O-R; N-O-R\n"
			+ "3 03E0 P-O-R; S-O-R\n"
			+ "2 0000 C-Met  Met<>B,Si\n"
			+ "2 00C0 any unsaturated C, C3-ring or assymetric carbon; any Te\n"
			+ "2 0100 any F or Cl\n"
			+ "2 0140 any Br or I\n"
			+ "2 0280 any C=O; oxirane; aziridine\n"
			+ "2 03C0 X-O-R  X=N,O,P,S\n"
			+ "1 0100 any halogene\n"
			+ "1 0200 any N; C=C=X\n"
			+ "0 0000 anything";

	private static final int[] GRP_OFFSET = { 511, 510, 508, 504, 496, 480, 448, 384, 256, 0 };
	private static final int[] EFG_OFFSET = { 2044, 2040, 2032, 2016, 1984, 1920, 1792, 1536, 1024, 0 };

	private static ClassificationData sInstance;
	private int mHEntries,mDEntries,mEEntries,mCEntries,mREntries;
	private String[] mHRxnTb1,mHRxnTb2,mDRxnTb1,mDRxnTb2,mERxnTb,mCRxnTb1,mCRxnTb2,mRRxnTb,mGRPName,mEFGName;
	private int[] mHRxnDe,mHRxnDefs,mDRxnDe,mERxnDe,mCRxnDe,mRRxnDe,mRRxn_fGrpNo;
	private boolean[] mRRxn_Sym;
	private int[][] mRRxnDefs;

/* private
	short		mPrunOptionPriv[MAXPRUNOPTIONS];
	short		mPrunOptionType[MAXPRUNOPTIONS];
	const char	*mPrunOptionName[MAXPRUNOPTIONS];
*/

	private ClassificationData() {
		initialize();
		}

	public static ClassificationData getInstance() {
		if (sInstance != null)
			return sInstance;

		synchronized(ClassificationData.class) {
			if (sInstance == null) {
				ClassificationData instance = new ClassificationData();
				instance.initialize();
				sInstance = instance;
				}
			}

		return sInstance;
		}

	private void initialize() {
		Scanner scanner = new Scanner(CLASSDATA);

		mHEntries = scanner.nextInt();
		mHRxnTb1 = new String[mHEntries];
		mHRxnTb2 = new String[mHEntries];
		mHRxnDe = new int[mHEntries];
		mHRxnDefs = new int[mHEntries];
		for (int i=0; i<mHEntries; i++) {
			mHRxnTb1[i] = scanner.next();
			mHRxnTb2[i] = scanner.next();
			String s = scanner.next();
			mHRxnDe[i] = Integer.parseInt(s, 16);
			mHRxnDefs[i] = Integer.parseInt(scanner.next(), 16);
			}

		mDEntries = scanner.nextInt();
		mDRxnTb1 = new String[mDEntries];
		mDRxnTb2 = new String[mDEntries];
		mDRxnDe = new int[mDEntries];
		for (int i=0; i<mDEntries; i++) {
			mDRxnTb1[i] = scanner.next();
			mDRxnTb2[i] = scanner.next();
			mDRxnDe[i] = Integer.parseInt(scanner.next(), 16);
			}

		mEEntries = scanner.nextInt();
		mERxnTb = new String[mEEntries];
		mERxnDe = new int[mEEntries];
		for (int i=0; i<mEEntries; i++) {
			mERxnTb[i] = scanner.next();
			mERxnDe[i] = Integer.parseInt(scanner.next(), 16);
			}

		mCEntries = scanner.nextInt();
		mCRxnTb1 = new String[mCEntries];
		mCRxnTb2 = new String[mCEntries];
		mCRxnDe = new int[mCEntries];
		for (int i=0; i<mCEntries; i++) {
			mCRxnTb1[i] = scanner.next();
			mCRxnTb2[i] = scanner.next();
			mCRxnDe[i] = Integer.parseInt(scanner.next(), 16);
			}

		mREntries = scanner.nextInt();
		mRRxnTb = new String[mREntries];
		mRRxnDe = new int[mREntries];
		mRRxn_fGrpNo = new int[mREntries];
		mRRxn_Sym = new boolean[mREntries];
		mRRxnDefs = new int[mREntries][];
		for (int i=0; i<mREntries; i++) {
			mRRxnTb[i] = scanner.next();
			mRRxnDe[i] = Integer.parseInt(scanner.next(), 16);
			mRRxnDefs[i] = new int[scanner.nextInt()];
			mRRxn_fGrpNo[i] = scanner.nextInt();
			mRRxn_Sym[i] = (scanner.nextInt() == 1);
			for (int j=0; j<mRRxnDefs[i].length; j++) {
				mRRxnDefs[i][j] = Integer.parseInt(scanner.next(), 16);
//				fscanf( fpoin,"%lx", (unsigned long *)&mRRxnDefs[i][j][0] );
//				::invertLongOnMac( (void *)mRRxnDefs[i][j] );
				}
			}

		mGRPName = new String[512];
		try {
			BufferedReader reader = new BufferedReader(new StringReader(GRPNAMES));
			String line = reader.readLine();
			while (line != null) {
				int matchLevel = line.charAt(0) - '0';
				int groupNo = Integer.parseInt(line.substring(2,4), 16);
				String name = line.substring(5);
				int index = getGRPNameIndex(groupNo, matchLevel);
				mGRPName[index] = name;
				line = reader.readLine();
				}
			}
		catch (IOException ioe) {}

		mEFGName = new String[2048];
		try {
			BufferedReader reader = new BufferedReader(new StringReader(EFGNAMES));
			String line = reader.readLine();
			while (line != null) {
				int matchLevel = line.charAt(0) - '0';
				int groupNo = Integer.parseInt(line.substring(2,6), 16);
				String name = line.substring(7);
				int index = getEFGNameIndex(groupNo, matchLevel);
				mEFGName[index] = name;
				line = reader.readLine();
				}
			}
		catch (IOException ioe) {}
		}

	private int getGRPNameIndex(int fGroup, int matchLevel) {
		return GRP_OFFSET[matchLevel] + (fGroup >> (8-matchLevel));
		}

	private int getEFGNameIndex(int efgClass, int matchLevel) {
		return EFG_OFFSET[matchLevel] + (efgClass >> (8-matchLevel));
		}

	public String getEFGName(int efgClass, int matchLevel) {
		return mEFGName[getEFGNameIndex(efgClass, matchLevel)];
		}

	public int getHEntries() {
		return mHEntries;
		}

	public int getDEntries() {
		return mDEntries;
		}

	public int getEEntries() {
		return mEEntries;
		}

	public int getCEntries() {
		return mCEntries;
		}

	public int getREntries() {
		return mREntries;
		}

	public int getHRxnDelta(int i) {
		return mHRxnDe[i];
		}

	public int getDRxnDelta(int i) {
		return mDRxnDe[i];
		}

	public int getERxnDelta(int i) {
		return mERxnDe[i];
		}

	public int getCRxnDelta(int i) {
		return mCRxnDe[i];
		}

	public int getRRxnDelta(int i) {
		return (mRRxnDe[i]);
		}

	public String getCRingClosureName(int i) {
		return mCRxnTb1[i];
		}

	public String getCRingOpeningName(int i) {
		return mCRxnTb2[i];
		}

	public String getDConstructionName(int i) {
		return mDRxnTb1[i];
		}

	public String getDFragmentationName(int i) {
		return mDRxnTb2[i];
		}

	public String getERearrangementName(int i) {
		return mERxnTb[i];
		}

	public String getHConstructionName(int i) {
		return mHRxnTb1[i];
		}

	public String getHFragmentationName(int i) {
		return mHRxnTb2[i];
		}

	public int getHRxnGroupDef(int i) {
		return mHRxnDefs[i];
		}

	public String getRRefuncName(int i) {
		return mRRxnTb[i];
		}

	public int getRRxnDef(int entryNo, int perm, int group) {
		final int[] mask = { 0x000000FF, 0x0000FF00, 0x00FF0000, 0xFF000000 };
		return (mRRxnDefs[entryNo][perm] & mask[group]) >> (8*group);
		}

	public int getRRxnFGroups(int i) {
		return mRRxn_fGrpNo[i];
		}

	public int getRRxnMasks(int i) {
		return mRRxnDefs[i].length;
		}

	public boolean getRRxnSymmetric(int i) {
		return mRRxn_Sym[i];
		}

/*	public int getPrunOptionPriv(int optionNo) {
		return mPrunOptionPriv[optionNo];
		}

	public int getPrunOptionType(int optionNo) {
		return mPrunOptionType[optionNo];
		}

	public String getPrunOptionName(int optionNo) {
		return mPrunOptionName[optionNo];
		}
*/
}

