package sinkcluster

/* ClusterWriter, and (ClusterCountResult).Count output a streamed IP set journal file to remember distinct IP address

   its format is as follows:

   This file should be in newline-delimited JSON format(https://jsonlines.org/).
   For each line, the format of json data should be in the format of:
   {"recordingStart":"2022-05-30T14:38:44.678610091Z","recordingEnd":"2022-05-30T14:39:48.157630926Z","recorded":""}

	recordingStart:datetime is the time this chunk of recording start.

	recordingEnd:datetime is the time this chunk of recording end.

	recorded is the checkpoint data generated by hyperloglog.
*/

import "time"

type SinkEntry struct {
	RecordingStart time.Time `json:"recordingStart"`
	RecordingEnd   time.Time `json:"recordingEnd"`
	Recorded       []byte    `json:"recorded"`
}
