# 日誌收集工具|deepin-log-viewer|

## 概述

日誌收集工具是負責收集程序運行時所產生日誌的小工具，如操作系統和應用程序在啟動、運行等過程中的相關信息。您可以通過分析詳細日誌信息，快速地找到故障原因並解決問題。



## 使用入門

您可以通過以下方式運行或關閉日誌收集工具，或者創建快捷方式。

### 運行日誌收集工具

1. 單擊任務欄上的啟動器圖標 ![deepin_launcher](../common/deepin_launcher.svg)，進入啟動器界面。
2. 上下滾動鼠標滾輪瀏覽或通過搜索，找到日誌收集工具圖標 ![deepin_log_viewer](../common/deepin_log_viewer.svg)，單擊運行。
3. 右鍵單擊 ![deepin_log_viewer](../common/deepin_log_viewer.svg)，您可以：
   - 單擊 **發送到桌面**，在桌面創建快捷方式。
   - 單擊 **發送到任務欄**，將應用程序固定到任務欄。
   - 單擊 **開機自動啟動**，將應用程序添加到開機啟動項，在電腦開機時自動運行該應用程序。

### 關閉日誌收集工具

- 在日誌收集工具界面，單擊 ![close_icon](../common/close_icon.svg)，退出日誌收集工具。
- 在任務欄上右鍵單擊 ![deepin_log_viewer](../common/deepin_log_viewer.svg) ，選擇 **關閉所有**，退出日誌收集工具。
- 在日誌收集工具界面單擊 ![icon_menu](../common/icon_menu.svg)，選擇 **退出**，退出日誌收集工具。

## 操作介紹

### 搜索日誌

1. 在日誌收集工具搜索框中，單擊 ![search](../common/search.svg)。
2. 輸入關鍵字，實時顯示搜索結果。
3. 單擊 ![close_icon](../common/close_icon.svg) ，則清空搜索內容。



### 篩選日誌

您可以通過 **週期**、**級別**、**狀態**、**應用列表** 或 **事件類型** 來篩選日誌。
<table border="1">
   <tr>
    <th>類型</th>
 <th>說明 </th>
</tr>
   <tr>
    <td>按週期篩選</td>
    <td>按日誌生成的時間順序進行篩選。
      <ul>
          <li>選項包括：全部、今天、近三天、近一週、近一個月、近三個月，默認選項為全部。</li>
          <li>適用類型：除了啟動日誌沒有顯示時間外，其他類型的日誌都支持按週期篩選。</li>
      </ul>
 </td>
</tr>
   <tr>
    <td>按級別篩選</td>
    <td>按照事件的級別高低進行篩選。
    <ul>
          <li>選項包括：全部、緊急、嚴重警告、嚴重、錯誤、警告、注意、信息、調試，默認選項為信息。</li>
          <li>適用類型：系統日誌、應用日誌。</li>
      </ul>
      <tr>
    <td>按狀態篩選</td>
    <td>
    <ul>
          <li>選項包括：全部、OK、Failed，默認選項為全部。</li>
          <li>適用類型：僅適用於啟動日誌。</li>
      </ul>
          <tr>
    <td>按應用列表篩選</td>
    <td>
        適用類型：僅適用於應用日誌，對應用程序的log文件進行篩選，默認選項為第一個應用程序。 </td>
              <tr>
    <td>按事件類型篩選</td>
    <td>
    <ul>
          <li>選項包括：全部、登錄、開機、關機，默認選項為全部。</li>
          <li>適用類型：僅適用於開關機事件。</li>
      </ul>
 </td>
   </tr>
   </table>


### 查看日誌

#### 查看系統日誌

1. 在日誌收集工具界面，單擊 **系統日誌**。
2. 查看系統日誌的級別、進程、時間和信息。
3. 選中某條日誌後，可查看該日誌的詳細信息，包括進程、時間、主機名、進程號、級別和詳細信息。

![rsylog](fig/syslog.png)

#### 查看內核日誌

1. 在日誌收集工具界面，單擊 **內核日誌**。
2. 彈出“密碼認證”窗口，輸入用戶登錄密碼後單擊 **確定**。
3. 查看內核日誌的時間、主機名、進程和信息。
4. 選中某條日誌後，可查看該日誌的詳細信息，包括進程、時間、主機名和詳細信息。

![kernlog](fig/kernlog.png)

#### 查看啟動日誌

1. 在日誌收集工具界面，單擊 **啟動日誌**。
2. 彈出“密碼認證”窗口，輸入用戶登錄密碼後單擊 **確定**。
3. 查看啟動日誌的狀態和信息。
4. 選中某條日誌後，可查看該日誌的詳細信息，包括主機名、狀態和詳細信息。

![bootlog](fig/bootlog.png)

#### 查看dpkg日誌

1. 在日誌收集工具界面，單擊 **dpkg日誌**。
2. 查看dpkg日誌的時間和信息。
3. 選中某條日誌後，可查看該日誌的詳細信息，包括時間、主機名、動作和詳細信息。

![dpkglog](fig/dpkglog.png)

#### 查看Xorg日誌

1. 在日誌收集工具界面，單擊 **Xorg日誌**。
2. 查看Xorg日誌的時間和信息。
3. 選中某條日誌後，可查看該日誌的詳細信息，包括時間、主機名和詳細信息。

![xorglog](fig/xorglog.png)

#### 查看應用日誌

1. 在日誌收集工具界面，單擊 **應用日誌**。
2. 查看應用日誌的級別、時間、來源和信息。
3. 選中某條日誌後，可查看該日誌的詳細信息，包括來源、時間 、主機名、級別和詳細信息。

![applog](fig/applog.png)

#### 查看開關機事件

1. 在日誌收集工具界面，單擊 **開關機事件**。
2. 查看開關機事件的事件類型、用戶名、時間和信息。
3. 選中某條日誌後，可查看該日誌的詳細信息，包括時間、主機名、事件類型、用戶名和詳細信息。

![power_event](fig/power_event.png)

#### 查看其它日誌

1. 在日誌收集工具界面，單擊 **其它日誌**。
2. 其它日誌以文件列表方式展示日誌文件的文件名稱、修改日期。同類日誌文件以文件夾方式展示。
3. 選中某個文件後，可查看該文件的詳細內容。拖拽文件列表和詳細內容分界線，可以同步調整兩區域大小。

![otherslog](fig/otherslog.png)



### 自定義日誌

自定義日誌功能是將日誌文件添加至日誌收集工具進行查看、導出。自定義日誌兼容Gsettings配置和Dconfig配置。

**Gsettings配置**

1. 在終端執行Gsettings配置設置命令，“[]”中填寫日誌文件路徑，比如：['a.log','b.log','c.log']。

```shell
gsettings set com.deepin.log.viewer customlogfiles []
```

2. 在日誌收集工具界面，單擊**自定義日誌**，即可發現已有配置。

**Dconfig配置**

1. 在終端執行Dconfig配置設置命令，"[]"中填寫日誌文件路徑，比如：["a.log","b.log","c.log"]

```shell
dde-dconfig --set -a org.deepin.log.viewer -r org.deepin.log.viewer -k customLogFiles -v '["a.log","b.log","c.log"]'
```

2. 在日誌收集工具界面，單擊**自定義日誌**，即可發現已有配置。

### 導出日誌

導出日誌功能是將日誌查詢結果導出到本地，幫助您分析、定位和解決問題。


1. 選擇某一日誌類型，單擊界面右上角 **導出** 按鈕。
2. 如果彈出密碼認證窗口，輸入用戶登錄密碼後單擊 **確定**。
3. 在彈出的窗口中，選擇存儲位置，單擊 **保存**。

>![icon](../common/notes.svg) 說明：您也可以單擊標題欄上的全部導出按鈕 ![icon](../common/export.svg)，將系統日誌、內核日誌、啟動日誌、dpkg日誌、Xorg日誌、應用日誌和開關機事件的日誌全部導出。

### 刷新日誌

刷新日誌分為手動刷新和自動刷新，如果是自動刷新日誌，還可以設置自動刷新的頻率。

#### 手動刷新日誌

單擊標題欄上的立即刷新按鈕 ![icon](../common/refresh.svg)；或右鍵單擊某一日誌類型，選擇 **刷新**，刷新日誌。

#### 自動刷新日誌

1. 在日誌收集工具界面，單擊 ![icon_menu](../common/icon_menu.svg) > **刷新頻率**。
2. 選擇自動刷新的頻率：**每10秒**、**每1分鐘** 或 **每5分鐘**， 刷新日誌。

   如果選擇 **不刷新**，表示停止自動刷新日誌。

### 在文件管理器中顯示

在日誌收集工具中僅內核日誌、啟動日誌、dpkg日誌、Xorg日誌和應用日誌支持 **在文件管理器中顯示** 的功能。

1. 在日誌收集工具左側導航欄中，右鍵單擊某一日誌類型。
2. 選擇 **在文件管理器中顯示**，定位到當前日誌的存儲位置。


![right](fig/rightclick.png)


### 清除日誌

在日誌收集工具中僅內核日誌、啟動日誌、dpkg日誌、Xorg日誌和應用日誌支持 **清除日誌** 的功能。
1. 在日誌收集工具左側導航欄中，右鍵單擊某一日誌類型。
2. 選擇 **清除日誌**。
3. 彈出“確定清除日誌”提示框，單擊 **確定**。
4. 如果彈出密碼認證窗口，輸入用戶登錄密碼後單擊 **確定**。


## 主菜單

在主菜單中，您可以 [設置刷新頻率](#自動刷新日誌)、切換窗口主題，查看幫助手冊等。

### 主題

窗口主題包含淺色主題、深色主題和系統主題。

1. 在日誌收集工具界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **主題**，選擇一個主題顏色。


### 幫助

查看幫助手冊，進一步瞭解和使用日誌收集工具。

1. 在日誌收集工具界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **幫助**。
3. 查看日誌收集工具的幫助手冊。


### 關於

1. 在日誌收集工具界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **關於**。
3. 查看日誌收集工具的版本和介紹。

### 退出

1. 在日誌收集工具界面，單擊 ![icon_menu](../common/icon_menu.svg)。
2. 選擇 **退出**。

