/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;

public class CaseFirstCollator
implements StringCollator {
    private final StringCollator baseCollator;
    private final boolean upperFirst;
    private final String uri;

    public CaseFirstCollator(StringCollator base, boolean upperFirst, String collationURI) {
        this.baseCollator = base;
        this.upperFirst = upperFirst;
        this.uri = collationURI;
    }

    public static StringCollator makeCaseOrderedCollator(String uri, StringCollator stringCollator, String caseOrder) throws XPathException {
        switch (caseOrder) {
            case "lower-first": {
                stringCollator = new CaseFirstCollator(stringCollator, false, uri);
                break;
            }
            case "upper-first": {
                stringCollator = new CaseFirstCollator(stringCollator, true, uri);
                break;
            }
            default: {
                throw new XPathException("case-order must be lower-first, upper-first, or #default");
            }
        }
        return stringCollator;
    }

    @Override
    public String getCollationURI() {
        return this.uri;
    }

    @Override
    public int compareStrings(UnicodeString a, UnicodeString b) {
        a = a.tidy();
        b = b.tidy();
        Categories.Category letters = Categories.getCategory("L");
        Categories.Category upperCase = Categories.getCategory("Lu");
        Categories.Category lowerCase = Categories.getCategory("Ll");
        int diff = this.baseCollator.compareStrings(a, b);
        if (diff != 0) {
            return diff;
        }
        long i = 0L;
        long j = 0L;
        while (true) {
            boolean bFirst;
            if (i < a.length() && j < b.length() && a.codePointAt(i) == b.codePointAt(j)) {
                ++i;
                ++j;
                continue;
            }
            while (i < a.length() && !letters.test(a.codePointAt(i))) {
                ++i;
            }
            while (j < b.length() && !letters.test(b.codePointAt(j))) {
                ++j;
            }
            if (i >= a.length()) {
                return 0;
            }
            if (j >= b.length()) {
                return 0;
            }
            boolean aFirst = this.upperFirst ? upperCase.test(a.codePointAt(i++)) : lowerCase.test(a.codePointAt(i++));
            boolean bl = bFirst = this.upperFirst ? upperCase.test(b.codePointAt(j++)) : lowerCase.test(b.codePointAt(j++));
            if (aFirst && !bFirst) {
                return -1;
            }
            if (bFirst && !aFirst) break;
        }
        return 1;
    }

    @Override
    public boolean comparesEqual(UnicodeString s1, UnicodeString s2) {
        return this.compareStrings(s1, s2) == 0;
    }

    @Override
    public AtomicMatchKey getCollationKey(UnicodeString s2) {
        return this.baseCollator.getCollationKey(s2);
    }
}

