// GENERATED FILE - DO NOT EDIT.
// Generated by generate_tests.py
//
// Copyright (c) 2022 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "../diff_test_utils.h"

#include "gtest/gtest.h"

namespace spvtools {
namespace diff {
namespace {

// Test where src and dst have a few large functions with large differences.
constexpr char kSrc[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpName %4 "main"
               OpName %6 "f1("
               OpName %8 "f2("
               OpName %12 "x"
               OpName %15 "gl_LocalInvocationID"
               OpName %20 "y"
               OpName %27 "image"
               OpName %44 "sum"
               OpName %46 "i"
               OpName %56 "j"
               OpName %80 "BufferOut"
               OpMemberName %80 0 "o_uv4"
               OpMemberName %80 1 "o_v3"
               OpMemberName %80 2 "o_i"
               OpName %82 ""
               OpName %88 "BufferIn"
               OpMemberName %88 0 "i_u"
               OpMemberName %88 1 "i_v4"
               OpMemberName %88 2 "i_f"
               OpName %90 ""
               OpName %101 "i"
               OpName %128 "image2"
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
               OpDecorate %128 DescriptorSet 0
               OpDecorate %128 Binding 3
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %128 = OpVariable %26 UniformConstant
        %130 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %136 = OpFunctionCall %2 %6
        %137 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIMul %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %129 = OpLoad %25 %128
        %131 = OpImageRead %38 %129 %130
        %132 = OpCompositeExtract %24 %131 0
        %133 = OpConvertSToF %78 %132
        %134 = OpCompositeConstruct %79 %133 %133 %133
        %135 = OpAccessChain %110 %82 %73
               OpStore %135 %134
               OpReturn
               OpFunctionEnd
)";
constexpr char kDst[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15 %110
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpName %4 "main"
               OpName %6 "f1("
               OpName %8 "f2("
               OpName %12 "x"
               OpName %15 "gl_GlobalInvocationID"
               OpName %20 "z"
               OpName %26 "i"
               OpName %40 "BufferOut"
               OpMemberName %40 0 "o_uv4"
               OpMemberName %40 1 "o_v3"
               OpMemberName %40 2 "o_i"
               OpName %42 ""
               OpName %63 "image2"
               OpName %79 "image"
               OpName %89 "i"
               OpName %110 "gl_LocalInvocationID"
               OpName %127 "BufferIn"
               OpMemberName %127 0 "i_u"
               OpMemberName %127 1 "i_v4"
               OpMemberName %127 2 "i_f"
               OpName %129 ""
               OpDecorate %15 BuiltIn GlobalInvocationId
               OpMemberDecorate %40 0 Offset 0
               OpMemberDecorate %40 1 Offset 16
               OpMemberDecorate %40 2 Offset 28
               OpDecorate %40 BufferBlock
               OpDecorate %42 DescriptorSet 0
               OpDecorate %42 Binding 1
               OpDecorate %63 DescriptorSet 0
               OpDecorate %63 Binding 3
               OpDecorate %79 DescriptorSet 0
               OpDecorate %79 Binding 2
               OpDecorate %110 BuiltIn LocalInvocationId
               OpMemberDecorate %127 0 Offset 0
               OpMemberDecorate %127 1 RowMajor
               OpMemberDecorate %127 1 Offset 16
               OpMemberDecorate %127 1 MatrixStride 16
               OpMemberDecorate %127 2 Offset 80
               OpDecorate %127 Block
               OpDecorate %129 DescriptorSet 0
               OpDecorate %129 Binding 0
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypePointer Function %24
         %27 = OpConstant %24 0
         %34 = OpConstant %24 2
         %35 = OpTypeBool
         %37 = OpTypeVector %10 4
         %38 = OpTypeFloat 32
         %39 = OpTypeVector %38 3
         %40 = OpTypeStruct %37 %39 %24
         %41 = OpTypePointer Uniform %40
         %42 = OpVariable %41 Uniform
         %46 = OpTypeVector %10 2
         %48 = OpTypePointer Uniform %37
         %53 = OpTypePointer Uniform %10
         %59 = OpConstant %24 1
         %61 = OpTypeImage %24 2D 0 0 0 2 R32i
         %62 = OpTypePointer UniformConstant %61
         %63 = OpVariable %62 UniformConstant
         %69 = OpTypeVector %24 2
         %71 = OpTypeVector %24 4
         %74 = OpTypePointer Uniform %24
         %76 = OpConstant %10 2
         %77 = OpConstant %10 3400
         %78 = OpConstant %10 264
         %79 = OpVariable %62 UniformConstant
         %96 = OpConstant %24 3
        %103 = OpConstantComposite %69 %27 %27
        %107 = OpTypePointer Uniform %38
        %110 = OpVariable %14 Input
        %113 = OpTypeVector %38 2
        %125 = OpTypeVector %38 4
        %126 = OpTypeMatrix %125 4
        %127 = OpTypeStruct %10 %126 %38
        %128 = OpTypePointer Uniform %127
        %129 = OpVariable %128 Uniform
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %123 = OpFunctionCall %2 %8
        %124 = OpFunctionCall %2 %6
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %26 = OpVariable %25 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
               OpStore %26 %27
               OpBranch %28
         %28 = OpLabel
               OpLoopMerge %30 %31 None
               OpBranch %32
         %32 = OpLabel
         %33 = OpLoad %24 %26
         %36 = OpSLessThan %35 %33 %34
               OpBranchConditional %36 %29 %30
         %29 = OpLabel
         %43 = OpLoad %10 %12
         %44 = OpLoad %10 %20
         %45 = OpIAdd %10 %43 %44
         %47 = OpCompositeConstruct %46 %45 %45
         %49 = OpAccessChain %48 %42 %27
         %50 = OpLoad %37 %49
         %51 = OpVectorShuffle %46 %50 %50 0 1
         %52 = OpIAdd %46 %51 %47
         %54 = OpAccessChain %53 %42 %27 %16
         %55 = OpCompositeExtract %10 %52 0
               OpStore %54 %55
         %56 = OpAccessChain %53 %42 %27 %21
         %57 = OpCompositeExtract %10 %52 1
               OpStore %56 %57
               OpBranch %31
         %31 = OpLabel
         %58 = OpLoad %24 %26
         %60 = OpIAdd %24 %58 %59
               OpStore %26 %60
               OpBranch %28
         %30 = OpLabel
         %64 = OpLoad %61 %63
         %65 = OpLoad %10 %12
         %66 = OpBitcast %24 %65
         %67 = OpLoad %10 %20
         %68 = OpBitcast %24 %67
         %70 = OpCompositeConstruct %69 %66 %68
         %72 = OpImageRead %71 %64 %70
         %73 = OpCompositeExtract %24 %72 1
         %75 = OpAccessChain %74 %42 %34
               OpStore %75 %73
               OpMemoryBarrier %76 %77
               OpControlBarrier %76 %76 %78
         %80 = OpLoad %61 %79
         %81 = OpLoad %10 %20
         %82 = OpBitcast %24 %81
         %83 = OpLoad %10 %12
         %84 = OpBitcast %24 %83
         %85 = OpCompositeConstruct %69 %82 %84
         %86 = OpAccessChain %74 %42 %34
         %87 = OpLoad %24 %86
         %88 = OpCompositeConstruct %71 %87 %27 %27 %27
               OpImageWrite %80 %85 %88
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
         %89 = OpVariable %25 Function
               OpStore %89 %27
               OpBranch %90
         %90 = OpLabel
               OpLoopMerge %92 %93 None
               OpBranch %94
         %94 = OpLabel
         %95 = OpLoad %24 %89
         %97 = OpSLessThan %35 %95 %96
               OpBranchConditional %97 %91 %92
         %91 = OpLabel
         %98 = OpLoad %24 %89
         %99 = OpIEqual %35 %98 %27
               OpSelectionMerge %101 None
               OpBranchConditional %99 %100 %109
        %100 = OpLabel
        %102 = OpLoad %61 %63
        %104 = OpImageRead %71 %102 %103
        %105 = OpCompositeExtract %24 %104 0
        %106 = OpConvertSToF %38 %105
        %108 = OpAccessChain %107 %42 %59 %16
               OpStore %108 %106
               OpBranch %101
        %109 = OpLabel
        %111 = OpLoad %13 %110
        %112 = OpConvertUToF %39 %111
        %114 = OpCompositeExtract %38 %112 0
        %115 = OpCompositeExtract %38 %112 1
        %116 = OpCompositeConstruct %113 %114 %115
        %117 = OpAccessChain %107 %42 %59 %21
        %118 = OpCompositeExtract %38 %116 0
               OpStore %117 %118
        %119 = OpAccessChain %107 %42 %59 %76
        %120 = OpCompositeExtract %38 %116 1
               OpStore %119 %120
               OpBranch %101
        %101 = OpLabel
               OpBranch %93
         %93 = OpLabel
        %121 = OpLoad %24 %89
        %122 = OpIAdd %24 %121 %59
               OpStore %89 %122
               OpBranch %90
         %92 = OpLabel
               OpReturn
               OpFunctionEnd

)";

TEST(DiffTest, LargeFunctionsLargeDiffs) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 138
+; Bound: 190
 ; Schema: 0
 OpCapability Shader
 %1 = OpExtInstImport "GLSL.std.450"
 OpMemoryModel Logical GLSL450
-OpEntryPoint GLCompute %4 "main" %15
+OpEntryPoint GLCompute %4 "main" %138 %15
 OpExecutionMode %4 LocalSize 1 1 1
 OpSource ESSL 310
 OpName %4 "main"
 OpName %6 "f1("
 OpName %8 "f2("
 OpName %12 "x"
+OpName %138 "gl_GlobalInvocationID"
 OpName %15 "gl_LocalInvocationID"
-OpName %20 "y"
+OpName %20 "z"
 OpName %27 "image"
-OpName %44 "sum"
+OpName %44 "i"
-OpName %46 "i"
-OpName %56 "j"
 OpName %80 "BufferOut"
 OpMemberName %80 0 "o_uv4"
 OpMemberName %80 1 "o_v3"
 OpMemberName %80 2 "o_i"
 OpName %82 ""
 OpName %88 "BufferIn"
 OpMemberName %88 0 "i_u"
 OpMemberName %88 1 "i_v4"
 OpMemberName %88 2 "i_f"
 OpName %90 ""
 OpName %101 "i"
 OpName %128 "image2"
+OpDecorate %138 BuiltIn GlobalInvocationId
 OpDecorate %15 BuiltIn LocalInvocationId
 OpDecorate %27 DescriptorSet 0
 OpDecorate %27 Binding 2
 OpMemberDecorate %80 0 Offset 0
 OpMemberDecorate %80 1 Offset 16
 OpMemberDecorate %80 2 Offset 28
 OpDecorate %80 BufferBlock
 OpDecorate %82 DescriptorSet 0
 OpDecorate %82 Binding 1
 OpMemberDecorate %88 0 Offset 0
 OpMemberDecorate %88 1 RowMajor
 OpMemberDecorate %88 1 Offset 16
 OpMemberDecorate %88 1 MatrixStride 16
 OpMemberDecorate %88 2 Offset 80
 OpDecorate %88 Block
 OpDecorate %90 DescriptorSet 0
 OpDecorate %90 Binding 0
 OpDecorate %128 DescriptorSet 0
 OpDecorate %128 Binding 3
 %2 = OpTypeVoid
 %3 = OpTypeFunction %2
 %10 = OpTypeInt 32 0
 %11 = OpTypePointer Function %10
 %13 = OpTypeVector %10 3
 %14 = OpTypePointer Input %13
+%138 = OpVariable %14 Input
 %15 = OpVariable %14 Input
 %16 = OpConstant %10 0
 %17 = OpTypePointer Input %10
 %21 = OpConstant %10 1
 %24 = OpTypeInt 32 1
 %25 = OpTypeImage %24 2D 0 0 0 2 R32i
 %26 = OpTypePointer UniformConstant %25
 %27 = OpVariable %26 UniformConstant
 %29 = OpTypeVector %10 2
 %32 = OpTypeVector %24 2
 %38 = OpTypeVector %24 4
 %40 = OpConstant %10 2
 %41 = OpConstant %10 3400
 %42 = OpConstant %10 264
 %43 = OpTypePointer Function %24
 %45 = OpConstant %24 0
+%149 = OpTypePointer Uniform %10
 %53 = OpConstant %24 2
 %54 = OpTypeBool
 %73 = OpConstant %24 1
 %77 = OpTypeVector %10 4
 %78 = OpTypeFloat 32
 %79 = OpTypeVector %78 3
 %80 = OpTypeStruct %77 %79 %24
 %81 = OpTypePointer Uniform %80
 %82 = OpVariable %81 Uniform
 %84 = OpTypePointer Uniform %24
 %86 = OpTypeVector %78 4
 %87 = OpTypeMatrix %86 4
 %88 = OpTypeStruct %10 %87 %78
 %89 = OpTypePointer Uniform %88
 %90 = OpVariable %89 Uniform
-%91 = OpTypePointer Uniform %87
+%179 = OpTypeVector %78 2
 %94 = OpTypePointer Uniform %77
 %108 = OpConstant %24 3
-%110 = OpTypePointer Uniform %79
 %113 = OpTypePointer Uniform %78
 %128 = OpVariable %26 UniformConstant
 %130 = OpConstantComposite %32 %45 %45
 %4 = OpFunction %2 None %3
 %5 = OpLabel
-%136 = OpFunctionCall %2 %6
 %137 = OpFunctionCall %2 %8
+%189 = OpFunctionCall %2 %6
 OpReturn
 OpFunctionEnd
 %6 = OpFunction %2 None %3
 %7 = OpLabel
 %12 = OpVariable %11 Function
 %20 = OpVariable %11 Function
 %44 = OpVariable %43 Function
-%46 = OpVariable %43 Function
-%56 = OpVariable %43 Function
-%18 = OpAccessChain %17 %15 %16
+%139 = OpAccessChain %17 %138 %16
-%19 = OpLoad %10 %18
+%19 = OpLoad %10 %139
 OpStore %12 %19
-%22 = OpAccessChain %17 %15 %21
+%140 = OpAccessChain %17 %138 %21
-%23 = OpLoad %10 %22
+%23 = OpLoad %10 %140
 OpStore %20 %23
-%28 = OpLoad %25 %27
-%30 = OpLoad %13 %15
-%31 = OpVectorShuffle %29 %30 %30 0 1
-%33 = OpBitcast %32 %31
-%34 = OpLoad %10 %12
-%35 = OpLoad %10 %20
-%36 = OpIAdd %10 %34 %35
-%37 = OpBitcast %24 %36
-%39 = OpCompositeConstruct %38 %37 %37 %37 %37
-OpImageWrite %28 %33 %39
-OpMemoryBarrier %40 %41
-OpControlBarrier %40 %40 %42
 OpStore %44 %45
-OpStore %46 %45
 OpBranch %47
 %47 = OpLabel
-OpLoopMerge %49 %50 None
+OpLoopMerge %49 %59 None
 OpBranch %51
 %51 = OpLabel
-%52 = OpLoad %24 %46
+%52 = OpLoad %24 %44
 %55 = OpSLessThan %54 %52 %53
 OpBranchConditional %55 %48 %49
 %48 = OpLabel
-OpStore %56 %45
-OpBranch %57
-%57 = OpLabel
-OpLoopMerge %59 %60 None
-OpBranch %61
-%61 = OpLabel
-%62 = OpLoad %24 %56
-%63 = OpSLessThan %54 %62 %53
-OpBranchConditional %63 %58 %59
-%58 = OpLabel
-%64 = OpLoad %25 %27
-%65 = OpLoad %24 %46
-%66 = OpLoad %24 %56
-%67 = OpCompositeConstruct %32 %65 %66
-%68 = OpImageRead %38 %64 %67
-%69 = OpCompositeExtract %24 %68 0
-%70 = OpLoad %24 %44
-%71 = OpIMul %24 %70 %69
+%141 = OpLoad %10 %12
+%142 = OpLoad %10 %20
+%143 = OpIAdd %10 %141 %142
+%144 = OpCompositeConstruct %29 %143 %143
+%145 = OpAccessChain %94 %82 %45
+%146 = OpLoad %77 %145
+%147 = OpVectorShuffle %29 %146 %146 0 1
+%148 = OpIAdd %29 %147 %144
+%150 = OpAccessChain %149 %82 %45 %16
+%151 = OpCompositeExtract %10 %148 0
-OpStore %44 %71
+OpStore %150 %151
-OpBranch %60
-%60 = OpLabel
-%72 = OpLoad %24 %56
-%74 = OpIAdd %24 %72 %73
+%152 = OpAccessChain %149 %82 %45 %21
+%153 = OpCompositeExtract %10 %148 1
-OpStore %56 %74
+OpStore %152 %153
-OpBranch %57
+OpBranch %59
 %59 = OpLabel
-OpBranch %50
-%50 = OpLabel
-%75 = OpLoad %24 %46
+%75 = OpLoad %24 %44
 %76 = OpIAdd %24 %75 %73
-OpStore %46 %76
+OpStore %44 %76
 OpBranch %47
 %49 = OpLabel
+%154 = OpLoad %25 %128
+%155 = OpLoad %10 %12
+%156 = OpBitcast %24 %155
+%157 = OpLoad %10 %20
+%158 = OpBitcast %24 %157
+%159 = OpCompositeConstruct %32 %156 %158
+%160 = OpImageRead %38 %154 %159
+%161 = OpCompositeExtract %24 %160 1
+%162 = OpAccessChain %84 %82 %53
+OpStore %162 %161
 OpMemoryBarrier %40 %41
 OpControlBarrier %40 %40 %42
-%83 = OpLoad %24 %44
+%163 = OpLoad %25 %27
+%164 = OpLoad %10 %20
+%165 = OpBitcast %24 %164
+%166 = OpLoad %10 %12
+%167 = OpBitcast %24 %166
+%168 = OpCompositeConstruct %32 %165 %167
 %85 = OpAccessChain %84 %82 %53
-OpStore %85 %83
+%169 = OpLoad %24 %85
+%170 = OpCompositeConstruct %38 %169 %45 %45 %45
+OpImageWrite %163 %168 %170
 OpReturn
 OpFunctionEnd
 %8 = OpFunction %2 None %3
 %9 = OpLabel
 %101 = OpVariable %43 Function
-%92 = OpAccessChain %91 %90 %73
-%93 = OpLoad %87 %92
-%95 = OpAccessChain %94 %82 %45
-%96 = OpLoad %77 %95
-%97 = OpConvertUToF %86 %96
-%98 = OpMatrixTimesVector %86 %93 %97
-%99 = OpConvertFToU %77 %98
-%100 = OpAccessChain %94 %82 %45
-OpStore %100 %99
+OpStore %101 %45
-OpStore %101 %45
 OpBranch %102
 %102 = OpLabel
-OpLoopMerge %104 %105 None
+OpLoopMerge %171 %172 None
 OpBranch %106
 %106 = OpLabel
 %107 = OpLoad %24 %101
 %109 = OpSLessThan %54 %107 %108
-OpBranchConditional %109 %103 %104
+OpBranchConditional %109 %103 %171
 %103 = OpLabel
-%111 = OpAccessChain %110 %82 %73
-%112 = OpLoad %79 %111
-%114 = OpAccessChain %113 %90 %53
-%115 = OpLoad %78 %114
-%116 = OpVectorTimesScalar %79 %112 %115
-%117 = OpConvertFToU %13 %116
-%118 = OpCompositeExtract %10 %117 0
-%119 = OpCompositeExtract %10 %117 1
-%120 = OpCompositeExtract %10 %117 2
-%121 = OpCompositeConstruct %77 %118 %119 %120 %16
-%122 = OpAccessChain %94 %82 %45
-%123 = OpLoad %77 %122
-%124 = OpIAdd %77 %123 %121
-%125 = OpAccessChain %94 %82 %45
-OpStore %125 %124
-OpBranch %105
-%105 = OpLabel
 %126 = OpLoad %24 %101
-%127 = OpIAdd %24 %126 %73
+%173 = OpIEqual %54 %126 %45
+OpSelectionMerge %174 None
+OpBranchConditional %173 %104 %176
+%176 = OpLabel
+%177 = OpLoad %13 %15
+%178 = OpConvertUToF %79 %177
+%180 = OpCompositeExtract %78 %178 0
+%181 = OpCompositeExtract %78 %178 1
+%182 = OpCompositeConstruct %179 %180 %181
+%183 = OpAccessChain %113 %82 %73 %21
+%184 = OpCompositeExtract %78 %182 0
-OpStore %101 %127
+OpStore %183 %184
+%185 = OpAccessChain %113 %82 %73 %40
+%186 = OpCompositeExtract %78 %182 1
+OpStore %185 %186
-OpBranch %102
+OpBranch %174
 %104 = OpLabel
-OpMemoryBarrier %40 %41
-OpControlBarrier %40 %40 %42
 %129 = OpLoad %25 %128
 %131 = OpImageRead %38 %129 %130
 %132 = OpCompositeExtract %24 %131 0
 %133 = OpConvertSToF %78 %132
-%134 = OpCompositeConstruct %79 %133 %133 %133
-%135 = OpAccessChain %110 %82 %73
+%175 = OpAccessChain %113 %82 %73 %16
-OpStore %135 %134
+OpStore %175 %133
+OpBranch %174
+%174 = OpLabel
+OpBranch %172
+%172 = OpLabel
+%187 = OpLoad %24 %101
+%188 = OpIAdd %24 %187 %73
+OpStore %101 %188
+OpBranch %102
+%171 = OpLabel
 OpReturn
 OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, LargeFunctionsLargeDiffsNoDebug) {
  constexpr char kSrcNoDebug[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpDecorate %15 BuiltIn LocalInvocationId
               OpDecorate %27 DescriptorSet 0
               OpDecorate %27 Binding 2
               OpMemberDecorate %80 0 Offset 0
               OpMemberDecorate %80 1 Offset 16
               OpMemberDecorate %80 2 Offset 28
               OpDecorate %80 BufferBlock
               OpDecorate %82 DescriptorSet 0
               OpDecorate %82 Binding 1
               OpMemberDecorate %88 0 Offset 0
               OpMemberDecorate %88 1 RowMajor
               OpMemberDecorate %88 1 Offset 16
               OpMemberDecorate %88 1 MatrixStride 16
               OpMemberDecorate %88 2 Offset 80
               OpDecorate %88 Block
               OpDecorate %90 DescriptorSet 0
               OpDecorate %90 Binding 0
               OpDecorate %128 DescriptorSet 0
               OpDecorate %128 Binding 3
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypeImage %24 2D 0 0 0 2 R32i
         %26 = OpTypePointer UniformConstant %25
         %27 = OpVariable %26 UniformConstant
         %29 = OpTypeVector %10 2
         %32 = OpTypeVector %24 2
         %38 = OpTypeVector %24 4
         %40 = OpConstant %10 2
         %41 = OpConstant %10 3400
         %42 = OpConstant %10 264
         %43 = OpTypePointer Function %24
         %45 = OpConstant %24 0
         %53 = OpConstant %24 2
         %54 = OpTypeBool
         %73 = OpConstant %24 1
         %77 = OpTypeVector %10 4
         %78 = OpTypeFloat 32
         %79 = OpTypeVector %78 3
         %80 = OpTypeStruct %77 %79 %24
         %81 = OpTypePointer Uniform %80
         %82 = OpVariable %81 Uniform
         %84 = OpTypePointer Uniform %24
         %86 = OpTypeVector %78 4
         %87 = OpTypeMatrix %86 4
         %88 = OpTypeStruct %10 %87 %78
         %89 = OpTypePointer Uniform %88
         %90 = OpVariable %89 Uniform
         %91 = OpTypePointer Uniform %87
         %94 = OpTypePointer Uniform %77
        %108 = OpConstant %24 3
        %110 = OpTypePointer Uniform %79
        %113 = OpTypePointer Uniform %78
        %128 = OpVariable %26 UniformConstant
        %130 = OpConstantComposite %32 %45 %45
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %136 = OpFunctionCall %2 %6
        %137 = OpFunctionCall %2 %8
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %44 = OpVariable %43 Function
         %46 = OpVariable %43 Function
         %56 = OpVariable %43 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
         %28 = OpLoad %25 %27
         %30 = OpLoad %13 %15
         %31 = OpVectorShuffle %29 %30 %30 0 1
         %33 = OpBitcast %32 %31
         %34 = OpLoad %10 %12
         %35 = OpLoad %10 %20
         %36 = OpIAdd %10 %34 %35
         %37 = OpBitcast %24 %36
         %39 = OpCompositeConstruct %38 %37 %37 %37 %37
               OpImageWrite %28 %33 %39
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
               OpStore %44 %45
               OpStore %46 %45
               OpBranch %47
         %47 = OpLabel
               OpLoopMerge %49 %50 None
               OpBranch %51
         %51 = OpLabel
         %52 = OpLoad %24 %46
         %55 = OpSLessThan %54 %52 %53
               OpBranchConditional %55 %48 %49
         %48 = OpLabel
               OpStore %56 %45
               OpBranch %57
         %57 = OpLabel
               OpLoopMerge %59 %60 None
               OpBranch %61
         %61 = OpLabel
         %62 = OpLoad %24 %56
         %63 = OpSLessThan %54 %62 %53
               OpBranchConditional %63 %58 %59
         %58 = OpLabel
         %64 = OpLoad %25 %27
         %65 = OpLoad %24 %46
         %66 = OpLoad %24 %56
         %67 = OpCompositeConstruct %32 %65 %66
         %68 = OpImageRead %38 %64 %67
         %69 = OpCompositeExtract %24 %68 0
         %70 = OpLoad %24 %44
         %71 = OpIMul %24 %70 %69
               OpStore %44 %71
               OpBranch %60
         %60 = OpLabel
         %72 = OpLoad %24 %56
         %74 = OpIAdd %24 %72 %73
               OpStore %56 %74
               OpBranch %57
         %59 = OpLabel
               OpBranch %50
         %50 = OpLabel
         %75 = OpLoad %24 %46
         %76 = OpIAdd %24 %75 %73
               OpStore %46 %76
               OpBranch %47
         %49 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
         %83 = OpLoad %24 %44
         %85 = OpAccessChain %84 %82 %53
               OpStore %85 %83
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
        %101 = OpVariable %43 Function
         %92 = OpAccessChain %91 %90 %73
         %93 = OpLoad %87 %92
         %95 = OpAccessChain %94 %82 %45
         %96 = OpLoad %77 %95
         %97 = OpConvertUToF %86 %96
         %98 = OpMatrixTimesVector %86 %93 %97
         %99 = OpConvertFToU %77 %98
        %100 = OpAccessChain %94 %82 %45
               OpStore %100 %99
               OpStore %101 %45
               OpBranch %102
        %102 = OpLabel
               OpLoopMerge %104 %105 None
               OpBranch %106
        %106 = OpLabel
        %107 = OpLoad %24 %101
        %109 = OpSLessThan %54 %107 %108
               OpBranchConditional %109 %103 %104
        %103 = OpLabel
        %111 = OpAccessChain %110 %82 %73
        %112 = OpLoad %79 %111
        %114 = OpAccessChain %113 %90 %53
        %115 = OpLoad %78 %114
        %116 = OpVectorTimesScalar %79 %112 %115
        %117 = OpConvertFToU %13 %116
        %118 = OpCompositeExtract %10 %117 0
        %119 = OpCompositeExtract %10 %117 1
        %120 = OpCompositeExtract %10 %117 2
        %121 = OpCompositeConstruct %77 %118 %119 %120 %16
        %122 = OpAccessChain %94 %82 %45
        %123 = OpLoad %77 %122
        %124 = OpIAdd %77 %123 %121
        %125 = OpAccessChain %94 %82 %45
               OpStore %125 %124
               OpBranch %105
        %105 = OpLabel
        %126 = OpLoad %24 %101
        %127 = OpIAdd %24 %126 %73
               OpStore %101 %127
               OpBranch %102
        %104 = OpLabel
               OpMemoryBarrier %40 %41
               OpControlBarrier %40 %40 %42
        %129 = OpLoad %25 %128
        %131 = OpImageRead %38 %129 %130
        %132 = OpCompositeExtract %24 %131 0
        %133 = OpConvertSToF %78 %132
        %134 = OpCompositeConstruct %79 %133 %133 %133
        %135 = OpAccessChain %110 %82 %73
               OpStore %135 %134
               OpReturn
               OpFunctionEnd

)";
  constexpr char kDstNoDebug[] = R"(               OpCapability Shader
          %1 = OpExtInstImport "GLSL.std.450"
               OpMemoryModel Logical GLSL450
               OpEntryPoint GLCompute %4 "main" %15 %110
               OpExecutionMode %4 LocalSize 1 1 1
               OpSource ESSL 310
               OpDecorate %15 BuiltIn GlobalInvocationId
               OpMemberDecorate %40 0 Offset 0
               OpMemberDecorate %40 1 Offset 16
               OpMemberDecorate %40 2 Offset 28
               OpDecorate %40 BufferBlock
               OpDecorate %42 DescriptorSet 0
               OpDecorate %42 Binding 1
               OpDecorate %63 DescriptorSet 0
               OpDecorate %63 Binding 3
               OpDecorate %79 DescriptorSet 0
               OpDecorate %79 Binding 2
               OpDecorate %110 BuiltIn LocalInvocationId
               OpMemberDecorate %127 0 Offset 0
               OpMemberDecorate %127 1 RowMajor
               OpMemberDecorate %127 1 Offset 16
               OpMemberDecorate %127 1 MatrixStride 16
               OpMemberDecorate %127 2 Offset 80
               OpDecorate %127 Block
               OpDecorate %129 DescriptorSet 0
               OpDecorate %129 Binding 0
          %2 = OpTypeVoid
          %3 = OpTypeFunction %2
         %10 = OpTypeInt 32 0
         %11 = OpTypePointer Function %10
         %13 = OpTypeVector %10 3
         %14 = OpTypePointer Input %13
         %15 = OpVariable %14 Input
         %16 = OpConstant %10 0
         %17 = OpTypePointer Input %10
         %21 = OpConstant %10 1
         %24 = OpTypeInt 32 1
         %25 = OpTypePointer Function %24
         %27 = OpConstant %24 0
         %34 = OpConstant %24 2
         %35 = OpTypeBool
         %37 = OpTypeVector %10 4
         %38 = OpTypeFloat 32
         %39 = OpTypeVector %38 3
         %40 = OpTypeStruct %37 %39 %24
         %41 = OpTypePointer Uniform %40
         %42 = OpVariable %41 Uniform
         %46 = OpTypeVector %10 2
         %48 = OpTypePointer Uniform %37
         %53 = OpTypePointer Uniform %10
         %59 = OpConstant %24 1
         %61 = OpTypeImage %24 2D 0 0 0 2 R32i
         %62 = OpTypePointer UniformConstant %61
         %63 = OpVariable %62 UniformConstant
         %69 = OpTypeVector %24 2
         %71 = OpTypeVector %24 4
         %74 = OpTypePointer Uniform %24
         %76 = OpConstant %10 2
         %77 = OpConstant %10 3400
         %78 = OpConstant %10 264
         %79 = OpVariable %62 UniformConstant
         %96 = OpConstant %24 3
        %103 = OpConstantComposite %69 %27 %27
        %107 = OpTypePointer Uniform %38
        %110 = OpVariable %14 Input
        %113 = OpTypeVector %38 2
        %125 = OpTypeVector %38 4
        %126 = OpTypeMatrix %125 4
        %127 = OpTypeStruct %10 %126 %38
        %128 = OpTypePointer Uniform %127
        %129 = OpVariable %128 Uniform
          %4 = OpFunction %2 None %3
          %5 = OpLabel
        %123 = OpFunctionCall %2 %8
        %124 = OpFunctionCall %2 %6
               OpReturn
               OpFunctionEnd
          %6 = OpFunction %2 None %3
          %7 = OpLabel
         %12 = OpVariable %11 Function
         %20 = OpVariable %11 Function
         %26 = OpVariable %25 Function
         %18 = OpAccessChain %17 %15 %16
         %19 = OpLoad %10 %18
               OpStore %12 %19
         %22 = OpAccessChain %17 %15 %21
         %23 = OpLoad %10 %22
               OpStore %20 %23
               OpStore %26 %27
               OpBranch %28
         %28 = OpLabel
               OpLoopMerge %30 %31 None
               OpBranch %32
         %32 = OpLabel
         %33 = OpLoad %24 %26
         %36 = OpSLessThan %35 %33 %34
               OpBranchConditional %36 %29 %30
         %29 = OpLabel
         %43 = OpLoad %10 %12
         %44 = OpLoad %10 %20
         %45 = OpIAdd %10 %43 %44
         %47 = OpCompositeConstruct %46 %45 %45
         %49 = OpAccessChain %48 %42 %27
         %50 = OpLoad %37 %49
         %51 = OpVectorShuffle %46 %50 %50 0 1
         %52 = OpIAdd %46 %51 %47
         %54 = OpAccessChain %53 %42 %27 %16
         %55 = OpCompositeExtract %10 %52 0
               OpStore %54 %55
         %56 = OpAccessChain %53 %42 %27 %21
         %57 = OpCompositeExtract %10 %52 1
               OpStore %56 %57
               OpBranch %31
         %31 = OpLabel
         %58 = OpLoad %24 %26
         %60 = OpIAdd %24 %58 %59
               OpStore %26 %60
               OpBranch %28
         %30 = OpLabel
         %64 = OpLoad %61 %63
         %65 = OpLoad %10 %12
         %66 = OpBitcast %24 %65
         %67 = OpLoad %10 %20
         %68 = OpBitcast %24 %67
         %70 = OpCompositeConstruct %69 %66 %68
         %72 = OpImageRead %71 %64 %70
         %73 = OpCompositeExtract %24 %72 1
         %75 = OpAccessChain %74 %42 %34
               OpStore %75 %73
               OpMemoryBarrier %76 %77
               OpControlBarrier %76 %76 %78
         %80 = OpLoad %61 %79
         %81 = OpLoad %10 %20
         %82 = OpBitcast %24 %81
         %83 = OpLoad %10 %12
         %84 = OpBitcast %24 %83
         %85 = OpCompositeConstruct %69 %82 %84
         %86 = OpAccessChain %74 %42 %34
         %87 = OpLoad %24 %86
         %88 = OpCompositeConstruct %71 %87 %27 %27 %27
               OpImageWrite %80 %85 %88
               OpReturn
               OpFunctionEnd
          %8 = OpFunction %2 None %3
          %9 = OpLabel
         %89 = OpVariable %25 Function
               OpStore %89 %27
               OpBranch %90
         %90 = OpLabel
               OpLoopMerge %92 %93 None
               OpBranch %94
         %94 = OpLabel
         %95 = OpLoad %24 %89
         %97 = OpSLessThan %35 %95 %96
               OpBranchConditional %97 %91 %92
         %91 = OpLabel
         %98 = OpLoad %24 %89
         %99 = OpIEqual %35 %98 %27
               OpSelectionMerge %101 None
               OpBranchConditional %99 %100 %109
        %100 = OpLabel
        %102 = OpLoad %61 %63
        %104 = OpImageRead %71 %102 %103
        %105 = OpCompositeExtract %24 %104 0
        %106 = OpConvertSToF %38 %105
        %108 = OpAccessChain %107 %42 %59 %16
               OpStore %108 %106
               OpBranch %101
        %109 = OpLabel
        %111 = OpLoad %13 %110
        %112 = OpConvertUToF %39 %111
        %114 = OpCompositeExtract %38 %112 0
        %115 = OpCompositeExtract %38 %112 1
        %116 = OpCompositeConstruct %113 %114 %115
        %117 = OpAccessChain %107 %42 %59 %21
        %118 = OpCompositeExtract %38 %116 0
               OpStore %117 %118
        %119 = OpAccessChain %107 %42 %59 %76
        %120 = OpCompositeExtract %38 %116 1
               OpStore %119 %120
               OpBranch %101
        %101 = OpLabel
               OpBranch %93
         %93 = OpLabel
        %121 = OpLoad %24 %89
        %122 = OpIAdd %24 %121 %59
               OpStore %89 %122
               OpBranch %90
         %92 = OpLabel
               OpReturn
               OpFunctionEnd

)";
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
-; Bound: 138
+; Bound: 220
 ; Schema: 0
 OpCapability Shader
 %1 = OpExtInstImport "GLSL.std.450"
 OpMemoryModel Logical GLSL450
-OpEntryPoint GLCompute %4 "main" %15
+OpEntryPoint GLCompute %4 "main" %143 %15
 OpExecutionMode %4 LocalSize 1 1 1
 OpSource ESSL 310
+OpDecorate %143 BuiltIn GlobalInvocationId
 OpDecorate %15 BuiltIn LocalInvocationId
 OpDecorate %27 DescriptorSet 0
 OpDecorate %27 Binding 2
 OpMemberDecorate %80 0 Offset 0
 OpMemberDecorate %80 1 Offset 16
 OpMemberDecorate %80 2 Offset 28
 OpDecorate %80 BufferBlock
 OpDecorate %82 DescriptorSet 0
 OpDecorate %82 Binding 1
 OpMemberDecorate %88 0 Offset 0
 OpMemberDecorate %88 1 RowMajor
 OpMemberDecorate %88 1 Offset 16
 OpMemberDecorate %88 1 MatrixStride 16
 OpMemberDecorate %88 2 Offset 80
 OpDecorate %88 Block
 OpDecorate %90 DescriptorSet 0
 OpDecorate %90 Binding 0
 OpDecorate %128 DescriptorSet 0
 OpDecorate %128 Binding 3
 %2 = OpTypeVoid
 %3 = OpTypeFunction %2
 %10 = OpTypeInt 32 0
 %11 = OpTypePointer Function %10
 %13 = OpTypeVector %10 3
 %14 = OpTypePointer Input %13
+%143 = OpVariable %14 Input
 %15 = OpVariable %14 Input
 %16 = OpConstant %10 0
 %17 = OpTypePointer Input %10
 %21 = OpConstant %10 1
 %24 = OpTypeInt 32 1
 %25 = OpTypeImage %24 2D 0 0 0 2 R32i
 %26 = OpTypePointer UniformConstant %25
 %27 = OpVariable %26 UniformConstant
 %29 = OpTypeVector %10 2
 %32 = OpTypeVector %24 2
 %38 = OpTypeVector %24 4
 %40 = OpConstant %10 2
 %41 = OpConstant %10 3400
 %42 = OpConstant %10 264
 %43 = OpTypePointer Function %24
 %45 = OpConstant %24 0
+%165 = OpTypePointer Uniform %10
 %53 = OpConstant %24 2
 %54 = OpTypeBool
 %73 = OpConstant %24 1
 %77 = OpTypeVector %10 4
 %78 = OpTypeFloat 32
 %79 = OpTypeVector %78 3
 %80 = OpTypeStruct %77 %79 %24
 %81 = OpTypePointer Uniform %80
 %82 = OpVariable %81 Uniform
 %84 = OpTypePointer Uniform %24
 %86 = OpTypeVector %78 4
 %87 = OpTypeMatrix %86 4
 %88 = OpTypeStruct %10 %87 %78
 %89 = OpTypePointer Uniform %88
 %90 = OpVariable %89 Uniform
-%91 = OpTypePointer Uniform %87
+%210 = OpTypeVector %78 2
 %94 = OpTypePointer Uniform %77
 %108 = OpConstant %24 3
-%110 = OpTypePointer Uniform %79
 %113 = OpTypePointer Uniform %78
 %128 = OpVariable %26 UniformConstant
 %130 = OpConstantComposite %32 %45 %45
 %4 = OpFunction %2 None %3
 %5 = OpLabel
-%136 = OpFunctionCall %2 %6
+%136 = OpFunctionCall %2 %140
-%137 = OpFunctionCall %2 %8
+%137 = OpFunctionCall %2 %138
 OpReturn
 OpFunctionEnd
-%6 = OpFunction %2 None %3
-%7 = OpLabel
-%12 = OpVariable %11 Function
-%20 = OpVariable %11 Function
-%44 = OpVariable %43 Function
-%46 = OpVariable %43 Function
-%56 = OpVariable %43 Function
-%18 = OpAccessChain %17 %15 %16
-%19 = OpLoad %10 %18
-OpStore %12 %19
-%22 = OpAccessChain %17 %15 %21
-%23 = OpLoad %10 %22
-OpStore %20 %23
-%28 = OpLoad %25 %27
-%30 = OpLoad %13 %15
-%31 = OpVectorShuffle %29 %30 %30 0 1
-%33 = OpBitcast %32 %31
-%34 = OpLoad %10 %12
-%35 = OpLoad %10 %20
-%36 = OpIAdd %10 %34 %35
-%37 = OpBitcast %24 %36
-%39 = OpCompositeConstruct %38 %37 %37 %37 %37
-OpImageWrite %28 %33 %39
-OpMemoryBarrier %40 %41
-OpControlBarrier %40 %40 %42
-OpStore %44 %45
-OpStore %46 %45
-OpBranch %47
-%47 = OpLabel
-OpLoopMerge %49 %50 None
-OpBranch %51
-%51 = OpLabel
-%52 = OpLoad %24 %46
-%55 = OpSLessThan %54 %52 %53
-OpBranchConditional %55 %48 %49
-%48 = OpLabel
-OpStore %56 %45
-OpBranch %57
-%57 = OpLabel
-OpLoopMerge %59 %60 None
-OpBranch %61
-%61 = OpLabel
-%62 = OpLoad %24 %56
-%63 = OpSLessThan %54 %62 %53
-OpBranchConditional %63 %58 %59
-%58 = OpLabel
-%64 = OpLoad %25 %27
-%65 = OpLoad %24 %46
-%66 = OpLoad %24 %56
-%67 = OpCompositeConstruct %32 %65 %66
-%68 = OpImageRead %38 %64 %67
-%69 = OpCompositeExtract %24 %68 0
-%70 = OpLoad %24 %44
-%71 = OpIMul %24 %70 %69
-OpStore %44 %71
-OpBranch %60
-%60 = OpLabel
-%72 = OpLoad %24 %56
-%74 = OpIAdd %24 %72 %73
-OpStore %56 %74
-OpBranch %57
-%59 = OpLabel
-OpBranch %50
-%50 = OpLabel
-%75 = OpLoad %24 %46
-%76 = OpIAdd %24 %75 %73
-OpStore %46 %76
-OpBranch %47
-%49 = OpLabel
-OpMemoryBarrier %40 %41
-OpControlBarrier %40 %40 %42
-%83 = OpLoad %24 %44
-%85 = OpAccessChain %84 %82 %53
-OpStore %85 %83
-OpReturn
-OpFunctionEnd
-%8 = OpFunction %2 None %3
-%9 = OpLabel
-%101 = OpVariable %43 Function
-%92 = OpAccessChain %91 %90 %73
-%93 = OpLoad %87 %92
-%95 = OpAccessChain %94 %82 %45
-%96 = OpLoad %77 %95
-%97 = OpConvertUToF %86 %96
-%98 = OpMatrixTimesVector %86 %93 %97
-%99 = OpConvertFToU %77 %98
-%100 = OpAccessChain %94 %82 %45
-OpStore %100 %99
-OpStore %101 %45
-OpBranch %102
-%102 = OpLabel
-OpLoopMerge %104 %105 None
-OpBranch %106
-%106 = OpLabel
-%107 = OpLoad %24 %101
-%109 = OpSLessThan %54 %107 %108
-OpBranchConditional %109 %103 %104
-%103 = OpLabel
-%111 = OpAccessChain %110 %82 %73
-%112 = OpLoad %79 %111
-%114 = OpAccessChain %113 %90 %53
-%115 = OpLoad %78 %114
-%116 = OpVectorTimesScalar %79 %112 %115
-%117 = OpConvertFToU %13 %116
-%118 = OpCompositeExtract %10 %117 0
-%119 = OpCompositeExtract %10 %117 1
-%120 = OpCompositeExtract %10 %117 2
-%121 = OpCompositeConstruct %77 %118 %119 %120 %16
-%122 = OpAccessChain %94 %82 %45
-%123 = OpLoad %77 %122
-%124 = OpIAdd %77 %123 %121
-%125 = OpAccessChain %94 %82 %45
-OpStore %125 %124
-OpBranch %105
-%105 = OpLabel
-%126 = OpLoad %24 %101
-%127 = OpIAdd %24 %126 %73
-OpStore %101 %127
-OpBranch %102
-%104 = OpLabel
-OpMemoryBarrier %40 %41
-OpControlBarrier %40 %40 %42
-%129 = OpLoad %25 %128
-%131 = OpImageRead %38 %129 %130
-%132 = OpCompositeExtract %24 %131 0
-%133 = OpConvertSToF %78 %132
-%134 = OpCompositeConstruct %79 %133 %133 %133
-%135 = OpAccessChain %110 %82 %73
-OpStore %135 %134
-OpReturn
-OpFunctionEnd
+%138 = OpFunction %2 None %3
+%139 = OpLabel
+%142 = OpVariable %11 Function
+%146 = OpVariable %11 Function
+%149 = OpVariable %43 Function
+%144 = OpAccessChain %17 %143 %16
+%145 = OpLoad %10 %144
+OpStore %142 %145
+%147 = OpAccessChain %17 %143 %21
+%148 = OpLoad %10 %147
+OpStore %146 %148
+OpStore %149 %45
+OpBranch %150
+%150 = OpLabel
+OpLoopMerge %152 %153 None
+OpBranch %154
+%154 = OpLabel
+%155 = OpLoad %24 %149
+%156 = OpSLessThan %54 %155 %53
+OpBranchConditional %156 %151 %152
+%151 = OpLabel
+%157 = OpLoad %10 %142
+%158 = OpLoad %10 %146
+%159 = OpIAdd %10 %157 %158
+%160 = OpCompositeConstruct %29 %159 %159
+%161 = OpAccessChain %94 %82 %45
+%162 = OpLoad %77 %161
+%163 = OpVectorShuffle %29 %162 %162 0 1
+%164 = OpIAdd %29 %163 %160
+%166 = OpAccessChain %165 %82 %45 %16
+%167 = OpCompositeExtract %10 %164 0
+OpStore %166 %167
+%168 = OpAccessChain %165 %82 %45 %21
+%169 = OpCompositeExtract %10 %164 1
+OpStore %168 %169
+OpBranch %153
+%153 = OpLabel
+%170 = OpLoad %24 %149
+%171 = OpIAdd %24 %170 %73
+OpStore %149 %171
+OpBranch %150
+%152 = OpLabel
+%172 = OpLoad %25 %128
+%173 = OpLoad %10 %142
+%174 = OpBitcast %24 %173
+%175 = OpLoad %10 %146
+%176 = OpBitcast %24 %175
+%177 = OpCompositeConstruct %32 %174 %176
+%178 = OpImageRead %38 %172 %177
+%179 = OpCompositeExtract %24 %178 1
+%180 = OpAccessChain %84 %82 %53
+OpStore %180 %179
+OpMemoryBarrier %40 %41
+OpControlBarrier %40 %40 %42
+%181 = OpLoad %25 %27
+%182 = OpLoad %10 %146
+%183 = OpBitcast %24 %182
+%184 = OpLoad %10 %142
+%185 = OpBitcast %24 %184
+%186 = OpCompositeConstruct %32 %183 %185
+%187 = OpAccessChain %84 %82 %53
+%188 = OpLoad %24 %187
+%189 = OpCompositeConstruct %38 %188 %45 %45 %45
+OpImageWrite %181 %186 %189
+OpReturn
+OpFunctionEnd
+%140 = OpFunction %2 None %3
+%141 = OpLabel
+%190 = OpVariable %43 Function
+OpStore %190 %45
+OpBranch %191
+%191 = OpLabel
+OpLoopMerge %193 %194 None
+OpBranch %195
+%195 = OpLabel
+%196 = OpLoad %24 %190
+%197 = OpSLessThan %54 %196 %108
+OpBranchConditional %197 %192 %193
+%192 = OpLabel
+%198 = OpLoad %24 %190
+%199 = OpIEqual %54 %198 %45
+OpSelectionMerge %201 None
+OpBranchConditional %199 %200 %207
+%207 = OpLabel
+%208 = OpLoad %13 %15
+%209 = OpConvertUToF %79 %208
+%211 = OpCompositeExtract %78 %209 0
+%212 = OpCompositeExtract %78 %209 1
+%213 = OpCompositeConstruct %210 %211 %212
+%214 = OpAccessChain %113 %82 %73 %21
+%215 = OpCompositeExtract %78 %213 0
+OpStore %214 %215
+%216 = OpAccessChain %113 %82 %73 %40
+%217 = OpCompositeExtract %78 %213 1
+OpStore %216 %217
+OpBranch %201
+%200 = OpLabel
+%202 = OpLoad %25 %128
+%203 = OpImageRead %38 %202 %130
+%204 = OpCompositeExtract %24 %203 0
+%205 = OpConvertSToF %78 %204
+%206 = OpAccessChain %113 %82 %73 %16
+OpStore %206 %205
+OpBranch %201
+%201 = OpLabel
+OpBranch %194
+%194 = OpLabel
+%218 = OpLoad %24 %190
+%219 = OpIAdd %24 %218 %73
+OpStore %190 %219
+OpBranch %191
+%193 = OpLabel
+OpReturn
+OpFunctionEnd
)";
  Options options;
  DoStringDiffTest(kSrcNoDebug, kDstNoDebug, kDiff, options);
}

}  // namespace
}  // namespace diff
}  // namespace spvtools
