/*
 * intrinsic.c
 *
 * Description of this file:
 *    tables used in SIMD assembly functions of the xavs2 library
 *
 * --------------------------------------------------------------------------
 *
 *    xavs2 - video encoder of AVS2/IEEE1857.4 video coding standard
 *    Copyright (C) 2018~ VCL, NELVT, Peking University
 *
 *    Authors: Falei LUO <falei.luo@gmail.com>
 *             Jiaqi ZHANG <zhangjiaqi.cs@gmail.com>
 *             etc.
 *
 *    Homepage1: http://vcl.idm.pku.edu.cn/xavs2
 *    Homepage2: https://github.com/pkuvcl/xavs2
 *    Homepage3: https://gitee.com/pkuvcl/xavs2
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02111, USA.
 *
 *    This program is also available under a commercial proprietary license.
 *    For more information, contact us at sswang @ pku.edu.cn.
 */

#include "../basic_types.h"
#include "intrinsic.h"

#include <mmintrin.h>
#include <emmintrin.h>
#include <tmmintrin.h>
#include <smmintrin.h>

ALIGN32(const int8_t intrinsic_mask[15][16]) = {
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0 }
};


ALIGN32(const int8_t intrinsic_mask_256_8bit[16][32]) = {
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 }

};


ALIGN32(const int8_t intrinsic_mask32[32][32]) = {
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },
    { -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0 },
    { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0 }
};

ALIGN32(const int8_t tab_log2[65]) = {
    -1,
    0, 1, -1, 2, -1, -1, -1, 3,
    -1, -1, -1, -1, -1, -1, -1, 4,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 5,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 6
};

const uint8_t tab_idx_mode_7[64] = {
    0, 1, 2, 2, 3, 4, 5, 5, 6, 7, 7, 8, 9, 10, 10, 11, 12, 13, 13, 14, 15, 15, 16,
    17, 18, 18, 19, 20, 21, 21, 22, 23, 23, 24, 25, 26, 26, 27, 28, 29, 29, 30, 31, 31,
    32, 33, 34, 34, 35, 36, 37, 37, 38, 39, 39, 40, 41, 42, 42, 43, 44, 45, 45, 46
};

ALIGN16(const pel_t tab_coeff_mode_7[64][16]) = {
    { 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23 },//0
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 3, 35, 61, 29, 3, 35, 61, 29, 3, 35, 61, 29, 3, 35, 61, 29 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },//8
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },//16
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },//24
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },//32
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },//40
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 25, 57, 39, 7, 25, 57, 39, 7, 25, 57, 39, 7, 25, 57, 39, 7 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13 },
    { 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },//48
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10 },
    { 31, 63, 33, 1, 31, 63, 33, 1, 31, 63, 33, 1, 31, 63, 33, 1 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 25, 57, 39, 7, 25, 57, 39, 7, 25, 57, 39, 7, 25, 57, 39, 7 },
    { 2, 34, 62, 30, 2, 34, 62, 30, 2, 34, 62, 30, 2, 34, 62, 30 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13 },//56
    { 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4 },
    { 5, 37, 59, 27, 5, 37, 59, 27, 5, 37, 59, 27, 5, 37, 59, 27 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10 },
    { 31, 63, 33, 1, 31, 63, 33, 1, 31, 63, 33, 1, 31, 63, 33, 1 },
    { 8, 40, 56, 24, 8, 40, 56, 24, 8, 40, 56, 24, 8, 40, 56, 24 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 }//63
};

ALIGN32(const pel_t tab_coeff_mode_7_avx[64][32]) = {
    {  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23},//0
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14},
    { 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5},
    {  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29,  3, 35, 61, 29},
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20},
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11},
    { 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2},
    {  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26,  6, 38, 58, 26},
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17},//8
    { 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8},
    {  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31},
    {  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23,  9, 41, 55, 23},
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14},
    { 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5},
    {  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28},
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20},
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11},//16
    { 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2},
    {  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25},
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17},
    { 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8},
    {  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31},
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22},
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14},
    { 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5},//24
    {  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28},
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19},
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11},
    { 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2},
    {  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25},
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16},
    { 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8, 24, 56, 40,  8},
    {  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31},//32
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22},
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13},
    { 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5, 27, 59, 37,  5},
    {  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28},
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19},
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10},
    { 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2, 30, 62, 34,  2},
    {  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25},//40
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16},
    { 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7},
    {  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31,  1, 33, 63, 31},
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22},
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13},
    { 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4},
    {  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28,  4, 36, 60, 28},
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19},//48
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10},
    { 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1},
    {  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25,  7, 39, 57, 25},
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16},
    { 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7, 25, 57, 39,  7},
    {  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30,  2, 34, 62, 30},
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22},
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13},//56
    { 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4, 28, 60, 36,  4},
    {  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27,  5, 37, 59, 27},
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19},
    { 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10, 22, 54, 42, 10},
    { 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1, 31, 63, 33,  1},
    {  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24,  8, 40, 56, 24},
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16}//63
};

ALIGN16(const int8_t tab_coeff_mode_9[64][16]) = {
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },
    { 3, 35, 61, 29, 3, 35, 61, 29, 3, 35, 61, 29, 3, 35, 61, 29 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26, 6, 38, 58, 26 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23, 9, 41, 55, 23 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17, 15, 47, 49, 17 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14, 18, 50, 46, 14 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19, 13, 45, 51, 19 },
    { 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31, 1, 33, 63, 31 },
    { 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11, 21, 53, 43, 11 },
    { 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22, 10, 42, 54, 22 },
    { 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2, 30, 62, 34, 2 },
    { 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13, 19, 51, 45, 13 },
    { 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25, 7, 39, 57, 25 },
    { 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5, 27, 59, 37, 5 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 }
};
const uint8_t tab_idx_mode_9[64] = {
    0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 9, 9,
    9, 10, 10, 10, 11, 11, 11, 12, 12, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16,
    16, 17, 17, 17, 18, 18, 18, 19, 19, 19, 20, 20, 21, 21, 21, 22, 22, 22, 23
};

const ALIGN16(int8_t tab_coeff_mode_11[64][16]) = {
    { 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4, 28, 60, 36, 4 },
    { 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8, 24, 56, 40, 8 },
    { 20, 52, 44, 12, 20, 52, 44, 12, 20, 52, 44, 12, 20, 52, 44, 12 },
    { 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16, 16, 48, 48, 16 },
    { 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20, 12, 44, 52, 20 },
    { 8, 40, 56, 24, 8, 40, 56, 24, 8, 40, 56, 24, 8, 40, 56, 24 },
    { 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28, 4, 36, 60, 28 },
    { 32, 64, 32, 0, 32, 64, 32, 0, 32, 64, 32, 0, 32, 64, 32, 0 }
};
