/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#ifndef __checkbutton
#define __checkbutton

#include "button.h"

struct checkbutton;
struct state_listener {
  virtual void changed (checkbutton& cb) = 0;
};

class checkbutton : public button {

  int state; // 1 - on, 0 - off
  state_listener* lsnr;

  int color_blend_;

  public:

    static const color on_color, off_color;

    checkbutton (int left = 0, int bottom = 0, int st = 0, const std::string& label = "", int clr_blnd = 1);

    int is_on () const {return state;}
    void turn_on ();
    void turn_off ();
    void toggle ();
    void set_state (int s);
    int get_state () const {return state;}

    int handle_input ();
    void draw ();

    void set_listener (state_listener* sl) {lsnr = sl;}

    void blend_on_off_color (float blend);
    int color_blend () const {return color_blend_;}
    void color_blend (int yesorno) {color_blend_ = yesorno;}

};

#endif
