# -*- coding:binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::Kerberos::TicketConverter do
  let(:sample_kirbi) do
    "\x76\x82\x04\xa3\x30\x82\x04\x9f\xa0\x03\x02\x01\x05\xa1\x03\x02" \
    "\x01\x16\xa2\x82\x03\xa4\x30\x82\x03\xa0\x61\x82\x03\x9c\x30\x82" \
    "\x03\x98\xa0\x03\x02\x01\x05\xa1\x0a\x1b\x08\x44\x57\x2e\x4c\x4f" \
    "\x43\x41\x4c\xa2\x28\x30\x26\xa0\x03\x02\x01\x01\xa1\x1f\x30\x1d" \
    "\x1b\x08\x4d\x53\x53\x71\x6c\x53\x76\x63\x1b\x11\x64\x63\x31\x2e" \
    "\x64\x77\x2e\x6c\x6f\x63\x61\x6c\x3a\x31\x34\x33\x33\xa3\x82\x03" \
    "\x59\x30\x82\x03\x55\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02\xa2" \
    "\x82\x03\x47\x04\x82\x03\x43\x7e\xd2\xbf\xc0\xa5\x14\x86\x74\x5a" \
    "\xa1\xbc\xcb\xd3\xe1\x71\xc3\x1d\x38\x83\x58\x49\x85\x8a\x3f\xb4" \
    "\xfe\x0b\x6f\x81\x75\x46\x91\x66\xb3\xac\x48\x84\xe3\xe4\x8c\xc4" \
    "\x82\x5c\x00\x8c\x05\x46\xe7\xf2\x08\xd1\xfb\x70\xcc\x0a\x92\xf0" \
    "\x60\x1c\xcc\x45\x00\x1f\x0e\xa2\x66\xcb\x31\xc7\x03\x31\x15\xa0" \
    "\x6f\xdc\xf2\x80\x44\xe8\xbc\x68\x3b\xef\x16\xc8\x87\x75\x8a\x2c" \
    "\xe6\xe2\x97\x19\x0b\x48\xab\x3f\xde\xbb\xab\x85\xd3\x3c\x7c\x63" \
    "\x96\x67\xbb\x9e\xa9\x96\xca\x4c\x1f\x1f\x99\x03\xe7\x6a\x88\xaa" \
    "\x9a\x53\x93\x47\xfa\xfb\x99\xa8\x87\xdd\x90\x65\xd8\x0c\x0d\xff" \
    "\x23\x17\x1d\xf5\x9a\x44\x2e\x2d\x77\x9d\xb4\x9e\x2b\x3d\xfc\x13" \
    "\x5f\x43\x15\xc6\xe4\x3c\x23\x32\x7c\x0d\x18\x3b\x2e\x78\x3b\x69" \
    "\x23\x0e\x3c\xc2\xbe\x2b\x65\x10\xc4\x70\x38\x81\x02\xa5\x50\xf2" \
    "\xa2\x05\xe2\xa3\xe0\x29\xf8\x01\x96\xda\x15\xe7\xb5\x4e\x3f\x87" \
    "\xc3\x94\x8d\x49\x19\x46\xfa\xdb\x26\xbe\xad\x2e\xf1\x98\xad\xb0" \
    "\xb2\x6b\x83\x3f\xce\x4f\x4d\x02\xd2\xf2\xac\x33\xd7\x82\x22\x51" \
    "\xb3\x99\x02\x20\xc6\xe8\x81\x34\x7d\xc8\xac\xe9\x15\xa6\xb1\xb4" \
    "\x4e\x22\x86\x00\xcc\xde\x8e\x41\x8c\x0e\xe2\xae\xab\xe2\x09\x2b" \
    "\x8b\x9e\xa1\xbc\x08\xdb\x58\x72\x53\x1c\x7c\x10\x53\xaf\x40\xd6" \
    "\xc7\x59\x80\x5b\x58\x81\x42\xec\x4b\x21\x43\x73\x0f\x65\xaf\x59" \
    "\xee\x7c\x5b\xfe\x70\x4f\xa8\xd7\x0e\x17\x9c\xa4\x5a\x5d\xbc\xf7" \
    "\x97\x02\x84\x85\x16\x4a\x4d\x32\xaf\xd4\xf1\x3f\xcc\x81\xf0\xd4" \
    "\x6c\xda\x31\xf2\x19\xee\x7b\xe6\x59\xcf\x36\x57\x73\x2d\xb1\xf0" \
    "\x01\x6f\x97\xb3\xac\xe3\xd2\x06\x16\x80\xc1\x46\x92\x09\x74\x35" \
    "\xaa\x25\x52\xba\x0e\xfe\xc4\xa0\xa7\x7f\x8d\x46\x6e\xc6\xbc\x18" \
    "\x6f\x14\xd0\x84\x04\x7b\x43\xfe\x7e\x47\x51\x16\xd6\xd5\x8e\x3d" \
    "\x2d\x7e\x20\xe7\x53\x08\x78\xde\x81\x27\x99\x4a\xcf\xb3\xb6\xbb" \
    "\xa0\x7b\xe6\x29\x44\x0f\xd3\xcf\x35\xe6\xa2\x52\x80\x53\x64\x94" \
    "\xc5\xd6\xaf\x33\xcc\xb7\x87\x42\x8c\xec\xda\xcf\xd3\xd1\xbc\xb6" \
    "\xb6\xfa\x70\xc4\xff\x82\x25\x5c\x84\x97\x68\xf8\xa5\xbf\x37\xa6" \
    "\x86\x96\x95\x78\x2f\xc3\xa8\xe9\xd0\x5c\x9a\x3e\x36\x84\x98\x53" \
    "\xea\xa4\xea\x56\x14\x9b\x55\xd5\x2c\x00\xe1\x97\x00\x40\x6d\x85" \
    "\xb2\x92\xe2\xd0\x94\x1a\x4e\x7f\xd4\x9b\x2a\x21\xaa\x91\x80\x74" \
    "\x76\xe7\x92\x42\x78\xad\x82\xc8\xe2\xc0\x68\xb2\x03\xdc\xd9\xc7" \
    "\xdc\x35\x21\x23\x45\x85\xce\xe0\xd3\x37\x5a\x3a\x28\x18\x09\xf3" \
    "\xfb\xc8\x24\xf5\x90\x17\x18\xf7\xe3\x20\xab\x77\x6d\x8f\xea\x65" \
    "\x07\x13\x89\xed\xd2\xbc\xfa\x58\x13\x33\x44\x71\xdf\xe6\xce\xb4" \
    "\x23\x59\x15\x1a\xb0\x88\xad\x15\x7c\x26\xb0\xe1\xd8\x3a\x97\xac" \
    "\x8d\xe8\x92\x73\xcc\xff\xae\x6d\x7f\x17\xfa\x3b\xbf\xc5\xfd\xd3" \
    "\x55\xc4\x2b\x79\xef\x2a\x79\x44\xb6\x27\x34\x34\xca\x24\x92\x63" \
    "\x75\x4b\x05\x42\xd8\x71\xaf\x5c\x5e\x50\xf0\x28\x74\xde\x84\xf9" \
    "\x7b\x19\x8f\x1f\x77\x88\x06\xac\xf3\xce\x60\x83\x92\x03\x41\x4b" \
    "\x28\xc3\x3c\x04\x92\x66\x76\x95\xc4\xa4\x23\x2e\xa8\xc3\xd8\xe7" \
    "\x4f\x81\x25\x83\xbe\x22\x01\x67\x89\x44\x79\xa9\x7b\x4f\xea\x3a" \
    "\x3e\x52\x8a\x9b\x8e\x39\xec\xa3\xac\x71\xe3\xf1\xfb\x03\x09\x45" \
    "\x96\x7d\x69\xe7\xca\x6a\xa8\x6c\x52\x6b\x74\x6b\x53\xa1\xb6\x03" \
    "\x59\x3a\x01\x52\x70\x14\x79\x4a\x46\xb7\x00\x88\xf5\x3f\x4b\xc6" \
    "\x2d\xee\x59\xfd\x22\xb3\x74\xbe\xc0\xe6\xbd\xd0\x8a\x17\xf6\xd9" \
    "\xcb\xf7\x71\x41\x29\xd4\x23\x14\x02\x2e\xd6\x28\xf4\xbb\x49\xf3" \
    "\x42\xaf\x50\x2d\x7a\xb8\xe0\x52\xd3\x77\x67\x3e\x7f\x2c\x07\x75" \
    "\x4b\xa0\x79\x31\x5f\xd9\x6b\x42\x1b\x6d\x96\xc2\xe9\x0c\x1e\xa4" \
    "\x4b\x5d\xf5\x79\x7a\x17\x84\x0f\x67\xb7\xc2\xd0\x4e\xd0\x4e\x31" \
    "\x30\xe8\xa8\x3d\xe4\x05\x6f\x2d\xe9\xba\x17\x94\xa3\x0c\xf7\x0f" \
    "\x84\xcb\xcb\x2d\x9d\xf6\x15\xce\x81\xd1\xa3\x81\xea\x30\x81\xe7" \
    "\xa0\x03\x02\x01\x17\xa2\x81\xdf\x04\x81\xdc\x7d\x81\xd9\x30\x81" \
    "\xd6\xa0\x81\xd3\x30\x81\xd0\x30\x81\xcd\xa0\x1b\x30\x19\xa0\x03" \
    "\x02\x01\x17\xa1\x12\x04\x10\x6e\x57\x57\x69\x43\x61\x76\x62\x44" \
    "\x6e\x49\x55\x48\x64\x55\x74\xa1\x0a\x1b\x08\x44\x57\x2e\x4c\x4f" \
    "\x43\x41\x4c\xa2\x17\x30\x15\xa0\x03\x02\x01\x01\xa1\x0e\x30\x0c" \
    "\x1b\x0a\x66\x61\x6b\x65\x5f\x6d\x79\x73\x71\x6c\xa3\x07\x03\x05" \
    "\x00\x50\xa0\x00\x00\xa4\x11\x18\x0f\x32\x30\x32\x32\x30\x39\x31" \
    "\x31\x32\x30\x35\x38\x33\x39\x5a\xa5\x11\x18\x0f\x32\x30\x32\x32" \
    "\x30\x39\x31\x31\x32\x30\x35\x38\x33\x39\x5a\xa6\x11\x18\x0f\x32" \
    "\x30\x33\x32\x30\x39\x30\x38\x32\x30\x35\x38\x33\x39\x5a\xa7\x11" \
    "\x18\x0f\x32\x30\x33\x32\x30\x39\x30\x38\x32\x30\x35\x38\x33\x39" \
    "\x5a\xa8\x0a\x1b\x08\x44\x57\x2e\x4c\x4f\x43\x41\x4c\xa9\x28\x30" \
    "\x26\xa0\x03\x02\x01\x01\xa1\x1f\x30\x1d\x1b\x08\x4d\x53\x53\x71" \
    "\x6c\x53\x76\x63\x1b\x11\x64\x63\x31\x2e\x64\x77\x2e\x6c\x6f\x63" \
    "\x61\x6c\x3a\x31\x34\x33\x33"
  end

  let(:sample_ccache) do
    "\x05\x04\x00\x0c\x00\x01\x00\x08\xff\xff\xff\xff\x00\x00\x00\x00" \
    "\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x08\x44\x57\x2e\x4c" \
    "\x4f\x43\x41\x4c\x00\x00\x00\x0a\x66\x61\x6b\x65\x5f\x6d\x79\x73" \
    "\x71\x6c\x00\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x08\x44\x57" \
    "\x2e\x4c\x4f\x43\x41\x4c\x00\x00\x00\x0a\x66\x61\x6b\x65\x5f\x6d" \
    "\x79\x73\x71\x6c\x00\x00\x00\x01\x00\x00\x00\x02\x00\x00\x00\x08" \
    "\x44\x57\x2e\x4c\x4f\x43\x41\x4c\x00\x00\x00\x08\x4d\x53\x53\x71" \
    "\x6c\x53\x76\x63\x00\x00\x00\x11\x64\x63\x31\x2e\x64\x77\x2e\x6c" \
    "\x6f\x63\x61\x6c\x3a\x31\x34\x33\x33\x00\x17\x00\x00\x00\x10\x6e" \
    "\x57\x57\x69\x43\x61\x76\x62\x44\x6e\x49\x55\x48\x64\x55\x74\x63" \
    "\x1e\x4b\xff\x63\x1e\x4b\xff\x75\xea\x4e\xff\x75\xea\x4e\xff\x00" \
    "\x50\xa0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\xa0" \
    "\x61\x82\x03\x9c\x30\x82\x03\x98\xa0\x03\x02\x01\x05\xa1\x0a\x1b" \
    "\x08\x44\x57\x2e\x4c\x4f\x43\x41\x4c\xa2\x28\x30\x26\xa0\x03\x02" \
    "\x01\x01\xa1\x1f\x30\x1d\x1b\x08\x4d\x53\x53\x71\x6c\x53\x76\x63" \
    "\x1b\x11\x64\x63\x31\x2e\x64\x77\x2e\x6c\x6f\x63\x61\x6c\x3a\x31" \
    "\x34\x33\x33\xa3\x82\x03\x59\x30\x82\x03\x55\xa0\x03\x02\x01\x17" \
    "\xa1\x03\x02\x01\x02\xa2\x82\x03\x47\x04\x82\x03\x43\x7e\xd2\xbf" \
    "\xc0\xa5\x14\x86\x74\x5a\xa1\xbc\xcb\xd3\xe1\x71\xc3\x1d\x38\x83" \
    "\x58\x49\x85\x8a\x3f\xb4\xfe\x0b\x6f\x81\x75\x46\x91\x66\xb3\xac" \
    "\x48\x84\xe3\xe4\x8c\xc4\x82\x5c\x00\x8c\x05\x46\xe7\xf2\x08\xd1" \
    "\xfb\x70\xcc\x0a\x92\xf0\x60\x1c\xcc\x45\x00\x1f\x0e\xa2\x66\xcb" \
    "\x31\xc7\x03\x31\x15\xa0\x6f\xdc\xf2\x80\x44\xe8\xbc\x68\x3b\xef" \
    "\x16\xc8\x87\x75\x8a\x2c\xe6\xe2\x97\x19\x0b\x48\xab\x3f\xde\xbb" \
    "\xab\x85\xd3\x3c\x7c\x63\x96\x67\xbb\x9e\xa9\x96\xca\x4c\x1f\x1f" \
    "\x99\x03\xe7\x6a\x88\xaa\x9a\x53\x93\x47\xfa\xfb\x99\xa8\x87\xdd" \
    "\x90\x65\xd8\x0c\x0d\xff\x23\x17\x1d\xf5\x9a\x44\x2e\x2d\x77\x9d" \
    "\xb4\x9e\x2b\x3d\xfc\x13\x5f\x43\x15\xc6\xe4\x3c\x23\x32\x7c\x0d" \
    "\x18\x3b\x2e\x78\x3b\x69\x23\x0e\x3c\xc2\xbe\x2b\x65\x10\xc4\x70" \
    "\x38\x81\x02\xa5\x50\xf2\xa2\x05\xe2\xa3\xe0\x29\xf8\x01\x96\xda" \
    "\x15\xe7\xb5\x4e\x3f\x87\xc3\x94\x8d\x49\x19\x46\xfa\xdb\x26\xbe" \
    "\xad\x2e\xf1\x98\xad\xb0\xb2\x6b\x83\x3f\xce\x4f\x4d\x02\xd2\xf2" \
    "\xac\x33\xd7\x82\x22\x51\xb3\x99\x02\x20\xc6\xe8\x81\x34\x7d\xc8" \
    "\xac\xe9\x15\xa6\xb1\xb4\x4e\x22\x86\x00\xcc\xde\x8e\x41\x8c\x0e" \
    "\xe2\xae\xab\xe2\x09\x2b\x8b\x9e\xa1\xbc\x08\xdb\x58\x72\x53\x1c" \
    "\x7c\x10\x53\xaf\x40\xd6\xc7\x59\x80\x5b\x58\x81\x42\xec\x4b\x21" \
    "\x43\x73\x0f\x65\xaf\x59\xee\x7c\x5b\xfe\x70\x4f\xa8\xd7\x0e\x17" \
    "\x9c\xa4\x5a\x5d\xbc\xf7\x97\x02\x84\x85\x16\x4a\x4d\x32\xaf\xd4" \
    "\xf1\x3f\xcc\x81\xf0\xd4\x6c\xda\x31\xf2\x19\xee\x7b\xe6\x59\xcf" \
    "\x36\x57\x73\x2d\xb1\xf0\x01\x6f\x97\xb3\xac\xe3\xd2\x06\x16\x80" \
    "\xc1\x46\x92\x09\x74\x35\xaa\x25\x52\xba\x0e\xfe\xc4\xa0\xa7\x7f" \
    "\x8d\x46\x6e\xc6\xbc\x18\x6f\x14\xd0\x84\x04\x7b\x43\xfe\x7e\x47" \
    "\x51\x16\xd6\xd5\x8e\x3d\x2d\x7e\x20\xe7\x53\x08\x78\xde\x81\x27" \
    "\x99\x4a\xcf\xb3\xb6\xbb\xa0\x7b\xe6\x29\x44\x0f\xd3\xcf\x35\xe6" \
    "\xa2\x52\x80\x53\x64\x94\xc5\xd6\xaf\x33\xcc\xb7\x87\x42\x8c\xec" \
    "\xda\xcf\xd3\xd1\xbc\xb6\xb6\xfa\x70\xc4\xff\x82\x25\x5c\x84\x97" \
    "\x68\xf8\xa5\xbf\x37\xa6\x86\x96\x95\x78\x2f\xc3\xa8\xe9\xd0\x5c" \
    "\x9a\x3e\x36\x84\x98\x53\xea\xa4\xea\x56\x14\x9b\x55\xd5\x2c\x00" \
    "\xe1\x97\x00\x40\x6d\x85\xb2\x92\xe2\xd0\x94\x1a\x4e\x7f\xd4\x9b" \
    "\x2a\x21\xaa\x91\x80\x74\x76\xe7\x92\x42\x78\xad\x82\xc8\xe2\xc0" \
    "\x68\xb2\x03\xdc\xd9\xc7\xdc\x35\x21\x23\x45\x85\xce\xe0\xd3\x37" \
    "\x5a\x3a\x28\x18\x09\xf3\xfb\xc8\x24\xf5\x90\x17\x18\xf7\xe3\x20" \
    "\xab\x77\x6d\x8f\xea\x65\x07\x13\x89\xed\xd2\xbc\xfa\x58\x13\x33" \
    "\x44\x71\xdf\xe6\xce\xb4\x23\x59\x15\x1a\xb0\x88\xad\x15\x7c\x26" \
    "\xb0\xe1\xd8\x3a\x97\xac\x8d\xe8\x92\x73\xcc\xff\xae\x6d\x7f\x17" \
    "\xfa\x3b\xbf\xc5\xfd\xd3\x55\xc4\x2b\x79\xef\x2a\x79\x44\xb6\x27" \
    "\x34\x34\xca\x24\x92\x63\x75\x4b\x05\x42\xd8\x71\xaf\x5c\x5e\x50" \
    "\xf0\x28\x74\xde\x84\xf9\x7b\x19\x8f\x1f\x77\x88\x06\xac\xf3\xce" \
    "\x60\x83\x92\x03\x41\x4b\x28\xc3\x3c\x04\x92\x66\x76\x95\xc4\xa4" \
    "\x23\x2e\xa8\xc3\xd8\xe7\x4f\x81\x25\x83\xbe\x22\x01\x67\x89\x44" \
    "\x79\xa9\x7b\x4f\xea\x3a\x3e\x52\x8a\x9b\x8e\x39\xec\xa3\xac\x71" \
    "\xe3\xf1\xfb\x03\x09\x45\x96\x7d\x69\xe7\xca\x6a\xa8\x6c\x52\x6b" \
    "\x74\x6b\x53\xa1\xb6\x03\x59\x3a\x01\x52\x70\x14\x79\x4a\x46\xb7" \
    "\x00\x88\xf5\x3f\x4b\xc6\x2d\xee\x59\xfd\x22\xb3\x74\xbe\xc0\xe6" \
    "\xbd\xd0\x8a\x17\xf6\xd9\xcb\xf7\x71\x41\x29\xd4\x23\x14\x02\x2e" \
    "\xd6\x28\xf4\xbb\x49\xf3\x42\xaf\x50\x2d\x7a\xb8\xe0\x52\xd3\x77" \
    "\x67\x3e\x7f\x2c\x07\x75\x4b\xa0\x79\x31\x5f\xd9\x6b\x42\x1b\x6d" \
    "\x96\xc2\xe9\x0c\x1e\xa4\x4b\x5d\xf5\x79\x7a\x17\x84\x0f\x67\xb7" \
    "\xc2\xd0\x4e\xd0\x4e\x31\x30\xe8\xa8\x3d\xe4\x05\x6f\x2d\xe9\xba" \
    "\x17\x94\xa3\x0c\xf7\x0f\x84\xcb\xcb\x2d\x9d\xf6\x15\xce\x81\xd1" \
    "\x00\x00\x00\x00"
  end

  let(:krb_cred) do
    Rex::Proto::Kerberos::Model::KrbCred.decode(sample_kirbi)
  end

  let(:ccache) do
    Rex::Proto::Kerberos::CredentialCache::Krb5Ccache.read(sample_ccache)
  end

  describe '#kirbi_to_ccache' do
    it { expect(subject.kirbi_to_ccache(krb_cred)).to be_a(Rex::Proto::Kerberos::CredentialCache::Krb5Ccache) }
    it { expect(subject.kirbi_to_ccache(krb_cred).magic).to eq(ccache.magic) }
    it { expect(subject.kirbi_to_ccache(krb_cred).version).to eq(ccache.version) }
    it { expect(subject.kirbi_to_ccache(krb_cred).default_principal).to eq(ccache.default_principal) }
    it { expect(subject.kirbi_to_ccache(krb_cred).credentials).to eq(ccache.credentials) }
  end

  describe '#ccache_to_kirbi' do
    it { expect(subject.ccache_to_kirbi(ccache)).to be_a(Rex::Proto::Kerberos::Model::KrbCred) }
    it { expect(subject.ccache_to_kirbi(ccache)).to eq(krb_cred) }
  end
end
