typedef enum
{
  CG_UNKNOWN_TYPE,
  CG_STRUCT,
  CG_ARRAY,

  CG_TYPE_START_ENUM = 1024,

#define CG_DATATYPE_MACRO(name, compiler_name, enum_name, ncols, nrows) \
  enum_name ,

/* This stuff comes straight from Cg/cg_datatypes.h */
/* I couldn't figure out how to get SWIG to include
 * the headerfile with %include, %import, #include, etc. 
 */
CG_DATATYPE_MACRO(Half,half,CG_HALF,0,0)
CG_DATATYPE_MACRO(Half2,half2,CG_HALF2,0,0)
CG_DATATYPE_MACRO(Half3,half3,CG_HALF3,0,0)
CG_DATATYPE_MACRO(Half4,half4,CG_HALF4,0,0)
CG_DATATYPE_MACRO(Half1x1,half1x1,CG_HALF1x1,1,1)
CG_DATATYPE_MACRO(Half1x2,half1x2,CG_HALF1x2,1,2)
CG_DATATYPE_MACRO(Half1x3,half1x3,CG_HALF1x3,1,3)
CG_DATATYPE_MACRO(Half1x4,half1x4,CG_HALF1x4,1,4)
CG_DATATYPE_MACRO(Half2x1,half2x1,CG_HALF2x1,2,1)
CG_DATATYPE_MACRO(Half2x2,half2x2,CG_HALF2x2,2,2)
CG_DATATYPE_MACRO(Half2x3,half2x3,CG_HALF2x3,2,3)
CG_DATATYPE_MACRO(Half2x4,half2x4,CG_HALF2x4,2,4)
CG_DATATYPE_MACRO(Half3x1,half3x1,CG_HALF3x1,3,1)
CG_DATATYPE_MACRO(Half3x2,half3x2,CG_HALF3x2,3,2)
CG_DATATYPE_MACRO(Half3x3,half3x3,CG_HALF3x3,3,3)
CG_DATATYPE_MACRO(Half3x4,half3x4,CG_HALF3x4,3,4)
CG_DATATYPE_MACRO(Half4x1,half4x1,CG_HALF4x1,4,1)
CG_DATATYPE_MACRO(Half4x2,half4x2,CG_HALF4x2,4,2)
CG_DATATYPE_MACRO(Half4x3,half4x3,CG_HALF4x3,4,3)
CG_DATATYPE_MACRO(Half4x4,half4x4,CG_HALF4x4,4,4)
CG_DATATYPE_MACRO(Float,float,CG_FLOAT,0,0)
CG_DATATYPE_MACRO(Float2,float2,CG_FLOAT2,0,0)
CG_DATATYPE_MACRO(Float3,float3,CG_FLOAT3,0,0)
CG_DATATYPE_MACRO(Float4,float4,CG_FLOAT4,0,0)
CG_DATATYPE_MACRO(Float1x1,float1x1,CG_FLOAT1x1,1,1)
CG_DATATYPE_MACRO(Float1x2,float1x2,CG_FLOAT1x2,1,2)
CG_DATATYPE_MACRO(Float1x3,float1x3,CG_FLOAT1x3,1,3)
CG_DATATYPE_MACRO(Float1x4,float1x4,CG_FLOAT1x4,1,4)
CG_DATATYPE_MACRO(Float2x1,float2x1,CG_FLOAT2x1,2,1)
CG_DATATYPE_MACRO(Float2x2,float2x2,CG_FLOAT2x2,2,2)
CG_DATATYPE_MACRO(Float2x3,float2x3,CG_FLOAT2x3,2,3)
CG_DATATYPE_MACRO(Float2x4,float2x4,CG_FLOAT2x4,2,4)
CG_DATATYPE_MACRO(Float3x1,float3x1,CG_FLOAT3x1,3,1)
CG_DATATYPE_MACRO(Float3x2,float3x2,CG_FLOAT3x2,3,2)
CG_DATATYPE_MACRO(Float3x3,float3x3,CG_FLOAT3x3,3,3)
CG_DATATYPE_MACRO(Float3x4,float3x4,CG_FLOAT3x4,3,4)
CG_DATATYPE_MACRO(Float4x1,float4x1,CG_FLOAT4x1,4,1)
CG_DATATYPE_MACRO(Float4x2,float4x2,CG_FLOAT4x2,4,2)
CG_DATATYPE_MACRO(Float4x3,float4x3,CG_FLOAT4x3,4,3)
CG_DATATYPE_MACRO(Float4x4,float4x4,CG_FLOAT4x4,4,4)
CG_DATATYPE_MACRO(Sampler1D,sampler1D,CG_SAMPLER1D,0,0)
CG_DATATYPE_MACRO(Sampler2D,sampler2D,CG_SAMPLER2D,0,0)
CG_DATATYPE_MACRO(Sampler3D,sampler3D,CG_SAMPLER3D,0,0)
CG_DATATYPE_MACRO(SamplerRECT,samplerRECT,CG_SAMPLERRECT,0,0)
CG_DATATYPE_MACRO(SamplerCUBE,samplerCUBE,CG_SAMPLERCUBE,0,0)
CG_DATATYPE_MACRO(Fixed,fixed,CG_FIXED,0,0)
CG_DATATYPE_MACRO(Fixed2,fixed2,CG_FIXED2,0,0)
CG_DATATYPE_MACRO(Fixed3,fixed3,CG_FIXED3,0,0)
CG_DATATYPE_MACRO(Fixed4,fixed4,CG_FIXED4,0,0)
CG_DATATYPE_MACRO(Fixed1x1,fixed1x1,CG_FIXED1x1,1,1)
CG_DATATYPE_MACRO(Fixed1x2,fixed1x2,CG_FIXED1x2,1,2)
CG_DATATYPE_MACRO(Fixed1x3,fixed1x3,CG_FIXED1x3,1,3)
CG_DATATYPE_MACRO(Fixed1x4,fixed1x4,CG_FIXED1x4,1,4)
CG_DATATYPE_MACRO(Fixed2x1,fixed2x1,CG_FIXED2x1,2,1)
CG_DATATYPE_MACRO(Fixed2x2,fixed2x2,CG_FIXED2x2,2,2)
CG_DATATYPE_MACRO(Fixed2x3,fixed2x3,CG_FIXED2x3,2,3)
CG_DATATYPE_MACRO(Fixed2x4,fixed2x4,CG_FIXED2x4,2,4)
CG_DATATYPE_MACRO(Fixed3x1,fixed3x1,CG_FIXED3x1,3,1)
CG_DATATYPE_MACRO(Fixed3x2,fixed3x2,CG_FIXED3x2,3,2)
CG_DATATYPE_MACRO(Fixed3x3,fixed3x3,CG_FIXED3x3,3,3)
CG_DATATYPE_MACRO(Fixed3x4,fixed3x4,CG_FIXED3x4,3,4)
CG_DATATYPE_MACRO(Fixed4x1,fixed4x1,CG_FIXED4x1,4,1)
CG_DATATYPE_MACRO(Fixed4x2,fixed4x2,CG_FIXED4x2,4,2)
CG_DATATYPE_MACRO(Fixed4x3,fixed4x3,CG_FIXED4x3,4,3)
CG_DATATYPE_MACRO(Fixed4x4,fixed4x4,CG_FIXED4x4,4,4)
CG_DATATYPE_MACRO(Half1,half1,CG_HALF1,0,0)
CG_DATATYPE_MACRO(Float1,float1,CG_FLOAT1,0,0)
CG_DATATYPE_MACRO(Fixed1,fixed1,CG_FIXED1,0,0)
CG_DATATYPE_MACRO(Bool,bool,CG_BOOL,0,0)
CG_DATATYPE_MACRO(Int,int,CG_INT,0,0)
CG_DATATYPE_MACRO(Int1,int1,CG_INT1,0,0)
CG_DATATYPE_MACRO(Int2,int2,CG_INT2,0,0)
CG_DATATYPE_MACRO(Int3,int3,CG_INT3,0,0)
CG_DATATYPE_MACRO(Int4,int4,CG_INT4,0,0)

#undef CG_DATATYPE_MACRO

} CGtype;

typedef enum
{
# define CG_BINDLOCATION_MACRO(name,enum_name,compiler_name,\
                               enum_int,addressable,param_type) \
  enum_name = enum_int,

/* For the same reason these are imported here, SWIG's
 * %include does not work as documented. */
CG_BINDLOCATION_MACRO(TexUnit0,CG_TEXUNIT0,"texunit 0",2048,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit1,CG_TEXUNIT1,"texunit 1",2049,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit2,CG_TEXUNIT2,"texunit 2",2050,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit3,CG_TEXUNIT3,"texunit 3",2051,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit4,CG_TEXUNIT4,"texunit 4",2052,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit5,CG_TEXUNIT5,"texunit 5",2053,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit6,CG_TEXUNIT6,"texunit 6",2054,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit7,CG_TEXUNIT7,"texunit 7",2055,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit8,CG_TEXUNIT8,"texunit 8",2056,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit9,CG_TEXUNIT9,"texunit 9",2057,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit10,CG_TEXUNIT10,"texunit 10",2058,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit11,CG_TEXUNIT11,"texunit 11",2059,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit12,CG_TEXUNIT12,"texunit 12",2060,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit13,CG_TEXUNIT13,"texunit 13",2061,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit14,CG_TEXUNIT14,"texunit 14",2062,0,cgTexObjParam)
CG_BINDLOCATION_MACRO(TexUnit15,CG_TEXUNIT15,"texunit 15",2063,0,cgTexObjParam)

CG_BINDLOCATION_MACRO(Attr0,CG_ATTR0,"ATTR0",2113,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr1,CG_ATTR1,"ATTR1",2114,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr2,CG_ATTR2,"ATTR2",2115,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr3,CG_ATTR3,"ATTR3",2116,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr4,CG_ATTR4,"ATTR4",2117,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr5,CG_ATTR5,"ATTR5",2118,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr6,CG_ATTR6,"ATTR6",2119,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr7,CG_ATTR7,"ATTR7",2120,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr8,CG_ATTR8,"ATTR8",2121,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr9,CG_ATTR9,"ATTR9",2122,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr10,CG_ATTR10,"ATTR10",2123,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr11,CG_ATTR11,"ATTR11",2124,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr12,CG_ATTR12,"ATTR12",2125,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr13,CG_ATTR13,"ATTR13",2126,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr14,CG_ATTR14,"ATTR14",2127,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Attr15,CG_ATTR15,"ATTR15",2128,0,cgConnectorMemberParam)

CG_BINDLOCATION_MACRO(VertUniform,CG_C,"c",2178,1,cgUniformParam)

CG_BINDLOCATION_MACRO(Tex0,CG_TEX0,"TEX0",2179,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex1,CG_TEX1,"TEX1",2180,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex2,CG_TEX2,"TEX2",2181,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex3,CG_TEX3,"TEX3",2192,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex4,CG_TEX4,"TEX4",2193,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex5,CG_TEX5,"TEX5",2194,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex6,CG_TEX6,"TEX6",2195,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tex7,CG_TEX7,"TEX7",2196,0,cgConnectorMemberParam)

CG_BINDLOCATION_MACRO(HPos,CG_HPOS,"HPOS",2243,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Col0,CG_COL0,"COL0",2245,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Col1,CG_COL1,"COL1",2246,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Col2,CG_COL2,"COL2",2247,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Col3,CG_COL3,"COL3",2248,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSiz,CG_PSIZ,"PSIZ",2309,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(WPos,CG_WPOS,"WPOS",2373,0,cgConnectorMemberParam)

CG_BINDLOCATION_MACRO(Position0,CG_POSITION0,"POSITION0",2437,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position1,CG_POSITION1,"POSITION1",2438,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position2,CG_POSITION2,"POSITION2",2439,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position3,CG_POSITION3,"POSITION3",2440,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position4,CG_POSITION4,"POSITION4",2441,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position5,CG_POSITION5,"POSITION5",2442,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position6,CG_POSITION6,"POSITION6",2443,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position7,CG_POSITION7,"POSITION7",2444,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position8,CG_POSITION8,"POSITION8",2445,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position9,CG_POSITION9,"POSITION9",2446,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position10,CG_POSITION10,"POSITION10",2447,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position11,CG_POSITION11,"POSITION11",2448,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position12,CG_POSITION12,"POSITION12",2449,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position13,CG_POSITION13,"POSITION13",2450,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position14,CG_POSITION14,"POSITION14",2451,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Position15,CG_POSITION15,"POSITION15",2452,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Diffuse0,CG_DIFFUSE0,"DIFFUSE0",2501,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent0,CG_TANGENT0,"TANGENT0",2565,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent1,CG_TANGENT1,"TANGENT1",2566,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent2,CG_TANGENT2,"TANGENT2",2567,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent3,CG_TANGENT3,"TANGENT3",2568,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent4,CG_TANGENT4,"TANGENT4",2569,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent5,CG_TANGENT5,"TANGENT5",2570,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent6,CG_TANGENT6,"TANGENT6",2571,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent7,CG_TANGENT7,"TANGENT7",2572,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent8,CG_TANGENT8,"TANGENT8",2573,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent9,CG_TANGENT9,"TANGENT9",2574,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent10,CG_TANGENT10,"TANGENT10",2575,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent11,CG_TANGENT11,"TANGENT11",2576,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent12,CG_TANGENT12,"TANGENT12",2577,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent13,CG_TANGENT13,"TANGENT13",2578,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent14,CG_TANGENT14,"TANGENT14",2579,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Tangent15,CG_TANGENT15,"TANGENT15",2580,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Specular0,CG_SPECULAR0,"SPECULAR0",2629,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices0,CG_BLENDINDICES0,"BLENDINDICES0",2693,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices1,CG_BLENDINDICES1,"BLENDINDICES1",2694,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices2,CG_BLENDINDICES2,"BLENDINDICES2",2695,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices3,CG_BLENDINDICES3,"BLENDINDICES3",2696,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices4,CG_BLENDINDICES4,"BLENDINDICES4",2697,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices5,CG_BLENDINDICES5,"BLENDINDICES5",2698,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices6,CG_BLENDINDICES6,"BLENDINDICES6",2699,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices7,CG_BLENDINDICES7,"BLENDINDICES7",2700,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices8,CG_BLENDINDICES8,"BLENDINDICES8",2701,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices9,CG_BLENDINDICES9,"BLENDINDICES9",2702,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices10,CG_BLENDINDICES10,"BLENDINDICES10",2703,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices11,CG_BLENDINDICES11,"BLENDINDICES11",2704,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices12,CG_BLENDINDICES12,"BLENDINDICES12",2705,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices13,CG_BLENDINDICES13,"BLENDINDICES13",2706,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices14,CG_BLENDINDICES14,"BLENDINDICES14",2707,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendIndices15,CG_BLENDINDICES15,"BLENDINDICES15",2708,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color0,CG_COLOR0,"COLOR0",2757,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color1,CG_COLOR1,"COLOR1",2758,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color2,CG_COLOR2,"COLOR2",2759,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color3,CG_COLOR3,"COLOR3",2760,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color4,CG_COLOR4,"COLOR4",2761,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color5,CG_COLOR5,"COLOR5",2762,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color6,CG_COLOR6,"COLOR6",2763,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color7,CG_COLOR7,"COLOR7",2764,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color8,CG_COLOR8,"COLOR8",2765,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color9,CG_COLOR9,"COLOR9",2766,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color10,CG_COLOR10,"COLOR10",2767,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color11,CG_COLOR11,"COLOR11",2768,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color12,CG_COLOR12,"COLOR12",2769,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color13,CG_COLOR13,"COLOR13",2770,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color14,CG_COLOR14,"COLOR14",2771,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Color15,CG_COLOR15,"COLOR15",2772,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize0,CG_PSIZE0,"PSIZE0",2821,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize1,CG_PSIZE1,"PSIZE1",2822,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize2,CG_PSIZE2,"PSIZE2",2823,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize3,CG_PSIZE3,"PSIZE3",2824,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize4,CG_PSIZE4,"PSIZE4",2825,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize5,CG_PSIZE5,"PSIZE5",2826,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize6,CG_PSIZE6,"PSIZE6",2827,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize7,CG_PSIZE7,"PSIZE7",2828,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize8,CG_PSIZE8,"PSIZE8",2829,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize9,CG_PSIZE9,"PSIZE9",2830,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize10,CG_PSIZE10,"PSIZE10",2831,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize11,CG_PSIZE11,"PSIZE11",2832,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize12,CG_PSIZE12,"PSIZE12",2833,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize13,CG_PSIZE13,"PSIZE13",2834,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize14,CG_PSIZE14,"PSIZE14",2835,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(PSize15,CG_PSIZE15,"PSIZE15",2836,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal0,CG_BINORMAL0,"BINORMAL0",2885,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal1,CG_BINORMAL1,"BINORMAL1",2886,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal2,CG_BINORMAL2,"BINORMAL2",2887,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal3,CG_BINORMAL3,"BINORMAL3",2888,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal4,CG_BINORMAL4,"BINORMAL4",2889,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal5,CG_BINORMAL5,"BINORMAL5",2890,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal6,CG_BINORMAL6,"BINORMAL6",2891,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal7,CG_BINORMAL7,"BINORMAL7",2892,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal8,CG_BINORMAL8,"BINORMAL8",2893,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal9,CG_BINORMAL9,"BINORMAL9",2894,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal10,CG_BINORMAL10,"BINORMAL10",2895,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal11,CG_BINORMAL11,"BINORMAL11",2896,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal12,CG_BINORMAL12,"BINORMAL12",2897,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal13,CG_BINORMAL13,"BINORMAL13",2898,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal14,CG_BINORMAL14,"BINORMAL14",2899,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BiNormal15,CG_BINORMAL15,"BINORMAL15",2900,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG0,CG_FOG0,"FOG0",2917,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG1,CG_FOG1,"FOG1",2918,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG2,CG_FOG2,"FOG2",2919,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG3,CG_FOG3,"FOG3",2920,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG4,CG_FOG4,"FOG4",2921,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG5,CG_FOG5,"FOG5",2922,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG6,CG_FOG6,"FOG6",2923,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG7,CG_FOG7,"FOG7",2924,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG8,CG_FOG8,"FOG8",2925,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG9,CG_FOG9,"FOG9",2926,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG10,CG_FOG10,"FOG10",2927,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG11,CG_FOG11,"FOG11",2928,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG12,CG_FOG12,"FOG12",2929,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG13,CG_FOG13,"FOG13",2930,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG14,CG_FOG14,"FOG14",2931,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FOG15,CG_FOG15,"FOG15",2932,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH0,CG_DEPTH0,"DEPTH0",2933,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH1,CG_DEPTH1,"DEPTH1",2934,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH2,CG_DEPTH2,"DEPTH2",2935,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH3,CG_DEPTH3,"DEPTH3",2936,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH4,CG_DEPTH4,"DEPTH4",2937,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH5,CG_DEPTH5,"DEPTH5",2938,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH6,CG_DEPTH6,"DEPTH6",2939,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH7,CG_DEPTH7,"DEPTH7",2940,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH8,CG_DEPTH8,"DEPTH8",2941,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH9,CG_DEPTH9,"DEPTH9",29542,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH10,CG_DEPTH10,"DEPTH10",2943,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH11,CG_DEPTH11,"DEPTH11",2944,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH12,CG_DEPTH12,"DEPTH12",2945,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH13,CG_DEPTH13,"DEPTH13",2946,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH14,CG_DEPTH14,"DEPTH14",2947,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(DEPTH15,CG_DEPTH15,"DEPTH15",2948,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE0,CG_SAMPLE0,"SAMPLE0",2949,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE1,CG_SAMPLE1,"SAMPLE1",2950,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE2,CG_SAMPLE2,"SAMPLE2",2951,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE3,CG_SAMPLE3,"SAMPLE3",2952,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE4,CG_SAMPLE4,"SAMPLE4",2953,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE5,CG_SAMPLE5,"SAMPLE5",2954,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE6,CG_SAMPLE6,"SAMPLE6",2955,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE7,CG_SAMPLE7,"SAMPLE7",2956,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE8,CG_SAMPLE8,"SAMPLE8",2957,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE9,CG_SAMPLE9,"SAMPLE9",2958,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE10,CG_SAMPLE10,"SAMPLE10",2959,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE11,CG_SAMPLE11,"SAMPLE11",2960,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE12,CG_SAMPLE12,"SAMPLE12",2961,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE13,CG_SAMPLE13,"SAMPLE13",2962,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE14,CG_SAMPLE14,"SAMPLE14",2963,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(SAMPLE15,CG_SAMPLE15,"SAMPLE15",2964,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight0,CG_BLENDWEIGHT0,"BLENDWEIGHT0",3028,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight1,CG_BLENDWEIGHT1,"BLENDWEIGHT1",3029,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight2,CG_BLENDWEIGHT2,"BLENDWEIGHT2",3030,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight3,CG_BLENDWEIGHT3,"BLENDWEIGHT3",3031,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight4,CG_BLENDWEIGHT4,"BLENDWEIGHT4",3032,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight5,CG_BLENDWEIGHT5,"BLENDWEIGHT5",3033,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight6,CG_BLENDWEIGHT6,"BLENDWEIGHT6",3034,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight7,CG_BLENDWEIGHT7,"BLENDWEIGHT7",3035,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight8,CG_BLENDWEIGHT8,"BLENDWEIGHT8",3036,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight9,CG_BLENDWEIGHT9,"BLENDWEIGHT9",3037,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight10,CG_BLENDWEIGHT10,"BLENDWEIGHT10",3038,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight11,CG_BLENDWEIGHT11,"BLENDWEIGHT11",3039,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight12,CG_BLENDWEIGHT12,"BLENDWEIGHT12",3040,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight13,CG_BLENDWEIGHT13,"BLENDWEIGHT13",3041,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight14,CG_BLENDWEIGHT14,"BLENDWEIGHT14",3042,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(BlendWeight15,CG_BLENDWEIGHT15,"BLENDWEIGHT15",3043,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal0,CG_NORMAL0,"NORMAL0",3092,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal1,CG_NORMAL1,"NORMAL1",3093,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal2,CG_NORMAL2,"NORMAL2",3094,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal3,CG_NORMAL3,"NORMAL3",3095,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal4,CG_NORMAL4,"NORMAL4",3096,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal5,CG_NORMAL5,"NORMAL5",3097,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal6,CG_NORMAL6,"NORMAL6",3098,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal7,CG_NORMAL7,"NORMAL7",3099,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal8,CG_NORMAL8,"NORMAL8",3100,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal9,CG_NORMAL9,"NORMAL9",3101,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal10,CG_NORMAL10,"NORMAL10",3102,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal11,CG_NORMAL11,"NORMAL11",3103,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal12,CG_NORMAL12,"NORMAL12",3104,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal13,CG_NORMAL13,"NORMAL13",3105,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal14,CG_NORMAL14,"NORMAL14",3106,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(Normal15,CG_NORMAL15,"NORMAL15",3107,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(FogCoord,CG_FOGCOORD,"FOGCOORD",3156,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord0,CG_TEXCOORD0,"TEXCOORD0",3220,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord1,CG_TEXCOORD1,"TEXCOORD1",3221,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord2,CG_TEXCOORD2,"TEXCOORD2",3222,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord3,CG_TEXCOORD3,"TEXCOORD3",3223,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord4,CG_TEXCOORD4,"TEXCOORD4",3224,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord5,CG_TEXCOORD5,"TEXCOORD5",3225,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord6,CG_TEXCOORD6,"TEXCOORD6",3226,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord7,CG_TEXCOORD7,"TEXCOORD7",3227,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord8,CG_TEXCOORD8,"TEXCOORD8",3228,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord9,CG_TEXCOORD9,"TEXCOORD9",3229,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord10,CG_TEXCOORD10,"TEXCOORD10",3230,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord11,CG_TEXCOORD11,"TEXCOORD11",3231,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord12,CG_TEXCOORD12,"TEXCOORD12",3232,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord13,CG_TEXCOORD13,"TEXCOORD13",3233,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord14,CG_TEXCOORD14,"TEXCOORD14",3234,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(TexCoord15,CG_TEXCOORD15,"TEXCOORD15",3235,0,cgConnectorMemberParam)
CG_BINDLOCATION_MACRO(CombinerConst0,CG_COMBINER_CONST0,"COMBINER_CONST0",3284,0,cgUniformParam)
CG_BINDLOCATION_MACRO(CombinerConst1,CG_COMBINER_CONST1,"COMBINER_CONST1",3285,0,cgUniformParam)
CG_BINDLOCATION_MACRO(CombinerStageConst0,CG_COMBINER_STAGE_CONST0,"COMBINER_STAGE_CONST0",3286,1,cgUniformParam)
CG_BINDLOCATION_MACRO(CombinerStageConst1,CG_COMBINER_STAGE_CONST1,"COMBINER_STAGE_CONST1",3287,1,cgUniformParam)
CG_BINDLOCATION_MACRO(OffsetTextureMatrix,CG_OFFSET_TEXTURE_MATRIX,"OFFSET_TEXTURE_MATRIX",3288,0,cgUniformParam)
CG_BINDLOCATION_MACRO(OffsetTextureScale,CG_OFFSET_TEXTURE_SCALE,"OFFSET_TEXTURE_SCALE",3289,0,cgUniformParam)
CG_BINDLOCATION_MACRO(OffsetTextureBias,CG_OFFSET_TEXTURE_BIAS,"OFFSET_TEXTURE_BIAS",3290,0,cgUniformParam)
CG_BINDLOCATION_MACRO(ConstEye,CG_CONST_EYE,"CONST_EYE",3291,0,cgUniformParam)
CG_BINDLOCATION_MACRO(TessFactor,CG_TESSFACTOR,"TESSFACTOR",3255,0,cgConnectorMemberParam)

#undef CG_BINDLOCATION_MACRO
  CG_UNDEFINED,

} CGresource;

typedef enum
{
# define CG_ENUM_MACRO(enum_name, enum_val) \
   enum_name = enum_val,

CG_ENUM_MACRO(CG_UNKNOWN, 4096)
CG_ENUM_MACRO(CG_IN, 4097)
CG_ENUM_MACRO(CG_OUT, 4098)
CG_ENUM_MACRO(CG_INOUT, 4099)
CG_ENUM_MACRO(CG_MIXED, 4100)
CG_ENUM_MACRO(CG_VARYING, 4101)
CG_ENUM_MACRO(CG_UNIFORM, 4102)
CG_ENUM_MACRO(CG_CONSTANT, 4103)
CG_ENUM_MACRO(CG_PROGRAM_SOURCE, 4104)
CG_ENUM_MACRO(CG_PROGRAM_ENTRY, 4105)
CG_ENUM_MACRO(CG_COMPILED_PROGRAM, 4106)
CG_ENUM_MACRO(CG_PROGRAM_PROFILE, 4107)
CG_ENUM_MACRO(CG_GLOBAL, 4108)
CG_ENUM_MACRO(CG_PROGRAM, 4109)
CG_ENUM_MACRO(CG_DEFAULT, 4110)
CG_ENUM_MACRO(CG_ERROR, 4111)
CG_ENUM_MACRO(CG_SOURCE, 4112)
CG_ENUM_MACRO(CG_OBJECT, 4113)
CG_ENUM_MACRO(CG_COMPILE_MANUAL, 4114)
CG_ENUM_MACRO(CG_COMPILE_IMMEDIATE, 4115)
CG_ENUM_MACRO(CG_COMPILE_LAZY, 4116)
CG_ENUM_MACRO(CG_CURRENT, 4117)
CG_ENUM_MACRO(CG_LITERAL, 4118)
CG_ENUM_MACRO(CG_VERSION, 4119)

#undef CG_ENUM_MACRO
} CGenum;

typedef enum
 {
  CG_PROFILE_START = 6144,
  CG_PROFILE_UNKNOWN,

# define CG_PROFILE_MACRO(name, compiler_id, compiler_id_caps, compiler_opt,int_id,vertex_profile) \
  CG_PROFILE_##compiler_id_caps = int_id,

CG_PROFILE_MACRO(Vertex,vp20,VP20,"vp20",6146,1)
CG_PROFILE_MACRO(Fragment20,fp20,FP20,"fp20",6147,0)
CG_PROFILE_MACRO(Vertex30,vp30,VP30,"vp30",6148,1)
CG_PROFILE_MACRO(Fragment,fp30,FP30,"fp30",6149,0)
CG_PROFILE_MACRO(ARBVertex,arbvp1,ARBVP1,"arbvp1",6150,1)
CG_PROFILE_MACRO(Fragment40,fp40,FP40,"fp40",6151,0)
CG_PROFILE_MACRO(ARBFragment,arbfp1,ARBFP1,"arbfp1",7000,0)
CG_PROFILE_MACRO(Vertex40,vp40,VP40,"vp40",7001,1)

#ifndef CG_IN_PROFILES_INCLUDE
# undef CG_PROFILE_MACRO
#endif

  CG_PROFILE_MAX = 7100,
} CGprofile;

typedef enum
{
  CG_GL_MATRIX_IDENTITY = 0,
  CG_GL_MATRIX_TRANSPOSE = 1,
  CG_GL_MATRIX_INVERSE = 2,
  CG_GL_MATRIX_INVERSE_TRANSPOSE = 3,

  CG_GL_MODELVIEW_MATRIX, CG_GL_PROJECTION_MATRIX,
  CG_GL_TEXTURE_MATRIX, CG_GL_MODELVIEW_PROJECTION_MATRIX,
  CG_GL_VERTEX, CG_GL_FRAGMENT,

} CGGLenum;

typedef enum
 {
# define CG_ERROR_MACRO(code, enum_name, new_enum_name, message) \
   new_enum_name = code,

CG_ERROR_MACRO(0, NoError, CG_NO_ERROR, "No error has occurred.")
CG_ERROR_MACRO(1, CompileError, CG_COMPILER_ERROR, "The compile returned an error.") 
CG_ERROR_MACRO(2, InvalidParameterError, CG_INVALID_PARAMETER_ERROR, "The parameter used is invalid.")
CG_ERROR_MACRO(3, InvalidProfileError, CG_INVALID_PROFILE_ERROR, "The profile is not supported.") 
CG_ERROR_MACRO(4, ProgramLoadError, CG_PROGRAM_LOAD_ERROR, "The program could not load.")
CG_ERROR_MACRO(5, ProgramBindError, CG_PROGRAM_BIND_ERROR, "The program could not bind.") 
CG_ERROR_MACRO(6, ProgramNotLoadedError, CG_PROGRAM_NOT_LOADED_ERROR, "The program must be loaded before this operation may be used.")
CG_ERROR_MACRO(7, UnsupportedGLExtensionError, CG_UNSUPPORTED_GL_EXTENSION_ERROR, "An unsupported GL extension was required to perform this operation.")
CG_ERROR_MACRO(8, InvalidValueTypeError, CG_INVALID_VALUE_TYPE_ERROR, "An unknown value type was assigned to a parameter.")
CG_ERROR_MACRO(9, NotMatrixParamError, CG_NOT_MATRIX_PARAM_ERROR, "The parameter is not of matrix type.")
CG_ERROR_MACRO(10, InvalidEnumerantError, CG_INVALID_ENUMERANT_ERROR, "The enumerant parameter has an invalid value.")
CG_ERROR_MACRO(11, Not4x4MatrixError, CG_NOT_4x4_MATRIX_ERROR, "The parameter must be a 4x4 matrix type.")
CG_ERROR_MACRO(12, FileReadError, CG_FILE_READ_ERROR, "The file could not be read.")
CG_ERROR_MACRO(13, FileWriteError, CG_FILE_WRITE_ERROR, "The file could not be written.")
CG_ERROR_MACRO(14, NVParseError, CG_NVPARSE_ERROR, "nvparse could not successfully parse the output from the Cg " "compiler backend.")
CG_ERROR_MACRO(15, MemoryAllocError, CG_MEMORY_ALLOC_ERROR, "Memory allocation failed.")
CG_ERROR_MACRO(16, InvalidContextHandleError, CG_INVALID_CONTEXT_HANDLE_ERROR, "Invalid context handle.")
CG_ERROR_MACRO(17, InvalidProgramHandleError, CG_INVALID_PROGRAM_HANDLE_ERROR, "Invalid program handle.")
CG_ERROR_MACRO(18, InvalidParamHandleError, CG_INVALID_PARAM_HANDLE_ERROR, "Invalid parameter handle.")
CG_ERROR_MACRO(19, UnknownProfileError, CG_UNKNOWN_PROFILE_ERROR, "The specified profile is unknown.")
CG_ERROR_MACRO(20, VarArgError, CG_VAR_ARG_ERROR, "The variable arguments were specified incorrectly.")
CG_ERROR_MACRO(21, InvalidDimensionError, CG_INVALID_DIMENSION_ERROR, "The dimension value is invalid.")
CG_ERROR_MACRO(22, ArrayParamError, CG_ARRAY_PARAM_ERROR, "The parameter must be an array.")
CG_ERROR_MACRO(23, OutOfArrayBoundsError, CG_OUT_OF_ARRAY_BOUNDS_ERROR, "Index into the array is out of bounds.")

#undef CG_ERROR_MACRO

 } CGerror;

