# CiviCRM 4.7.25

Released October 4, 2017

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                     |         |
|:----------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                               |   no    |
| **Change the database schema?**                             | **yes** |
| **Alter the API?**                                          | **yes** |
| Require attention to configuration options?                 |   no    |
| Fix problems installing or upgrading to a previous version? |   no    |
| **Introduce features?**                                     | **yes** |
| **Fix bugs?**                                               | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-20769](https://issues.civicrm.org/jira/browse/CRM-20769) Allow for
  Button Text on profiles to be overriden in settings
  ([10940](https://github.com/civicrm/civicrm-core/pull/10940) and
  [11051](https://github.com/civicrm/civicrm-core/pull/11051))**

  This adds columns to the `civicrm_uf_group` table to support customizing
  profile buttons.

- **[CRM-20964](https://issues.civicrm.org/jira/browse/CRM-20964) Include queue
  id while retrieving rows from Event Queue.
  ([10757](https://github.com/civicrm/civicrm-core/pull/10757))**

  `CRM_Mailing_Event_BAO_Queue::getRows()` returned rows for each intended
  recipients, but didn't include any info which differentiates each row.

  This adds a `queue_id` in the key column of the $result array which enables
  hooks to know which row is getting displayed.

- **[CRM-21118](https://issues.civicrm.org/jira/browse/CRM-21118) Add action
  links for message templates overview at top of page
  ([10917](https://github.com/civicrm/civicrm-core/pull/10917))**

  Previously action links (add message template) were only shown at the bottom
  of the page.  If you have lots of message templates it is not visible until
  scrolling down.  This adds the links at the top of the page as well (like many
  other pages in CiviCRM).

- **[CRM-20979](https://issues.civicrm.org/jira/browse/CRM-20979) pre help for
  price fields not exposed to UI.
  ([10780](https://github.com/civicrm/civicrm-core/pull/10780))**

  Adds a field to the Add/Edit Price Field Form to enter pre help for price
  fields.

- **[CRM-20680](https://issues.civicrm.org/jira/browse/CRM-20680) Make the
  CiviCRM logo spin while waiting for next page to load
  ([10903](https://github.com/civicrm/civicrm-core/pull/10903)) (fix to previous
  work)**

  This fixes a side effect of the new feature that caused all CiviCRM logos on
  the page to spin.

- **[CRM-21078](https://issues.civicrm.org/jira/browse/CRM-21078) Allow user to
  save and continue editing message template
  ([10871](https://github.com/civicrm/civicrm-core/pull/10871))**

  The message template editing screen now matches similar forms in CiviCRM by
  offering separate "Save" and "Save and Done" buttons.

- **[CRM-20941](https://issues.civicrm.org/jira/browse/CRM-20941) Determine &
  notify date to end support for PHP5.3 and PHP5.4
  ([10851](https://github.com/civicrm/civicrm-core/pull/10851))**

  A pre-upgrade message and system check now warn administrators of sites using
  PHP versions prior to  5.6.

- **[CRM-17157](https://issues.civicrm.org/jira/browse/CRM-17157) CiviCRM money
  validation should allow more decimal places
  ([10827](https://github.com/civicrm/civicrm-core/pull/10827))**

  Previously, validation of money fields limited values to two decimal places.
  This allows for currencies that may have more decimal places.

- **[CRM-20926](https://issues.civicrm.org/jira/browse/CRM-20926) Allow
  extensions to flag PHPIDS html/json fields
  ([10709](https://github.com/civicrm/civicrm-core/pull/10709))**

  Extensions can now denote fields that should be be evaluated as HTML, JSON, or
  exceptions for the intrusion detection system (IDS).

- **[CRM-20155](https://issues.civicrm.org/jira/browse/CRM-20155) The dedupe
  code passes has serious maintainability issues, locked in by hooks
  ([10890](https://github.com/civicrm/civicrm-core/pull/10890)) (preliminary
  work)**

  This is initial cleanup work toward separating the dedupe process from the
  form layer, allowing for extensions to do custom dedupe logic.  This initial
  work merely cleans up the existing processing.

- **[CRM-17748](https://issues.civicrm.org/jira/browse/CRM-17748) Expose
  options['result_buffering'] to CRM_Core_DAO
  ([10585](https://github.com/civicrm/civicrm-core/pull/10585))**

  Queries sent to the DAO can now pass options for `DB_mysql`.  Specifically,
  a `result_buffering` option can reduce PHP memory needs by calling for an
  unbuffered query.

- **[CRM-20733](https://issues.civicrm.org/jira/browse/CRM-20733) Relationship
  report improvements
  ([10679](https://github.com/civicrm/civicrm-core/pull/10679))**

  The Relationship Report can now filter results by permissions (contact A over
  contact B and vice-versa) and order results by start date.

- **[CRM-21108](https://issues.civicrm.org/jira/browse/CRM-21108) Creating
  contacts is slow, part 1 of 2: Calculating Greetings
  ([10906](https://github.com/civicrm/civicrm-core/pull/10906))**

  This optimizes the population of greetings for newly-created contacts, the
  slowest part of generating contacts.

- **[CRM-18231](https://issues.civicrm.org/jira/browse/CRM-18231) Support safe
  migration from production to non-production instances
  ([10972](https://github.com/civicrm/civicrm-core/pull/10972),
  [10936](https://github.com/civicrm/civicrm-core/pull/10936), and
  [8724](https://github.com/civicrm/civicrm-core/pull/8724))**

  This introduces a feature of environment labels that can be set in
  `civicrm.settings.php` and be extended in specially-named settings files.  If
  the label is anything other than `Production`, outbound email and scheduled
  jobs are disabled.  See further explanation in the [Sysadmin
  Guide](https://docs.civicrm.org/sysadmin/en/master/misc/staging-production/)

### CiviCase

- **[CRM-20958](https://issues.civicrm.org/jira/browse/CRM-20958) Data model:
  Track creation+modification times for activities+cases
  ([10754](https://github.com/civicrm/civicrm-core/pull/10754))**

  Adds timestamp columns created_date and modified_date to the tables
  `civicrm_activity` and `civicrm_case`

- **[CRM-21052](https://issues.civicrm.org/jira/browse/CRM-21052) Allow opt-out
  of embedded case-activity tracking
  ([10842](https://github.com/civicrm/civicrm-core/pull/10842))**

  A new setting, "Enable Embedded Activity Revisions", determines whether each
  revision to a case records the change as an activity.  This has been the
  behavior in the past and will continue to be the default for CiviCase until
  the redesign is complete.  However, many CiviCase users may prefer to leave
  change logging to the log tables that are created when overall CiviCRM logging
  is enabled.

### CiviContribute

- **[CRM-21058](https://issues.civicrm.org/jira/browse/CRM-21058) Add Event
  filter to PCP contribution report
  ([10862](https://github.com/civicrm/civicrm-core/pull/10862))**

  The Personal Campaign Page report now allows filtering by the title of a PCP's
  associated event.

- **[CRM-20990](https://issues.civicrm.org/jira/browse/CRM-20990) Assign
  `$contributionStatus` to the Contribution Online message template
  ([10793](https://github.com/civicrm/civicrm-core/pull/10793))**

  The contribution status is now available as a Smarty variable on the receipt
  message template for online contributions.

- **[CRM-21019](https://issues.civicrm.org/jira/browse/CRM-21019) Change column
  labels ([10813](https://github.com/civicrm/civicrm-core/pull/10813))**

  The column headers on accounting batch screens are now clearer.

### CiviEvent

- **[CRM-20507](https://issues.civicrm.org/jira/browse/CRM-20507) Prevent
  disclosure of `is_public=0` Custom Groups in email templates
  ([10661](https://github.com/civicrm/civicrm-core/pull/10661))**

  Custom data groups can be public or backend-only as of 4.7.19.  This
  suppresses non-public fields from email receipts for event registrations.

### CiviMail

- **[CRM-20905](https://issues.civicrm.org/jira/browse/CRM-20905) Simple mail :
  Make max emails a hidden config instead of hardcoded value set to 50
  ([10705](https://github.com/civicrm/civicrm-core/pull/10705))**

  The maximum number of emails sent through the quick "send an email" feature is
  set to 50.  This change allows that number to be overridden through the
  setting API or settings file.

### CiviMember

- **[CRM-21152](https://issues.civicrm.org/jira/browse/CRM-21152) Add spec for
  MembershipStatus.calc API function
  ([10944](https://github.com/civicrm/civicrm-core/pull/10944))**

  Adds a function to adjust metadata for `Calc` action. The metadata is used for
  setting defaults, documentation & validation.

### Drupal Integration

- **[CRM-21016](https://issues.civicrm.org/jira/browse/CRM-21016) Allow Drupal
  views to be used for Notes related to contributions
  ([468](https://github.com/civicrm/civicrm-drupal/pull/468))**

  Drupal Views will now join to the `civicrm_note` table for any related entity,
  not just contacts.

- **Add Contributions relevant to the Participant record.
  ([469](https://github.com/civicrm/civicrm-drupal/pull/469))**

  Drupal Views will now join to the `civicrm_participant_payment` table,
  allowing related contributions to be displayed alongside event registrations.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-21068](https://issues.civicrm.org/jira/browse/CRM-21068)
  &lastModified() fails more gracefully.
  ([10863](https://github.com/civicrm/civicrm-core/pull/10863))**

  This change avoids displaying an error if something is missing from the log
  entry for a contact when shown in the summary view.

- **[CRM-21099](https://issues.civicrm.org/jira/browse/CRM-21099) Contribution
  search: "Total Cancelled Amount" surprisingly includes "refunded" status
  ([10893](https://github.com/civicrm/civicrm-core/pull/10893))**

  In the results of a Find Contributions search, summary numbers are displayed
  at the top. One of these is "Total Cancelled Amount" this total included
  contributions with a "Refunded" or "Cancelled" status. This total now only
  includes contributions with a status of "Cancelled".

- **[CRM-21075](https://issues.civicrm.org/jira/browse/CRM-21075) Notice errors
  on contact edit
  ([10878](https://github.com/civicrm/civicrm-core/pull/10878))**

  When a user would edit their record, a series of notices would be generated
  because of use of a deprecated function. This change removes those errors.

- **[CRM-21057](https://issues.civicrm.org/jira/browse/CRM-21057) export field
  mapping limited to 25 records
  ([10848](https://github.com/civicrm/civicrm-core/pull/10848))**

  This resolves a bug where only 25 saved export mappings were available to
  select.

- **[CRM-21124](https://issues.civicrm.org/jira/browse/CRM-21124) Fix DB error
  on deduping by criteria when criteria string is too long
  ([10921](https://github.com/civicrm/civicrm-core/pull/10921))**

- **[CRM-21061](https://issues.civicrm.org/jira/browse/CRM-21061) Fix rare
  CiviReport error relating to long report names
  ([10854](https://github.com/civicrm/civicrm-core/pull/10854))**

  The relatively short length of the `report_id` field in the `civicrm_report`
  table meant that reports with long names would produce obtuse errors.  The
  field is now 512 characters long.

- **[CRM-21004](https://issues.civicrm.org/jira/browse/CRM-21004) profile:
  unable to copy profiles used for events/contribs/etc.
  ([10802](https://github.com/civicrm/civicrm-core/pull/10802))**

- **[CRM-21230](https://issues.civicrm.org/jira/browse/CRM-21230) Multi-value
  custom field import fail with error message: Call to undefined method
  `CRM_Custom_Import_Parser_Api::formatContactParameters`
  ([11039](https://github.com/civicrm/civicrm-core/pull/11039))**

- **[CRM-21174](https://issues.civicrm.org/jira/browse/CRM-21174) Circular
  dependency during upgrade: civicrm_menu.module_data
  ([10974](https://github.com/civicrm/civicrm-core/pull/10974))**

  A field to be created during the upgrade was accidentally loaded as part of
  the upgrade.

- **[CRM-21175](https://issues.civicrm.org/jira/browse/CRM-21175) Fatal error on
  multiple custom field import
  ([10975](https://github.com/civicrm/civicrm-core/pull/10975))**

  Import mappings now must have a mapping type.  This resolves an error that
  would appear when a mapping type was missing; now, the mapping type is created
  on the fly.

- **[CRM-20533](https://issues.civicrm.org/jira/browse/CRM-20533) 'Update
  Indices' System Status action can get tied up (index name already exists,
  localised dbs?)
  ([10908](https://github.com/civicrm/civicrm-core/pull/10908)) (continues
  previous work)**

  A system check offers to update old or missing table indices when it detects
  they are missing.  In practice, many sites have equivalent indices to the ones
  that are supposedly missing, but the index names differ or the index fields
  are listed in a different order.  This script has had persistent problems with
  attempting to create indices that already exist or incorrectly dropping
  indices.

  This most recent change deletes false indices automatically when the Update
  Indices process is started rather than asking the site administrator.  Any
  false-looking index that is actually good will simply be replaced when the
  missing indices are populated.

- **[CRM-21110](https://issues.civicrm.org/jira/browse/CRM-21110) Relationships
  tab on contact summary runs query twice
  ([10907](https://github.com/civicrm/civicrm-core/pull/10907))**

  This streamlines the processing of the contact relationship listing to reduce
  the number of queries to run.

- **[CRM-21142](https://issues.civicrm.org/jira/browse/CRM-21142) Installation
  fails if PHP XML module isn't installed
  ([10939](https://github.com/civicrm/civicrm-core/pull/10939))**

  The installer now checks that PHP SimpleXML support is present.

- **[CRM-21139](https://issues.civicrm.org/jira/browse/CRM-21139) Font-Awesome
  icons not showing on fatal error screen
  ([10937](https://github.com/civicrm/civicrm-core/pull/10937))**

  Now `crm-i.css` is specifically loaded on the fatal error template.

- **[CRM-19933](https://issues.civicrm.org/jira/browse/CRM-19933) Importing
  contacts clears out preferred communication method
  ([10731](https://github.com/civicrm/civicrm-core/pull/10731))**

- **[CRM-21079](https://issues.civicrm.org/jira/browse/CRM-21079) Datetime logs
  don't supports timezones
  ([10874](https://github.com/civicrm/civicrm-core/pull/10874)) (continues
  previous work)**

  A system check appears if certain database fields are `DATETIME` rather than
  `TIMESTAMP`.  Due to the complexity of assigning timezones and the possibility
  of customizations depending upon those fields, the check merely explains the
  situation and recommends using [Doctor
  When](https://github.com/civicrm/org.civicrm.doctorwhen), a time lord
  extension, to straighten out the situation.

- **[CRM-20970](https://issues.civicrm.org/jira/browse/CRM-20970) long postal
  code in db prevents searching by zipcode range
  ([10781](https://github.com/civicrm/civicrm-core/pull/10781)) (completes
  previous work)**

  This adds test coverage for the fix which appeared in 4.7.24.

- **[CRM-20790](https://issues.civicrm.org/jira/browse/CRM-20790) CIVICRM-159 -
  Import Contacts, Current Employer (Employee of field) is not being imported at
  all ([10808](https://github.com/civicrm/civicrm-core/pull/10808))**

  Import would fail to record relationships if data for one or both contacts in
  the relationship matched existing contacts.

- **[CRM-21049](https://issues.civicrm.org/jira/browse/CRM-21049) Can't create a
  RelationshipType record via API with "All Contacts" as a value
  ([10839](https://github.com/civicrm/civicrm-core/pull/10839))**

  This prevented relationship types created in the API where one or both
  contacts could be any contact type.

- **[CRM-20993](https://issues.civicrm.org/jira/browse/CRM-20993) API -
  Extension get - Cannot filter by ID anymore
  ([10794](https://github.com/civicrm/civicrm-core/pull/10794))**

- **[CRM-21029](https://issues.civicrm.org/jira/browse/CRM-21029) Activity
  report SQL syntax error
  ([10819](https://github.com/civicrm/civicrm-core/pull/10819))**

  A SQL error would appear in the Activity Report, including the Scheduled
  Activities dashlet, when no ACL `WHERE` clauses are applicable.

- **[CRM-20858](https://issues.civicrm.org/jira/browse/CRM-20858) Custom fields
  migrated even when not asked during merge
  ([10831](https://github.com/civicrm/civicrm-core/pull/10831))**

- **[CRM-21129](https://issues.civicrm.org/jira/browse/CRM-21129) CLI import
  doesn't allow single-column CSVs
  ([10924](https://github.com/civicrm/civicrm-core/pull/10924))**

- **[CRM-19612](https://issues.civicrm.org/jira/browse/CRM-19612) DB error
  deduping a group when rule has more than one field
  ([10405](https://github.com/civicrm/civicrm-core/pull/10405))**

- **[CRM-19664](https://issues.civicrm.org/jira/browse/CRM-19664) Skip row and
  keep importing if matching this contact based on the de-dupe rule would cause
  an external ID conflict
  ([9410](https://github.com/civicrm/civicrm-core/pull/9410))**

### CiviMail

- **[CRM-21077](https://issues.civicrm.org/jira/browse/CRM-21077) Warn the user
  when testing outbound mail configuration if CIVICRM_MAIL_LOG is set
  ([10870](https://github.com/civicrm/civicrm-core/pull/10870))**

  When sending a test email from the Outbound Email form, a user would not be
  notified if the CiviCRM settings file was set to send all outbound email to a
  log file.

- **[CRM-20643](https://issues.civicrm.org/jira/browse/CRM-20643) Fix invalid
  bounce type filter for bounce report
  ([10427](https://github.com/civicrm/civicrm-core/pull/10427))**

  A dummy option of `-- please select --` for bounce type was hard-coded as a
  filter option.  This caused the report to default to this value and not load
  any data.

- **[CRM-21000](https://issues.civicrm.org/jira/browse/CRM-21000) Display result
  as Mailing on Advance Search produces DB Error
  ([10798](https://github.com/civicrm/civicrm-core/pull/10798))**

  This resolves an error in Advanced Search when the form is set to display
  mailings rather than contacts.

- **[CRM-20855](https://issues.civicrm.org/jira/browse/CRM-20855) Disabling
  "Search Primary Details Only" causes partial CiviMail delivery failure
  ([10915](https://github.com/civicrm/civicrm-core/pull/10915))**

- **[CRM-20982](https://issues.civicrm.org/jira/browse/CRM-20982) Fix: Mails
  sent via command line fail due to EHLO/HELO being "localhost"
  ([10785](https://github.com/civicrm/civicrm-core/pull/10785))**

  SMTP connections from the command line now attempt to identify themselves with
  `EHLO` and the base URL rather than just `EHLO localhost`.

### Backdrop Integration

- **[CRM-21088](https://issues.civicrm.org/jira/browse/CRM-21088) Backdrop class
  contains `drupal_` calls that should be changed
  ([10884](https://github.com/civicrm/civicrm-core/pull/10884))**

  This would cause problems if Backdrop compatibility mode was disabled.

- **[CRM-21098](https://issues.civicrm.org/jira/browse/CRM-21098) Prevent
  Backdrop admin drop-down menus from appearing beneath CiviCRM admin menu
  ([10892](https://github.com/civicrm/civicrm-core/pull/10892))**

- **[CRM-21095](https://issues.civicrm.org/jira/browse/CRM-21095) CSS conflicts
  between CiviCRM and Backdrop
  ([10891](https://github.com/civicrm/civicrm-core/pull/10891),
  [42](https://github.com/civicrm/civicrm-backdrop/pull/42), and
  [41](https://github.com/civicrm/civicrm-backdrop/pull/41))**

### CiviCampaign

- **[CRM-21094](https://issues.civicrm.org/jira/browse/CRM-21094) Minor
  improvement to display of columns in Survey Details report
  ([10889](https://github.com/civicrm/civicrm-core/pull/10889))**

  This arranges the columns so that contact-related fields are together and
  preceding activity fields.

- **[CRM-21089](https://issues.civicrm.org/jira/browse/CRM-21089) Fatal error on
  "Interview Respondents"
  ([10885](https://github.com/civicrm/civicrm-core/pull/10885))**

### Drupal Integration

- **[CRM-17652](https://issues.civicrm.org/jira/browse/CRM-17652) Symfony
  conflict between Civi and Drupal 8
  ([10694](https://github.com/civicrm/civicrm-core/pull/10694) and
  [465](https://github.com/civicrm/civicrm-drupal/pull/465)) (in progress)**

  This uses Composer to install dependencies (such as Symfony) in a way that
  does not conflict with Drupal 8.  It resolves a bug where Drupal 8 sites with
  CiviCRM could not install any more modules.

- **[CRM-20838](https://issues.civicrm.org/jira/browse/CRM-20838) Provide alert &
  fix method for tables in the CiviCRM Db with no log table
  ([10628](https://github.com/civicrm/civicrm-core/pull/10628))**

  If Drupal and CiviCRM are installed with the same database and logging is
  enabled, the logging triggers get confused by the existence of tables created
  by the role sync modules.  A system check now suggests that corresponding log
  tables be created when it notices this.

### CiviMember

- **[CRM-21126](https://issues.civicrm.org/jira/browse/CRM-21126)
  member_is_primary not set by default on passing owner in the url
  ([10923](https://github.com/civicrm/civicrm-core/pull/10923))**

  The membership search now allows `owner=1` to be specified as a URL parameter
  that populates the "Primary member?" field.

- **[CRM-20571](https://issues.civicrm.org/jira/browse/CRM-20571) Offline / Back
  Office Renewal fatal error when "renewal_date" set to far back.
  ([10822](https://github.com/civicrm/civicrm-core/pull/10822))**

  A helpful warning appears when attempting to set a membership renewal date
  prior to the join date.

- **[CRM-20966](https://issues.civicrm.org/jira/browse/CRM-20966) Contribution
  deleted when relationship deleted, incorrect line items & membership_payments
  for second inherited membership created in back end via price set
  ([10759](https://github.com/civicrm/civicrm-core/pull/10759))**

  This resolves a problem where membership contributions would be applied
  incorrectly when one contact inherits memberships of separate types from
  separate related contacts.  This could result in data loss if the relationship
  is deleted.

- **[CRM-20955](https://issues.civicrm.org/jira/browse/CRM-20955) Contact's
  second membership fails to inherit when created in back end using price set
  ([10745](https://github.com/civicrm/civicrm-core/pull/10745))**

### CiviContribute

- **[CRM-21055](https://issues.civicrm.org/jira/browse/CRM-21055) Change label
  of cancel button
  ([10845](https://github.com/civicrm/civicrm-core/pull/10845))**

  The button to exit the backend contribution form without saving is now labeled
  "Close" rather than "Cancel".  This now differs from all other forms.

- **[CRM-17040](https://issues.civicrm.org/jira/browse/CRM-17040) Import
  Contributions using External Id's causes soft credit to be wrongly associated
  ([10797](https://github.com/civicrm/civicrm-core/pull/10797))**

  This resolves a problem that occurred when importing contributions that have
  both soft credit and donor contacts identified by external ID.  The
  contribution would record the soft credit contact as the actual donor.

- **[CRM-20949](https://issues.civicrm.org/jira/browse/CRM-20949)
  BillingBlock.tpl contains wrong paymentProcessor object on initial load of
  backend Contribution page.
  ([10734](https://github.com/civicrm/civicrm-core/pull/10734))**

- **[CRM-21087](https://issues.civicrm.org/jira/browse/CRM-21087) Payment popup
  goes weird if you click 'adjust payment amount'.
  ([10882](https://github.com/civicrm/civicrm-core/pull/10882))**

  The pledge payment pop-up caused problems with page focus and covering the
  Save button.

- **[CRM-20936](https://issues.civicrm.org/jira/browse/CRM-20936) Hide statuses
  on backoffice contribution form
  ([10718](https://github.com/civicrm/civicrm-core/pull/10718))**

  Non-applicable contribution statuses are now suppressed when creating
  contributions, event registrations, and memberships on the backend.

- **[CRM-21045](https://issues.civicrm.org/jira/browse/CRM-21045) Multiple email
  field shown on Contribution Page.
  ([10832](https://github.com/civicrm/civicrm-core/pull/10832))**

  If a contribution page included a profile with a billing email, the email
  field at the top of the contribution page would fail to disappear, resulting
  in two HTML fields for the same data.  This resolves that bug.

- **[CRM-21047](https://issues.civicrm.org/jira/browse/CRM-21047) TypeError:
  financialtypeIds is undefined, on contribution form
  ([10836](https://github.com/civicrm/civicrm-core/pull/10836))**

  This resolves a Javascript error on the backend contribution form.

- **[CRM-20615](https://issues.civicrm.org/jira/browse/CRM-20615) Export only
  those batches having status Exported
  ([10394](https://github.com/civicrm/civicrm-core/pull/10394))**

  This prevents batches from bein exported if the status isn't yet set to
  "exported".

- **[CRM-21026](https://issues.civicrm.org/jira/browse/CRM-21026) Contribution
  count on contact tabs excludes contributions with disabled financial types
  ([10824](https://github.com/civicrm/civicrm-core/pull/10824))**

- **[CRM-19469](https://issues.civicrm.org/jira/browse/CRM-19469) EWay
  transaction receipt not sent when member signs up using front-end form but
  works in the CiviCRM back-end
  ([9973](https://github.com/civicrm/civicrm-core/pull/9973))**

- **[CRM-21043](https://issues.civicrm.org/jira/browse/CRM-21043) Fix Dupe check
  of on behalf organisation
  ([10830](https://github.com/civicrm/civicrm-core/pull/10830))**

  When contributing on behalf of an organization, the organization would not be
  checked against duplicates and a new contact would be created each time.

- **[CRM-19739](https://issues.civicrm.org/jira/browse/CRM-19739) "New Account
  Relationship Option Screen" does not show exception
  ([10651](https://github.com/civicrm/civicrm-core/pull/10651))**

  Creating an invalid account relationship would result in an endless spinning
  logo rather than displaying an error.

- **[CRM-21015](https://issues.civicrm.org/jira/browse/CRM-21015) Contribution
  page creates recurring contribution even though recurring is not selected
  ([10835](https://github.com/civicrm/civicrm-core/pull/10835))**

  Recurring contributions would be created if a contribution page had the option
  for recurring contributions and a membership price set, even if the recurring
  contribution checkbox was empty.

- **[CRM-21005](https://issues.civicrm.org/jira/browse/CRM-21005) "Record
  Payment" dialogue lacks required field and is clunky
  ([10817](https://github.com/civicrm/civicrm-core/pull/10817))**

  The form for recording a payment did not require a payment method even though
  that is necessary.  Omitting it would result in a system error rather than a
  validation error.  Also, the payment amount now defaults to the amount due.

- **[CRM-21031](https://issues.civicrm.org/jira/browse/CRM-21031) Financial type
  ID display instead of label in "View Price Options"
  ([10823](https://github.com/civicrm/civicrm-core/pull/10823))**

- **[CRM-19186](https://issues.civicrm.org/jira/browse/CRM-19186) Subsequent
  Installments of Recurring Credit Card Contributions Indicate a Payment
  Instrument of Check
  ([10749](https://github.com/civicrm/civicrm-core/pull/10749))**

- **[CRM-17281](https://issues.civicrm.org/jira/browse/CRM-17281) Pledges
  miscalculate when total amount is not an integer and a payment is received
  that covers three installments
  ([10861](https://github.com/civicrm/civicrm-core/pull/10861))**

- **[CRM-21039](https://issues.civicrm.org/jira/browse/CRM-21039) Trying to add
  Asset account relationship throws validation error
  ([10828](https://github.com/civicrm/civicrm-core/pull/10828))**

- **[CRM-20988](https://issues.civicrm.org/jira/browse/CRM-20988) Don't display
  option of Export, Delete etc to users who lack that permission
  ([10791](https://github.com/civicrm/civicrm-core/pull/10791))**

### CiviCase

- **[CRM-20930](https://issues.civicrm.org/jira/browse/CRM-20930) Case Detail
  Report cannot filter by "Last Action Date"
  ([10712](https://github.com/civicrm/civicrm-core/pull/10712))**

- **[CRM-18082](https://issues.civicrm.org/jira/browse/CRM-18082) CiviCase API
  Create ignores custom data
  ([10728](https://github.com/civicrm/civicrm-core/pull/10728))**

### CiviEvent

- **[CRM-20935](https://issues.civicrm.org/jira/browse/CRM-20935) Deleting an
  event does not delete links to profiles it used
  ([10719](https://github.com/civicrm/civicrm-core/pull/10719))**

  Rows in `civicrm_uf_join` were not deleted when events were deleted.  This
  resolves the bug and performs a cleanup of orphaned rows upon upgrade.

- **[CRM-20237](https://issues.civicrm.org/jira/browse/CRM-20237) Event
  pricesets copied with long suffix cause DB error
  ([10929](https://github.com/civicrm/civicrm-core/pull/10929))**

  When copied, a price set has a copy ID tacked onto the end of its title.  This
  change prevents copies of copies from accumulating many copy ID add-ons.

- **[CRM-21069](https://issues.civicrm.org/jira/browse/CRM-21069) Fail more
  gracefully on event display with invalid data in the DB
  ([10865](https://github.com/civicrm/civicrm-core/pull/10865))**

  This avoids a database error by suppressing display of participant records
  where the event has been deleted in the database.

- **[CRM-20914](https://issues.civicrm.org/jira/browse/CRM-20914) participant
  note field breaking export when populated with data over 32 characters
  ([10700](https://github.com/civicrm/civicrm-core/pull/10700))**

- **[CRM-20933](https://issues.civicrm.org/jira/browse/CRM-20933) Updating Pay
  later event registration from backend produces formRule error
  ([10716](https://github.com/civicrm/civicrm-core/pull/10716))**

- **[CRM-21121](https://issues.civicrm.org/jira/browse/CRM-21121) Event Income
  (Summary) report backtrace with 'only_full_group_by'
  ([10926](https://github.com/civicrm/civicrm-core/pull/10926))**

- **[CRM-20027](https://issues.civicrm.org/jira/browse/CRM-20027) Need 'access
  deleted contacts' permission to retrieve loc block addresses using API
  ([10916](https://github.com/civicrm/civicrm-core/pull/10916))**

  Addresses lacking contact IDs because they're used for event locations were
  treated like addresses belonging to deleted contacts.

- **[CRM-13309](https://issues.civicrm.org/jira/browse/CRM-13309) Participant
  Role on Event's Schedule Reminder form does not populate
  ([10801](https://github.com/civicrm/civicrm-core/pull/10801))**

  The field to restrict scheduled reminders to specific participant roles would
  not appear.

- **[CRM-20942](https://issues.civicrm.org/jira/browse/CRM-20942) Email location
  type must be 'primary' in profile or user creation won't work for event
  ([10744](https://github.com/civicrm/civicrm-core/pull/10744))**

### WordPress Integration

- **Fix parameter parsing in wp-cli civicrm api.
  ([114](https://github.com/civicrm/civicrm-wordpress/pull/114))**

- **[CRM-21166](https://issues.civicrm.org/jira/browse/CRM-21166) WP-CLI
  commands fail due to whitespace in regex
  ([115](https://github.com/civicrm/civicrm-wordpress/pull/115))**

### Internationalization

- **[CRM-19968](https://issues.civicrm.org/jira/browse/CRM-19968) Disable
  multiple languages fixes
  ([9783](https://github.com/civicrm/civicrm-core/pull/9783))**

  This patch makes the following tweaks to the SQL queries that run when
  disabling multiple languages so that it is more likely to succeed.

  1. Column is renamed instead of created and copied, as the copy often leads to
  a row size constraint (eg. in civicrm_event when you have some text in
  intro_text_lang).
  2. Use DROP VIEW IF EXISTS instead of DROP VIEW (supported
  in mysql 5.1+). There is more support for IF EXISTS on other SQL functions in
  new versions of mysql but we can't use them if we're maintaining
  compatibility.

## <a name="misc"></a>Miscellany

- **[CRM-21153](https://issues.civicrm.org/jira/browse/CRM-21153) Fix mispelled
  variable ([10945](https://github.com/civicrm/civicrm-core/pull/10945))**

  Fixes a misspelled variable

- **[CRM-21065](https://issues.civicrm.org/jira/browse/CRM-21065) Replace some
  deprecated slow function calls: some CRM_Core_OptionGroup::values with
  CRM_Activity_BAO_ActivityContact::buildOptions
  ([10860](https://github.com/civicrm/civicrm-core/pull/10860))**

  Replace (some not all) CRM_Core_OptionGroup::values with
  CRM_Activity_BAO_ActivityContact::buildOptions where it is safe to do so (ie.
  parameters map directly).

- **[CRM-20927](https://issues.civicrm.org/jira/browse/CRM-20927)  Allow
  `civicrm_menu` to store new data in generic column
  ([10858](https://github.com/civicrm/civicrm-core/pull/10858)) (completes
  previous work)**

  The schema change is moved to a PHP-based upgrade task rather than a SQL
  incremental upgrade query template.

- **[CRM-21036](https://issues.civicrm.org/jira/browse/CRM-21036) Change
  deprecated comments to tags so phpstorm marks functions as deprecated
  ([10825](https://github.com/civicrm/civicrm-core/pull/10825))**

- **[CRM-21023](https://issues.civicrm.org/jira/browse/CRM-21023) Replace
  deprecated code and hardcoded IDs with pseudoconstants in Activity BAO
  ([10816](https://github.com/civicrm/civicrm-core/pull/10816))**

- **(NFC) SettingsStack - Finish incomplete docblock
  ([10950](https://github.com/civicrm/civicrm-core/pull/10950))**

- **Reinstate accidentally deleted test.
  ([10938](https://github.com/civicrm/civicrm-core/pull/10938))**

- **NFC remove some unused vars, fix comment
  ([10886](https://github.com/civicrm/civicrm-core/pull/10886))**

- **Renamed test class.
  ([10730](https://github.com/civicrm/civicrm-core/pull/10730))**

- **Fix PHP Warnings. Replace fatal with statusBounce. Mark breadcrumbs
  parameter as array instead of string so editors don't give a warning
  ([10888](https://github.com/civicrm/civicrm-core/pull/10888))**

- **(NFC) Update contributor-key.yml
  ([10894](https://github.com/civicrm/civicrm-core/pull/10894))**

- **(NFC) Improve docs in CONTRIBUTING.md
  ([10853](https://github.com/civicrm/civicrm-core/pull/10853))**

- **(NFC) SettingsStack - Add test coverage for new helper class
  ([10867](https://github.com/civicrm/civicrm-core/pull/10867))**

- **[NFC] Simplify method of getting logged in contact ID
  ([10855](https://github.com/civicrm/civicrm-core/pull/10855))**

- **Update CONTRIBUTORS.txt
  ([10843](https://github.com/civicrm/civicrm-core/pull/10843))**

- **Update Jon Goldberg in CONTRIBUTORS.txt
  ([10840](https://github.com/civicrm/civicrm-core/pull/10840))**

- **Klaas Eikelboom (Kainuk Empowerment) is member of CiviCooP
  ([10812](https://github.com/civicrm/civicrm-core/pull/10812))**

- **(NFC) Lint civicrm.drush.inc
  ([473](https://github.com/civicrm/civicrm-drupal/pull/473))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

Aaron Jones; Abhikalak Consultants - Amal Sharma; AGH Strategies - Alice Frumin,
Andie Hunt; Agileware - Agileware Team, Justin Freeman; Australian Greens -
Seamus Lee; CEDC - Laryn Kragt Bakker; Circle Interactive - Dave Jenkins;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CiviFirst - John
Kirk; CompuCorp - Camilo Rodriguez; Coop SymbioTIC - Mathieu Lutfy; Eaiman
Shoshi; Freeform Solutions - Herb van den Dool; Fuzion - Jitendra Purohit; JMA
Consulting - Edsel Lopez, Monish Deb, Pradeep Nayak; John Kingsnorth; Joinery -
Allen Shaw; Ken West; Left Join Labs - Sean Madsen; Lemniscus - Noah Miller;
Lighthouse Design and Consulting - Brian Shaughnessy; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; myDropWizard - David
Snopek; Oxfam Germany - Thomas Schüttler; Progressive Technology Project - Jamie
McClelland; Randy Tobias; Tadpole Collective - Kevin Cristiano; Wikimedia
Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Barbara Miller; Black Brick Software - David Hayes;
Blackfly Solutions - Alan Dixon; Brian Hay; Brian McFee; British Humanist
Association - Andrew West, William Gordon; Christian Wach; Circle Interactive -
Andrew Walker, Martin Castle; CiviCoop - Jaap Jansma, Klaas Eikelboom; CiviDesk -
Nicolas Ganivet; Community Builders - Andrew Perry; CompuCorp - Guanhuan Chen,
Omar Abu Hussein; Dave D; Dave Greenberg; Dave Rolsky; David Hepper; Davis Media
Access - Darrick Servis; Deepak Srivastava; Donald Hirst; Donald Lobo; Effy
Elden; Electronic Frontier Foundation - Mark Burdett; eQuality Technology - Greg
Rundlett; Forest CRM Consulting - Tamar Meir; Fuzion - Chris Burgess, Peter
Davis; Greenleaf Advancement - Guy Iaccarino; Hemophilia of North Carolina -
Charles Register; JMA Consulting - Joe Murray; Joel Stevens; Johan Vervloet;
Klangsoft - David Reedy Jr; Korlon - Stuart Gaston; Lullabot - Nate Lampton;
Manish Zope; Marc Brazeau; Mathias Consulting - Cheryl Chase; Michal Mach;
National Democratic Institute - Evan Summers; Nubay Services - David Tarrant;
Openflows - Eric Goldhagen; Palante Technology Cooperative - Joseph Lacey; Phil
McKerracher; Rareș Pamfil; Responsive Development Technologies - Thomas
Nilefalk; Rex Keal; Richard van Oosterhout; Saurabh Batra; Semper IT - Karin
Gerritsen; SEN Magazine - Jeremy Nicholls; Shailesh Lende; Skvare - Mark Hanna;
Squiffle Consulting - Aidan Saunders; Steve Binkowski; Team Expansion - Greg
Harris; Tobias Lounsbury; Wikimedia Foundation - Elliott Eggleston

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please login to https://chat.civicrm.org/civicrm
and contact `@agh1`.
