# CiviCRM 5.40.0

Released August 5, 2021

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Move check for presence of the phone strip function to a Check (currently
  done whenever a phone number is edited)
  ([dev/core#27](https://lab.civicrm.org/dev/core/-/issues/27):
  [20757](https://github.com/civicrm/civicrm-core/pull/20757))**

  CiviCRM relies on a MySQL function to generate a numeric-only version of phone
  numbers.  This change adds a system check to ensure the function exists
  instead of checking for the function each time a phone number is added or
  edited.

- **Add calling function to deprecatedWarning log message
  ([20719](https://github.com/civicrm/civicrm-core/pull/20719))**

  Improves logging.

- **Add contact-summary-image region
  ([20662](https://github.com/civicrm/civicrm-core/pull/20662))**

  Adds a new region around the contact summary image.

- **Replace extension key with description in 'Add New' tab
  ([20720](https://github.com/civicrm/civicrm-core/pull/20720))**

  Improves the "Extensions" -> "Add New" form user experience by displaying the
  description below the extension name instead of the extension key.

- **User experience improvement - Remove the confusing mixed terminology used to
  describe Tags: "Tags (Categories)" and "Tag (Category)"
  ([20268](https://github.com/civicrm/civicrm-core/pull/20268))**

  Improves user experience by removing the term "Category" when referencing
  tags.

- **Improve output triggers when logged to file
  ([20472](https://github.com/civicrm/civicrm-core/pull/20472))**

  Improves output triggers when logged to a file by adding an asort, putting all
  the triggers into an array keyed by the statement and opening and closing the
  delimiters just once.

- **Show smarty E-notices when in debug mode
  ([20640](https://github.com/civicrm/civicrm-core/pull/20640))**

  Improves the user experience in debug mode by showing php notices (e.g.
  "undefined variable").

- **Add pseudoconstant to acl_entity_role
  ([20566](https://github.com/civicrm/civicrm-core/pull/20566))**

  Adds a pseudoconstant for `acl_entity_role`.

- **[php8-compact] Allow for CiviCRM to be installed by 3rd parties using
  composer on php8 systems
  ([20625](https://github.com/civicrm/civicrm-core/pull/20625))**

  Makes it so sites can install and update CiviCRM via CLI when their CLI uses
  PHP8.

### Afform and SearchKit

- **Searchkit display with event location data
  ([dev/core#2676](https://lab.civicrm.org/dev/core/-/issues/2676):
  [20746](https://github.com/civicrm/civicrm-core/pull/20746))**

  Adds LocBlock entity to display event location data in SearchKit.

- **SearchKit - Allow super admins to disable Search Display access checks
  ([20607](https://github.com/civicrm/civicrm-core/pull/20607))**

  Allows users with 'all CiviCRM permissions and ACLs' to configure a search
  display to bypass permission checks and display all records to the user.

- **SearchKit - Add translatable descriptions to entities
  ([20598](https://github.com/civicrm/civicrm-core/pull/20598))**

  Adds user-friendly descriptions to the top-level entities in SearchKit, and
  makes it possible to add them to other entities as well.

- **SearchKit - Show Pledge as a primary entity
  ([20589](https://github.com/civicrm/civicrm-core/pull/20589))**

  Shows Pledges as a primary entity in SearchKit, since it has its own tab on
  the contact summary screen.

- **SearchKit - Add ability to join on multi-select ContactRef fields
  ([20764](https://github.com/civicrm/civicrm-core/pull/20764))**

  Improves support for custom contact Reference fields in APIv4, SearchKit, and
  Afform. Makes it possible to save, search for, and filter by serialized
  (multi-select) custom Contact Reference fields.

### API version 4

- **Improve api consistency on custom field creation
  ([20743](https://github.com/civicrm/civicrm-core/pull/20743))**

  Makes it so the parameter "option_type" is not needed to create an
  option_value in APIv4.

- **APIv4 Explorer: show joins for write actions
  ([20731](https://github.com/civicrm/civicrm-core/pull/20731))**

  Displays information about joins for write operations in the API Explorer.

- **APIv4 - Add `@since` annotation to each entity
  ([20701](https://github.com/civicrm/civicrm-core/pull/20701))**

  Adds since version for each entity to APIv4 code documentation.

- **APIv4 - Allow FK dot notation in create/update/save actions
  ([20677](https://github.com/civicrm/civicrm-core/pull/20677))**

  Makes it possible to reference other entities during create without knowing
  their ID when using the APIv4. Makes it easier to package entities e.g. with
  civicrm_managed.

- **APIv4 - Add filter for entity tags
  ([20573](https://github.com/civicrm/civicrm-core/pull/20573))**

  Adds a SearchKit/APIv4 filter for tags similar to the "groups" filter recently
  added to SearchKit.

- **APIv4 - add is_current as a pseudo (calculated) field
  ([20586](https://github.com/civicrm/civicrm-core/pull/20586))**

  Adds an "is_current" field to SearchKit for relationships, events & campaigns.
  It checks that the record is active and has a non-past end date and a
  non-future start date.

- **APIv4 Explorer - When joining via EntityBridge, make bridge fields
  selectable ([20721](https://github.com/civicrm/civicrm-core/pull/20721))**

  Improves the APIv4 Explorer by displaying bridge fields.

- **Canonize API for storing translated data (Work Towards
  [dev/translation#67](https://lab.civicrm.org/dev/translation/-/issues/67):
  [20606](https://github.com/civicrm/civicrm-core/pull/20606) and
  [20584](https://github.com/civicrm/civicrm-core/pull/20584))**

  Adds APIv4 support for the "Translation" entity. Allows translation of fields
  which lack an explicit HTML type.

- **Apiv4 entity parity
  (Work Towards [dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [20553](https://github.com/civicrm/civicrm-core/pull/20553))**

  Adds a foreign key on civicrm_contribution_product.product_id.

### CiviContribute

- **Move financialACLs to a core extension (Work Towards
  [dev/core#2115](https://lab.civicrm.org/dev/core/-/issues/2115):
  [20761](https://github.com/civicrm/civicrm-core/pull/20761),
  [20762](https://github.com/civicrm/civicrm-core/pull/20762) and
  [20769](https://github.com/civicrm/civicrm-core/pull/20769))**

  Moves financial acl code out of APIv3 Contribution.create and assorted cleanup
  towards moving the Financial ACL code to an extension.

- **Proposal - make future recurring contribution instances modifiable & not
  fail if the only contribution is deleted. (Work Towards
  [dev/financial#6](https://lab.civicrm.org/dev/financial/-/issues/6):
  [20452](https://github.com/civicrm/civicrm-core/pull/20452),
  [20451](https://github.com/civicrm/civicrm-core/pull/20451) and
  [20450](https://github.com/civicrm/civicrm-core/pull/20450))**

  Work to make it possible to edit recurring contributions.

- **Make Order api easier to use for default price set
  ([20681](https://github.com/civicrm/civicrm-core/pull/20681))**

  Improves the order api by making it not necessary to figure out the details of
  the default price set when using it to create memberships.

### CiviSMS

- **Display SMS segment count when constructing a Mass SMS
  ([dev/core#1711](https://lab.civicrm.org/dev/core/-/issues/1711):
  [20722](https://github.com/civicrm/civicrm-core/pull/20722) and
  [20220](https://github.com/civicrm/civicrm-core/pull/20220))**

  Modifies the javascript that shows the character count when creating a SMS
  message so that it also shows how many SMS segments are required to send the
  message.

### WordPress Integration

- **Fail gracefully when errors are detected
  ([251](https://github.com/civicrm/civicrm-wordpress/pull/251))**

  Rewrites the error checking that the WordPress plugin performs and fails
  gracefully instead of throwing fatal errors and making WordPress inoperable.
  Introduces a "CiviCRM Troubleshooting" page to help diagnose and fix problems.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Regression: Smart group rebuild in default config crashes cron
  ([dev/core#2687](https://lab.civicrm.org/dev/core/-/issues/2687):
  [20835](https://github.com/civicrm/civicrm-core/pull/20835))**

- **Syntax errors when loading sample data
  ([dev/drupal#161](https://lab.civicrm.org/dev/drupal/-/issues/161):
  [20925](https://github.com/civicrm/civicrm-core/pull/20925))**

- **During upgrade ConfigAndLog has errors about crm-l10n.js for every upgrade
  step because assets aren't built during upgrade
  ([dev/core#2666](https://lab.civicrm.org/dev/core/-/issues/2666):
  [20890](https://github.com/civicrm/civicrm-core/pull/20890))**

- **Exporting in localized civicrm crashes due to long translation for
  preferred_mail_format varchar(8) field.
  ([dev/core#2645](https://lab.civicrm.org/dev/core/-/issues/2645):
  [20626](https://github.com/civicrm/civicrm-core/pull/20626))**

- **failing update Smart Groups for installs with none
  ([dev/core#2659](https://lab.civicrm.org/dev/core/-/issues/2659):
  [20756](https://github.com/civicrm/civicrm-core/pull/20756))**

- **Menu link for "New Tag" doesn't quite work
  ([dev/core#2660](https://lab.civicrm.org/dev/core/-/issues/2660):
  [20686](https://github.com/civicrm/civicrm-core/pull/20686))**

  Points the "New Tag" menu link to form to create a new tag instead of "Manage
  Tags" form.

- **Special characters in password cause trouble.
  ([dev/core#2663](https://lab.civicrm.org/dev/core/-/issues/2663):
  [20713](https://github.com/civicrm/civicrm-core/pull/20713))**

- **Upgrade to Nightly (5.40.alpha1) from Stable (5.38.1) fails with DB Error:
  constraint violation
  ([dev/core#2680](https://lab.civicrm.org/dev/core/-/issues/2680):
  [20814](https://github.com/civicrm/civicrm-core/pull/20814))**

- **[php8-compact] Add in more protection for unset variables in various smarty
  templates ([20546](https://github.com/civicrm/civicrm-core/pull/20546) and
  [20547](https://github.com/civicrm/civicrm-core/pull/20547))**

- **Force cleanup of setting value type "checkboxes" when is empty
  ([20600](https://github.com/civicrm/civicrm-core/pull/20600))**

  Fixes a bug where custom settings of the type "checkboxes" with no checked
  values were not saving to the database correctly.

- **Fix activity_date_time_relative filter when `preserve_activity_tab_filter`
  setting is on ([20602](https://github.com/civicrm/civicrm-core/pull/20602))**

- **Support saving more than 25 records in Profile.submit api
  ([20744](https://github.com/civicrm/civicrm-core/pull/20744))**

- **Fix schema support for composite primary keys
  ([20705](https://github.com/civicrm/civicrm-core/pull/20705))**

- **Fix sorting for drop triggers
  ([20693](https://github.com/civicrm/civicrm-core/pull/20693))**

- **Fix Schema calculation of usePrefix to cope with rpow:
  ([20471](https://github.com/civicrm/civicrm-core/pull/20471))**

- **Fixed url ([20641](https://github.com/civicrm/civicrm-core/pull/20641))**

- **Ensure custom group name does not conflict with existing field
  ([20694](https://github.com/civicrm/civicrm-core/pull/20694))**

- **Force the right path in github action script
  ([20688](https://github.com/civicrm/civicrm-core/pull/20688))**

  The original script ran in a repo called civicrm-regen, but because the name
  of this repo is civicrm-core and hence the github workspace folder contains
  the literal "civicrm-core" in it, the civicrm.config.php file determines that
  this must be a composer install, and so it gets the path to
  civicrm.settings.php wrong.

- **Always assign mode to smarty
  ([20664](https://github.com/civicrm/civicrm-core/pull/20664))**

- **AngularLoader - Emit warning when setModules method is used.
  ([20628](https://github.com/civicrm/civicrm-core/pull/20628))**

  Emits a warning when extensions do something that could potentially cause
  problems with other extensions.

- **Throw exception when baoName is not found
  ([20696](https://github.com/civicrm/civicrm-core/pull/20696) and
  [20742](https://github.com/civicrm/civicrm-core/pull/20742))**

- **Convert Notes to use option_group instead of hardcoded list
  ([20554](https://github.com/civicrm/civicrm-core/pull/20554))**

- **Fix a few more undefined template vars
  ([20577](https://github.com/civicrm/civicrm-core/pull/20577) and
  [20684](https://github.com/civicrm/civicrm-core/pull/20684))**

- **CKEditor - Fix .tpl insertion on every form
  ([20846](https://github.com/civicrm/civicrm-core/pull/20846))**

- **Fix undefined tpl vars in CiviReport
  ([20797](https://github.com/civicrm/civicrm-core/pull/20797))**

- **smarty notice - title is only set for a list of existing report instances
  ([20771](https://github.com/civicrm/civicrm-core/pull/20771))**

- **smarty notice - confirm_message is usually irrelevant in report listings
 ([20772](https://github.com/civicrm/civicrm-core/pull/20772))**

- **Minor tpl simplificaiton, notice reduction
  ([20663](https://github.com/civicrm/civicrm-core/pull/20663))**

- **Fix undefined tpl variables on contact summary
  ([20659](https://github.com/civicrm/civicrm-core/pull/20659))**

- **Some php warnings on new case
  ([20712](https://github.com/civicrm/civicrm-core/pull/20712))**

- **Remove deprecated use of format money
  ([20697](https://github.com/civicrm/civicrm-core/pull/20697))**

- **Fix possibly undefined custom groupTree tpl variable
  ([20737](https://github.com/civicrm/civicrm-core/pull/20737))**

- **Fix undefined tpl vars on contact summary page
  ([20754](https://github.com/civicrm/civicrm-core/pull/20754))**

- **Tpl enotice fix
  ([20735](https://github.com/civicrm/civicrm-core/pull/20735))**

- **Fix undefined indexes in tpls
  ([20781](https://github.com/civicrm/civicrm-core/pull/20781))**

- **Enotice fix Remove references to savedFieldMapping in page 2 of the import
  ([20738](https://github.com/civicrm/civicrm-core/pull/20738))**

- **Fix undefined tpl vars on custom field page
  ([20726](https://github.com/civicrm/civicrm-core/pull/20726))**

- **Fix often undefined variable $row.class in tpl tables
  ([20725](https://github.com/civicrm/civicrm-core/pull/20725))**

- **Throw exception rather than allow php fail
  ([20565](https://github.com/civicrm/civicrm-core/pull/20565))**

  Throws an exception rather than allow php fail when the api class is not
  found.

- **Proposal - store metadata on membership renewal on line item (Work Towards
  [dev/membership#29](https://lab.civicrm.org/dev/membership/-/issues/29):
  [20672](https://github.com/civicrm/civicrm-core/pull/20672))**

  Adds a new column to the civicrm_line_item table: membership_num_terms.

### Afform and SearchKit

- **Afform - cosmetic fixes in palette panel
  ([20755](https://github.com/civicrm/civicrm-core/pull/20755))**

- **Search-kit - declaring joins breaks deduping
  ([dev/core#2656](https://lab.civicrm.org/dev/core/-/issues/2656):
  [20631](https://github.com/civicrm/civicrm-core/pull/20631) and
  [20639](https://github.com/civicrm/civicrm-core/pull/20639))**

- **SearchKit - use primary_key info instead of assuming 'id'
  ([20763](https://github.com/civicrm/civicrm-core/pull/20763))**

  Fixes a bug in SearchKit when dealing with entities without "id" as their
  primary key field.

- **SearchKit - Remove automatic filter from address
  ([20803](https://github.com/civicrm/civicrm-core/pull/20803))**

  Usability fix for SearchKit - stops automatically add "Location Type" to the
  search when joining with Address.

- **OR term in WHERE clause crashes Search Kit
  ([dev/report#71](https://lab.civicrm.org/dev/report/-/issues/71):
  [20824](https://github.com/civicrm/civicrm-core/pull/20824))**

  Fixes an error when saving or opening a search with an OR group in a clause.

### API version 4

- **APIv4 - Silently ignore non-permissioned fields instead of throwing
  exceptions ([20724](https://github.com/civicrm/civicrm-core/pull/20724))**

- **APIv4 - Fix same-table joins and remove unused code
  ([20715](https://github.com/civicrm/civicrm-core/pull/20715))**

- **APIv4 - Don't assume the identifier field for a table is named 'id'
  ([20707](https://github.com/civicrm/civicrm-core/pull/20707) and
  [20749](https://github.com/civicrm/civicrm-core/pull/20749))**

- **APIv4 - Deprecate Entity::getLinks action
  ([20727](https://github.com/civicrm/civicrm-core/pull/20727))**

- **APIv4 - Deprecate passing 'id' to basic actions
  ([20765](https://github.com/civicrm/civicrm-core/pull/20765))**

- **APIv4 Explorer - Only apply default limit 25 for "get" action
  ([20698](https://github.com/civicrm/civicrm-core/pull/20698))**

- **Failing api4 test
  api.v4.Action.CreateWithOptionGroupTest.testWithCustomDataForMultipleContacts
  ([dev/core#2699](https://lab.civicrm.org/dev/core/-/issues/2699):
  [20928](https://github.com/civicrm/civicrm-core/pull/20928))**

### CiviCase

- **Case Manager is not shown for closed cases.
  ([dev/core#542](https://lab.civicrm.org/dev/core/-/issues/542) and
  [dev/core#1947](https://lab.civicrm.org/dev/core/-/issues/1947):
  [19737](https://github.com/civicrm/civicrm-core/pull/19737))**

  Ensures inactive active case role are shown for closed cases.

- **Some php warnings on case dashboard
  ([20711](https://github.com/civicrm/civicrm-core/pull/20711))**

- **smarty notice - case dashboard when no upcoming/recent cases
  ([20770](https://github.com/civicrm/civicrm-core/pull/20770))**

- **smarty notices - New case screen - Case.hlp
  ([20795](https://github.com/civicrm/civicrm-core/pull/20795))**

- **Error when sorting case roles table by end date
  ([20728](https://github.com/civicrm/civicrm-core/pull/20728))**

### CiviContribute

- **Error submitting contribution form if ""is_monetary=0""
  ([dev/wordpress#109](https://lab.civicrm.org/dev/wordpress/-/issues/109):
  [#20929](https://github.com/civicrm/civicrm-core/pull/20929))**

- **Can't remove previously-added currencies
  ([dev/financial#175](https://lab.civicrm.org/dev/financial/-/issues/175):
  [20627](https://github.com/civicrm/civicrm-core/pull/20627))**

- **civicrm/payment/form url got empty currency argument in backoffice live CC
  form ([dev/financial#150](https://lab.civicrm.org/dev/financial/-/issues/150):
  [18517](https://github.com/civicrm/civicrm-core/pull/18517))**

- **"Non-static method CRM_Financial_Form_BatchTransaction::links() should not
  be called statically" when viewing accounting batch
  ([dev/core#2647](https://lab.civicrm.org/dev/core/-/issues/2647):
  [20691](https://github.com/civicrm/civicrm-core/pull/20691))**

- **pre hook is not triggered for LineItem delete
  ([dev/core#2657](https://lab.civicrm.org/dev/core/-/issues/2657):
  [20644](https://github.com/civicrm/civicrm-core/pull/20644))**

- **Undefined variable ids in CRM\Core\Payment\AuthorizeNetIPN.php
  ([dev/core#2685](https://lab.civicrm.org/dev/core/-/issues/2685):
  [20818](https://github.com/civicrm/civicrm-core/pull/20818))**

- **Send pcp notification only when the contribution is completed
  ([20523](https://github.com/civicrm/civicrm-core/pull/20523))**

- **Add missing "View Recurring Contribution" link to contribution view
  ([20750](https://github.com/civicrm/civicrm-core/pull/20750))**

  Add missing "View Recurring Contribution" link to contribution view when
  displaying line items.

### CiviEvent

- **Fix bug where only one participant registration is completed
  ([20654](https://github.com/civicrm/civicrm-core/pull/20654))**

### CiviMail

- **Unwanted mail blast sent by Scheduled Reminders
  ([dev/core#365](https://lab.civicrm.org/dev/core/-/issues/365):
  [20432](https://github.com/civicrm/civicrm-core/pull/20432) and
  [19973](https://github.com/civicrm/civicrm-core/pull/19973))**

  Adds Effective start and end date to the Schedule Reminder UI.

- **Specifying a "Selection Method" without a location type gives a DB error
  ([dev/mail#96](https://lab.civicrm.org/dev/mail/-/issues/96):
  [20536](https://github.com/civicrm/civicrm-core/pull/20536))**

- **Mailing label prints name twice
  ([dev/core#2681](https://lab.civicrm.org/dev/core/-/issues/2681):
  [20783](https://github.com/civicrm/civicrm-core/pull/20783))**

- **Fix invalid defaults for Mailing.update_email_resetdate API
  ([20751](https://github.com/civicrm/civicrm-core/pull/20751))**

- **Use mysql to set mailing.created_date
  ([20630](https://github.com/civicrm/civicrm-core/pull/20630))**

### Drupal Integration

- **hook_civicrm_buildProfile not working on Drupal 8
  ([dev/drupal#113](https://lab.civicrm.org/dev/drupal/-/issues/113):
  [65](https://github.com/civicrm/civicrm-drupal-8/pull/65))**

## <a name="misc"></a>Miscellany

- **Unused smarty variable
  ([20796](https://github.com/civicrm/civicrm-core/pull/20796))**

- **Remove unreachable code from admin page
  ([20642](https://github.com/civicrm/civicrm-core/pull/20642))**

- **replace unnecessary function call with string literal
  ([20634](https://github.com/civicrm/civicrm-core/pull/20634))**

- **APIv4 - Remove POC code leftover from early alpha development
  ([20709](https://github.com/civicrm/civicrm-core/pull/20709))**

- **Move upgrade code to correct version
  ([20643](https://github.com/civicrm/civicrm-core/pull/20643))**

- **Move determination of priceSetID to the internal order class
  ([20669](https://github.com/civicrm/civicrm-core/pull/20669))**

- **CRM_Utils_Array::asColumns() - Add helper to rotate a matrix (from rows to
  columns) ([20788](https://github.com/civicrm/civicrm-core/pull/20788))**

- **CRM_Utils_Array - Implement pathUnset() method
  ([20787](https://github.com/civicrm/civicrm-core/pull/20787))**

- **Handle participant payment create in line item
  ([20790](https://github.com/civicrm/civicrm-core/pull/20790))**

- **APIv4 Explorer - Render joins using addJoin function in OOP
  ([20723](https://github.com/civicrm/civicrm-core/pull/20723))**

- **Deprecate duplicate getLoggedInContactID() function
  ([20321](https://github.com/civicrm/civicrm-core/pull/20321))**

- **Remove deprecated function
  ([20760](https://github.com/civicrm/civicrm-core/pull/20760))**

- **Hopefully fix time rollover problem in MessageTemplateTest
  ([20714](https://github.com/civicrm/civicrm-core/pull/20714))**

- **Extract feeBlock to it's own tpl
  ([20679](https://github.com/civicrm/civicrm-core/pull/20679))**

- **Deprecate passing in 'null' for tax
  ([20671](https://github.com/civicrm/civicrm-core/pull/20671))**

- **Add test validation for Membership & participant payments
  ([20621](https://github.com/civicrm/civicrm-core/pull/20621))**

- **Fix up on invalid test data
  ([20667](https://github.com/civicrm/civicrm-core/pull/20667))**

- **Fix test to use valid amounts
  ([20668](https://github.com/civicrm/civicrm-core/pull/20668))**

- **Fix test to use valid financials
  ([20676](https://github.com/civicrm/civicrm-core/pull/20676))**

- **Improve CustomGroupTest
  ([20617](https://github.com/civicrm/civicrm-core/pull/20617))**

- **Test cleanup - specify return
  ([20570](https://github.com/civicrm/civicrm-core/pull/20570))**

- **Clean up code to determine line items for membership batch entry
  ([20779](https://github.com/civicrm/civicrm-core/pull/20779))**

- **AssetBuilderTest - Raise threshold for timeout
  ([20810](https://github.com/civicrm/civicrm-core/pull/20810))**

- **Reduce test api calls with no 'return'
  ([20574](https://github.com/civicrm/civicrm-core/pull/20574))**

- **Fix BaseIPN test to (mostly) pass invalid financials checks
  ([20785](https://github.com/civicrm/civicrm-core/pull/20785))**

- **Fix test set up to user Order api
  ([20780](https://github.com/civicrm/civicrm-core/pull/20780))**

- **[REF] Membership api for v4 (Work Towards
  [dev/core#2634](https://lab.civicrm.org/dev/core/-/issues/2634):
  [20759](https://github.com/civicrm/civicrm-core/pull/20759))**

- **[Ref] Remove (more) unreachable code from order api
  ([20793](https://github.com/civicrm/civicrm-core/pull/20793))**

- **[REF] Add in template guard for  not being always set as per html format
  ([20747](https://github.com/civicrm/civicrm-core/pull/20747))**

- **[REF] Remove isPayLater from membership batch screen
  ([20396](https://github.com/civicrm/civicrm-core/pull/20396))**

- **[REF] Extend testing on membership batch entry & minor cleanup
  ([20394](https://github.com/civicrm/civicrm-core/pull/20394))**

- **[REF] Fix trying to access array offset from boolean value
  ([20734](https://github.com/civicrm/civicrm-core/pull/20734))**

- **[REF] Alter new Setup process to use CiviCRM's Event Dispatcher
  ([20717](https://github.com/civicrm/civicrm-core/pull/20717))**

- **[REF] - Improve efficiency of APIv4 GetInfo
  ([20708](https://github.com/civicrm/civicrm-core/pull/20708))**

- **REF - Get Contact Summary tab counts after calling hook to avoid wasting
  time ([20673](https://github.com/civicrm/civicrm-core/pull/20673))**

- **[REF] Remove always false if
  ([20653](https://github.com/civicrm/civicrm-core/pull/20653))**

- **[REF] Extract CKEditor into its own core extension
  ([20392](https://github.com/civicrm/civicrm-core/pull/20392))**

- **(REF) crmUi - Support onCrmUiSelect for using select2 as a picklist
  ([20789](https://github.com/civicrm/civicrm-core/pull/20789))**

- **[REF] Tidy up param transforms
  ([20778](https://github.com/civicrm/civicrm-core/pull/20778))**

- **[REF] Follow up clean up - remove contribution_mode
  ([20656](https://github.com/civicrm/civicrm-core/pull/20656))**

- **[REF] Remove unnecessary variable wrangling in case roles section
  ([20729](https://github.com/civicrm/civicrm-core/pull/20729))**

- **[REF] Follow up fix to fixing note entity tables in views
  ([144](https://github.com/civicrm/civicrm-backdrop/pull/144))**

- **[REF] Follow up fix to fixing note entity tables in views
  ([646](https://github.com/civicrm/civicrm-drupal/pull/646))**

- **[NFC] - update code comment
  ([20599](https://github.com/civicrm/civicrm-core/pull/20599))**

- **[NFC] Fix test failure on MySQL8 because of lack of order in API
  ([20605](https://github.com/civicrm/civicrm-core/pull/20605))**

- **[NFC] [Test] Remove duplicate cleanup
  ([20647](https://github.com/civicrm/civicrm-core/pull/20647))**

- **[NFC] [TEST] cleanup, more use of return in ActivityTest
  ([20633](https://github.com/civicrm/civicrm-core/pull/20633))**

- **[NFC] Cleanup on membership test
  ([20636](https://github.com/civicrm/civicrm-core/pull/20636))**

- **[NFC] [Test] Remove duplicate cleanup
  ([20637](https://github.com/civicrm/civicrm-core/pull/20637))**

- **[NFC] Cleanup on contribution v3 api test
  ([20638](https://github.com/civicrm/civicrm-core/pull/20638))**

- **[NFC] Add in unit test to lock in the fix for the is_deleted in where clause
  issue ([20733](https://github.com/civicrm/civicrm-core/pull/20733))**

- **[NFC] Afform - Regenerate civix files
  ([20615](https://github.com/civicrm/civicrm-core/pull/20615))**

- **[NFC] Fix test setup on a couple of tests to make them pass in php8
  ([20614](https://github.com/civicrm/civicrm-core/pull/20614))**

- **[NFC] Update various npm depdencies used only in unit testing
  ([20748](https://github.com/civicrm/civicrm-core/pull/20748))**

- **[NFC] Improve use of return parameters in ContributionPage test class
  ([20648](https://github.com/civicrm/civicrm-core/pull/20648))**

- **[NFC] Unit test for 20602
  ([20745](https://github.com/civicrm/civicrm-core/pull/20745))**

- **[NFC] Remove boilerplate comment block from APIv4 classes
  ([20700](https://github.com/civicrm/civicrm-core/pull/20700))**

- **[NFC] Github action script to run regen.sh for you
  ([20680](https://github.com/civicrm/civicrm-core/pull/20680))**

- **[NFC] Regenerate ContributeProduct DAO and also fix search_kit install on
  MySQL 5.6 on test boxes
  ([20674](https://github.com/civicrm/civicrm-core/pull/20674))**

- **[NFC] Fixes an issue in this unit test where we are trying to do an array
  access on an integer
  ([20652](https://github.com/civicrm/civicrm-core/pull/20652))**

- **[NFC] [Test] Cleanup on membership type test
  ([20649](https://github.com/civicrm/civicrm-core/pull/20649))**

- **[NFC/Unit test] - Add a test for getCaseRoles when there's a lot of roles
  assigned ([20657](https://github.com/civicrm/civicrm-core/pull/20657))**

- **[NFC] [TEST] cleanup, more use of return in AddressTest
  ([20635](https://github.com/civicrm/civicrm-core/pull/20635))**

- **[NFC] [Test] Specify return values on get calls
  ([20632](https://github.com/civicrm/civicrm-core/pull/20632))**

- **[TEST][NFC] CiviCRM reaching MySQL join limit (Work Towards
  [dev/core#1191](https://lab.civicrm.org/dev/core/-/issues/1191):
  [20618](https://github.com/civicrm/civicrm-core/pull/20618) and
  [20622](https://github.com/civicrm/civicrm-core/pull/20622))**

- **[php8-compact][NFC] Update testGroupClause unit test to work on php8
  ([20624](https://github.com/civicrm/civicrm-core/pull/20624))**

- **[php8-compact][REF] Fix failing custom group test on php8 by better handling
  strings in 2nd key of the extends array and also validating the child and main
  entity work ([20616](https://github.com/civicrm/civicrm-core/pull/20616))**

- **[php8-compact] Fix APIv4 Group Concat Test by setting dataType to be NULL if
  the first expression is a SQL Function
  ([20655](https://github.com/civicrm/civicrm-core/pull/20655))**

- **[php8-compact]  Fix issues with participant message templates causing Event
  Tests to fail ([20613](https://github.com/civicrm/civicrm-core/pull/20613))**

- **[php8-compact] Add in guards into common templates to assit with fixing test
  failures on php8
  ([20543](https://github.com/civicrm/civicrm-core/pull/20543))**

- **[php8-compact] Fix Array to String in formButtons in CRM_Core_FormTest
  ([20608](https://github.com/civicrm/civicrm-core/pull/20608))**

- **[php8-compact] Fix Event Form test for php8 by setting totalAmount in the
  form params ([20623](https://github.com/civicrm/civicrm-core/pull/20623))**

- **[php8-compat] Alternate to the alternate for testOpeningForms
  ([20603](https://github.com/civicrm/civicrm-core/pull/20603))**

- **[php8-compact] Fix apiv4 tests in php8 by not incrementing an array
  ([20594](https://github.com/civicrm/civicrm-core/pull/20594))**

- **[php8-compact] Further test fixes for php8
  ([20597](https://github.com/civicrm/civicrm-core/pull/20597))**

- **[php8-compact] Fix failing AuthorizeNetIPN tests on php8
  ([20596](https://github.com/civicrm/civicrm-core/pull/20596))**

- **[php8-compact] Fix failing CRM_Core_InvokeTest on php8
  ([20595](https://github.com/civicrm/civicrm-core/pull/20595))**

- **[php8-compact] Fix Session Test errors in php8
  ([20593](https://github.com/civicrm/civicrm-core/pull/20593))**

- **[php8-compact] Fix Case Activity Message Template to fix test failure in
  php8 ([20592](https://github.com/civicrm/civicrm-core/pull/20592))**

- **[php8-compact]  Fix PDF Letter Test by ensuring that all actual DB fields
  are in the tokens array and also by resetting the static cache of tokens
  ([20591](https://github.com/civicrm/civicrm-core/pull/20591))**

- **[php8-compact] Add in guards into various templates to fix the
  CRM_Contact_Form_IndividualTest suite
  ([20579](https://github.com/civicrm/civicrm-core/pull/20579))**

- **[php8-compact] Fixes test failures in the
  CRM_Contribute_Form_ContributionTest class due to template issues
  ([20581](https://github.com/civicrm/civicrm-core/pull/20581))**

- **[php8-compact] Fix Dashboard Tests by adding in if guards into smarty
  templates ([20575](https://github.com/civicrm/civicrm-core/pull/20575))**

- **[php8-compact] Add in guards into various templates to fix issues in test
  runs on php8 ([20544](https://github.com/civicrm/civicrm-core/pull/20544))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle, Justin
Freeman; Akos Garai; Australian Greens - John Twyman; Blackfly Solutions - Alan
Dixon; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop - Jaap
Jansma; CiviCRM - Coleman Watts, Tim Otten; CompuCorp - Debarshi Bhaumik; Dave
D; Gokhalemethod- Sadashiv; iXiam - Luciano Spiegel; JMA Consulting - Monish
Deb, Seamus Lee; Lemniscus - Noah Miller; Lighthouse Consulting and Design -
Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; Skvare - Sunil Pawar; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Bob Silvern; CiviCoop - Klaas Eikelboom; CiviDesk -
Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy; Freeform Solutions - Herb van
den Dool; Fuzion - Jitendra Purohit; JMA Consulting - Joe Murray; Ray Wright;
Semper IT - Karin Gerritsen; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Tech To The People - Xavier Dutoit; Third Sector
Design - Michael McAndrew; Web Access - Kurund Jalmi

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
