# CiviCRM 5.45.0

Released January 5, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**


## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add CiviX class in Core? (Work Towards
  [civix#175](https://github.com/totten/civix/issues/175):
  [22198](https://github.com/civicrm/civicrm-core/pull/22198) and
  [22199](https://github.com/civicrm/civicrm-core/pull/22199))**

  Adds support for mixins to civix and updates core extensions to use them.

- **Escape-on-Input => Escape-on-Output (Work Towards
  [dev/core#1328](https://lab.civicrm.org/dev/core/-/issues/1328):
  [21956](https://github.com/civicrm/civicrm-core/pull/21956))**

  Adds option to enable escape-on-output.

- **APIv4 Explorer - Optionally view results in PHP format
  ([22010](https://github.com/civicrm/civicrm-core/pull/22010))**

  Improves the APIv4 Explorer UX by showing output in PHP format as well as
  JSON.

- **APIv4 - Add SortableEntity type which auto-adjusts weights
  ([22137](https://github.com/civicrm/civicrm-core/pull/22137))**

  Gives APIv4 the ability to manage the "weight" of certain entities.

- **APIv4 - Add export action for managed entities
  ([22014](https://github.com/civicrm/civicrm-core/pull/22014))**

  Adds a new APIv4 export action which generates an exportable array suitable
  for use in a .mgd.php file.

- **APIv4 - Opt-in more ManagedEntity types
  ([22068](https://github.com/civicrm/civicrm-core/pull/22068))**

  Adds the ManagedEntity trait to a number of entities that are commonly used
  for configuration, making it possible to work with them as APIv4 managed
  entities.

- **SearchKit - Animated loading skeleton
  ([22019](https://github.com/civicrm/civicrm-core/pull/22019))**

  Shows a wireframe "skeleton" while loading results in SearchKit. Improves the
  user perception of load times.

- **SearchKit - tabbed display for custom vs packaged searches
  ([21986](https://github.com/civicrm/civicrm-core/pull/21986))**

  Splits the SearchKit admin UI in to 2 tabs - one for custom (locally-created)
  searches, and one for packaged searches (defined in extensions). Adds a
  "revert" button for packaged searches.

- **SearchKit - Add default text/image to displays; support custom file fields
  ([21992](https://github.com/civicrm/civicrm-core/pull/21992))**

  Allows for "placeholder" text in a search display when a column value is
  empty. Also works for image fields. Image fields now support custom file
  fields to display images out-of-the-box.

- **SearchKit - Add drag-sortable weight functionality
  ([22081](https://github.com/civicrm/civicrm-core/pull/22081))**

  Allows SearchKit table displays to be drag-sortable.

- **SearchKit - enable search by case role
  ([22121](https://github.com/civicrm/civicrm-core/pull/22121))**

  Permits searching for contacts by case role in SearchKit.

- **SearchKit - Allow searches of OptionValues, LocationTypes, CustomFields
  ([22151](https://github.com/civicrm/civicrm-core/pull/22151))**

  Flips the switch on a few entities to be searchable in SearchKit, with an eye
  toward more UIs being built with it.

- **SearchKit - Improve UX for refresh after editing
  ([22125](https://github.com/civicrm/civicrm-core/pull/22125))**

  Makes editing records faster and easier, and fixes a bug where the pager
  count would not be correctly updated.

- **SearchKit - Improve search listing UI
  ([22114](https://github.com/civicrm/civicrm-core/pull/22114))**

  Makes a few improvements to the main SearchKit screen (the tabbed listing of
  Saved Searches) specifically:

  - More responsive switching between tabs
  - Bookmarkable urls for each tab
  - Fixes the "modified" column for packaged searches, only showing a value if
    the packaged version has been overridden
  - Only shows "revert" button when a packaged search has been overridden

- **Update Afform & search kit info
  ([22126](https://github.com/civicrm/civicrm-core/pull/22126))**

  Updates SearchKit and Afform info.xml files with more helpful and less
  confusing titles, descriptions and links.

- **Afform - Add table of submission results
  ([22009](https://github.com/civicrm/civicrm-core/pull/22009))**

  Uses a SearchDisplay in an Afform to display form submissions.

- **Afform - Display the extension in which an Afform is packaged
  ([21960](https://github.com/civicrm/civicrm-core/pull/21960))**

  Displays extension name in the UI for packaged Afforms.

- **Make more hardcoded strings available for translation
  ([21994](https://github.com/civicrm/civicrm-core/pull/21994))**

  Improves translation.

- **Alter default frequency for scheduled reminders job
  ([dev/core#2916](https://lab.civicrm.org/dev/core/-/issues/2916):
  [21835](https://github.com/civicrm/civicrm-core/pull/21835))**

  Changes the scheduled reminder job to default to run hourly instead of daily.

- **Display higher severity status checks first
  ([22143](https://github.com/civicrm/civicrm-core/pull/22143))**

  Improves user experience on the status page by displaying highest severity
  status checks first.

- **Sort list of extensions alphabetically in 'Extensions ok' check
  ([22142](https://github.com/civicrm/civicrm-core/pull/22142))**

  Improves user experience by sorting the list of extensions alphabetically in
  the 'Extensions ok' check.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Email to Activity processing: If there's a matching org contact and no
  matching individual, then file on the org instead of creating a new individual
  ([dev/core#2872](https://lab.civicrm.org/dev/core/-/issues/2872):
  [21983](https://github.com/civicrm/civicrm-core/pull/21983))**

- **Activity redirects to search instead of view
  ([dev/core#2894](https://lab.civicrm.org/dev/core/-/issues/2894):
  [22088](https://github.com/civicrm/civicrm-core/pull/22088))**

- **Can't save extra custom fields when inline and required
  ([dev/core#2912](https://lab.civicrm.org/dev/core/-/issues/2912):
  [21936](https://github.com/civicrm/civicrm-core/pull/21936))**

- **Hidden submit buttons are confusing for keyboard users
  ([dev/core#2919](https://lab.civicrm.org/dev/core/-/issues/2919):
  [21854](https://github.com/civicrm/civicrm-core/pull/21854))**

- **some PDFs hard-code format to "a3 landscape", overriding default PDF format
  ([dev/core#2959](https://lab.civicrm.org/dev/core/-/issues/2959):
  [22098](https://github.com/civicrm/civicrm-core/pull/22098))**

- **All custom fields broken on edit forms
  ([dev/core#2973](https://lab.civicrm.org/dev/core/-/issues/2973):
  [22178](https://github.com/civicrm/civicrm-core/pull/22178))**

- **APIv4 Export - Fix logic for exporting pseudoconstant syntax
  ([22201](https://github.com/civicrm/civicrm-core/pull/22201))**

- **APIv4 - Add fixes & tests for domain-specific managed entities
  ([22173](https://github.com/civicrm/civicrm-core/pull/22173))**

- **Api v4 contact delete bug
  ([dev/core#2757](https://lab.civicrm.org/dev/core/-/issues/2757):
  [21232](https://github.com/civicrm/civicrm-core/pull/21232))**

- **APIv4 - Delete unused OptionList trait
  ([22158](https://github.com/civicrm/civicrm-core/pull/22158))**

- **APIv4 - Treat navigation permissions as array, add pseudoconstant for
  operator ([22160](https://github.com/civicrm/civicrm-core/pull/22160))**

- **APIv4 - Fix checkAccess for CiviCase or other entities with nonstandard
  class names ([22090](https://github.com/civicrm/civicrm-core/pull/22090))**

- **SearchKit with Form Builder when viewed on the front-end displays a CiviCRM
  breadcrumb trail which can duplicate the existing website breadcrumb trail
  ([22087](https://github.com/civicrm/civicrm-core/pull/22087))**

- **SearchKit - Fix undefined variable for searches of Afforms etc.
  ([22218](https://github.com/civicrm/civicrm-core/pull/22218))**

- **[Smarty variables] Consistently assign isAdmin at php layer
  ([22189](https://github.com/civicrm/civicrm-core/pull/22189))**

- **Smarty variables]  Remove isset from a.net
  ([22191](https://github.com/civicrm/civicrm-core/pull/22191))**

- **[Smarty variables] remove isset from Mail accounts
  ([22190](https://github.com/civicrm/civicrm-core/pull/22190))**

- **[Smarty variables] Remove another isset - user dashboard
  ([22181](https://github.com/civicrm/civicrm-core/pull/22181))**

- **Smarty variables]  Remove isset from relationship tab
  ([22177](https://github.com/civicrm/civicrm-core/pull/22177))**

- **[Smarty variables] [CiviCase] remove isset from case dashboard
  ([22176](https://github.com/civicrm/civicrm-core/pull/22176))**

- **[Smarty variables] - remove isset
  ([22185](https://github.com/civicrm/civicrm-core/pull/22185))**

- **[Smarty variables] Fix contribution tab to work with escape by default
  ([22179](https://github.com/civicrm/civicrm-core/pull/22179))**

- **[Smarty variables] The last isset....
  ([22196](https://github.com/civicrm/civicrm-core/pull/22196))**

- **Smarty variables]  Prevent settings form assigned html from being escaped
  ([22165](https://github.com/civicrm/civicrm-core/pull/22165))**

- **[Smarty variable][Civicase] remove isset
  ([22175](https://github.com/civicrm/civicrm-core/pull/22175))**

- **[Smarty variables] Remove isset from add new group form
  ([22184](https://github.com/civicrm/civicrm-core/pull/22184))**

- **[Smarty Variables] Remove isset from location type form
  ([22167](https://github.com/civicrm/civicrm-core/pull/22167))**

- **[Smarty variables] Remove issets from scheduled job screen
  ([22166](https://github.com/civicrm/civicrm-core/pull/22166))**

- **[Smarty variables] [custom data form] Template notice cleanup - make sane
  ([22138](https://github.com/civicrm/civicrm-core/pull/22138))**

- **[Smarty variables] [report test]Ensure smarty variables are consistently
  assigned in report
  ([22147](https://github.com/civicrm/civicrm-core/pull/22147))**

- **[Smarty variables] [Activity form] Ensure separation,tag are assigned to
  the template ([22152](https://github.com/civicrm/civicrm-core/pull/22152))**

- **[Smarty variables] Specify isRepeatingEntity when including
  ConfirmRepeatMode.tpl
  ([22155](https://github.com/civicrm/civicrm-core/pull/22155))**

- **[Smarty variables] Ensure groupElementType is always set
  ([22074](https://github.com/civicrm/civicrm-core/pull/22074))**

- **[Smarty variables] [contact summary]  Assign variable to determine whether
  to show email signature field
  ([22132](https://github.com/civicrm/civicrm-core/pull/22132))**

- **[Smarty variables] Use always-assigned isTagSet to determine if is tagset
  ([22154](https://github.com/civicrm/civicrm-core/pull/22154))**

- **[Smarty variables] [Activity form] Ensure activityTypeFile is always
  assigned ([22153](https://github.com/civicrm/civicrm-core/pull/22153))**

- **Remove issets from Activity search screen
  ([22180](https://github.com/civicrm/civicrm-core/pull/22180))**

- **Remove isset checks on isForm
  ([22174](https://github.com/civicrm/civicrm-core/pull/22174))**

- **Remove isset from custom data tpls
  ([22124](https://github.com/civicrm/civicrm-core/pull/22124))**

- **Remove issets from Options.tpl
  ([22079](https://github.com/civicrm/civicrm-core/pull/22079))**

- **Remove a bunch of isset from options.tpl
  ([22111](https://github.com/civicrm/civicrm-core/pull/22111))**

- **Remove isset from Datasource.tpl
  ([21988](https://github.com/civicrm/civicrm-core/pull/21988))**

- **Remove smarty isset in favour of always set
  ([22084](https://github.com/civicrm/civicrm-core/pull/22084))**

- **Escape-on-output: Cleanup addCampaignToSearch, remove isset
  ([22035](https://github.com/civicrm/civicrm-core/pull/22035))**

- **OptionValue - Fix checking if domain is set
  ([22095](https://github.com/civicrm/civicrm-core/pull/22095))**

- **Fix all the issets that affect ability to load contact summary page
  ([22030](https://github.com/civicrm/civicrm-core/pull/22030))**

- **Remove use of isset for info.tpl
  ([22028](https://github.com/civicrm/civicrm-core/pull/22028))**

- **Ensure smarty variable formTpl is set
  ([22018](https://github.com/civicrm/civicrm-core/pull/22018))**

- **Enotice fixes - ensure a couple more variables are consistently assigned
  ([22148](https://github.com/civicrm/civicrm-core/pull/22148))**

- **Fix broken extension page smarty assignment
  ([22168](https://github.com/civicrm/civicrm-core/pull/22168))**

- **Ensure custom fields properties are assigned to the template
  ([22139](https://github.com/civicrm/civicrm-core/pull/22139))**

- **Ensure context is always assigned
  ([22141](https://github.com/civicrm/civicrm-core/pull/22141))**

- **FormBuilder - Hide configuration options that do not apply to certain form
  types ([22127](https://github.com/civicrm/civicrm-core/pull/22127))**

- **Ensure CMSPrint variables are assigned to the template
  ([22134](https://github.com/civicrm/civicrm-core/pull/22134))**

- **Ensure tab headers are assigned, fix widget form test
  ([22135](https://github.com/civicrm/civicrm-core/pull/22135))**

- **Ensure buildForm is called to assign values
  ([22128](https://github.com/civicrm/civicrm-core/pull/22128))**

- **Update Fields.tpl
  ([22129](https://github.com/civicrm/civicrm-core/pull/22129))**

- **Add Colombia missing state
  ([22007](https://github.com/civicrm/civicrm-core/pull/22007))**

- **Use getEntityNameForTable() instead of getClassForTable(), as this might
  yield ambiguous results
  ([22116](https://github.com/civicrm/civicrm-core/pull/22116))**

- **Suppresses error logging on every page load when open_basedir restriction
  in effect: File(/CRM/Core/Smarty/plugins/) is not within the allowed path(s)
  ([21589](https://github.com/civicrm/civicrm-core/pull/21589))**

- **Bypass any default escaping for blog, getting started
  ([22119](https://github.com/civicrm/civicrm-core/pull/22119))**

- **Do not use default escaping on address display
  ([22120](https://github.com/civicrm/civicrm-core/pull/22120))**

- **Throw spaghetti
  ([22070](https://github.com/civicrm/civicrm-core/pull/22070))**

- **Allow "Download chart" text to be translated.
  ([22106](https://github.com/civicrm/civicrm-core/pull/22106))**

- **Contribution amounts configuration page is borked when translation contains
  apostrophe ([22091](https://github.com/civicrm/civicrm-core/pull/22091))**

- **Use smarty:nodefaults with smarty.get
  ([22082](https://github.com/civicrm/civicrm-core/pull/22082))**

- **Ensure masterAddress is always assigned
  ([22076](https://github.com/civicrm/civicrm-core/pull/22076))**

- **Ensure paramSubType is always set
  ([22075](https://github.com/civicrm/civicrm-core/pull/22075))**

- **Do not check is context is set, should always be
  ([22069](https://github.com/civicrm/civicrm-core/pull/22069))**

- **Fix typo in smarty template "gender_display"
  ([22066](https://github.com/civicrm/civicrm-core/pull/22066))**

- **Ensure context is always set
  ([22056](https://github.com/civicrm/civicrm-core/pull/22056))**

- **Ensure contactTag is always set
  ([22055](https://github.com/civicrm/civicrm-core/pull/22055))**

- **php8 - fix for breadcrumb fails during tests
  ([22059](https://github.com/civicrm/civicrm-core/pull/22059))**

- **Mark a few more token functions as deprected
  ([22044](https://github.com/civicrm/civicrm-core/pull/22044))**

- **Ensure gender_display is always set
  ([22047](https://github.com/civicrm/civicrm-core/pull/22047))**

- **ManagedEntities - Track modification and auto-update
  ([21989](https://github.com/civicrm/civicrm-core/pull/21989))**

- **Ensure userRecordUrl is always set- fixes enotice with escape-on-output
  ([22042](https://github.com/civicrm/civicrm-core/pull/22042))**

- **Fix tabs getting overwritten by double foreach loop
  ([22040](https://github.com/civicrm/civicrm-core/pull/22040))**

- **Ensure imageUrl is always set
  ([22031](https://github.com/civicrm/civicrm-core/pull/22031))**

- **Escape-on-output-proof enotice fixes
  ([22036](https://github.com/civicrm/civicrm-core/pull/22036))**

- **Do not smarty encode quicksearch html
  ([22033](https://github.com/civicrm/civicrm-core/pull/22033))**

- **Ensure action is set when loading contactFooter
  ([22029](https://github.com/civicrm/civicrm-core/pull/22029))**

- **Flip logic for determining if $section variable is set.
  ([22027](https://github.com/civicrm/civicrm-core/pull/22027))**

- **Ensure beginHookFormElements is assigned
  ([22000](https://github.com/civicrm/civicrm-core/pull/22000))**

- **CRM_Utils_File::isChildPath - Fix checking of non-existent paths
  ([22021](https://github.com/civicrm/civicrm-core/pull/22021))**

- **Ensure hookContentPlacement is assigned
  ([22001](https://github.com/civicrm/civicrm-core/pull/22001))**

- **Ensure that keys are set in tabValues before hitting smarty
  ([21991](https://github.com/civicrm/civicrm-core/pull/21991))**

- **Extract getGroupOrganizationUrl & ensure always assigned
  ([22002](https://github.com/civicrm/civicrm-core/pull/22002))**

- **Avoid default escaping for blog titles
  ([22172](https://github.com/civicrm/civicrm-core/pull/22172))**

- **PHP 8 compat - no optional param before required
  ([22210](https://github.com/civicrm/civicrm-core/pull/22210))**

- **tools/mixin/bin/test-all - Fix guard for EXT_DIR
 ([22204](https://github.com/civicrm/civicrm-core/pull/22204))**

- **DebugSubscriber - Fix test-suite compatibility with XDebug 3
  ([22197](https://github.com/civicrm/civicrm-core/pull/22197))**

- **ManagedEntities - Fix permission error during uninstallation
  (regression-fix)
  ([22188](https://github.com/civicrm/civicrm-core/pull/22188))**

- **Fix two English strings
  ([22097](https://github.com/civicrm/civicrm-core/pull/22097))**

- **OptionValue - Fix incorrect update of `is_default`
  ([22089](https://github.com/civicrm/civicrm-core/pull/22089))**

- **Fix missing currency for event registration when configured via
  "quick config" ([21966](https://github.com/civicrm/civicrm-core/pull/21966))**

- **don't overfill the prevnext cache when reserving for a survey.
  ([22011](https://github.com/civicrm/civicrm-core/pull/22011))**

- **Guard against passing empty values to CRM_Core_DAO::getFieldValue()
  ([21998](https://github.com/civicrm/civicrm-core/pull/21998))**

- **Tidy up title attributes
  ([21995](https://github.com/civicrm/civicrm-core/pull/21995))**

- **Enotice fixes in debug.tpl that are compatible with default escaping
  ([21940](https://github.com/civicrm/civicrm-core/pull/21940))**

- **Fix isForm to be always assigned, remove checks
  ([21979](https://github.com/civicrm/civicrm-core/pull/21979))**

- **Enotice fixes
  ([21987](https://github.com/civicrm/civicrm-core/pull/21987))**

- **Beautifier - avoid e_notice in php 7.4 when acting on first comment token
  ([332](https://github.com/civicrm/civicrm-packages/pull/332))**

### CiviCase

- **Assign cgCount in Case custom data form
  ([22140](https://github.com/civicrm/civicrm-core/pull/22140))**

### CiviContribute

- **Can't filter by anything other than contribution status in Contribution
  Aggregate by Relationship CiviReport
  ([dev/report#77](https://lab.civicrm.org/dev/report/-/issues/77):
  [22041](https://github.com/civicrm/civicrm-core/pull/22041),
  [22024](https://github.com/civicrm/civicrm-core/pull/22024),
  [22015](https://github.com/civicrm/civicrm-core/pull/22015),
  [22016](https://github.com/civicrm/civicrm-core/pull/22016) and
  [22025](https://github.com/civicrm/civicrm-core/pull/22025))**

- **Using GHC as a default currency causes a fatal error with Brick/Money
  ([dev/financial#184](https://lab.civicrm.org/dev/financial/-/issues/184):
  [21751](https://github.com/civicrm/civicrm-core/pull/21751))**

  Fixes the currency names for Ghana and Belarus.

- **Repeat Contributions CiviReport warnings: Formatting non-numeric values is
  no longer supported
  ([dev/core#2982](https://lab.civicrm.org/dev/core/-/issues/2982):
  [22216](https://github.com/civicrm/civicrm-core/pull/22216))**

- **Expose contribution custom fields in LYBUNT report
  ([dev/core#2951](https://lab.civicrm.org/dev/core/-/issues/2951):
  [22038](https://github.com/civicrm/civicrm-core/pull/22038))**

- **fix unit plural in contribution page
  ([21944](https://github.com/civicrm/civicrm-core/pull/21944))**

- **Update PayPalImpl.php - action on style test failure
  ([22112](https://github.com/civicrm/civicrm-core/pull/22112))**

- **Check the billing fields returned by each payment processor
  ([20811](https://github.com/civicrm/civicrm-core/pull/20811))**

### CiviEvent

- **Participant Listing report filters incorrectly on role ID
  ([dev/report#18](https://lab.civicrm.org/dev/report/-/issues/18):
  [21975](https://github.com/civicrm/civicrm-core/pull/21975))**

- **Remove broken dynamic title from event template
  ([22113](https://github.com/civicrm/civicrm-core/pull/22113))**

- **CRM/Event/BAO/Event: Fix ts usage on selfservice_preposition
  ([22136](https://github.com/civicrm/civicrm-core/pull/22136))**

- **Notice error Deprecated function CRM_Event_BAO_Event::checkPermission
  ([dev/core#1529](https://lab.civicrm.org/dev/core/-/issues/1529):
  [22017](https://github.com/civicrm/civicrm-core/pull/22017))**

- **Custom data not available in the post hook after registering for an event
  ([dev/core#2948](https://lab.civicrm.org/dev/core/-/issues/2948):
  [22022](https://github.com/civicrm/civicrm-core/pull/22022))**

- **CiviCRM Event, remove the superfluous "Are you sure you want to delete this
  Event?" confirmation for the Event delete action
  ([22122](https://github.com/civicrm/civicrm-core/pull/22122))**

### CiviMail

- **Fix unencoded mailing url query param in Mailing report
  ([22008](https://github.com/civicrm/civicrm-core/pull/22008))**

- **CiviCRM Message Template, HTML Format and Text Format fields are listed in
  a different order on the Default Message Template
  ([22110](https://github.com/civicrm/civicrm-core/pull/22110))**

- **Fix message templates screen to work with escape enabled by default
  ([22118](https://github.com/civicrm/civicrm-core/pull/22118))**

### CiviMember

- **CiviCRM Membership Status can never be deleted when logging is enabled
  ([22032](https://github.com/civicrm/civicrm-core/pull/22032))**

- **Fix membership test to use full flow
  ([22162](https://github.com/civicrm/civicrm-core/pull/22162))**

### Drupal Integration

- **Add back in body classes for themeing.
  ([68](https://github.com/civicrm/civicrm-drupal-8/pull/68))**

### WordPress Integration

- **CiviCRM WordPress shortcode remove the display of default text and instead
  just return blank if the shortcode cannot be rendered.
  ([262](https://github.com/civicrm/civicrm-wordpress/pull/262))**

- **Resolve conflict with AIOSEO stomping on CiviCRM Shortcode
  ([263](https://github.com/civicrm/civicrm-wordpress/pull/263))**

- **Prevent fatal error when the "the_title" filter has only one param
  ([261](https://github.com/civicrm/civicrm-wordpress/pull/261))**

## <a name="misc"></a>Miscellany

- **APIv4 ConformanceTest - Demonstrate entity APIs which fail to emit
  `hook_civicrm_post(delete)`
  ([22205](https://github.com/civicrm/civicrm-core/pull/22205))**

- **Move responsibilty for ensuring greeting parameters are set to
  `ensureGreetingParamsAreSet`
  ([21912](https://github.com/civicrm/civicrm-core/pull/21912))**

- **Remove unused variable
  ([21933](https://github.com/civicrm/civicrm-core/pull/21933))**

- **Remove obsolete showVisibility
  ([22102](https://github.com/civicrm/civicrm-core/pull/22102))**

- **Remove empty check previously commented to be meaningless
  ([22164](https://github.com/civicrm/civicrm-core/pull/22164))**

- **[REF] Remove support for not-passed 'pledge' value
  ([21908](https://github.com/civicrm/civicrm-core/pull/21908))**

- **[REF] - Switch BAOs to use standard delete function which calls hooks
  ([22207](https://github.com/civicrm/civicrm-core/pull/22207))**

- **[REF] Remove usage of deprecated jqXHR.error in jQuery code
  ([21919](https://github.com/civicrm/civicrm-core/pull/21919))**

- **[REF] Preliminary cleanup in update greeting
  ([21909](https://github.com/civicrm/civicrm-core/pull/21909))**

- **REF: Switch to debug level logging for lock debugging
  ([22026](https://github.com/civicrm/civicrm-core/pull/22026))**

- **[REF] Fix Pledge Test failing on php8 by ensuring all payments have a
  status assigned and that customGroup is always assigned to the template and
  updating test to pass in some additional form values
  ([22037](https://github.com/civicrm/civicrm-core/pull/22037))**

- **[REF] Add in missing province for Philippines and update names to match ISO
 ([22005](https://github.com/civicrm/civicrm-core/pull/22005))**

- **[REF] "Your browser session has expired and we are unable to complete your
  form submission" on all D9.2 anonymous sessions
  ([dev/drupal#169](https://lab.civicrm.org/dev/drupal/-/issues/169):
  [22080](https://github.com/civicrm/civicrm-core/pull/22080)
  and [335](https://github.com/civicrm/civicrm-packages/pull/335))**

- **[NFC] Update System Uft8mb4 check to handle for the fact that MySQL8
  outputs utf8mb3 when the charset has been set to utf8 as utf8mb3 is the
  underlyling charset for utf8
  ([22221](https://github.com/civicrm/civicrm-core/pull/22221))**

- **[NFC] Remove Selenium WebTest code from CiviMailUtils
  ([22219](https://github.com/civicrm/civicrm-core/pull/22219))**

- **(NFC) tools/mixin/bin/test-all - Work-around segfault in CI
  ([22215](https://github.com/civicrm/civicrm-core/pull/22215))**

- **[NFC] Fix test failures for testRelativeDateRanges
  ([22209](https://github.com/civicrm/civicrm-core/pull/22209))**

- **[NFC] Add missing calls to parent::setUp and tearDown in unit tests
  ([22073](https://github.com/civicrm/civicrm-core/pull/22073))**

- **[NFC] Array formatting
  ([22067](https://github.com/civicrm/civicrm-core/pull/22067))**

- **[NFC] ENsure that formTpl is assigned in CRM_Custom_Form_OptionTest
  ([22065](https://github.com/civicrm/civicrm-core/pull/22065))**

- **[NFC] php8 assign formTpl in HookTest test
  ([22061](https://github.com/civicrm/civicrm-core/pull/22061))**

- **[NFC] php8 - set smarty null defaults for CRM_Core_SessionTest
  ([22048](https://github.com/civicrm/civicrm-core/pull/22048))**

- **[NFC] php8 - fix test fails for CRM_Contact_Page_View_UserDashBoardTest
  ([22023](https://github.com/civicrm/civicrm-core/pull/22023))**

- **[NFC] Fix test issue about trying to do array offset on NULL in Payment
  ProcessorFormTest
  ([22020](https://github.com/civicrm/civicrm-core/pull/22020))**

- **[NFC] Add in unit test to demonstate issue with API
  ([dev/mail#103](https://lab.civicrm.org/dev/mail/-/issues/103):
  [22045](https://github.com/civicrm/civicrm-core/pull/22045))**

- **[NFC] Additional Fix on UserDashBoard Tests to assign action value to
  dashboard ([22034](https://github.com/civicrm/civicrm-core/pull/22034))**

- **Test fix - use more 'real' rendering function
  ([22123](https://github.com/civicrm/civicrm-core/pull/22123))**

- **Fix more tests to use full flow
  ([22161](https://github.com/civicrm/civicrm-core/pull/22161))**

- **[Test] Fix tests to use form helper
  ([22157](https://github.com/civicrm/civicrm-core/pull/22157))**

- **[Test] Test cleanup to use full-form methods
  ([22156](https://github.com/civicrm/civicrm-core/pull/22156))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Justin Freeman;
BrightMinded Ltd - Bradley Taylor; Christian Wach; CiviCoop - Jaap Jansma;
CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp -
Lisandro; Coop SymbioTIC - Mathieu Lutfy; CSES (Chelmsford Science and
Engineering Society) - Adam Wood; Dave D; Digitalcourage - Detlev Sieber;
homotechsual - Mikey O'Toole; Jens Schuppe; JMA Consulting - Monish Deb, Seamus
Lee; joapta; Joinery - Allen Shaw; Lighthouse Consulting and Design - Brian
Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; PERORA SRL - Samuele Masetto; Progressive Technology Project -
Jamie McClelland; Third Sector Design - Kurund Jalmi, William Mortada;
Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Arnaud Broes; Artful Robot - Rich Lott; Asylum Seekers Centre; Australian
Greens - John Twyman; Betty Dolfing; Blackfly Solutions - Alan Dixon; Carlos
Capote; Guydn; JMA Consulting - Joe Murray; Lemniscus - Noah Miller; netzih;
Nicol Wistreich; Richard van Oosterhout; Skvare - Sunil Pawar; Tadpole
Collective - Kevin Cristiano;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
