/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter.tag;

import java.net.URI;

import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.converter.SimpleConverterContext;
import org.apache.maven.tools.plugin.javadoc.JavadocReference;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class LinkUtilsTest {
    @Test
    void testCreateUnresolvableLink() {
        JavadocReference reference = JavadocReference.parse("Unresolvable");
        ConverterContext context = new SimpleConverterContext("myPackage", (ref) -> URI.create(""), reference);
        assertEquals(
                "Unresolvable<!-- this link could not be resolved -->", LinkUtils.createLink("Unresolvable", context));
    }

    @Test
    void testCreateLinkWithNoJavadoc() {
        ConverterContext context = new SimpleConverterContext("myPackage", (ref) -> {
            throw new IllegalArgumentException("Could not get javadoc");
        });
        assertEquals(
                "NoJavadoc<!-- reference not found in associated javadoc sites -->",
                LinkUtils.createLink("NoJavadoc", context));
    }
}
