/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x1d1d1d1d1d1d1d1d;
  *((unsigned long *)&__m256i_op0[2]) = 0x1d1d1d1d1d1d1d1d;
  *((unsigned long *)&__m256i_op0[1]) = 0x61d849f0c0794ced;
  *((unsigned long *)&__m256i_op0[0]) = 0xe75278c187b20039;
  *((unsigned long *)&__m256i_op1[3]) = 0xf90c0c0c00000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0ca40c0c0c0c0cc0;
  *((unsigned long *)&__m256i_op1[1]) = 0x0c0c0c0c0cb60cc0;
  *((unsigned long *)&__m256i_op1[0]) = 0xfbe0b80c960c96d0;
  *((unsigned long *)&__m256i_result[3]) = 0x8b1414140e0e0e0e;
  *((unsigned long *)&__m256i_result[2]) = 0x146014141414146e;
  *((unsigned long *)&__m256i_result[1]) = 0x36722a7e66972cd6;
  *((unsigned long *)&__m256i_result[0]) = 0xf19998668e5f4b84;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000ffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x000000000000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x00000000ff00fff0;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000007f7f;
  *((unsigned long *)&__m256i_result[2]) = 0x00000000007f7f7f;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000007f7f;
  *((unsigned long *)&__m256i_result[0]) = 0x000000007f007f78;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffff02ff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000ffffffff0100;
  *((unsigned long *)&__m256i_op0[0]) = 0xff00fefffeff02ff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x00030006fa05f20e;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x00030081bd80f90e;
  *((unsigned long *)&__m256i_result[3]) = 0x00007f7f7f7f7f7f;
  *((unsigned long *)&__m256i_result[2]) = 0x00010003fc827a86;
  *((unsigned long *)&__m256i_result[1]) = 0x00007f7f7f7f0000;
  *((unsigned long *)&__m256i_result[0]) = 0x7f017fc0ddbf7d86;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0202010202020102;
  *((unsigned long *)&__m256i_op1[2]) = 0x0202010202020102;
  *((unsigned long *)&__m256i_op1[1]) = 0x0202010202020102;
  *((unsigned long *)&__m256i_op1[0]) = 0x0202010202020102;
  *((unsigned long *)&__m256i_result[3]) = 0x0101000101010001;
  *((unsigned long *)&__m256i_result[2]) = 0x0101000101010001;
  *((unsigned long *)&__m256i_result[1]) = 0x0101000101010001;
  *((unsigned long *)&__m256i_result[0]) = 0x0101000101010001;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00ffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x00ffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffff00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x007f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_result[2]) = 0x7f7f7f7f00000000;
  *((unsigned long *)&__m256i_result[1]) = 0x007f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_result[0]) = 0x7f7f7f7f00000000;
  __m256i_out = __lasx_xvavg_bu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000007f00000022;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000007f00000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000003f00000011;
  *((unsigned long *)&__m256i_result[0]) = 0x0000003f00000000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x3fff3fff3fff3fff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x3fff3fff3fff3fff;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fff7fff7fff7fff;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffbfffafffffffe;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffff0000;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffbfffaffff0000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00fe01fc01fe01fc;
  *((unsigned long *)&__m256i_op1[2]) = 0x012c002c001c0006;
  *((unsigned long *)&__m256i_op1[1]) = 0x00fe01fc01fe0000;
  *((unsigned long *)&__m256i_op1[0]) = 0x012c002c001c000a;
  *((unsigned long *)&__m256i_result[3]) = 0x807e80fd80fe80fd;
  *((unsigned long *)&__m256i_result[2]) = 0x80938013800d8002;
  *((unsigned long *)&__m256i_result[1]) = 0x807e80fd80fe0000;
  *((unsigned long *)&__m256i_result[0]) = 0x80938013800d0005;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0002000200020002;
  *((unsigned long *)&__m256i_result[3]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[0]) = 0x8000800080008000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000000007fff7fff;
  *((unsigned long *)&__m256i_result[2]) = 0x000000007fff7fff;
  *((unsigned long *)&__m256i_result[1]) = 0x000000007fff7fff;
  *((unsigned long *)&__m256i_result[0]) = 0x000000007fff7fff;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ff810011;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ff810011;
  *((unsigned long *)&__m256i_op1[3]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x3fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[2]) = 0x3fff7fffffc08008;
  *((unsigned long *)&__m256i_result[1]) = 0x3fff7fff7fff7fff;
  *((unsigned long *)&__m256i_result[0]) = 0x3fff7fffffc08008;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x80000000ff800000;
  *((unsigned long *)&__m256i_op0[1]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x80000000ff800000;
  *((unsigned long *)&__m256i_op1[3]) = 0x800000007fff0001;
  *((unsigned long *)&__m256i_op1[2]) = 0x80000000ff7f0001;
  *((unsigned long *)&__m256i_op1[1]) = 0x800000007fff0001;
  *((unsigned long *)&__m256i_op1[0]) = 0x80000000ff7f0001;
  *((unsigned long *)&__m256i_result[3]) = 0x800000007fff0000;
  *((unsigned long *)&__m256i_result[2]) = 0x80000000ff7f0000;
  *((unsigned long *)&__m256i_result[1]) = 0x800000007fff0000;
  *((unsigned long *)&__m256i_result[0]) = 0x80000000ff7f0000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffc6ffc6003a003a;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffff0000;
  *((unsigned long *)&__m256i_op1[1]) = 0xffc6ffc6003a003a;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffff0000;
  *((unsigned long *)&__m256i_result[3]) = 0x7fe37fe3001d001d;
  *((unsigned long *)&__m256i_result[2]) = 0x7fff7fff7fff0000;
  *((unsigned long *)&__m256i_result[1]) = 0x7fe37fe3001d001d;
  *((unsigned long *)&__m256i_result[0]) = 0x7fff7fff7fff0000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000004;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000004;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000004;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000004;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000fc38fc38;
  *((unsigned long *)&__m256i_op0[2]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000fc38fc38;
  *((unsigned long *)&__m256i_op0[0]) = 0xfc00000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_result[2]) = 0x7e00000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_result[0]) = 0x7e00000000000000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000fffe00800022;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000fffe00800022;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000003ffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x00007fff00400011;
  *((unsigned long *)&__m256i_result[2]) = 0x000000008001ffff;
  *((unsigned long *)&__m256i_result[1]) = 0x00007fff00400011;
  *((unsigned long *)&__m256i_result[0]) = 0x000000007fff7fff;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_hu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0a09080706050403;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0a09080706050403;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0504840303028201;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0504840303028201;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000200;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000200;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000005000000020;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000005000000020;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000002800000010;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000002800000010;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x40efffe000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x40efffe000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[2]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[1]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[0]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_result[3]) = 0x9ff87ef07f7f817f;
  *((unsigned long *)&__m256i_result[2]) = 0x7f807f007f7f817f;
  *((unsigned long *)&__m256i_result[1]) = 0x9ff87ef07f7f817f;
  *((unsigned long *)&__m256i_result[0]) = 0x7f807f007f7f817f;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0fffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x111ebb784f9c4100;
  *((unsigned long *)&__m256i_op1[2]) = 0x1c386546809f3b50;
  *((unsigned long *)&__m256i_op1[1]) = 0x111ebb784f9bf1ac;
  *((unsigned long *)&__m256i_op1[0]) = 0x21f6050d955d3f68;
  *((unsigned long *)&__m256i_result[3]) = 0x088f5dbc27ce2080;
  *((unsigned long *)&__m256i_result[2]) = 0x161c32a2c04f9da7;
  *((unsigned long *)&__m256i_result[1]) = 0x088f5dbc27cdf8d6;
  *((unsigned long *)&__m256i_result[0]) = 0x10fb02864aae9fb4;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffe0000fffe0012;
  *((unsigned long *)&__m256i_op0[1]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffe0000fffe0012;
  *((unsigned long *)&__m256i_op1[3]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_op1[2]) = 0xfffe0000fffe0012;
  *((unsigned long *)&__m256i_op1[1]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_op1[0]) = 0xfffe0000fffe0012;
  *((unsigned long *)&__m256i_result[3]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_result[2]) = 0xfffe0000fffe0012;
  *((unsigned long *)&__m256i_result[1]) = 0xfffefffefffeffee;
  *((unsigned long *)&__m256i_result[0]) = 0xfffe0000fffe0012;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000100000001;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_wu (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x7fffffffffffffff;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op0[2]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000800080008000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000800080008000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000800080008000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000800080008000;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000004444;
  *((unsigned long *)&__m256i_op1[2]) = 0x00007bbb0000f777;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000004444;
  *((unsigned long *)&__m256i_op1[0]) = 0x00007bbb0000f777;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000002222;
  *((unsigned long *)&__m256i_result[2]) = 0x00003ddd80007bbb;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000002222;
  *((unsigned long *)&__m256i_result[0]) = 0x00003ddd80007bbb;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000000000f0f0;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000000000f0f0;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000007878;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000007878;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x7fffffffffffffff;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000001e00000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000f00000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvavg_du (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
