/*
 * Copyright (C) Tildeslash Ltd. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU Affero General Public License in all respects
 * for all of the code used other than OpenSSL.
 */


#include "config.h"

#include "monit.h"


/**
 * Implementation of the Address class.
 *
 * @file
 */


/* ------------------------------------------------------------- Definitions */


#define T Address_T


/* ------------------------------------------------------------------ Public */


T Address_new(void) {
        Address_T A;
        NEW(A);
        return A;
}


void Address_free(T *A) {
        assert(A && *A);
        FREE((*A)->name);
        FREE((*A)->address);
        FREE(*A);
}


T Address_copy(T A) {
        assert(A);
        Address_T C = Address_new();
        C->name = A->name ? Str_dup(A->name) : NULL;
        C->address = A->address ? Str_dup(A->address) : NULL;
        return C;
}

