/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_HOSTEDPOWERMANAGEMENTSERVICEACCESS_H_
#define OPENDRIM_HOSTEDPOWERMANAGEMENTSERVICEACCESS_H_

#include "PowerManagement_Common.h"

#include "OpenDRIM_HostedPowerManagementService.h"
#include "assocOpenDRIM_HostedPowerManagementService.h"

int PowerManagement_OpenDRIM_HostedPowerManagementService_load(const CMPIBroker* broker, string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_unload(string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_HostedPowerManagementService>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_HostedPowerManagementService_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_HostedPowerManagementService& instance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedPowerManagementService& newInstance, const OpenDRIM_HostedPowerManagementService& oldInstance, const char** properties, string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedPowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_HostedPowerManagementService& instance, string& errorMessage);

int PowerManagement_OpenDRIM_HostedPowerManagementService_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_HostedPowerManagementService_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_HostedPowerManagementService_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_HostedPowerManagementService>& OpenDRIM_HostedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_HostedPowerManagementService_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_HostedPowerManagementService>& OpenDRIM_HostedPowerManagementService_instances, const char** properties, string& errorMessage, const string& discriminant);

int PowerManagement_OpenDRIM_HostedPowerManagementService_populate(OpenDRIM_HostedPowerManagementService& instance, string& errorMessage);

#endif /*OPENDRIM_HOSTEDPOWERMANAGEMENTSERVICEACCESS_H_*/
