//=======================================================================
// baseconfig.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "common.h"
#include "baseconfig.h"
#include <fstream>

using std::string;

using namespace Paco;

// Forward declarations
static string expandHome(string const& str);


namespace Paco
{
	string BaseConfig::sLogdir			= LOGDIR;
	string BaseConfig::sInclude			= INCLUDE;
	string BaseConfig::sExclude			= EXCLUDE;
	bool BaseConfig::sLogIgnoreErrors	= false;
	bool BaseConfig::sLogIgnoreShared	= false;
	bool BaseConfig::sCaseSensitive		= false;
	int BaseConfig::sBlockSize			= DEFAULT_BLOCK_SIZE;
	int BaseConfig::sMaxDbAge			= DEFAULT_MAX_DB_AGE;
}


BaseConfig::BaseConfig()
{
	std::ifstream f(PACORC);
	if (!f)
		return;

	string buf;

	while (getline(f, buf)) {

		string::size_type p(buf.find("="));
		if (p == string::npos || buf[0] == '#')
   			continue;
		string val(buf.substr(p + 1));
		buf.erase(p);
   
		if (val == "1" && buf == "LOG_IGNORE_ERRORS")
   			sLogIgnoreErrors = true;
		else if (val == "1" && buf == "LOG_IGNORE_SHARED")
   			sLogIgnoreShared = true;
		else if (val == "1" && buf == "APPARENT_SIZE")
   			sBlockSize = 1;
		else if (val == "1" && buf == "CASE_SENSITIVE")
   				sCaseSensitive = true;
		else if (buf == "BLOCK_SIZE")
   			sBlockSize = str2num<int>(val);
		else if (buf == "MAX_DB_AGE")
   			sMaxDbAge = str2num<int>(val);
		else if (buf == "LOGDIR")
   			sLogdir = expandHome(val);
		else if (buf == "INCLUDE")
   			sInclude = expandHome(val);
		else if (buf == "EXCLUDE")
   			sExclude = expandHome(val);
	}
}


BaseConfig::~BaseConfig()
{ }


// [static]
void BaseConfig::init()
{
	static BaseConfig c;
}


// [static]
void BaseConfig::touchStamp()
{
	std::ofstream f(stamp().c_str());
	if (f)
		f << PACKAGE_VERSION "\n";
}


// [static]
string BaseConfig::version()
{
	string v;
	std::ifstream f(stamp().c_str());
	if (f)
		f >> v;
	return v;
}


// [static]
bool BaseConfig::checkLogdir()
{
	return !inPaths(sLogdir, "/dev:/proc:/sys");
}


//
// Expand environment variable HOME in str
//
static string expandHome(string const& str)
{
	string ret(str);

	if (char* home = getenv("HOME")) {
		string::size_type p;
		for (p = 0; (p = ret.find("$HOME", p)) != string::npos; )
			ret.replace(p, 5, home);
		for (p = 0; (p = ret.find("${HOME}", p)) != string::npos; )
			ret.replace(p, 7, home);
    }

	return ret;
}

