#!/bin/sh
#  Program: ln-dir.sh
#  Author: David Cheatham / david@mush.cx / Vadiv@M*U*S*H / Vadiv@ChaoticMUX
#  Description: Creates symlink game dirs of pennmush
#  Date: May 4, 2002
#
#  This script has no warranty. Don't do stupid things like run it on
#  an already existing mush. It tried to check for that, but no
#  promises. Under no circumstances I can think of will it overwrite
#  your db, but it will overwrite your custom text files.
#
#  This script is public domain.
#  If you haven't messed with it, and something goes wrong, email me.
#
#  DIRECTIONS:
#
#  TO USE: Find a directory, and run this script in it. It will
#  create a game/ in that directory that has everything you need to
#  run pennmush. Feel free to rename or move this directory. 
#  (No, not while you're running it.)
#
#  If you have a database and/or help files, etc, copy those in, like you 
#  would normally. See the FAQ for more info. Note that the included
#  help files are symlinked, and it's best if you just leave those and
#  create *other* files in that directory, so upgrading is seamless.
#  nws/ and evt/ have normal text files in them, as those always change
#  per-mush.
#
#
#  TO SETUP: Compile pennmush, all the way. You should be able to type
#  ./restart and have it launch. In fact, you should do that, it won't
#  confuse anything and will save you from problems down the road, if you 
#  know it works.  Then type 'make globalinstall'. All the files that you
#  need are put in /usr/libexec/pennmush, but you can move them if you
#  want to. (Do it before you create any user installs, though.)
#  You can then delete the compile directory.
#
#  Note if you're compiling for other users you probably want all the flags
#  and options and everything turned on. Otherwise one set of people will be
#  whining about warnings and one set about ROY, etc...
#
#  That's technically all you need to do. *However*, if you want users to 
#  not have to type the full path out, you can create a symlink to this
#  script, and stick it in your path, with some nice name, and tell
#  users about it. I recommend calling it penn-install and sticking it
#  in /usr/bin. (I could do it for you, but I want the binaries to be
#  freely relocatable, and thus don't want to hardcode a location.)
#
#
#  TO UPGRADE: Just do the same thing as an install. All the user
#  installs *should* continue to operate, or there should be a
#  big warning in the Changelog. If there's something that needs doing,
#  hopefully it will be clearly documented.
#
#  Then all the user installs just need @shutdown/reboot. Though a
#  'make' in their txt/ directory before that can't hurt.
#
#
#  Don't mess with the rest of this file.

STARTPWD=`pwd`/pennmush
DOWN=''
# Good grief. Why can't we have a command to find the absolute place 
# a symlink is pointing at?
cd /`ls -l $0 |cut -d '>' -f 2- | sed 's/\/[^\/]*$//'|cut -d '/' -f 2-`
MASTER=`pwd`
mkdir $STARTPWD
cd $STARTPWD

mklns() {
  while [ $1 ]; do
  ln -s $MASTER/$DOWN/$1
  shift
  done
}

mkcps() {
  while [ $1 ]; do 
  cp $MASTER/$DOWN/$1 .
  shift
  done
}

mdcd() {
  cd $STARTPWD
  mkdir -p $1
  cd $1
  DOWN=$1
}

if test -f ./ln-dir.sh; then

  echo "Are you running this from the master pennmush directory?"
  echo "What exactly is going on here?"
  echo "Open this file up and read the instructions."
  echo "This creates a pennmush child directory in the currect"
  echo "directory. You need to run it in a different directory."
  exit

fi

if test -f ./utils/ln-dir.sh;  then

  echo "If you want to use this script, you need to 'make globalinstall"
  echo "as root first, and then run this script from where it's"
  echo "installed."
  exit

fi

if test -f ./game/restart; then

  echo "Okay, I'm confused. You only should run this once, to create"
  echo "the directories and symlinks. You shouldn't ever need to run it"
  echo "again. And, as I can't figure out which files you've modified,"
  echo "or what's wrong, that's a bad idea anyway."
  echo "If you've run into problems, you should create a new directory."
  echo "run me in that, and copy all the files you\'ve modified over."
  exit

fi

mklns README mushcnf.dst access.README getdate.README getdate.template config.sh
mkcps *.cnf restart

# Weird binary linking stuff
ln -s $MASTER/netmush
ln -s $MASTER/info_slave

# I'm a little baffled by needing to do this, but whatever.
chmod u+x restart

# The mostly empty directorys...
mdcd save
mklns README

mdcd log
mklns README

mdcd data
mklns minimal.db


# Txt files stuff.
# (Yes, I know compose.sh.SH generates compose.sh, but that never changes.)
mdcd txt
mklns compose.sh.SH compose.sh index-files.pl

# Copy outright all the text files. Half of these need modifying and the
# other half are autogenerated anyway.
mkcps *.txt Makefile

# Events and news are mush specific always, and they start out empty anyway

mdcd txt/evt
mkcps *
mdcd txt/nws
mkcps *

mdcd txt/hlp
mklns penncode.hlp pennfunc.hlp penntop.hlp pennchat.hlp pennconf.hlp \
	 pennmail.hlp pennvers.hlp penncmd.hlp pennflag.hlp pennpueb.hlp
