/*	$NetBSD: emcfanreg.h,v 1.1 2025/03/11 13:56:46 brad Exp $	*/

/*
 * Copyright (c) 2025 Brad Spencer <brad@anduin.eldar.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _DEV_I2C_EMCFANREG_H_
#define _DEV_I2C_EMCFANREG_H_

#include <dev/i2c/i2c_io.h>

static const i2c_addr_t emcfan_typical_addrs[] = { 0x2c, 0x2d, 0x2e, 0x2f, 0x4c, 0x4d };

#define EMCFAN_VOID_READ	0x55

#define EMCFAN_INTERNAL_TEMP_HIGH	0x00
#define EMCFAN_INTERNAL_TEMP_LOW	0x01
#define EMCFAN_2101_EXTERNAL_TEMP_HIGH	0x01
#define EMCFAN_2101_CHIP_CONFIG		0x03
#define EMCFAN_EXTERNAL_1_TEMP_HIGH	0x02
#define EMCFAN_2101_EXTERNAL_TEMP_LOW	0x10
#define EMCFAN_EXTERNAL_1_TEMP_LOW	0x03
#define EMCFAN_EXTERNAL_2_TEMP_HIGH	0x04
#define EMCFAN_EXTERNAL_2_TEMP_LOW	0x05
#define EMCFAN_EXTERNAL_3_TEMP_HIGH	0x06
#define EMCFAN_EXTERNAL_3_TEMP_LOW	0x07
#define EMCFAN_EXTERNAL_4_TEMP_HIGH	0x08
#define EMCFAN_EXTERNAL_4_TEMP_LOW	0x09

#define EMCFAN_VIN4_VOLTAGE		0x10

#define EMCFAN_CHIP_CONFIG	0x20
#define EMCFAN_CHIP_CONFIG_2	0x21
#define EMCFAN_TEMP_CONFIG_3	0x22
#define EMCFAN_210_346_FAN_STATUS 0x27
#define EMCFAN_POLARITY_CONFIG	0x2a

#define EMCFAN_210_346_PWM_BASEFREQ 0x2b
#define EMCFAN_2106_FAN_3_DIVIDE 0x2c
#define EMCFAN_2106_FAN_3_DRIVE 0x2d
#define EMCFAN_2106_FAN_4_DRIVE 0x2e
#define EMCFAN_2106_FAN_4_DIVIDE 0x2f
#define EMCFAN_2101_TACH_LOW	0x46
#define EMCFAN_2101_TACH_HIGH	0x47
#define EMCFAN_2101_FAN_CONFIG	0x4a
#define EMCFAN_2101_FAN_DRIVE	0x4c
#define EMCFAN_2101_FAN_DIVIDE	0x4e
#define EMCFAN_210_346_FAN_1_DRIVE 0x40
#define EMCFAN_210_346_FAN_1_DIVIDE 0x41
#define EMCFAN_210_346_CONFIG_1	0x42
#define EMCFAN_210_346_TACH_1_HIGH	0x4e
#define EMCFAN_210_346_TACH_1_LOW	0x4f
#define EMCFAN_210_346_CONFIG_2	0x82
#define EMCFAN_210_346_FAN_2_DRIVE 0x80
#define EMCFAN_210_346_FAN_2_DIVIDE 0x81
#define EMCFAN_210_346_TACH_2_HIGH	0x8e
#define EMCFAN_210_346_TACH_2_LOW	0x8f

#define EMCFAN_230X_FAN_STATUS 0x24
#define EMCFAN_230X_FAN_STALL_STATUS 0x25
#define EMCFAN_230X_FAN_SPIN_STATUS 0x26
#define EMCFAN_230X_FAN_DRIVE_STATUS 0x27
#define EMCFAN_230X_OUTPUT_CONFIG 0x2b
#define EMCFAN_230X_BASE_FREQ_45 0x2c
#define EMCFAN_230X_BASE_FREQ_123 0x2d
#define EMCFAN_230X_FAN_1_DRIVE 0x30
#define EMCFAN_230X_FAN_1_DIVIDE 0x31
#define EMCFAN_230X_CONFIG_1	0x32
#define EMCFAN_230X_TACH_1_HIGH 0x3e
#define EMCFAN_230X_TACH_1_LOW	0x3f
#define EMCFAN_230X_FAN_2_DRIVE 0x40
#define EMCFAN_230X_FAN_2_DIVIDE 0x41
#define EMCFAN_230X_CONFIG_2	0x42
#define EMCFAN_230X_TACH_2_HIGH 0x4e
#define EMCFAN_230X_TACH_2_LOW	0x4f
#define EMCFAN_230X_FAN_3_DRIVE 0x50
#define EMCFAN_230X_FAN_3_DIVIDE 0x51
#define EMCFAN_230X_CONFIG_3	0x52
#define EMCFAN_230X_TACH_3_HIGH 0x5e
#define EMCFAN_230X_TACH_3_LOW	0x5f
#define EMCFAN_230X_FAN_4_DRIVE 0x60
#define EMCFAN_230X_FAN_4_DIVIDE 0x61
#define EMCFAN_230X_CONFIG_4	0x62
#define EMCFAN_230X_TACH_4_HIGH 0x6e
#define EMCFAN_230X_TACH_4_LOW	0x6f
#define EMCFAN_230X_FAN_5_DRIVE 0x70
#define EMCFAN_230X_FAN_5_DIVIDE 0x71
#define EMCFAN_230X_CONFIG_5	0x72
#define EMCFAN_230X_TACH_5_HIGH 0x7e
#define EMCFAN_230X_TACH_5_LOW	0x7f

#define EMCFAN_PRODUCT_ID	0xfd
#define		EMCFAN_PRODUCT_2101 0x16
#define		EMCFAN_PRODUCT_2101R 0x28
#define		EMCFAN_PRODUCT_2103_1 0x24
#define		EMCFAN_PRODUCT_2103_24 0x26 /* EMC2103-2 and EMC2103-4 */
#define		EMCFAN_PRODUCT_2104 0x1d
#define		EMCFAN_PRODUCT_2106 0x1e
#define		EMCFAN_PRODUCT_2305 0x34
#define		EMCFAN_PRODUCT_2303 0x35
#define		EMCFAN_PRODUCT_2302 0x36
#define		EMCFAN_PRODUCT_2301 0x37
#define EMCFAN_MUX_PINS 0xe0
#define EMCFAN_DIR_PINS 0xe1
#define EMCFAN_OUTPUT_PIN_CONFIG 0xe2
#define EMCFAN_PINS_INPUT 0xe3
#define EMCFAN_PINS_OUTPUT 0xe4
#define EMCFAN_MANUFACTURER_ID	0xfe
#define		EMCFAN_VALID_MANUFACTURER_ID 0x5d
#define EMCFAN_REVISION		0xff

#define EMCFAN_FAMILY_210X 1
#define EMCFAN_FAMILY_230X 2

#endif
