/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.config.Keys;
import org.traccar.helper.model.AttributeUtil;
import org.traccar.model.Command;

public class Tk103ProtocolEncoder
extends StringProtocolEncoder {
    private final boolean forceAlternative;

    public Tk103ProtocolEncoder(Protocol protocol) {
        super(protocol);
        this.forceAlternative = false;
    }

    public Tk103ProtocolEncoder(Protocol protocol, boolean forceAlternative) {
        super(protocol);
        this.forceAlternative = forceAlternative;
    }

    private String formatAlt(Command command, String format, String ... keys) {
        return this.formatCommand(command, "[begin]sms2," + format + ",[end]", keys);
    }

    @Override
    protected Object encodeCommand(Command command) {
        boolean alternative = AttributeUtil.lookup(this.getCacheManager(), Keys.PROTOCOL_ALTERNATIVE.withPrefix(this.getProtocolName()), command.getDeviceId());
        this.initDevicePassword(command, "123456");
        if (alternative || this.forceAlternative) {
            return switch (command.getType()) {
                case "custom" -> this.formatAlt(command, "%s", "data");
                case "getVersion" -> this.formatAlt(command, "*about*", new String[0]);
                case "powerOff" -> this.formatAlt(command, "*turnoff*", new String[0]);
                case "rebootDevice" -> this.formatAlt(command, "88888888", new String[0]);
                case "positionSingle" -> this.formatAlt(command, "*getposl*", new String[0]);
                case "positionPeriodic" -> this.formatAlt(command, "*routetrack*99*", new String[0]);
                case "positionStop" -> this.formatAlt(command, "*routetrackoff*", new String[0]);
                case "getDeviceStatus" -> this.formatAlt(command, "*status*", new String[0]);
                case "deviceIdentification" -> this.formatAlt(command, "999999", new String[0]);
                case "modeDeepSleep" -> this.formatAlt(command, command.getBoolean("enable") ? "*sleep*2*" : "*sleepoff*", new String[0]);
                case "modePowerSaving" -> this.formatAlt(command, command.getBoolean("enable") ? "*sleepv*" : "*sleepoff*", new String[0]);
                case "alarmSos" -> this.formatAlt(command, command.getBoolean("enable") ? "*soson*" : "*sosoff*", new String[0]);
                case "setConnection" -> {
                    String server = command.getString("server").replace(".", "*");
                    yield this.formatAlt(command, "*setip*" + server + "*%s*", "port");
                }
                case "sosNumber" -> this.formatAlt(command, "*master*%s*%s*", "devicePassword", "phone");
                default -> null;
            };
        }
        return switch (command.getType()) {
            case "custom" -> this.formatCommand(command, "(%s%s)", "uniqueId", "data");
            case "getVersion" -> this.formatCommand(command, "(%sAP07)", "uniqueId");
            case "rebootDevice" -> this.formatCommand(command, "(%sAT00)", "uniqueId");
            case "setOdometer" -> this.formatCommand(command, "(%sAX01)", "uniqueId");
            case "positionSingle" -> this.formatCommand(command, "(%sAP00)", "uniqueId");
            case "positionPeriodic" -> {
                String frequency = String.format("%04X", command.getInteger("frequency"));
                yield this.formatCommand(command, "(%sAR00" + frequency + "0000)", "uniqueId");
            }
            case "positionStop" -> this.formatCommand(command, "(%sAR0000000000)", "uniqueId");
            case "engineStop" -> this.formatCommand(command, "(%sAV010)", "uniqueId");
            case "engineResume" -> this.formatCommand(command, "(%sAV011)", "uniqueId");
            case "outputControl" -> this.formatCommand(command, "(%sAV00%s)", "uniqueId", "data");
            default -> null;
        };
    }
}

