/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core;

import java.util.Objects;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.core.Frame;

public class OutgoingEntry {
    private final Frame frame;
    private final Callback callback;
    private final boolean batch;
    private final long frameTimeout;
    private final long messageTimeout;

    private OutgoingEntry(Frame frame, Callback callback, boolean batch, long frameTimeout, long messageTimeout) {
        this.frame = Objects.requireNonNull(frame);
        this.callback = Objects.requireNonNull(callback);
        this.batch = batch;
        this.frameTimeout = frameTimeout;
        this.messageTimeout = messageTimeout;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public long getFrameTimeout() {
        return this.frameTimeout;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public String toString() {
        return String.format("%s{messageTimeout=%s, frameTimeout=%s, frame=%s, callback=%s, batch=%s}", TypeUtil.toShortName(this.getClass()), this.messageTimeout, this.frameTimeout, this.frame, this.callback, this.batch);
    }

    public static class Builder {
        private Frame _frame;
        private Callback _callback;
        private boolean _batch;
        private long _frameTimeout;
        private long _messageTimeout;

        public Builder() {
        }

        public Builder(Frame frame, Callback callback) {
            this._frame = frame;
            this._callback = callback;
        }

        public Builder(OutgoingEntry outgoingEntry) {
            this._frame = outgoingEntry.getFrame();
            this._callback = outgoingEntry.getCallback();
            this._batch = outgoingEntry.isBatch();
            this._frameTimeout = outgoingEntry.getFrameTimeout();
            this._messageTimeout = outgoingEntry.getMessageTimeout();
        }

        public Builder frame(Frame frame) {
            this._frame = frame;
            return this;
        }

        public Builder callback(Callback callback) {
            this._callback = callback;
            return this;
        }

        public Builder batch(boolean batch) {
            this._batch = batch;
            return this;
        }

        public Builder frameTimeout(long frameTimeout) {
            this._frameTimeout = frameTimeout;
            return this;
        }

        public Builder messageTimeout(long messageTimeout) {
            this._messageTimeout = messageTimeout;
            return this;
        }

        public OutgoingEntry build() {
            return new OutgoingEntry(this._frame, this._callback, this._batch, this._frameTimeout, this._messageTimeout);
        }
    }
}

