/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.shared.common.error.StandardException;

class DropAliasConstantAction
extends DDLConstantAction {
    private SchemaDescriptor sd;
    private final String aliasName;
    private final char nameSpace;

    DropAliasConstantAction(SchemaDescriptor sd, String aliasName, char nameSpace) {
        this.sd = sd;
        this.aliasName = aliasName;
        this.nameSpace = nameSpace;
    }

    public String toString() {
        return "DROP ALIAS " + this.aliasName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        AliasDescriptor ad = dd.getAliasDescriptor(this.sd.getUUID().toString(), this.aliasName, this.nameSpace);
        if (ad == null) {
            throw StandardException.newException((String)"42X94", (Object[])new Object[]{AliasDescriptor.getAliasType(this.nameSpace), this.aliasName});
        }
        this.adjustUDTDependencies(lcc, dd, ad, false);
        ad.drop(lcc);
    }
}

