/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.parser.TypeCheckerEnvironment;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;
    private static final OperandRole CHOICE_ACTION = new OperandRole(8, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public Choose(Expression[] conditions, Expression[] actions) {
        this.conditions = conditions;
        this.actions = actions;
        if (conditions.length != actions.length) {
            throw new IllegalArgumentException("Choose: unequal length arguments");
        }
        for (int i = 0; i < conditions.length; ++i) {
            this.adoptChildExpression(conditions[i]);
            this.adoptChildExpression(actions[i]);
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, Literal.makeLiteral(BooleanValue.TRUE, elseExp.getContainer())};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).conditions.length == 1;
    }

    public Expression[] getConditions() {
        return this.conditions;
    }

    public Expression[] getActions() {
        return this.actions;
    }

    @Override
    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 156 : 141;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.simplify(this.conditions[i]);
            try {
                this.actions[i] = visitor.simplify(this.actions[i]);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        return this;
    }

    private Expression removeRedundantBranches(ExpressionVisitor visitor) {
        Expression[] a;
        Expression[] c;
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            if (!Literal.isConstantBoolean(this.conditions[i], false)) continue;
            if (this.conditions.length == 1) {
                Literal lit = Literal.makeEmptySequence(this.getContainer());
                ExpressionTool.copyLocationInfo(this, lit);
                return lit;
            }
            c = new Expression[this.conditions.length - 1];
            a = new Expression[this.conditions.length - 1];
            if (i != 0) {
                System.arraycopy(this.conditions, 0, c, 0, i);
                System.arraycopy(this.actions, 0, a, 0, i);
            }
            if (i != this.conditions.length) {
                System.arraycopy(this.conditions, i + 1, c, i, this.conditions.length - i - 1);
                System.arraycopy(this.actions, i + 1, a, i, this.actions.length - i - 1);
            }
            this.conditions = c;
            this.actions = a;
            --i;
        }
        for (i = 0; i < this.conditions.length - 1; ++i) {
            if (!Literal.isConstantBoolean(this.conditions[i], true)) continue;
            if (i == 0) {
                return this.actions[0];
            }
            c = new Expression[i + 1];
            a = new Expression[i + 1];
            System.arraycopy(this.conditions, 0, c, 0, i + 1);
            System.arraycopy(this.actions, 0, a, 0, i + 1);
            this.conditions = c;
            this.actions = a;
            break;
        }
        if (this.conditions.length == 1 && Literal.isConstantBoolean(this.conditions[0], true)) {
            return this.actions[0];
        }
        if (Literal.isEmptySequence(this.actions[this.actions.length - 1])) {
            if (this.conditions.length == 1) {
                return Literal.makeEmptySequence(this.getContainer());
            }
            Expression[] c2 = new Expression[this.conditions.length - 1];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            Expression[] a2 = new Expression[this.actions.length - 1];
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
            this.conditions = c2;
            this.actions = a2;
        }
        if (Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && this.actions[this.actions.length - 1] instanceof Choose) {
            Choose choose2 = (Choose)this.actions[this.actions.length - 1];
            int newLen = this.conditions.length + choose2.conditions.length - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
            System.arraycopy(choose2.conditions, 0, c2, this.conditions.length - 1, choose2.conditions.length);
            System.arraycopy(choose2.actions, 0, a2, this.actions.length - 1, choose2.actions.length);
            this.conditions = c2;
            this.actions = a2;
        }
        if (this.conditions.length == 2 && Literal.isConstantBoolean(this.actions[0], true) && Literal.isConstantBoolean(this.actions[1], false) && Literal.isConstantBoolean(this.conditions[1], true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.conditions[0].getItemType(), BuiltInAtomicType.BOOLEAN) && this.conditions[0].getCardinality() == 16384) {
                return this.conditions[0];
            }
            return SystemFunctionCall.makeSystemFunction("boolean", new Expression[]{this.conditions[0]});
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.typeCheck(this.conditions[i], contextInfo);
            XPathException err = TypeChecker.ebvError(this.conditions[i], visitor.getConfiguration().getTypeHierarchy());
            if (err == null) continue;
            err.setLocator(this.conditions[i]);
            throw err;
        }
        for (i = 0; i < this.actions.length; ++i) {
            try {
                this.actions[i] = visitor.typeCheck(this.actions[i], contextInfo);
                continue;
            }
            catch (XPathException err) {
                if (err.isStaticError()) {
                    throw err;
                }
                if (err.isTypeError()) {
                    if (Literal.isEmptySequence(this.actions[i]) || Literal.isConstantBoolean(this.conditions[i], false)) {
                        this.actions[i] = new ErrorExpression(err);
                        continue;
                    }
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        return this.removeRedundantBranches(visitor);
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, TypeCheckerEnvironment visitor) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            try {
                this.actions[i] = TypeChecker.staticTypeCheck(this.actions[i], req, backwardsCompatible, role, visitor);
                continue;
            }
            catch (XPathException err) {
                if (err.isStaticError()) {
                    throw err;
                }
                if (err.isTypeError()) {
                    visitor.issueWarning("Branch " + (i + 1) + " of conditional will fail with a type error if executed. " + err.getMessage(), this);
                }
                ErrorExpression ee = new ErrorExpression(err);
                ExpressionTool.copyLocationInfo(this.actions[1], ee);
                this.actions[i] = ee;
            }
        }
        if (!Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && !Cardinality.allowsZero(req.getCardinality())) {
            Expression[] c = new Expression[this.conditions.length + 1];
            Expression[] a = new Expression[this.conditions.length + 1];
            System.arraycopy(this.conditions, 0, c, 0, this.conditions.length);
            System.arraycopy(this.actions, 0, a, 0, this.conditions.length);
            c[this.conditions.length] = Literal.makeLiteral(BooleanValue.TRUE, this.getContainer());
            String cond = this.conditions.length == 1 ? "The condition is not" : "None of the conditions is";
            XPathException err = new XPathException("Conditional expression: " + cond + " satisfied, so an empty sequence is returned, " + "but this is not allowed as the " + role.getMessage());
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(true);
            err.setLocator(this);
            ErrorExpression errExp = new ErrorExpression(err);
            ExpressionTool.copyLocationInfo(this, errExp);
            a[this.conditions.length] = errExp;
            this.conditions = c;
            this.actions = a;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            boolean b;
            this.conditions[i] = visitor.optimize(this.conditions[i], contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.conditions[i], visitor, contextItemType);
            if (ebv != null && ebv != this.conditions[i]) {
                this.conditions[i] = ebv;
                this.adoptChildExpression(ebv);
            }
            if (!(this.conditions[i] instanceof Literal) || ((Literal)this.conditions[i]).getValue() instanceof BooleanValue) continue;
            try {
                b = ((Literal)this.conditions[i]).getValue().effectiveBooleanValue();
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            this.conditions[i] = Literal.makeLiteral(BooleanValue.get(b), this.getContainer());
        }
        for (i = 0; i < this.actions.length; ++i) {
            try {
                this.actions[i] = visitor.optimize(this.actions[i], contextItemType);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        if (this.actions.length == 0) {
            return Literal.makeEmptySequence(this.getContainer());
        }
        Expression e = this.removeRedundantBranches(visitor);
        if (e instanceof Choose) {
            return visitor.getConfiguration().obtainOptimizer().trySwitch((Choose)e, visitor.getStaticContext());
        }
        return e;
    }

    @Override
    public Expression copy() {
        Expression[] c2 = new Expression[this.conditions.length];
        Expression[] a2 = new Expression[this.conditions.length];
        for (int c = 0; c < this.conditions.length; ++c) {
            c2[c] = this.conditions[c].copy();
            a2[c] = this.actions[c].copy();
        }
        return new Choose(c2, a2);
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        for (Expression condition : this.conditions) {
            condition.checkForUpdatingSubexpressions();
            if (!condition.isUpdatingExpression()) continue;
            XPathException err = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            err.setLocator(condition);
            throw err;
        }
        boolean updating = false;
        boolean nonUpdating = false;
        for (Expression act : this.actions) {
            act.checkForUpdatingSubexpressions();
            if (!ExpressionTool.isAllowedInUpdatingContext(act)) {
                if (updating) {
                    XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    err.setLocator(act);
                    throw err;
                }
                nonUpdating = true;
            }
            if (!act.isUpdatingExpression()) continue;
            if (nonUpdating) {
                XPathException err = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                err.setLocator(act);
                throw err;
            }
            updating = true;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        for (Expression action : this.actions) {
            if (!action.isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        for (Expression action : this.actions) {
            if (action.isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int m = 14;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m |= 1;
        }
        return m;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result = 0;
        for (Expression action : this.actions) {
            result = Math.max(result, action.markTailFunctionCalls(qName, arity));
        }
        return result;
    }

    @Override
    public ItemType getItemType() {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        ItemType type = this.actions[0].getItemType();
        for (int i = 1; i < this.actions.length; ++i) {
            type = Type.getCommonSuperType(type, this.actions[i].getItemType(), th);
        }
        return type;
    }

    @Override
    public int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        for (int i = 0; i < this.actions.length; ++i) {
            card = Cardinality.union(card, this.actions[i].getCardinality());
            if (!Literal.isConstantBoolean(this.conditions[i], true)) continue;
            includesTrue = true;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    @Override
    public int computeSpecialProperties() {
        int props = this.actions[0].getSpecialProperties();
        for (int i = 1; i < this.actions.length; ++i) {
            props &= this.actions[i].getSpecialProperties();
        }
        return props;
    }

    @Override
    public final boolean createsNewNodes() {
        for (Expression action : this.actions) {
            int props = action.getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>(this.conditions.length * 2);
        for (Expression c : this.conditions) {
            list.add(new Operand(c, OperandRole.INSPECT));
        }
        for (Expression c : this.actions) {
            list.add(new Operand(c, CHOICE_ACTION));
        }
        return list;
    }

    @Override
    public boolean replaceOperand(Expression original, Expression replacement) {
        int i;
        boolean found = false;
        for (i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i] != original) continue;
            this.conditions[i] = replacement;
            found = true;
        }
        for (i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] != original) continue;
            this.actions[i] = replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action == 14) {
            int i;
            for (i = 0; i < this.conditions.length; ++i) {
                this.conditions[i] = this.doPromotion(this.conditions[i], offer);
            }
            for (i = 0; i < this.actions.length; ++i) {
                this.actions[i] = this.doPromotion(this.actions[i], offer);
            }
        } else {
            this.conditions[0] = this.doPromotion(this.conditions[0], offer);
        }
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i] = this.actions[i].unordered(retainAllNodes, forStreaming);
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        for (Expression action : this.actions) {
            action.checkPermittedContents(parentType, env, whole);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Expression condition : this.conditions) {
            condition.addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (Expression action : this.actions) {
            PathMap.PathMapNodeSet temp = action.addToPathMap(pathMap, pathMapNodeSet);
            result.addNodeSet(temp);
        }
        return result;
    }

    @Override
    public String toString() {
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append("if (");
        for (int i = 0; i < this.conditions.length; ++i) {
            sb.append(this.conditions[i].toString());
            sb.append(") then (");
            sb.append(this.actions[i].toString());
            if (i == this.conditions.length - 1) {
                sb.append(")");
                continue;
            }
            sb.append(") else if (");
        }
        return sb.toString();
    }

    @Override
    public String toShortString() {
        return "if(" + this.conditions[0].toShortString() + ") then ... else ...";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("choose");
        for (int i = 0; i < this.conditions.length; ++i) {
            out.startSubsidiaryElement("when");
            this.conditions[i].explain(out);
            out.endSubsidiaryElement();
            out.startSubsidiaryElement("then");
            this.actions[i].explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        int i = this.choose(context);
        if (i >= 0) {
            if (this.actions[i] instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.actions[i])).processLeavingTail(context);
            }
            this.actions[i].process(context);
            return null;
        }
        return null;
    }

    private int choose(XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (!b) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int i = this.choose(context);
        return i < 0 ? null : this.actions[i].evaluateItem(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int i = this.choose(context);
        return i < 0 ? EmptyIterator.emptyIterator() : this.actions[i].iterate(context);
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        int i = this.choose(context);
        return i < 0 ? EmptyEventIterator.getInstance() : this.actions[i].iterateEvents(context);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        int i = this.choose(context);
        if (i >= 0) {
            this.actions[i].evaluatePendingUpdates(context, pul);
        }
    }
}

