/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.sse.internal;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault
public class SseSinkItemInfo {
    private final String connectionId = UUID.randomUUID().toString();
    private final Set<String> trackedItems = new CopyOnWriteArraySet<String>();

    public String getConnectionId() {
        return this.connectionId;
    }

    public void updateTrackedItems(Set<String> itemNames) {
        this.trackedItems.clear();
        this.trackedItems.addAll(itemNames);
    }

    public static Predicate<SseSinkItemInfo> hasConnectionId(String connectionId) {
        return info -> info.connectionId.equals(connectionId);
    }

    public static Predicate<SseSinkItemInfo> tracksItem(String itemName) {
        return info -> info.trackedItems.contains(itemName);
    }
}

