/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.SweepDeduplicator;
import org.eclipse.californium.elements.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SweepPerPeerDeduplicator
extends SweepDeduplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweepPerPeerDeduplicator.class);
    private final ConcurrentMap<Object, Queue<KeyMID>> incomingPerPeerMessages = new ConcurrentHashMap<Object, Queue<KeyMID>>();
    private final int messagePerPeer;

    public SweepPerPeerDeduplicator(NetworkConfig config) {
        super(config);
        this.algorithm = new SweepAlgorithm();
        this.messagePerPeer = config.getInt("PEERS_MARK_AND_SWEEP_MESSAGES");
    }

    @Override
    protected void onAdd(KeyMID key, boolean replace) {
        Object peer = key.getPeer();
        Queue<KeyMID> peersQueue = (ArrayBlockingQueue<KeyMID>)this.incomingPerPeerMessages.get(peer);
        if (peersQueue == null) {
            peersQueue = new ArrayBlockingQueue<KeyMID>(this.messagePerPeer);
            peersQueue.add(key);
            Queue temp = this.incomingPerPeerMessages.putIfAbsent(peer, peersQueue);
            if (temp == null) {
                return;
            }
            peersQueue = temp;
        }
        if (replace) {
            peersQueue.remove(key);
        }
        while (!peersQueue.offer(key)) {
            KeyMID oldest = (KeyMID)peersQueue.poll();
            this.incomingMessages.remove(oldest);
        }
    }

    private void removeSame(Queue<KeyMID> peersQueue, KeyMID key) {
        Iterator iterator = peersQueue.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != key) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.incomingPerPeerMessages.clear();
    }

    private class SweepAlgorithm
    implements Runnable {
        private int lastSizeDiff;

        private SweepAlgorithm() {
        }

        @Override
        public void run() {
            try {
                LOGGER.trace("Start Mark-And-Sweep with {} entries", (Object)SweepPerPeerDeduplicator.this.incomingMessages.size());
                this.sweep();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception in Mark-and-Sweep algorithm", t);
            }
        }

        private void sweep() {
            if (!SweepPerPeerDeduplicator.this.incomingMessages.isEmpty()) {
                long start = ClockUtil.nanoRealtime();
                long oldestAllowed = start - TimeUnit.MILLISECONDS.toNanos(SweepPerPeerDeduplicator.this.exchangeLifetime);
                int size = SweepPerPeerDeduplicator.this.incomingMessages.size();
                int queueSize = 0;
                int missingExchanges = 0;
                block0: for (Map.Entry entry : SweepPerPeerDeduplicator.this.incomingPerPeerMessages.entrySet()) {
                    KeyMID key;
                    Queue queue = (Queue)entry.getValue();
                    if (queue.isEmpty()) {
                        SweepPerPeerDeduplicator.this.incomingPerPeerMessages.remove(entry.getKey());
                        continue;
                    }
                    queueSize += queue.size();
                    while ((key = (KeyMID)queue.peek()) != null) {
                        long diff;
                        SweepDeduplicator.DedupExchange exchange = (SweepDeduplicator.DedupExchange)SweepPerPeerDeduplicator.this.incomingMessages.get(key);
                        long l = diff = exchange == null ? -1L : exchange.nanoTimestamp - oldestAllowed;
                        if (diff < 0L) {
                            if (exchange != null) {
                                SweepPerPeerDeduplicator.this.incomingMessages.remove(key, exchange);
                                LOGGER.trace("Mark-And-Sweep removes {}", (Object)key);
                            } else {
                                ++missingExchanges;
                            }
                            SweepPerPeerDeduplicator.this.removeSame(queue, key);
                            continue;
                        }
                        if (!LOGGER.isTraceEnabled()) continue block0;
                        LOGGER.trace("Time left {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(diff));
                        continue block0;
                    }
                }
                LOGGER.debug("Sweep run took {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - start));
                if (missingExchanges > 0) {
                    LOGGER.warn("{} exchanges missing", (Object)missingExchanges);
                }
                int diff = size - queueSize;
                if (Math.abs(this.lastSizeDiff) > 1000 && Math.abs(diff) > 1000) {
                    LOGGER.info("Map size {} differs from queues size {}!", (Object)size, (Object)queueSize);
                }
                this.lastSizeDiff = diff;
            }
        }
    }
}

