/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.ErrorCode;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;

public class FirebaseException
extends Exception {
    private final ErrorCode errorCode;
    private final IncomingHttpResponse httpResponse;

    public FirebaseException(@NonNull ErrorCode errorCode, @NonNull String message, @Nullable Throwable cause, @Nullable IncomingHttpResponse httpResponse) {
        super(message, cause);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)message) ? 1 : 0) != 0, (Object)"Message must not be null or empty");
        this.errorCode = (ErrorCode)((Object)Preconditions.checkNotNull((Object)((Object)errorCode), (Object)"ErrorCode must not be null"));
        this.httpResponse = httpResponse;
    }

    public FirebaseException(@NonNull ErrorCode errorCode, @NonNull String message, @Nullable Throwable cause) {
        this(errorCode, message, cause, null);
    }

    public final ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public final IncomingHttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

