/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.BetaApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.grpc.BaseGrpcServiceException;
import io.grpc.Status;
import java.io.IOException;
import javax.annotation.Nullable;

public class FirestoreException
extends BaseGrpcServiceException {
    private Status status;

    FirestoreException(String reason, Status status) {
        this(reason, status, null);
    }

    private FirestoreException(String reason, Status status, @Nullable Throwable cause) {
        super(reason, cause, status.getCode().value(), false);
        this.status = status;
    }

    private FirestoreException(String reason, ApiException exception) {
        super(reason, (Throwable)exception, exception.getStatusCode().getCode().getHttpStatusCode(), exception.isRetryable());
        this.status = FirestoreException.toStatus(exception.getStatusCode());
    }

    private FirestoreException(IOException exception, boolean retryable) {
        super(exception, retryable);
    }

    @BetaApi
    public static FirestoreException forInvalidArgument(String message, Object ... params) {
        return new FirestoreException(String.format(message, params), Status.INVALID_ARGUMENT);
    }

    @BetaApi
    public static FirestoreException forServerRejection(Status status, String message, Object ... params) {
        return FirestoreException.forServerRejection(status, null, message, params);
    }

    @BetaApi
    public static FirestoreException forServerRejection(Status status, @Nullable Throwable cause, String message, Object ... params) {
        return new FirestoreException(String.format(message, params), status, cause);
    }

    @BetaApi
    public static FirestoreException forIOException(IOException exception, boolean retryable) {
        return new FirestoreException(exception, retryable);
    }

    @BetaApi
    public static FirestoreException forApiException(ApiException exception) {
        return new FirestoreException(exception.getMessage(), exception);
    }

    @BetaApi
    public static FirestoreException forApiException(ApiException exception, String message) {
        return new FirestoreException(message, exception);
    }

    @BetaApi
    @Nullable
    public Status getStatus() {
        return this.status;
    }

    private static Status toStatus(StatusCode statusCode) {
        try {
            Status.Code code = Status.Code.valueOf((String)statusCode.getCode().name());
            return code.toStatus();
        }
        catch (IllegalArgumentException e) {
            return Status.UNKNOWN.withDescription("Unrecognized StatusCode.code: " + statusCode.getCode());
        }
    }
}

