/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#pragma once

#define FORY_PP_CONCAT_IMPL(a, b) a##b

// We use a two-step macro expansion process to ensure that arguments
// passed to the macros are fully expanded before they are concatenated.
#define FORY_PP_CONCAT(a, b) FORY_PP_CONCAT_IMPL(a, b)

#define FORY_PP_NARG_IMPL(...) FORY_PP_NARG_CALC(__VA_ARGS__)
#define FORY_PP_NARG(...) FORY_PP_NARG_IMPL(__VA_ARGS__, FORY_PP_NARG_REV())

#define FORY_PP_NARG_CALC(                                                     \
    _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16,     \
    _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, \
    _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, \
    _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, \
    _62, _63, N, ...)                                                          \
  N

#define FORY_PP_NARG_REV()                                                     \
  63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45,  \
      44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27,  \
      26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9,   \
      8, 7, 6, 5, 4, 3, 2, 1, 0

#define FORY_PP_INVOKE(X, ...) X(__VA_ARGS__)

// FORY_PP_FOREACH(X, a, b, c) -> X(a) X(b) X(c)
#define FORY_PP_FOREACH(X, ...)                                                \
  FORY_PP_INVOKE(                                                              \
      FORY_PP_CONCAT(FORY_PP_FOREACH_IMPL_, FORY_PP_NARG(__VA_ARGS__)), X,     \
      __VA_ARGS__)

// HOW TO GENERATE:
// for n in range(1, 64):
//   params = ', '.join(f'_{i}' for i in range(1, n+1))
//   calls = ' '.join(f'X(_{i})' for i in range(1, n+1))
//   print(f"#define FORY_PP_FOREACH_IMPL_{n}(X, {params}) {calls}")

// NOTE: we disable clang-format here since it will change everytimes
// clang-format off
#define FORY_PP_FOREACH_IMPL_1(X, _1) X(_1)
#define FORY_PP_FOREACH_IMPL_2(X, _1, _2) X(_1) X(_2)
#define FORY_PP_FOREACH_IMPL_3(X, _1, _2, _3) X(_1) X(_2) X(_3)
#define FORY_PP_FOREACH_IMPL_4(X, _1, _2, _3, _4) X(_1) X(_2) X(_3) X(_4)
#define FORY_PP_FOREACH_IMPL_5(X, _1, _2, _3, _4, _5) X(_1) X(_2) X(_3) X(_4) X(_5)
#define FORY_PP_FOREACH_IMPL_6(X, _1, _2, _3, _4, _5, _6) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6)
#define FORY_PP_FOREACH_IMPL_7(X, _1, _2, _3, _4, _5, _6, _7) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7)
#define FORY_PP_FOREACH_IMPL_8(X, _1, _2, _3, _4, _5, _6, _7, _8) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8)
#define FORY_PP_FOREACH_IMPL_9(X, _1, _2, _3, _4, _5, _6, _7, _8, _9) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9)
#define FORY_PP_FOREACH_IMPL_10(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10)
#define FORY_PP_FOREACH_IMPL_11(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11)
#define FORY_PP_FOREACH_IMPL_12(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12)
#define FORY_PP_FOREACH_IMPL_13(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13)
#define FORY_PP_FOREACH_IMPL_14(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14)
#define FORY_PP_FOREACH_IMPL_15(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15)
#define FORY_PP_FOREACH_IMPL_16(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16)
#define FORY_PP_FOREACH_IMPL_17(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17)
#define FORY_PP_FOREACH_IMPL_18(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18)
#define FORY_PP_FOREACH_IMPL_19(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19)
#define FORY_PP_FOREACH_IMPL_20(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20)
#define FORY_PP_FOREACH_IMPL_21(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21)
#define FORY_PP_FOREACH_IMPL_22(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22)
#define FORY_PP_FOREACH_IMPL_23(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23)
#define FORY_PP_FOREACH_IMPL_24(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24)
#define FORY_PP_FOREACH_IMPL_25(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25)
#define FORY_PP_FOREACH_IMPL_26(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26)
#define FORY_PP_FOREACH_IMPL_27(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27)
#define FORY_PP_FOREACH_IMPL_28(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28)
#define FORY_PP_FOREACH_IMPL_29(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29)
#define FORY_PP_FOREACH_IMPL_30(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30)
#define FORY_PP_FOREACH_IMPL_31(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31)
#define FORY_PP_FOREACH_IMPL_32(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32)
#define FORY_PP_FOREACH_IMPL_33(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33)
#define FORY_PP_FOREACH_IMPL_34(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34)
#define FORY_PP_FOREACH_IMPL_35(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35)
#define FORY_PP_FOREACH_IMPL_36(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36)
#define FORY_PP_FOREACH_IMPL_37(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37)
#define FORY_PP_FOREACH_IMPL_38(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38)
#define FORY_PP_FOREACH_IMPL_39(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39)
#define FORY_PP_FOREACH_IMPL_40(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40)
#define FORY_PP_FOREACH_IMPL_41(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41)
#define FORY_PP_FOREACH_IMPL_42(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42)
#define FORY_PP_FOREACH_IMPL_43(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43)
#define FORY_PP_FOREACH_IMPL_44(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44)
#define FORY_PP_FOREACH_IMPL_45(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45)
#define FORY_PP_FOREACH_IMPL_46(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46)
#define FORY_PP_FOREACH_IMPL_47(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47)
#define FORY_PP_FOREACH_IMPL_48(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48)
#define FORY_PP_FOREACH_IMPL_49(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49)
#define FORY_PP_FOREACH_IMPL_50(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50)
#define FORY_PP_FOREACH_IMPL_51(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51)
#define FORY_PP_FOREACH_IMPL_52(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52)
#define FORY_PP_FOREACH_IMPL_53(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53)
#define FORY_PP_FOREACH_IMPL_54(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54)
#define FORY_PP_FOREACH_IMPL_55(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55)
#define FORY_PP_FOREACH_IMPL_56(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56)
#define FORY_PP_FOREACH_IMPL_57(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57)
#define FORY_PP_FOREACH_IMPL_58(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58)
#define FORY_PP_FOREACH_IMPL_59(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58) X(_59)
#define FORY_PP_FOREACH_IMPL_60(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58) X(_59) X(_60)
#define FORY_PP_FOREACH_IMPL_61(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58) X(_59) X(_60) X(_61)
#define FORY_PP_FOREACH_IMPL_62(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58) X(_59) X(_60) X(_61) X(_62)
#define FORY_PP_FOREACH_IMPL_63(X, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63) X(_1) X(_2) X(_3) X(_4) X(_5) X(_6) X(_7) X(_8) X(_9) X(_10) X(_11) X(_12) X(_13) X(_14) X(_15) X(_16) X(_17) X(_18) X(_19) X(_20) X(_21) X(_22) X(_23) X(_24) X(_25) X(_26) X(_27) X(_28) X(_29) X(_30) X(_31) X(_32) X(_33) X(_34) X(_35) X(_36) X(_37) X(_38) X(_39) X(_40) X(_41) X(_42) X(_43) X(_44) X(_45) X(_46) X(_47) X(_48) X(_49) X(_50) X(_51) X(_52) X(_53) X(_54) X(_55) X(_56) X(_57) X(_58) X(_59) X(_60) X(_61) X(_62) X(_63)
// clang-format on

// different than FORY_PP_FOREACH, this macro can accept a two-argument function
// macro as input, e.g. FORY_PP_FOREACH_1(X, C, a, b) -> X(C, a) X(C, b)
#define FORY_PP_FOREACH_1(X, C, ...)                                           \
  FORY_PP_INVOKE(                                                              \
      FORY_PP_CONCAT(FORY_PP_FOREACH_1_IMPL_, FORY_PP_NARG(__VA_ARGS__)), X,   \
      C, __VA_ARGS__)

// HOW TO GENERATE:
// for n in range(1, 64):
//   params = ', '.join(f'_{i}' for i in range(1, n+1))
//   calls = ' '.join(f'X(C, _{i})' for i in range(1, n+1))
//   print(f"#define FORY_PP_FOREACH_1_IMPL_{n}(X, C, {params}) {calls}")

// NOTE: we disable clang-format here since it will change everytimes
// clang-format off
#define FORY_PP_FOREACH_1_IMPL_1(X, C, _1) X(C, _1)
#define FORY_PP_FOREACH_1_IMPL_2(X, C, _1, _2) X(C, _1) X(C, _2)
#define FORY_PP_FOREACH_1_IMPL_3(X, C, _1, _2, _3) X(C, _1) X(C, _2) X(C, _3)
#define FORY_PP_FOREACH_1_IMPL_4(X, C, _1, _2, _3, _4) X(C, _1) X(C, _2) X(C, _3) X(C, _4)
#define FORY_PP_FOREACH_1_IMPL_5(X, C, _1, _2, _3, _4, _5) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5)
#define FORY_PP_FOREACH_1_IMPL_6(X, C, _1, _2, _3, _4, _5, _6) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6)
#define FORY_PP_FOREACH_1_IMPL_7(X, C, _1, _2, _3, _4, _5, _6, _7) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7)
#define FORY_PP_FOREACH_1_IMPL_8(X, C, _1, _2, _3, _4, _5, _6, _7, _8) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8)
#define FORY_PP_FOREACH_1_IMPL_9(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9)
#define FORY_PP_FOREACH_1_IMPL_10(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10)
#define FORY_PP_FOREACH_1_IMPL_11(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11)
#define FORY_PP_FOREACH_1_IMPL_12(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12)
#define FORY_PP_FOREACH_1_IMPL_13(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13)
#define FORY_PP_FOREACH_1_IMPL_14(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14)
#define FORY_PP_FOREACH_1_IMPL_15(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15)
#define FORY_PP_FOREACH_1_IMPL_16(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16)
#define FORY_PP_FOREACH_1_IMPL_17(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17)
#define FORY_PP_FOREACH_1_IMPL_18(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18)
#define FORY_PP_FOREACH_1_IMPL_19(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19)
#define FORY_PP_FOREACH_1_IMPL_20(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20)
#define FORY_PP_FOREACH_1_IMPL_21(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21)
#define FORY_PP_FOREACH_1_IMPL_22(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22)
#define FORY_PP_FOREACH_1_IMPL_23(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23)
#define FORY_PP_FOREACH_1_IMPL_24(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24)
#define FORY_PP_FOREACH_1_IMPL_25(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25)
#define FORY_PP_FOREACH_1_IMPL_26(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26)
#define FORY_PP_FOREACH_1_IMPL_27(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27)
#define FORY_PP_FOREACH_1_IMPL_28(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28)
#define FORY_PP_FOREACH_1_IMPL_29(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29)
#define FORY_PP_FOREACH_1_IMPL_30(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30)
#define FORY_PP_FOREACH_1_IMPL_31(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31)
#define FORY_PP_FOREACH_1_IMPL_32(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32)
#define FORY_PP_FOREACH_1_IMPL_33(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33)
#define FORY_PP_FOREACH_1_IMPL_34(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34)
#define FORY_PP_FOREACH_1_IMPL_35(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35)
#define FORY_PP_FOREACH_1_IMPL_36(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36)
#define FORY_PP_FOREACH_1_IMPL_37(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37)
#define FORY_PP_FOREACH_1_IMPL_38(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38)
#define FORY_PP_FOREACH_1_IMPL_39(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39)
#define FORY_PP_FOREACH_1_IMPL_40(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40)
#define FORY_PP_FOREACH_1_IMPL_41(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41)
#define FORY_PP_FOREACH_1_IMPL_42(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42)
#define FORY_PP_FOREACH_1_IMPL_43(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43)
#define FORY_PP_FOREACH_1_IMPL_44(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44)
#define FORY_PP_FOREACH_1_IMPL_45(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45)
#define FORY_PP_FOREACH_1_IMPL_46(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46)
#define FORY_PP_FOREACH_1_IMPL_47(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47)
#define FORY_PP_FOREACH_1_IMPL_48(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48)
#define FORY_PP_FOREACH_1_IMPL_49(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49)
#define FORY_PP_FOREACH_1_IMPL_50(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50)
#define FORY_PP_FOREACH_1_IMPL_51(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51)
#define FORY_PP_FOREACH_1_IMPL_52(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52)
#define FORY_PP_FOREACH_1_IMPL_53(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53)
#define FORY_PP_FOREACH_1_IMPL_54(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54)
#define FORY_PP_FOREACH_1_IMPL_55(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55)
#define FORY_PP_FOREACH_1_IMPL_56(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56)
#define FORY_PP_FOREACH_1_IMPL_57(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57)
#define FORY_PP_FOREACH_1_IMPL_58(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58)
#define FORY_PP_FOREACH_1_IMPL_59(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58) X(C, _59)
#define FORY_PP_FOREACH_1_IMPL_60(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58) X(C, _59) X(C, _60)
#define FORY_PP_FOREACH_1_IMPL_61(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58) X(C, _59) X(C, _60) X(C, _61)
#define FORY_PP_FOREACH_1_IMPL_62(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58) X(C, _59) X(C, _60) X(C, _61) X(C, _62)
#define FORY_PP_FOREACH_1_IMPL_63(X, C, _1, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16, _17, _18, _19, _20, _21, _22, _23, _24, _25, _26, _27, _28, _29, _30, _31, _32, _33, _34, _35, _36, _37, _38, _39, _40, _41, _42, _43, _44, _45, _46, _47, _48, _49, _50, _51, _52, _53, _54, _55, _56, _57, _58, _59, _60, _61, _62, _63) X(C, _1) X(C, _2) X(C, _3) X(C, _4) X(C, _5) X(C, _6) X(C, _7) X(C, _8) X(C, _9) X(C, _10) X(C, _11) X(C, _12) X(C, _13) X(C, _14) X(C, _15) X(C, _16) X(C, _17) X(C, _18) X(C, _19) X(C, _20) X(C, _21) X(C, _22) X(C, _23) X(C, _24) X(C, _25) X(C, _26) X(C, _27) X(C, _28) X(C, _29) X(C, _30) X(C, _31) X(C, _32) X(C, _33) X(C, _34) X(C, _35) X(C, _36) X(C, _37) X(C, _38) X(C, _39) X(C, _40) X(C, _41) X(C, _42) X(C, _43) X(C, _44) X(C, _45) X(C, _46) X(C, _47) X(C, _48) X(C, _49) X(C, _50) X(C, _51) X(C, _52) X(C, _53) X(C, _54) X(C, _55) X(C, _56) X(C, _57) X(C, _58) X(C, _59) X(C, _60) X(C, _61) X(C, _62) X(C, _63)
// clang-format on
