/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProviderGroup {
    protected final String name;
    protected List<ProviderInfo> providerInfos;

    public ProviderGroup() {
        this("_DEFAULT", new ArrayList<ProviderInfo>());
    }

    public ProviderGroup(String name) {
        this(name, null);
    }

    public ProviderGroup(String name, List<ProviderInfo> providerInfos) {
        this.name = name;
        this.providerInfos = providerInfos == null ? new ArrayList() : providerInfos;
    }

    public ProviderGroup(List<ProviderInfo> providerInfos) {
        this("_DEFAULT", providerInfos);
    }

    public String getName() {
        return this.name;
    }

    public List<ProviderInfo> getProviderInfos() {
        return this.providerInfos;
    }

    public void setProviderInfos(List<ProviderInfo> providerInfos) {
        this.providerInfos = providerInfos;
    }

    public boolean isEmpty() {
        return CommonUtils.isEmpty(this.providerInfos);
    }

    public int size() {
        return this.providerInfos == null ? 0 : this.providerInfos.size();
    }

    public ProviderGroup add(ProviderInfo providerInfo) {
        if (providerInfo == null) {
            return this;
        }
        ConcurrentHashSet<ProviderInfo> tmp = new ConcurrentHashSet<ProviderInfo>(this.providerInfos);
        tmp.add(providerInfo);
        this.providerInfos = new ArrayList<ProviderInfo>(tmp);
        return this;
    }

    public ProviderGroup addAll(Collection<ProviderInfo> providerInfos) {
        if (CommonUtils.isEmpty(providerInfos)) {
            return this;
        }
        ConcurrentHashSet<ProviderInfo> tmp = new ConcurrentHashSet<ProviderInfo>(this.providerInfos);
        tmp.addAll(providerInfos);
        this.providerInfos = new ArrayList<ProviderInfo>(tmp);
        return this;
    }

    public ProviderGroup remove(ProviderInfo providerInfo) {
        if (providerInfo == null) {
            return this;
        }
        ConcurrentHashSet<ProviderInfo> tmp = new ConcurrentHashSet<ProviderInfo>(this.providerInfos);
        tmp.remove(providerInfo);
        this.providerInfos = new ArrayList<ProviderInfo>(tmp);
        return this;
    }

    public ProviderGroup removeAll(List<ProviderInfo> providerInfos) {
        if (CommonUtils.isEmpty(providerInfos)) {
            return this;
        }
        ConcurrentHashSet<ProviderInfo> tmp = new ConcurrentHashSet<ProviderInfo>(this.providerInfos);
        tmp.removeAll(providerInfos);
        this.providerInfos = new ArrayList<ProviderInfo>(tmp);
        return this;
    }

    public String toString() {
        return "ProviderGroup{name='" + this.name + '\'' + ", providerInfos=" + this.providerInfos + '}';
    }
}

