/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.event;

import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.Subscriber;
import com.alipay.sofa.rpc.event.rest.RestServerReceiveEvent;
import com.alipay.sofa.rpc.event.rest.RestServerSendEvent;
import com.alipay.sofa.rpc.tracer.Tracers;
import com.alipay.sofa.rpc.tracer.sofatracer.RestTracerAdapter;

public class RestTracerSubscriber
extends Subscriber {
    @Override
    public void onEvent(Event originEvent) {
        if (!Tracers.isEnable()) {
            return;
        }
        Class<?> eventClass = originEvent.getClass();
        if (eventClass == RestServerReceiveEvent.class) {
            RestServerReceiveEvent event = (RestServerReceiveEvent)originEvent;
            RestTracerAdapter.serverReceived(event.getRequest());
        } else if (eventClass == RestServerSendEvent.class) {
            RestServerSendEvent event = (RestServerSendEvent)originEvent;
            RestTracerAdapter.serverSend(event.getResponse(), event.getThrowable());
        }
    }
}

