/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.InputSourceFactory;
import org.apache.hugegraph.computer.core.input.InputSplitFetcher;
import org.apache.hugegraph.computer.core.input.MasterInputHandler;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class MasterInputManager
implements Manager {
    private static final Logger LOG = Log.logger(MasterInputManager.class);
    public static final String NAME = "master_input";
    private InputSplitFetcher fetcher;
    private MasterInputHandler handler;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        this.fetcher = InputSourceFactory.createInputSplitFetcher(config);
        this.handler = new MasterInputHandler(this.fetcher);
        int vertexSplitSize = this.handler.createVertexInputSplits();
        int edgeSplitSize = this.handler.createEdgeInputSplits();
        LOG.info("Master create {} vertex splits, {} edge splits", (Object)vertexSplitSize, (Object)edgeSplitSize);
    }

    @Override
    public void close(Config config) {
        if (this.fetcher != null) {
            this.fetcher.close();
        }
    }

    public MasterInputHandler handler() {
        E.checkNotNull((Object)this.handler, (String)"handler");
        return this.handler;
    }
}

