/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncBatchRpcRetryingCaller<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBatchRpcRetryingCaller.class);
    private final Timer retryTimer;
    private final AsyncConnectionImpl conn;
    private final TableName tableName;
    private final List<Action> actions;
    private final List<CompletableFuture<T>> futures;
    private final IdentityHashMap<Action, CompletableFuture<T>> action2Future;
    private final IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> action2Errors;
    private final long pauseNs;
    private final int maxAttempts;
    private final long operationTimeoutNs;
    private final long rpcTimeoutNs;
    private final int startLogErrorsCnt;
    private final long startNs;

    public AsyncBatchRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, TableName tableName, List<? extends Row> actions, long pauseNs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        this.retryTimer = retryTimer;
        this.conn = conn;
        this.tableName = tableName;
        this.pauseNs = pauseNs;
        this.maxAttempts = maxAttempts;
        this.operationTimeoutNs = operationTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.actions = new ArrayList<Action>(actions.size());
        this.futures = new ArrayList<CompletableFuture<T>>(actions.size());
        this.action2Future = new IdentityHashMap(actions.size());
        int n = actions.size();
        for (int i = 0; i < n; ++i) {
            Row rawAction = actions.get(i);
            Action action = new Action(rawAction, i);
            if (rawAction instanceof Append || rawAction instanceof Increment) {
                action.setNonce(conn.getNonceGenerator().newNonce());
            }
            this.actions.add(action);
            CompletableFuture future = new CompletableFuture();
            this.futures.add(future);
            this.action2Future.put(action, future);
        }
        this.action2Errors = new IdentityHashMap();
        this.startNs = System.nanoTime();
    }

    private long remainingTimeNs() {
        return this.operationTimeoutNs - (System.nanoTime() - this.startNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RetriesExhaustedException.ThrowableWithExtraContext> removeErrors(Action action) {
        IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> identityHashMap = this.action2Errors;
        synchronized (identityHashMap) {
            return this.action2Errors.remove(action);
        }
    }

    private void logException(int tries, Supplier<Stream<RegionRequest>> regionsSupplier, Throwable error, ServerName serverName) {
        if (tries > this.startLogErrorsCnt) {
            String regions = regionsSupplier.get().map(r -> "'" + r.loc.getRegion().getRegionNameAsString() + "'").collect(Collectors.joining(",", "[", "]"));
            LOG.warn("Process batch for " + regions + " in " + this.tableName + " from " + serverName + " failed, tries=" + tries, error);
        }
    }

    private String getExtraContextForError(ServerName serverName) {
        return serverName != null ? serverName.getServerName() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addError(Action action, Throwable error, ServerName serverName) {
        List errors;
        IdentityHashMap<Action, List<RetriesExhaustedException.ThrowableWithExtraContext>> identityHashMap = this.action2Errors;
        synchronized (identityHashMap) {
            errors = this.action2Errors.computeIfAbsent(action, k -> new ArrayList());
        }
        errors.add(new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), this.getExtraContextForError(serverName)));
    }

    private void addError(Iterable<Action> actions, Throwable error, ServerName serverName) {
        actions.forEach(action -> this.addError((Action)action, error, serverName));
    }

    private void failOne(Action action, int tries, Throwable error, long currentTime, String extras) {
        CompletableFuture<T> future = this.action2Future.get(action);
        if (future.isDone()) {
            return;
        }
        RetriesExhaustedException.ThrowableWithExtraContext errorWithCtx = new RetriesExhaustedException.ThrowableWithExtraContext(error, currentTime, extras);
        List<RetriesExhaustedException.ThrowableWithExtraContext> errors = this.removeErrors(action);
        if (errors == null) {
            errors = Collections.singletonList(errorWithCtx);
        } else {
            errors.add(errorWithCtx);
        }
        future.completeExceptionally(new RetriesExhaustedException(tries - 1, errors));
    }

    private void failAll(Stream<Action> actions, int tries, Throwable error, ServerName serverName) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        String extras = this.getExtraContextForError(serverName);
        actions.forEach(action -> this.failOne((Action)action, tries, error, currentTime, extras));
    }

    private void failAll(Stream<Action> actions, int tries) {
        actions.forEach(action -> {
            CompletableFuture<T> future = this.action2Future.get(action);
            if (future.isDone()) {
                return;
            }
            future.completeExceptionally(new RetriesExhaustedException(tries, Optional.ofNullable(this.removeErrors((Action)action)).orElse(Collections.emptyList())));
        });
    }

    private ClientProtos.MultiRequest buildReq(Map<byte[], RegionRequest> actionsByRegion, List<CellScannable> cells, Map<Integer, Integer> rowMutationsIndexMap) throws IOException {
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Map.Entry<byte[], RegionRequest> entry : actionsByRegion.entrySet()) {
            long nonceGroup = this.conn.getNonceGenerator().getNonceGroup();
            RequestConverter.buildNoDataRegionActions(entry.getKey(), entry.getValue().actions, cells, multiRequestBuilder, regionActionBuilder, actionBuilder, mutationBuilder, nonceGroup, rowMutationsIndexMap);
        }
        return multiRequestBuilder.build();
    }

    private void onComplete(Action action, RegionRequest regionReq, int tries, ServerName serverName, MultiResponse.RegionResult regionResult, List<Action> failedActions, Throwable regionException) {
        Object result = regionResult.result.getOrDefault(action.getOriginalIndex(), regionException);
        if (result == null) {
            LOG.error("Server " + serverName + " sent us neither result nor exception for row '" + Bytes.toStringBinary(action.getAction().getRow()) + "' of " + regionReq.loc.getRegion().getRegionNameAsString());
            this.addError(action, (Throwable)new RuntimeException("Invalid response"), serverName);
            failedActions.add(action);
        } else if (result instanceof Throwable) {
            Throwable error = ConnectionUtils.translateException((Throwable)result);
            this.logException(tries, () -> Stream.of(regionReq), error, serverName);
            this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error);
            if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
                this.failOne(action, tries, error, EnvironmentEdgeManager.currentTime(), this.getExtraContextForError(serverName));
            } else {
                failedActions.add(action);
            }
        } else {
            this.action2Future.get(action).complete(result);
        }
    }

    private void onComplete(Map<byte[], RegionRequest> actionsByRegion, int tries, ServerName serverName, MultiResponse resp) {
        ArrayList failedActions = new ArrayList();
        actionsByRegion.forEach((rn, regionReq) -> {
            MultiResponse.RegionResult regionResult = resp.getResults().get(rn);
            Throwable regionException = resp.getException((byte[])rn);
            if (regionResult != null) {
                regionReq.actions.forEach(action -> this.onComplete((Action)action, (RegionRequest)regionReq, tries, serverName, regionResult, failedActions, regionException));
            } else {
                Throwable error;
                if (regionException == null) {
                    LOG.error("Server sent us neither results nor exceptions for " + Bytes.toStringBinary(rn));
                    error = new RuntimeException("Invalid response");
                } else {
                    error = ConnectionUtils.translateException(regionException);
                }
                this.logException(tries, () -> Stream.of(regionReq), error, serverName);
                this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error);
                if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
                    this.failAll(regionReq.actions.stream(), tries, error, serverName);
                    return;
                }
                this.addError(regionReq.actions, error, serverName);
                failedActions.addAll(regionReq.actions);
            }
        });
        if (!failedActions.isEmpty()) {
            this.tryResubmit(failedActions.stream(), tries);
        }
    }

    private void send(Map<ServerName, ServerRequest> actionsByServer, int tries) {
        long remainingNs;
        if (this.operationTimeoutNs > 0L) {
            remainingNs = this.remainingTimeNs();
            if (remainingNs <= 0L) {
                this.failAll(actionsByServer.values().stream().flatMap(m -> m.actionsByRegion.values().stream()).flatMap(r -> r.actions.stream()), tries);
                return;
            }
        } else {
            remainingNs = Long.MAX_VALUE;
        }
        actionsByServer.forEach((sn, serverReq) -> {
            ClientProtos.MultiRequest req;
            ClientProtos.ClientService.Interface stub;
            try {
                stub = this.conn.getRegionServerStub((ServerName)sn);
            }
            catch (IOException e) {
                this.onError((Map<byte[], RegionRequest>)serverReq.actionsByRegion, tries, e, (ServerName)sn);
                return;
            }
            ArrayList<CellScannable> cells = new ArrayList<CellScannable>();
            HashMap<Integer, Integer> rowMutationsIndexMap = new HashMap<Integer, Integer>();
            try {
                req = this.buildReq(serverReq.actionsByRegion, cells, rowMutationsIndexMap);
            }
            catch (IOException e) {
                this.onError((Map<byte[], RegionRequest>)serverReq.actionsByRegion, tries, e, (ServerName)sn);
                return;
            }
            HBaseRpcController controller = this.conn.rpcControllerFactory.newController();
            ConnectionUtils.resetController(controller, Math.min(this.rpcTimeoutNs, remainingNs));
            if (!cells.isEmpty()) {
                controller.setCellScanner(CellUtil.createCellScanner(cells));
            }
            stub.multi(controller, req, resp -> {
                if (controller.failed()) {
                    this.onError((Map<byte[], RegionRequest>)serverReq.actionsByRegion, tries, controller.getFailed(), (ServerName)sn);
                } else {
                    try {
                        this.onComplete((Map<byte[], RegionRequest>)serverReq.actionsByRegion, tries, (ServerName)sn, ResponseConverter.getResults(req, rowMutationsIndexMap, resp, controller.cellScanner()));
                    }
                    catch (Exception e) {
                        this.onError((Map<byte[], RegionRequest>)serverReq.actionsByRegion, tries, e, (ServerName)sn);
                        return;
                    }
                }
            });
        });
    }

    private void onError(Map<byte[], RegionRequest> actionsByRegion, int tries, Throwable t, ServerName serverName) {
        Throwable error = ConnectionUtils.translateException(t);
        this.logException(tries, () -> actionsByRegion.values().stream(), error, serverName);
        actionsByRegion.forEach((rn, regionReq) -> this.conn.getLocator().updateCachedLocationOnError(regionReq.loc, error));
        if (error instanceof DoNotRetryIOException || tries >= this.maxAttempts) {
            this.failAll(actionsByRegion.values().stream().flatMap(r -> r.actions.stream()), tries, error, serverName);
            return;
        }
        List<Action> copiedActions = actionsByRegion.values().stream().flatMap(r -> r.actions.stream()).collect(Collectors.toList());
        this.addError(copiedActions, error, serverName);
        this.tryResubmit(copiedActions.stream(), tries);
    }

    private void tryResubmit(Stream<Action> actions, int tries) {
        long delayNs;
        if (this.operationTimeoutNs > 0L) {
            long maxDelayNs = this.remainingTimeNs() - ConnectionUtils.SLEEP_DELTA_NS;
            if (maxDelayNs <= 0L) {
                this.failAll(actions, tries);
                return;
            }
            delayNs = Math.min(maxDelayNs, ConnectionUtils.getPauseTime(this.pauseNs, tries - 1));
        } else {
            delayNs = ConnectionUtils.getPauseTime(this.pauseNs, tries - 1);
        }
        this.retryTimer.newTimeout(t -> this.groupAndSend(actions, tries + 1), delayNs, TimeUnit.NANOSECONDS);
    }

    private void groupAndSend(Stream<Action> actions, int tries) {
        long locateTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            locateTimeoutNs = this.remainingTimeNs();
            if (locateTimeoutNs <= 0L) {
                this.failAll(actions, tries);
                return;
            }
        } else {
            locateTimeoutNs = -1L;
        }
        ConcurrentHashMap actionsByServer = new ConcurrentHashMap();
        ConcurrentLinkedQueue locateFailed = new ConcurrentLinkedQueue();
        FutureUtils.addListener(CompletableFuture.allOf((CompletableFuture[])actions.map(action -> this.conn.getLocator().getRegionLocation(this.tableName, action.getAction().getRow(), RegionLocateType.CURRENT, locateTimeoutNs).whenComplete((loc, error) -> {
            if (error != null) {
                if ((error = FutureUtils.unwrapCompletionException(ConnectionUtils.translateException(error))) instanceof DoNotRetryIOException) {
                    this.failOne((Action)action, tries, (Throwable)error, EnvironmentEdgeManager.currentTime(), "");
                    return;
                }
                this.addError((Action)action, (Throwable)error, null);
                locateFailed.add(action);
            } else {
                CollectionUtils.computeIfAbsent(actionsByServer, loc.getServerName(), () -> new ServerRequest()).addAction((HRegionLocation)loc, (Action)action);
            }
        })).toArray(CompletableFuture[]::new)), (v, r) -> {
            if (!actionsByServer.isEmpty()) {
                this.send(actionsByServer, tries);
            }
            if (!locateFailed.isEmpty()) {
                this.tryResubmit(locateFailed.stream(), tries);
            }
        });
    }

    public List<CompletableFuture<T>> call() {
        this.groupAndSend(this.actions.stream(), 1);
        return this.futures;
    }

    private static final class ServerRequest {
        public final ConcurrentMap<byte[], RegionRequest> actionsByRegion = new ConcurrentSkipListMap<byte[], RegionRequest>(Bytes.BYTES_COMPARATOR);

        private ServerRequest() {
        }

        public void addAction(HRegionLocation loc, Action action) {
            CollectionUtils.computeIfAbsent(this.actionsByRegion, loc.getRegion().getRegionName(), (Supplier<RegionRequest>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addAction$0(org.apache.hadoop.hbase.HRegionLocation ), ()Lorg/apache/hadoop/hbase/client/AsyncBatchRpcRetryingCaller$RegionRequest;)((HRegionLocation)loc)).actions.add(action);
        }

        private static /* synthetic */ RegionRequest lambda$addAction$0(HRegionLocation loc) {
            return new RegionRequest(loc);
        }
    }

    private static final class RegionRequest {
        public final HRegionLocation loc;
        public final ConcurrentLinkedQueue<Action> actions = new ConcurrentLinkedQueue();

        public RegionRequest(HRegionLocation loc) {
            this.loc = loc;
        }
    }
}

