/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.index.IndexNotAvailableException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.InboundMessageHandlers;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.LoggerFactory;

public class InboundSink
implements InboundMessageHandlers.MessageConsumer {
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(LoggerFactory.getLogger(InboundSink.class), 1L, TimeUnit.SECONDS);
    private volatile ThrowingConsumer<Message<?>, IOException> sink;
    private static final AtomicReferenceFieldUpdater<InboundSink, ThrowingConsumer> sinkUpdater = AtomicReferenceFieldUpdater.newUpdater(InboundSink.class, ThrowingConsumer.class, "sink");
    private final MessagingService messaging;

    InboundSink(MessagingService messaging) {
        this.messaging = messaging;
        this.sink = message -> message.header.verb.handler().doVerb(message);
    }

    @Override
    public void fail(Message.Header header, Throwable failure) {
        if (header.callBackOnFailure()) {
            InetAddressAndPort to = header.respondTo() != null ? header.respondTo() : header.from;
            Message<RequestFailureReason> response = Message.failureResponse(header.id, header.expiresAtNanos, RequestFailureReason.forException(failure));
            this.messaging.send(response, to);
        }
    }

    @Override
    public void accept(Message<?> message) {
        try {
            this.sink.accept(message);
        }
        catch (Throwable t) {
            this.fail(message.header, t);
            if (t instanceof TombstoneOverwhelmingException || t instanceof IndexNotAvailableException) {
                noSpamLogger.error(t.getMessage(), new Object[0]);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void add(Predicate<Message<?>> allow) {
        sinkUpdater.updateAndGet(this, sink -> new Filtered(allow, (ThrowingConsumer)sink));
    }

    public void remove(Predicate<Message<?>> allow) {
        sinkUpdater.updateAndGet(this, sink -> InboundSink.without(sink, allow));
    }

    public void clear() {
        sinkUpdater.updateAndGet(this, InboundSink::clear);
    }

    @Deprecated
    public boolean allow(Message<?> message) {
        return InboundSink.allows(this.sink, message);
    }

    private static ThrowingConsumer<Message<?>, IOException> clear(ThrowingConsumer<Message<?>, IOException> sink) {
        while (sink instanceof Filtered) {
            sink = ((Filtered)sink).next;
        }
        return sink;
    }

    private static ThrowingConsumer<Message<?>, IOException> without(ThrowingConsumer<Message<?>, IOException> sink, Predicate<Message<?>> condition) {
        if (!(sink instanceof Filtered)) {
            return sink;
        }
        Filtered filtered = (Filtered)sink;
        Filtered next = InboundSink.without(filtered.next, condition);
        return condition.equals(filtered.condition) ? next : (next == filtered.next ? sink : new Filtered(filtered.condition, next));
    }

    private static boolean allows(ThrowingConsumer<Message<?>, IOException> sink, Message<?> message) {
        while (sink instanceof Filtered) {
            Filtered filtered = (Filtered)sink;
            if (!filtered.condition.test(message)) {
                return false;
            }
            sink = filtered.next;
        }
        return true;
    }

    private static class Filtered
    implements ThrowingConsumer<Message<?>, IOException> {
        final Predicate<Message<?>> condition;
        final ThrowingConsumer<Message<?>, IOException> next;

        private Filtered(Predicate<Message<?>> condition, ThrowingConsumer<Message<?>, IOException> next) {
            this.condition = condition;
            this.next = next;
        }

        public void accept(Message<?> message) throws IOException {
            if (this.condition.test(message)) {
                this.next.accept(message);
            }
        }
    }
}

