/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.BytesSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;

public class UserTypeSerializer
extends BytesSerializer {
    public final LinkedHashMap<String, TypeSerializer<?>> fields;

    public UserTypeSerializer(LinkedHashMap<String, TypeSerializer<?>> fields) {
        this.fields = fields;
    }

    @Override
    public <V> void validate(V input, ValueAccessor<V> accessor) throws MarshalException {
        int i = -1;
        int offset = 0;
        for (Map.Entry<String, TypeSerializer<?>> entry : this.fields.entrySet()) {
            ++i;
            if (accessor.isEmptyFromOffset(input, offset)) {
                return;
            }
            if (accessor.sizeFromOffset(input, offset) < 4) {
                throw new MarshalException(String.format("Not enough bytes to read size of %dth field %s", i, entry.getKey()));
            }
            int size = accessor.getInt(input, offset);
            offset += 4;
            if (size < 0) continue;
            if (accessor.sizeFromOffset(input, offset) < size) {
                throw new MarshalException(String.format("Not enough bytes to read %dth field %s", i, entry.getKey()));
            }
            V field = accessor.slice(input, offset, size);
            try {
                offset += size;
                entry.getValue().validate(field, accessor);
            }
            catch (MarshalException e) {
                throw new MarshalException(String.format("Failure validating the %dth field %s; %s", i, entry.getKey(), e.getMessage()), e);
            }
        }
        if (!accessor.isEmptyFromOffset(input, offset)) {
            throw new MarshalException("Invalid remaining data after end of UDT value");
        }
    }
}

