/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import jakarta.inject.Singleton;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.zip.GZIPOutputStream;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Provider
@Singleton
@Compress
public class CompressInterceptor
implements WriterInterceptor {
    public static final String GZIP = "gzip";
    private static final Logger LOG = Log.logger(CompressInterceptor.class);
    public static final int BUFFER_SIZE = 4096;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        if (context.getAnnotations().length > 0) {
            try {
                this.compress(context);
            }
            catch (Throwable e) {
                LOG.warn("Failed to compress response", e);
                throw e;
            }
        }
        context.proceed();
    }

    private void compress(WriterInterceptorContext context) throws IOException {
        Compress compression = CompressInterceptor.getCompressAnnotation(context);
        String encoding = compression.value();
        int buffer = compression.buffer();
        MultivaluedMap headers = context.getHeaders();
        headers.remove((Object)"Content-Length");
        headers.add((Object)"Content-Encoding", (Object)encoding);
        GZIPOutputStream output = null;
        if (!encoding.equalsIgnoreCase(GZIP)) {
            throw new WebApplicationException("Can't support: " + encoding);
        }
        output = new GZIPOutputStream(context.getOutputStream(), buffer);
        context.setOutputStream((OutputStream)output);
    }

    private static Compress getCompressAnnotation(WriterInterceptorContext c) {
        for (Annotation annotation : c.getAnnotations()) {
            if (annotation.annotationType() != Compress.class) continue;
            return (Compress)annotation;
        }
        throw new AssertionError((Object)"Unable find @Compress annotation");
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Compress {
        public String value() default "gzip";

        public int buffer() default 4096;
    }
}

