/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.CrossObjectReferenceResolver;
import org.apache.ignite.internal.binary.RawBinaryObjectExtractor;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;

class ObjectDetachHelper {
    private final RawBinaryObjectExtractor reader;
    private final int rootObjStartPos;
    private boolean isCrossObjReferenceDetected;

    private ObjectDetachHelper(BinaryInputStream in) {
        this.reader = new RawBinaryObjectExtractor(in);
        this.rootObjStartPos = in.position();
    }

    static ObjectDetachHelper create(byte[] data, int offset) {
        ObjectDetachHelper res = new ObjectDetachHelper(BinaryHeapInputStream.create(data, offset));
        res.findCrossObjectReferences();
        return res;
    }

    public boolean isCrossObjectReferencesDetected() {
        return this.isCrossObjReferenceDetected;
    }

    public void detach(BinaryOutputStream out) {
        this.reader.position(this.rootObjStartPos);
        CrossObjectReferenceResolver.copyObject(this.reader, out);
    }

    private void findCrossObjectReferences() {
        this.isCrossObjReferenceDetected = this.findInNextObject();
    }

    private boolean findInNextObject() {
        int objStartPos = this.reader.position();
        byte objType = this.reader.readBytePositioned(objStartPos);
        switch (objType) {
            case 103: {
                int objDataStartPos = objStartPos + BinaryUtils.dataStartRelative(this.reader, objStartPos);
                int objDataEndPos = BinaryUtils.rawOffsetAbsolute(this.reader, objStartPos);
                int objEndPos = objStartPos + BinaryUtils.length(this.reader, objStartPos);
                this.reader.position(objDataStartPos);
                while (this.reader.position() < objDataEndPos) {
                    if (!this.findInNextObject()) continue;
                    return true;
                }
                this.reader.position(objEndPos);
                return false;
            }
            case 102: {
                this.reader.skipBytes(1);
                int offset = this.reader.readInt();
                return objStartPos - offset < this.rootObjStartPos;
            }
            case 23: {
                this.reader.skipBytes(1);
                this.reader.skipTypeId();
                int size = this.reader.readInt();
                return this.findInNextCortege(size);
            }
            case 24: {
                this.reader.skipBytes(1);
                int size = this.reader.readInt();
                this.reader.skipBytes(1);
                return this.findInNextCortege(size);
            }
            case 25: {
                this.reader.skipBytes(1);
                int size = this.reader.readInt() * 2;
                this.reader.skipBytes(1);
                return this.findInNextCortege(size);
            }
        }
        this.reader.skipObject();
        return false;
    }

    private boolean findInNextCortege(int cortegeSize) {
        for (int elemIdx = 0; elemIdx < cortegeSize; ++elemIdx) {
            if (!this.findInNextObject()) continue;
            return true;
        }
        return false;
    }
}

