/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.SqlJoinProjection;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractRightMaterializedJoinNode;
import org.apache.ignite3.internal.sql.engine.exec.row.RowSchema;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.jetbrains.annotations.Nullable;

public abstract class HashJoinNode<RowT>
extends AbstractRightMaterializedJoinNode<RowT> {
    private static final int INITIAL_CAPACITY = 128;
    private static final BiPredicate<?, ?> ALWAYS_TRUE = (l, r) -> true;
    private static final Key NULL_KEY = new Key();
    final Map<Key, TouchedCollection<RowT>> hashStore = new Object2ObjectOpenHashMap(128);
    private final int[] leftJoinPositions;
    private final int[] rightJoinPositions;
    Iterator<RowT> rightIt = Collections.emptyIterator();
    final BiPredicate<RowT, RowT> nonEquiCondition;

    private HashJoinNode(ExecutionContext<RowT> ctx, JoinInfo joinInfo, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
        super(ctx);
        this.leftJoinPositions = joinInfo.leftKeys.toIntArray();
        this.rightJoinPositions = joinInfo.rightKeys.toIntArray();
        assert (this.leftJoinPositions.length == this.rightJoinPositions.length);
        this.nonEquiCondition = nonEquiCondition != null ? nonEquiCondition : (BiPredicate)Commons.cast(ALWAYS_TRUE);
    }

    @Override
    protected void rewindInternal() {
        this.rightIt = Collections.emptyIterator();
        this.hashStore.clear();
        super.rewindInternal();
    }

    public static <RowT> HashJoinNode<RowT> create(ExecutionContext<RowT> ctx, @Nullable SqlJoinProjection<RowT> projection, RelDataType leftRowType, RelDataType rightRowType, JoinRelType joinType, JoinInfo joinInfo, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
        switch (joinType) {
            case INNER: {
                assert (projection != null);
                return new InnerHashJoin<RowT>(ctx, joinInfo, projection, nonEquiCondition);
            }
            case LEFT: {
                assert (projection != null);
                RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightRowType));
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
                return new LeftHashJoin<RowT>(ctx, joinInfo, projection, rightRowFactory, nonEquiCondition);
            }
            case RIGHT: {
                assert (projection != null);
                RowSchema leftRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)leftRowType));
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
                return new RightHashJoin<RowT>(ctx, joinInfo, projection, leftRowFactory, nonEquiCondition);
            }
            case FULL: {
                assert (projection != null);
                RowSchema leftRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)leftRowType));
                RowSchema rightRowSchema = TypeUtils.rowSchemaFromRelTypes(RelOptUtil.getFieldTypeList((RelDataType)rightRowType));
                RowHandler.RowFactory<RowT> leftRowFactory = ctx.rowHandler().factory(leftRowSchema);
                RowHandler.RowFactory<RowT> rightRowFactory = ctx.rowHandler().factory(rightRowSchema);
                return new FullOuterHashJoin<RowT>(ctx, joinInfo, projection, leftRowFactory, rightRowFactory, nonEquiCondition);
            }
            case SEMI: {
                assert (projection == null);
                return new SemiHashJoin<RowT>(ctx, joinInfo, nonEquiCondition);
            }
            case ANTI: {
                assert (projection == null);
                return new AntiHashJoin<RowT>(ctx, joinInfo, nonEquiCondition);
            }
        }
        throw new IllegalStateException("Join type \"" + joinType + "\" is not supported yet");
    }

    Collection<RowT> lookup(RowT row) {
        Key row0 = this.extractKey(row, this.leftJoinPositions);
        if (row0 == NULL_KEY) {
            return Collections.emptyList();
        }
        TouchedCollection<RowT> found = this.hashStore.get(row0);
        if (found != null) {
            found.touched = true;
            return found.items();
        }
        return Collections.emptyList();
    }

    private static <RowT> Iterator<RowT> getUntouched(final Map<Key, TouchedCollection<RowT>> entries) {
        return new Iterator<RowT>(){
            private final Iterator<TouchedCollection<RowT>> it;
            private Iterator<RowT> innerIt;
            {
                this.it = entries.values().iterator();
                this.innerIt = Collections.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                if (this.innerIt.hasNext()) {
                    return true;
                }
                this.advance();
                return this.innerIt.hasNext();
            }

            @Override
            public RowT next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.innerIt.next();
            }

            void advance() {
                while (this.it.hasNext()) {
                    TouchedCollection coll = this.it.next();
                    if (coll.touched || coll.items().isEmpty()) continue;
                    this.innerIt = coll.items().iterator();
                    break;
                }
            }
        };
    }

    @Override
    protected void pushRight(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        --this.waitingRight;
        Key key = this.extractKey(row, this.rightJoinPositions);
        if (this.keepRowsWithNull() || key != NULL_KEY) {
            TouchedCollection raw = this.hashStore.computeIfAbsent(key, k -> new TouchedCollection());
            raw.add(row);
        }
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
    }

    private Key extractKey(RowT row, int[] mapping) {
        RowHandler<RowT> handler = this.context().rowHandler();
        for (int i : mapping) {
            if (!handler.isNull(i, row)) continue;
            return NULL_KEY;
        }
        return new RowWrapper<RowT>(row, handler, mapping);
    }

    void getMoreOrEnd() throws Exception {
        if (this.waitingRight == 0) {
            this.waitingRight = this.inBufSize;
            this.rightSource().request(this.waitingRight);
        }
        if (this.waitingLeft == 0 && this.leftInBuf.isEmpty()) {
            this.waitingLeft = this.inBufSize;
            this.leftSource().request(this.waitingLeft);
        }
        if (this.requested > 0 && this.waitingLeft == -1 && this.waitingRight == -1 && this.leftInBuf.isEmpty() && this.left == null && !this.rightIt.hasNext()) {
            this.requested = 0;
            this.hashStore.clear();
            this.downstream().end();
        }
    }

    protected boolean keepRowsWithNull() {
        return false;
    }

    private static class InnerHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final SqlJoinProjection<RowT> outputProjection;

        private InnerHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection<RowT> outputProjection, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
            this.outputProjection = outputProjection;
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            Collection<Object> rightRows = this.lookup(this.left);
                            this.rightIt = rightRows.iterator();
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                if (!this.nonEquiCondition.test(this.left, right)) continue;
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.downstream().push(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.left = null;
                            continue;
                        }
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class LeftHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;

        private LeftHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
            this.outputProjection = outputProjection;
            this.rightRowFactory = rightRowFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        boolean checkNonEquiCondition;
                        boolean bl = checkNonEquiCondition = this.nonEquiCondition != ALWAYS_TRUE;
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            Collection<Object> rightRows = this.lookup(this.left);
                            if (rightRows.isEmpty()) {
                                this.rightIt = Collections.singletonList(this.rightRowFactory.create()).iterator();
                                checkNonEquiCondition = false;
                            } else {
                                this.rightIt = rightRows.iterator();
                            }
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                if (checkNonEquiCondition && !this.nonEquiCondition.test(this.left, right)) {
                                    right = this.rightRowFactory.create();
                                }
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.downstream().push(row);
                            }
                        }
                        if (this.rightIt.hasNext()) continue;
                        this.left = null;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class RightHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;
        private boolean drainMaterialization;

        private RightHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in RIGHT join";
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            int processed;
            if (this.waitingRight == -1) {
                this.inLoop = true;
                processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            Collection<Object> rightRows = this.lookup(this.left);
                            this.rightIt = rightRows.iterator();
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.downstream().push(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.left = null;
                            continue;
                        }
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft == -1 && this.waitingRight == -1 && this.requested > 0) {
                this.inLoop = true;
                processed = 0;
                try {
                    if (!this.rightIt.hasNext() && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.rightIt = HashJoinNode.getUntouched(this.hashStore);
                    }
                    RowT emptyLeft = this.leftRowFactory.create();
                    while (this.requested > 0 && this.rightIt.hasNext()) {
                        Object right = this.rightIt.next();
                        RowT row = this.outputProjection.project(this.context(), emptyLeft, right);
                        --this.requested;
                        this.downstream().push(row);
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }

        @Override
        protected boolean keepRowsWithNull() {
            return true;
        }
    }

    private static class FullOuterHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private final RowHandler.RowFactory<RowT> leftRowFactory;
        private final RowHandler.RowFactory<RowT> rightRowFactory;
        private final SqlJoinProjection<RowT> outputProjection;
        private boolean drainMaterialization;

        private FullOuterHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, SqlJoinProjection<RowT> outputProjection, RowHandler.RowFactory<RowT> leftRowFactory, RowHandler.RowFactory<RowT> rightRowFactory, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in FULL OUTER join";
            this.outputProjection = outputProjection;
            this.leftRowFactory = leftRowFactory;
            this.rightRowFactory = rightRowFactory;
        }

        @Override
        protected void rewindInternal() {
            this.drainMaterialization = false;
            super.rewindInternal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            int processed;
            if (this.waitingRight == -1) {
                this.inLoop = true;
                processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            Collection<Object> rightRows = this.lookup(this.left);
                            this.rightIt = rightRows.isEmpty() ? Collections.singletonList(this.rightRowFactory.create()).iterator() : rightRows.iterator();
                        }
                        if (this.rightIt.hasNext()) {
                            while (this.requested > 0 && this.rightIt.hasNext()) {
                                if (processed++ > this.inBufSize) {
                                    this.execute(this::join);
                                    return;
                                }
                                Object right = this.rightIt.next();
                                --this.requested;
                                Object row = this.outputProjection.project(this.context(), this.left, right);
                                this.downstream().push(row);
                            }
                            if (this.rightIt.hasNext()) continue;
                            this.left = null;
                            continue;
                        }
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            if (this.left == null && this.leftInBuf.isEmpty() && this.waitingLeft == -1 && this.waitingRight == -1 && this.requested > 0) {
                this.inLoop = true;
                processed = 0;
                try {
                    if (!this.rightIt.hasNext() && !this.drainMaterialization) {
                        this.drainMaterialization = true;
                        this.rightIt = HashJoinNode.getUntouched(this.hashStore);
                    }
                    RowT emptyLeft = this.leftRowFactory.create();
                    while (this.requested > 0 && this.rightIt.hasNext()) {
                        Object right = this.rightIt.next();
                        RowT row = this.outputProjection.project(this.context(), emptyLeft, right);
                        --this.requested;
                        this.downstream().push(row);
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }

        @Override
        protected boolean keepRowsWithNull() {
            return true;
        }
    }

    private static class SemiHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private SemiHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
        }

        @Override
        protected void pushLeft(RowT row) throws Exception {
            if (this.waitingRight == -1 && this.hashStore.isEmpty()) {
                --this.waitingLeft;
                if (this.waitingLeft == 0) {
                    this.waitingLeft = -1;
                    this.leftInBuf.clear();
                    this.join();
                }
                return;
            }
            super.pushLeft(row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        boolean anyMatched;
                        if (!this.rightIt.hasNext()) {
                            this.left = this.leftInBuf.remove();
                            Collection<Object> rightRows = this.lookup(this.left);
                            this.rightIt = rightRows.iterator();
                        }
                        boolean bl = anyMatched = this.rightIt.hasNext() && this.nonEquiCondition == ALWAYS_TRUE;
                        if (!anyMatched) {
                            while (this.rightIt.hasNext()) {
                                Object right = this.rightIt.next();
                                if (this.nonEquiCondition.test(this.left, right)) {
                                    anyMatched = true;
                                    break;
                                }
                                if (processed++ <= this.inBufSize) continue;
                                this.execute(this::join);
                                return;
                            }
                        }
                        if (anyMatched) {
                            --this.requested;
                            this.downstream().push(this.left);
                            this.rightIt = Collections.emptyIterator();
                        }
                        if (!this.rightIt.hasNext()) {
                            this.left = null;
                        }
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class AntiHashJoin<RowT>
    extends HashJoinNode<RowT> {
        private AntiHashJoin(ExecutionContext<RowT> ctx, JoinInfo joinInfo, @Nullable BiPredicate<RowT, RowT> nonEquiCondition) {
            super(ctx, joinInfo, nonEquiCondition);
            assert (nonEquiCondition == null) : "Non equi condition is not supported in ANTI join";
        }

        @Override
        protected void join() throws Exception {
            if (this.waitingRight == -1) {
                this.inLoop = true;
                int processed = 0;
                try {
                    while (!(this.requested <= 0 || this.left == null && this.leftInBuf.isEmpty())) {
                        this.left = this.leftInBuf.remove();
                        Collection<Object> rightRows = this.lookup(this.left);
                        if (rightRows.isEmpty()) {
                            --this.requested;
                            this.downstream().push(this.left);
                        }
                        this.left = null;
                        if (processed++ <= this.inBufSize) continue;
                        this.execute(this::join);
                        return;
                    }
                }
                finally {
                    this.inLoop = false;
                }
            }
            this.getMoreOrEnd();
        }
    }

    private static class Key {
        private Key() {
        }
    }

    private static class TouchedCollection<RowT> {
        Collection<RowT> coll = new ArrayList<RowT>();
        boolean touched;

        TouchedCollection() {
        }

        void add(RowT row) {
            this.coll.add(row);
        }

        Collection<RowT> items() {
            return this.coll;
        }
    }

    private static class RowWrapper<RowT>
    extends Key {
        RowT row;
        RowHandler<RowT> handler;
        int[] items;

        RowWrapper(RowT row, RowHandler<RowT> handler, int[] items) {
            this.row = row;
            this.handler = handler;
            this.items = items;
        }

        public int hashCode() {
            int hashCode = 0;
            for (int i : this.items) {
                Object entHold = this.handler.get(i, this.row);
                hashCode += Objects.hashCode(entHold);
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RowWrapper row0 = (RowWrapper)obj;
            for (int i = 0; i < this.items.length; ++i) {
                Object current;
                Object input = row0.handler.get(row0.items[i], row0.row);
                boolean comp = Objects.equals(input, current = this.handler.get(this.items[i], this.row));
                if (comp) continue;
                return comp;
            }
            return true;
        }
    }
}

