/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index.sorted;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.tree.IgniteTree;
import org.apache.ignite3.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.jetbrains.annotations.Nullable;

class RemoveSortedIndexRowInvokeClosure
implements IgniteTree.InvokeClosure<SortedIndexRow> {
    private final SortedIndexRow sortedIndexRow;
    private final FreeListImpl freeList;
    private IgniteTree.OperationType operationType = IgniteTree.OperationType.REMOVE;

    public RemoveSortedIndexRowInvokeClosure(SortedIndexRow sortedIndexRow, FreeListImpl freeList) {
        assert (sortedIndexRow.indexColumns().link() == 0L);
        this.sortedIndexRow = sortedIndexRow;
        this.freeList = freeList;
    }

    @Override
    public void call(@Nullable SortedIndexRow oldRow) {
        if (oldRow == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
        } else {
            this.sortedIndexRow.indexColumns().link(oldRow.indexColumns().link());
        }
    }

    @Override
    @Nullable
    public SortedIndexRow newRow() {
        return null;
    }

    @Override
    public IgniteTree.OperationType operationType() {
        return this.operationType;
    }

    public void afterCompletion() throws IgniteInternalCheckedException {
        IndexColumns indexColumns = this.sortedIndexRow.indexColumns();
        if (indexColumns.link() != 0L) {
            assert (this.operationType == IgniteTree.OperationType.REMOVE);
            this.freeList.removeDataRowByLink(indexColumns.link());
            indexColumns.link(0L);
        }
    }
}

