/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import jakarta.inject.Inject;
import org.apache.james.mailbox.MailboxCounterCorrector;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.cassandra.mail.task.RecomputeMailboxCountersService;
import org.apache.james.mailbox.exception.MailboxException;
import reactor.core.publisher.Mono;

public class CassandraMailboxCounterCorrector
implements MailboxCounterCorrector {
    private final RecomputeMailboxCountersService service;

    @Inject
    public CassandraMailboxCounterCorrector(RecomputeMailboxCountersService service) {
        this.service = service;
    }

    public Mono<Void> fixCountersFor(MessageManager mailbox) {
        try {
            return this.service.recomputeMailboxCounter(new RecomputeMailboxCountersService.Context(), mailbox.getMailboxEntity(), RecomputeMailboxCountersService.Options.trustMessageProjection()).then();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

