/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import jakarta.inject.Inject;
import java.util.function.Function;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.ReactorUtils;
import org.apache.james.vault.metadata.DeletedMessageMetadataVault;
import org.apache.james.vault.metadata.DeletedMessageWithStorageInformation;
import org.apache.james.vault.metadata.MetadataSerializer;
import org.apache.james.vault.metadata.PostgresDeletedMessageMetadataDataDefinition;
import org.apache.james.vault.metadata.StorageInformation;
import org.jooq.Condition;
import org.jooq.JSONB;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresDeletedMessageMetadataVault
implements DeletedMessageMetadataVault {
    private final PostgresExecutor postgresExecutor;
    private final MetadataSerializer metadataSerializer;
    private final BlobId.Factory blobIdFactory;

    @Inject
    public PostgresDeletedMessageMetadataVault(PostgresExecutor postgresExecutor, MetadataSerializer metadataSerializer, BlobId.Factory blobIdFactory) {
        this.postgresExecutor = postgresExecutor;
        this.metadataSerializer = metadataSerializer;
        this.blobIdFactory = blobIdFactory;
    }

    public Publisher<Void> store(DeletedMessageWithStorageInformation deletedMessage) {
        return this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.insertInto(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME).set(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.OWNER, (Object)deletedMessage.getDeletedMessage().getOwner().asString()).set(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.MESSAGE_ID, (Object)deletedMessage.getDeletedMessage().getMessageId().serialize()).set(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME, (Object)deletedMessage.getStorageInformation().getBucketName().asString()).set(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BLOB_ID, (Object)deletedMessage.getStorageInformation().getBlobId().asString()).set(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.METADATA, (Object)JSONB.jsonb((String)this.metadataSerializer.serialize(deletedMessage)))));
    }

    public Publisher<Void> removeMetadataRelatedToBucket(BucketName bucketName) {
        return this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.deleteFrom(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME).where(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME.eq((Object)bucketName.asString()))));
    }

    public Publisher<Void> remove(BucketName bucketName, Username username, MessageId messageId) {
        return this.postgresExecutor.executeVoid(context -> Mono.from((Publisher)context.deleteFrom(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME).where(new Condition[]{PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME.eq((Object)bucketName.asString()), PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.OWNER.eq((Object)username.asString()), PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.MESSAGE_ID.eq((Object)messageId.serialize())})));
    }

    public Publisher<StorageInformation> retrieveStorageInformation(Username username, MessageId messageId) {
        return this.postgresExecutor.executeRow(context -> Mono.from((Publisher)context.select(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME, PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BLOB_ID).from(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME).where(new Condition[]{PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.OWNER.eq((Object)username.asString()), PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.MESSAGE_ID.eq((Object)messageId.serialize())}))).map(this.toStorageInformation());
    }

    private Function<Record, StorageInformation> toStorageInformation() {
        return record -> StorageInformation.builder().bucketName(BucketName.of((String)((String)record.get(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME)))).blobId(this.blobIdFactory.parse((String)record.get(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BLOB_ID)));
    }

    public Publisher<DeletedMessageWithStorageInformation> listMessages(BucketName bucketName, Username username) {
        return this.postgresExecutor.executeRows(context -> Flux.from((Publisher)context.select(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.METADATA).from(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME).where(new Condition[]{PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME.eq((Object)bucketName.asString()), PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.OWNER.eq((Object)username.asString())}))).map(record -> this.metadataSerializer.deserialize(((JSONB)record.get(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.METADATA)).data())).handle(ReactorUtils.publishIfPresent());
    }

    public Publisher<BucketName> listRelatedBuckets() {
        return this.postgresExecutor.executeRows(context -> Flux.from((Publisher)context.selectDistinct(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME).from(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.TABLE_NAME))).map(record -> BucketName.of((String)((String)record.get(PostgresDeletedMessageMetadataDataDefinition.DeletedMessageMetadataTable.BUCKET_NAME))));
    }
}

