/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class WrapperKeyManager
extends X509ExtendedKeyManager {
    @Nullable
    private final String certificateAlias;
    @NotNull
    private final X509KeyManager[] keyManagers;

    protected WrapperKeyManager(@NotNull KeyManager[] keyManagers, @Nullable String certificateAlias) {
        this.certificateAlias = certificateAlias;
        this.keyManagers = new X509KeyManager[keyManagers.length];
        for (int i = 0; i < keyManagers.length; ++i) {
            this.keyManagers[i] = (X509KeyManager)keyManagers[i];
        }
    }

    protected WrapperKeyManager(@NotNull X509KeyManager[] keyManagers, @Nullable String certificateAlias) {
        this.keyManagers = keyManagers;
        this.certificateAlias = certificateAlias;
    }

    @Nullable
    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    @Override
    @Nullable
    public final synchronized String[] getClientAliases(@NotNull String keyType, @Nullable Principal[] issuers) {
        LinkedHashSet<String> clientAliases = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getClientAliases(keyType, issuers);
            if (aliases == null) continue;
            clientAliases.addAll(Arrays.asList(aliases));
        }
        if (clientAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[clientAliases.size()];
        return clientAliases.toArray(aliases);
    }

    @Override
    @Nullable
    public final synchronized String chooseClientAlias(@NotNull String[] keyType, @Nullable Principal[] issuers, @Nullable Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                String alias = m.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s : keyType) {
            for (X509KeyManager m : this.keyManagers) {
                String[] aliases = m.getClientAliases(s, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final synchronized String chooseEngineClientAlias(@NotNull String[] keyType, @Nullable Principal[] issuers, @Nullable SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                if (m instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m;
                    String alias = em.chooseEngineClientAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m.chooseClientAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (String s : keyType) {
            for (X509KeyManager m : this.keyManagers) {
                String[] aliases = m.getClientAliases(s, issuers);
                if (aliases == null) continue;
                for (String alias : aliases) {
                    if (!alias.equals(this.certificateAlias)) continue;
                    return this.certificateAlias;
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final synchronized String[] getServerAliases(@NotNull String keyType, @Nullable Principal[] issuers) {
        LinkedHashSet<String> serverAliases = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            serverAliases.addAll(Arrays.asList(aliases));
        }
        if (serverAliases.isEmpty()) {
            return null;
        }
        String[] aliases = new String[serverAliases.size()];
        return serverAliases.toArray(aliases);
    }

    @Override
    @Nullable
    public final synchronized String chooseServerAlias(@NotNull String keyType, @Nullable Principal[] issuers, @Nullable Socket socket) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                String alias = m.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final synchronized String chooseEngineServerAlias(@NotNull String keyType, @Nullable Principal[] issuers, @Nullable SSLEngine engine) {
        if (this.certificateAlias == null) {
            for (X509KeyManager m : this.keyManagers) {
                if (m instanceof X509ExtendedKeyManager) {
                    X509ExtendedKeyManager em = (X509ExtendedKeyManager)m;
                    String alias = em.chooseEngineServerAlias(keyType, issuers, engine);
                    if (alias == null) continue;
                    return alias;
                }
                String alias = m.chooseServerAlias(keyType, issuers, null);
                if (alias == null) continue;
                return alias;
            }
            return null;
        }
        for (X509KeyManager m : this.keyManagers) {
            String[] aliases = m.getServerAliases(keyType, issuers);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (!alias.equals(this.certificateAlias)) continue;
                return this.certificateAlias;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final synchronized X509Certificate[] getCertificateChain(@NotNull String alias) {
        for (X509KeyManager m : this.keyManagers) {
            X509Certificate[] chain = m.getCertificateChain(alias);
            if (chain == null) continue;
            return chain;
        }
        return null;
    }

    @Override
    @Nullable
    public final synchronized PrivateKey getPrivateKey(@NotNull String alias) {
        for (X509KeyManager m : this.keyManagers) {
            PrivateKey key = m.getPrivateKey(alias);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

