/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.Analyzer;
import org.opensearch.client.opensearch._types.analysis.AnalyzerVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class PatternAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final String version;
    @Nullable
    private final String flags;
    @Nullable
    private final Boolean lowercase;
    private final String pattern;
    private final List<String> stopwords;
    public static final JsonpDeserializer<PatternAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternAnalyzer::setupPatternAnalyzerDeserializer);

    private PatternAnalyzer(Builder builder) {
        this.version = builder.version;
        this.flags = builder.flags;
        this.lowercase = builder.lowercase;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
    }

    public static PatternAnalyzer of(Function<Builder, ObjectBuilder<PatternAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Pattern;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Boolean lowercase() {
        return this.lowercase;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.lowercase != null) {
            generator.writeKey("lowercase");
            generator.write(this.lowercase.booleanValue());
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPatternAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::lowercase, JsonpDeserializer.booleanDeserializer(), "lowercase");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PatternAnalyzer> {
        @Nullable
        private String version;
        @Nullable
        private String flags;
        @Nullable
        private Boolean lowercase;
        private String pattern;
        @Nullable
        private List<String> stopwords;

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        public final Builder lowercase(@Nullable Boolean value) {
            this.lowercase = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Override
        public PatternAnalyzer build() {
            this._checkSingleUse();
            return new PatternAnalyzer(this);
        }
    }
}

