/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.server;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import jakarta.inject.Provider;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.mailrepository.api.MailRepositoryLoader;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryStore;
import org.apache.james.modules.mailrepository.guice.GuiceMailRepositoryLoader;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.MailRepositoryProbeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailStoreRepositoryModule
extends AbstractModule {
    public static final Logger LOGGER = LoggerFactory.getLogger(MailStoreRepositoryModule.class);

    protected void configure() {
        this.bind(MemoryMailRepositoryStore.class).in(Scopes.SINGLETON);
        this.bind(MailRepositoryStore.class).to(MemoryMailRepositoryStore.class);
        this.bind(GuiceMailRepositoryLoader.class).in(Scopes.SINGLETON);
        this.bind(MailRepositoryLoader.class).to(GuiceMailRepositoryLoader.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(MailRepositoryProbeImpl.class);
    }

    @Provides
    @Singleton
    MailRepositoryStoreConfiguration provideConfiguration(ConfigurationProvider configurationProvider, Provider<MailRepositoryStoreConfiguration.Item> defaultConfigurationItem) throws ConfigurationException {
        HierarchicalConfiguration configuration = configurationProvider.getConfiguration("mailrepositorystore");
        MailRepositoryStoreConfiguration userConfiguration = MailRepositoryStoreConfiguration.parse((HierarchicalConfiguration)configuration);
        if (!userConfiguration.getItems().isEmpty()) {
            return userConfiguration;
        }
        LOGGER.warn("Empty MailRepository store configuration supplied. Defaulting to default configuration for this product");
        return MailRepositoryStoreConfiguration.forItems((MailRepositoryStoreConfiguration.Item[])new MailRepositoryStoreConfiguration.Item[]{(MailRepositoryStoreConfiguration.Item)defaultConfigurationItem.get()});
    }

    @ProvidesIntoSet
    InitializationOperation startMailStore(MemoryMailRepositoryStore instance) {
        return InitilizationOperationBuilder.forClass(MemoryMailRepositoryStore.class).init(() -> ((MemoryMailRepositoryStore)instance).init());
    }
}

