/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class TableChangeEvent {
    public final SchemaChangeType changeType;
    public final TableMetadata oldTable;
    public final TableMetadata newTable;

    public static TableChangeEvent dropped(TableMetadata oldTable) {
        return new TableChangeEvent(SchemaChangeType.DROPPED, oldTable, null);
    }

    public static TableChangeEvent created(TableMetadata newTable) {
        return new TableChangeEvent(SchemaChangeType.CREATED, null, newTable);
    }

    public static TableChangeEvent updated(TableMetadata oldTable, TableMetadata newTable) {
        return new TableChangeEvent(SchemaChangeType.UPDATED, oldTable, newTable);
    }

    private TableChangeEvent(SchemaChangeType changeType, TableMetadata oldTable, TableMetadata newTable) {
        this.changeType = changeType;
        this.oldTable = oldTable;
        this.newTable = newTable;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TableChangeEvent) {
            TableChangeEvent that = (TableChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldTable, that.oldTable) && Objects.equals(this.newTable, that.newTable);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldTable, this.newTable});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("TableChangeEvent(CREATED %s)", this.newTable.getName());
            }
            case UPDATED: {
                return String.format("TableChangeEvent(UPDATED %s=>%s)", this.oldTable.getName(), this.newTable.getName());
            }
            case DROPPED: {
                return String.format("TableChangeEvent(DROPPED %s)", this.oldTable.getName());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

