/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotChars;

public class NodeFormatterTTL
extends NodeFormatterNT {
    private final NodeToLabel nodeToLabel;
    private final PrefixMap prefixMap;
    private final String baseStrIRI;
    private final IRIx baseIRI;
    private static final String dtDecimal = XSDDatatype.XSDdecimal.getURI();
    private static final String dtInteger = XSDDatatype.XSDinteger.getURI();
    private static final String dtDouble = XSDDatatype.XSDdouble.getURI();
    private static final String dtBoolean = XSDDatatype.XSDboolean.getURI();

    public NodeFormatterTTL() {
        this(null, null, NodeToLabel.createBNodeByLabelEncoded());
    }

    public NodeFormatterTTL(String baseIRI, PrefixMap prefixMap) {
        this(baseIRI, prefixMap, NodeToLabel.createBNodeByLabelEncoded());
    }

    public NodeFormatterTTL(String baseIRI, PrefixMap prefixMap, NodeToLabel nodeToLabel) {
        super(CharSpace.UTF8);
        this.nodeToLabel = nodeToLabel;
        if (prefixMap == null) {
            prefixMap = PrefixMapFactory.create();
        }
        this.prefixMap = prefixMap;
        this.baseStrIRI = baseIRI;
        if (baseIRI != null) {
            this.baseIRI = IRIs.resolveIRI((String)baseIRI);
            if (!this.baseIRI.isReference()) {
                throw new IRIException("Not suitable for a base IRI: '" + baseIRI + "'");
            }
        } else {
            this.baseIRI = null;
        }
    }

    @Override
    public void formatURI(AWriter w, String uriStr) {
        String x;
        String localname2;
        String prefix;
        Pair<String, String> pName = this.prefixMap.abbrev(uriStr);
        if (pName != null && NodeFormatterTTL.safePrefixName(prefix = (String)pName.getLeft(), localname2 = (String)pName.getRight())) {
            w.print(prefix);
            w.print(':');
            w.print(localname2);
            return;
        }
        if (this.baseIRI != null && (x = this.abbrevByBase(uriStr)) != null) {
            w.print('<');
            w.print(x);
            w.print('>');
            return;
        }
        super.formatURI(w, uriStr);
    }

    private String abbrevByBase(String uriStr) {
        if (this.baseIRI == null) {
            return null;
        }
        try {
            IRIx relInput = IRIx.create((String)uriStr);
            IRIx relativized = this.baseIRI.relativize(relInput);
            return relativized == null ? null : relativized.toString();
        }
        catch (IRIException ex) {
            return uriStr;
        }
    }

    @Override
    public void formatBNode(AWriter w, Node n) {
        String x = (String)this.nodeToLabel.get(null, n);
        w.print(x);
    }

    static boolean safePrefixName(String prefix, String localname2) {
        return NodeFormatterTTL.safeForPrefix(prefix) && NodeFormatterTTL.safeForPrefixLocalname(localname2);
    }

    static boolean safeForPrefix(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_BASE(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT(str2, idx, N - 1)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS(str2, idx)) == -1) {
            return false;
        }
        return idx == N;
    }

    static boolean safeForPrefixLocalname(String str2) {
        int N = str2.length();
        if (N == 0) {
            return true;
        }
        int idx = 0;
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_U_or_digit_or_COLON(str2, idx)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipAny_PN_CHARS_or_DOT_or_COLON(str2, idx, N - 1)) == -1) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skip1_PN_CHARS_or_COLON(str2, idx)) == -1) {
            return false;
        }
        return idx == N;
    }

    private static int skip1_PN_CHARS_BASE(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (RiotChars.isPNCharsBase(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skipAny_PN_CHARS_or_DOT(String str2, int idx, int max2) {
        for (int i = idx; i < max2; ++i) {
            char ch = str2.charAt(i);
            if (RiotChars.isPNChars(ch) || ch == '.') continue;
            return i;
        }
        return max2;
    }

    private static int skip1_PN_CHARS(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (RiotChars.isPNChars(ch)) {
            return idx + 1;
        }
        return -1;
    }

    private static int skip1_PN_CHARS_U_or_digit_or_COLON(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (RiotChars.isPNChars_U(ch)) {
            return idx + 1;
        }
        if (RiotChars.isDigit(ch)) {
            return idx + 1;
        }
        if (ch == ':') {
            return idx + 1;
        }
        return -1;
    }

    private static int skipAny_PN_CHARS_or_DOT_or_COLON(String str2, int idx, int max2) {
        for (int i = idx; i < max2; ++i) {
            char ch = str2.charAt(i);
            if (RiotChars.isPNChars(ch) || ch == '.' || ch == ':') continue;
            return i;
        }
        return max2;
    }

    private static int skip1_PN_CHARS_or_COLON(String str2, int idx) {
        char ch = str2.charAt(idx);
        if (RiotChars.isPNChars(ch)) {
            return idx + 1;
        }
        if (ch == ':') {
            return idx + 1;
        }
        return -1;
    }

    @Override
    public void formatLitDT(AWriter w, String lex, String datatypeURI) {
        boolean b = this.writeLiteralAbbreviated(w, lex, datatypeURI);
        if (b) {
            return;
        }
        this.writeLiteralWithDT(w, lex, datatypeURI);
    }

    protected void writeLiteralWithDT(AWriter w, String lex, String datatypeURI) {
        this.writeLiteralOneLine(w, lex, datatypeURI);
    }

    protected void writeLiteralOneLine(AWriter w, String lex, String datatypeURI) {
        super.formatLitDT(w, lex, datatypeURI);
    }

    protected boolean writeLiteralAbbreviated(AWriter w, String lex, String datatypeURI) {
        if (dtDecimal.equals(datatypeURI)) {
            if (NodeFormatterTTL.validDecimal(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtInteger.equals(datatypeURI)) {
            if (NodeFormatterTTL.validInteger(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtDouble.equals(datatypeURI)) {
            if (NodeFormatterTTL.validDouble(lex)) {
                w.print(lex);
                return true;
            }
        } else if (dtBoolean.equals(datatypeURI) && (lex.equals("true") || lex.equals("false"))) {
            w.print(lex);
            return true;
        }
        return false;
    }

    private static boolean validInteger(String lex) {
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDecimal(String lex) {
        int N = lex.length();
        if (N <= 1) {
            return false;
        }
        int idx = 0;
        idx = NodeFormatterTTL.skipSign(lex, idx);
        if ((idx = NodeFormatterTTL.skipDigits(lex, idx)) >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch != '.') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static boolean validDouble(String lex) {
        int idx2;
        int N = lex.length();
        if (N == 0) {
            return false;
        }
        int idx = 0;
        boolean initialDigits = (idx = NodeFormatterTTL.skipSign(lex, idx)) != (idx2 = NodeFormatterTTL.skipDigits(lex, idx));
        idx = idx2;
        if (idx >= N) {
            return false;
        }
        char ch = lex.charAt(idx);
        if (ch == '.') {
            if (++idx >= N) {
                return false;
            }
            idx2 = NodeFormatterTTL.skipDigits(lex, idx);
            boolean trailingDigits = idx != idx2;
            idx = idx2;
            if (idx >= N) {
                return false;
            }
            if (!initialDigits && !trailingDigits) {
                return false;
            }
        }
        if ((ch = lex.charAt(idx)) != 'e' && ch != 'E') {
            return false;
        }
        if (++idx >= N) {
            return false;
        }
        if ((idx = NodeFormatterTTL.skipSign(lex, idx)) >= N) {
            return false;
        }
        return (idx = NodeFormatterTTL.skipDigits(lex, idx)) == N;
    }

    private static int skipDigits(String str2, int start) {
        int N = str2.length();
        for (int i = start; i < N; ++i) {
            char ch = str2.charAt(i);
            if (RiotChars.isDigit(ch)) continue;
            return i;
        }
        return N;
    }

    private static int skipSign(String str2, int idx) {
        int N = str2.length();
        char ch = str2.charAt(idx);
        if (ch == '+' || ch == '-') {
            return idx + 1;
        }
        return idx;
    }
}

