/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.nifi.minifi.properties.DuplicateDetectingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PropertiesLoader {
    public static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);

    public static Properties load(File file, String propertiesType) {
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(String.format("{} Properties [%s] not found", propertiesType, file));
        }
        logger.info("Loading {} Properties [{}]", (Object)propertiesType, (Object)file);
        DuplicateDetectingProperties rawProperties = new DuplicateDetectingProperties();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            rawProperties.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Loading {} Properties [%s] failed", propertiesType, file), e);
        }
        if (!rawProperties.redundantKeySet().isEmpty()) {
            logger.warn("Duplicate property keys with the same value were detected in the properties file: {}", (Object)String.join((CharSequence)", ", rawProperties.redundantKeySet()));
        }
        if (!rawProperties.duplicateKeySet().isEmpty()) {
            throw new IllegalArgumentException("Duplicate property keys with different values were detected in the properties file: " + String.join((CharSequence)", ", rawProperties.duplicateKeySet()));
        }
        Properties properties = new Properties();
        rawProperties.stringPropertyNames().forEach(key -> {
            String property = rawProperties.getProperty((String)key);
            properties.setProperty((String)key, property.trim());
        });
        return properties;
    }
}

