/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HexFormat;
import java.util.Objects;
import org.apache.nifi.security.ssl.PemPrivateKeyReader;
import org.apache.nifi.security.ssl.ReadEntityException;

class StandardPemPrivateKeyReader
implements PemPrivateKeyReader {
    static final String RSA_PRIVATE_KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    static final String RSA_PRIVATE_KEY_FOOTER = "-----END RSA PRIVATE KEY-----";
    static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    private static final Charset KEY_CHARACTER_SET = StandardCharsets.US_ASCII;
    private static final PrivateKeyAlgorithmReader privateKeyAlgorithmReader = new PrivateKeyAlgorithmReader();
    private static final Base64.Decoder decoder = Base64.getDecoder();

    StandardPemPrivateKeyReader() {
    }

    @Override
    public PrivateKey readPrivateKey(InputStream inputStream) {
        PrivateKey privateKey;
        Objects.requireNonNull(inputStream, "Input Stream required");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, KEY_CHARACTER_SET));
        try {
            PrivateKey privateKey2;
            String line = reader.readLine();
            if (PRIVATE_KEY_HEADER.contentEquals(line)) {
                privateKeyPayload = this.readPrivateKeyPayload(reader, PRIVATE_KEY_FOOTER);
                privateKey2 = this.readPkcs8PrivateKey(privateKeyPayload);
            } else if (RSA_PRIVATE_KEY_HEADER.contentEquals(line)) {
                privateKeyPayload = this.readPrivateKeyPayload(reader, RSA_PRIVATE_KEY_FOOTER);
                privateKey2 = this.readPkcs1PrivateKey(privateKeyPayload);
            } else {
                throw new ReadEntityException("Supported Private Key header not found");
            }
            privateKey = privateKey2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ReadEntityException("Read Private Key failed", e);
            }
            catch (GeneralSecurityException e) {
                throw new ReadEntityException("Parsing Private Key failed", e);
            }
        }
        reader.close();
        return privateKey;
    }

    private PrivateKey readPkcs1PrivateKey(String privateKeyPayload) throws GeneralSecurityException {
        byte[] privateKeyDecoded = decoder.decode(privateKeyPayload);
        PKCS1EncodedPrivateKey encodedPrivateKey = new PKCS1EncodedPrivateKey(privateKeyDecoded);
        KeyFactory keyFactory = KeyFactory.getInstance(encodedPrivateKey.getAlgorithm());
        return (PrivateKey)keyFactory.translateKey(encodedPrivateKey);
    }

    private PrivateKey readPkcs8PrivateKey(String privateKeyPayload) throws GeneralSecurityException {
        byte[] privateKeyDecoded = decoder.decode(privateKeyPayload);
        ByteBuffer privateKeyBuffer = ByteBuffer.wrap(privateKeyDecoded);
        String keyAlgorithm = privateKeyAlgorithmReader.getAlgorithm(privateKeyBuffer);
        KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(privateKeyDecoded);
        return keyFactory.generatePrivate(encodedKeySpec);
    }

    private String readPrivateKeyPayload(BufferedReader reader, String footer) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        while (line != null && !footer.contentEquals(line)) {
            builder.append(line);
            line = reader.readLine();
        }
        return builder.toString();
    }

    static class PKCS1EncodedPrivateKey
    implements PrivateKey {
        private static final String PKCS1_FORMAT = "PKCS#1";
        private static final String RSA_ALGORITHM = "RSA";
        private final byte[] encoded;

        private PKCS1EncodedPrivateKey(byte[] encoded) {
            this.encoded = encoded;
        }

        @Override
        public String getAlgorithm() {
            return RSA_ALGORITHM;
        }

        @Override
        public String getFormat() {
            return PKCS1_FORMAT;
        }

        @Override
        public byte[] getEncoded() {
            return (byte[])this.encoded.clone();
        }
    }

    static class PrivateKeyAlgorithmReader {
        private static final int DER_TAG_MASK = 31;
        private static final int DER_LENGTH_MASK = 255;
        private static final int DER_RESERVED_LENGTH_MASK = 127;
        private static final int DER_LENGTH_BITS = 8;
        private static final int DER_INDEFINITE_LENGTH = 128;
        private static final byte SEQUENCE_DER_TAG_TYPE = 16;
        private static final byte INTEGER_DER_TAG_TYPE = 2;

        PrivateKeyAlgorithmReader() {
        }

        private String getAlgorithm(ByteBuffer privateKeyDecoded) throws UnrecoverableKeyException {
            String objectIdentifierEncoded = this.readObjectIdentifierEncoded(privateKeyDecoded);
            String keyAlgorithm = null;
            for (ObjectIdentifier objectIdentifier : ObjectIdentifier.values()) {
                if (!objectIdentifier.encoded.contentEquals(objectIdentifierEncoded)) continue;
                keyAlgorithm = objectIdentifier.algorithm;
                break;
            }
            if (keyAlgorithm == null) {
                throw new UnrecoverableKeyException("PKCS8 Algorithm Identifier not supported [%s]".formatted(objectIdentifierEncoded));
            }
            return keyAlgorithm;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String readObjectIdentifierEncoded(ByteBuffer buffer) throws UnrecoverableKeyException {
            byte derTagEncoded = buffer.get();
            int derTagType = derTagEncoded & 0x1F;
            if (16 != derTagType) throw new UnrecoverableKeyException("PKCS8 DER Sequence Tag not found");
            int sequenceLength = this.readDerLength(buffer);
            if (sequenceLength != buffer.remaining()) throw new UnrecoverableKeyException("PKCS8 DER Sequence Length not valid");
            byte versionTagType = buffer.get();
            if (2 != versionTagType) throw new UnrecoverableKeyException("PKCS8 DER Version Tag not found");
            buffer.get();
            buffer.get();
            buffer.get();
            buffer.get();
            buffer.get();
            int algorithmIdentifierLength = this.readDerLength(buffer);
            byte[] algorithmIdentifierEncoded = new byte[algorithmIdentifierLength];
            buffer.get(algorithmIdentifierEncoded);
            return HexFormat.of().formatHex(algorithmIdentifierEncoded);
        }

        private int readDerLength(ByteBuffer buffer) {
            int derLength;
            byte lengthEncoded = buffer.get();
            int initialByteLength = lengthEncoded & 0x80;
            if (initialByteLength == 0) {
                derLength = lengthEncoded & 0x7F;
            } else {
                int lengthBytes = lengthEncoded & 0x7F;
                int sequenceLength = 0;
                for (int i = 0; i < lengthBytes; ++i) {
                    sequenceLength <<= 8;
                    sequenceLength |= buffer.get() & 0xFF;
                }
                derLength = sequenceLength;
            }
            return derLength;
        }

        static enum ObjectIdentifier {
            ECDSA("2a8648ce3d0201", "EC"),
            ED25519("2b6570", "Ed25519"),
            RSA("2a864886f70d010101", "RSA");

            private final String encoded;
            private final String algorithm;

            private ObjectIdentifier(String encoded, String algorithm) {
                this.encoded = encoded;
                this.algorithm = algorithm;
            }
        }
    }
}

