/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.bundle.model;

import org.apache.nifi.registry.bundle.util.BundleUtils;

public class BundleIdentifier {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String identifier;

    public BundleIdentifier(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        BundleUtils.validateNotBlank("Group Id", this.groupId);
        BundleUtils.validateNotBlank("Artifact Id", this.artifactId);
        BundleUtils.validateNotBlank("Version", this.version);
        this.identifier = this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BundleIdentifier)) {
            return false;
        }
        BundleIdentifier other = (BundleIdentifier)obj;
        return this.getIdentifier().equals(other.getIdentifier());
    }

    public int hashCode() {
        return 37 * this.identifier.hashCode();
    }
}

